#define INCL_NOPM
#define INCL_DOSNLS
#include <os2.h>

#if !defined(__32BIT__) && !defined(__EMX__)
#define DosMapCase DosCaseMap
#endif

static unsigned char cUpperCase[256], cLowerCase[256];
static BOOL bInitialized;

static void InitNLS(void)
{
  unsigned nCnt, nU;
  COUNTRYCODE cc;

  bInitialized = TRUE;

  for ( nCnt = 0; nCnt < 256; nCnt++ )
    cUpperCase[nCnt] = cLowerCase[nCnt] = (unsigned char) nCnt;

  cc.country = cc.codepage = 0;
  DosMapCase(sizeof(cUpperCase), &cc, (PCHAR) cUpperCase);

  for ( nCnt = 0; nCnt < 256; nCnt++ )
  {
    nU = cUpperCase[nCnt];
    if (nU != nCnt && cLowerCase[nU] == (unsigned char) nU)
      cLowerCase[nU] = (unsigned char) nCnt;
  }

  for ( nCnt = 'A'; nCnt <= 'Z'; nCnt++ )
    cLowerCase[nCnt] = (unsigned char) (nCnt - 'A' + 'a');
}

int IsLower(int c)
{
  if ( !bInitialized )
    InitNLS();
  return (cUpperCase[c] != (unsigned char) c) 
    || (c == 0xE1); /* special case, german "sz" */
}

int IsUpper(int c)
{
  if ( !bInitialized )
    InitNLS();
  return (cLowerCase[c] != (unsigned char) c);
}

int IsPrint(int c)
{
  if ( !bInitialized )
    InitNLS();
  return (c == 0xE1) /* special case, german "sz" */
    || (cLowerCase[c] != (unsigned char) c)
    || (cUpperCase[c] != (unsigned char) c);
}

int ToLower(int c)
{
  if ( !bInitialized )
    InitNLS();
  return cLowerCase[(unsigned char) c];
}

int ToUpper(int c)
{
  if ( !bInitialized )
    InitNLS();
  return cUpperCase[(unsigned char) c];
}
