diff -cr gdb-4.16/bfd/emx-aout.c \emx\gnu\gdb-4.16/bfd/emx-aout.c
*** gdb-4.16/bfd/emx-aout.c	Sat Oct 28 01:25:42 1995
--- \emx\gnu\gdb-4.16/bfd/emx-aout.c	Wed May  8 17:56:32 1996
***************
*** 1,4 ****
! /* BFD back-end for i386 a.out binaries.
     Copyright 1990, 1991, 1992 Free Software Foundation, Inc.
  
  This file is part of BFD, the Binary File Descriptor library.
--- 1,4 ----
! /* BFD back-end for emx a.out binaries, derived from i386aout.c and aout-target.h
     Copyright 1990, 1991, 1992 Free Software Foundation, Inc.
  
  This file is part of BFD, the Binary File Descriptor library.
***************
*** 27,55 ****
  #define N_HEADER_IN_TEXT(x) 0
  #define BYTES_IN_WORD 4
  
! #define N_TXTOFF(x) 0x20
! #define N_TXTADDR(x) (N_MAGIC(x)==ZMAGIC ? 0x1020 : 0)
  
! #define N_TXTSIZE(x) ((x).a_text)
! #if 0
! #define N_DATADDR(x) (N_MAGIC(x)==OMAGIC? (N_TXTADDR(x)+(x).a_text) : (SEGMENT_SIZE + ((0x1020+(x).a_text-1) & ~(SEGMENT_SIZE-1))))
! #define NOSUBEXECB
! 
! #endif
! #define TARGET_PAGE_SIZE 4096
! #define SEGMENT_SIZE 0x400000
! #define DEFAULT_ARCH bfd_arch_i386
! 
! #define MY(OP) CAT(i386aout_,OP)
! #define TARGETNAME "a.out-i386"
  #define NO_WRITE_HEADER_KLUDGE 1
  
  #include "bfd.h"
  #include "sysdep.h"
  #include "libbfd.h"
  #include "libaout.h"
! static boolean MY(set_sizes)();
  #define MY_backend_data &MY(backend_data)
  static CONST struct aout_backend_data MY(backend_data) = {
    0,				/* zmagic contiguous */
    1,				/* text incl header */
--- 27,56 ----
  #define N_HEADER_IN_TEXT(x) 0
  #define BYTES_IN_WORD 4
  
! #define TARGET_PAGE_SIZE       0x1000
! #define SEGMENT_SIZE    0x10000
! #define TEXT_START_ADDR 0x10000
! #define DEFAULT_ARCH    bfd_arch_i386
  
! #define MY(OP) CAT(emx_aout_,OP)
! #define TARGETNAME "a.out-emx"
  #define NO_WRITE_HEADER_KLUDGE 1
  
+ #define MY_object_p MY(object_p)
+ 
  #include "bfd.h"
+ 
+ static PROTO (const bfd_target *, MY(callback), (bfd *abfd));
+ static PROTO (const bfd_target *, MY(object_p), (bfd *abfd));
+ 
  #include "sysdep.h"
  #include "libbfd.h"
  #include "libaout.h"
! 
  #define MY_backend_data &MY(backend_data)
+ static boolean MY(set_sizes)();
+ 
+ 
  static CONST struct aout_backend_data MY(backend_data) = {
    0,				/* zmagic contiguous */
    1,				/* text incl header */
***************
*** 66,68 ****
--- 67,100 ----
  };
  
  #include "aout-target.h"
+ 
+ /* Finish up the reading of an a.out file header */
+ 
+ static const bfd_target *
+ DEFUN(MY(object_p),(abfd),
+      bfd *abfd)
+ {
+   struct external_exec exec_bytes;	/* Raw exec header from file */
+   struct internal_exec exec;		/* Cleaned-up exec header */
+   const bfd_target *target;
+   long org_pos, add;
+ 
+   org_pos = bfd_tell (abfd);
+   (void)_fseek_hdr(bfd_cache_lookup(abfd));
+   add = bfd_tell (abfd) - org_pos;
+   if (bfd_read ((PTR) &exec_bytes, 1, EXEC_BYTES_SIZE, abfd)
+       != EXEC_BYTES_SIZE) {
+     if (bfd_get_error () != bfd_error_system_call)
+       bfd_set_error (bfd_error_wrong_format);
+     return 0;
+   }
+ 
+   exec.a_info = bfd_h_get_32 (abfd, exec_bytes.e_info);
+ 
+   if (N_BADMAG (exec)) return 0;
+ 
+   NAME(aout,swap_exec_header_in)(abfd, &exec_bytes, &exec);
+   exec.emx_add = add;
+   target = NAME(aout,some_aout_object_p) (abfd, &exec, MY(callback));
+   return target;
+ }
diff -cr gdb-4.16/bfd/libaout.h \emx\gnu\gdb-4.16/bfd/libaout.h
*** gdb-4.16/bfd/libaout.h	Tue Apr 23 05:29:56 1996
--- \emx\gnu\gdb-4.16/bfd/libaout.h	Wed May  8 23:12:50 1996
***************
*** 1,3 ****
--- 1,5 ----
+ /* libaout.h -- changed for emx by Eberhard Mattes -- May 1996 */
+ 
  /* BFD back-end data structures for a.out (and similar) files.
     Copyright 1990, 1991, 1992 Free Software Foundation, Inc.
     Written by Cygnus Support.
***************
*** 175,180 ****
--- 177,185 ----
  struct internal_exec
  {
      long a_info;		/* Magic number and flags, packed */
+ #ifdef __EMX__
+     long emx_add;
+ #endif /* __EMX__ */
      bfd_vma a_text;		/* length of text, in bytes  */
      bfd_vma a_data;		/* length of data, in bytes  */
      bfd_vma a_bss;		/* length of uninitialized data area in mem */
diff -cr gdb-4.16/bfd/targets.c \emx\gnu\gdb-4.16/bfd/targets.c
*** gdb-4.16/bfd/targets.c	Tue Apr 23 05:30:04 1996
--- \emx\gnu\gdb-4.16/bfd/targets.c	Wed May  8 17:54:28 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* targets.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* Generic target-file-type support for the BFD library.
     Copyright 1990, 91, 92, 93, 94, 95, 1996 Free Software Foundation, Inc.
     Written by Cygnus Support.
***************
*** 499,504 ****
--- 500,508 ----
  extern const bfd_target ecoff_big_vec;
  extern const bfd_target ecoff_little_vec;
  extern const bfd_target ecoffalpha_little_vec;
+ #ifdef EMX
+ extern const bfd_target emx_aout_vec;
+ #endif /* EMX */
  extern const bfd_target h8300coff_vec;
  extern const bfd_target h8500coff_vec;
  extern const bfd_target host_aout_vec;
diff -cr gdb-4.16/bfd/trad-cor.c \emx\gnu\gdb-4.16/bfd/trad-cor.c
*** gdb-4.16/bfd/trad-cor.c	Fri Dec 15 22:19:38 1995
--- \emx\gnu\gdb-4.16/bfd/trad-cor.c	Tue Jul 30 23:01:48 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* trad-cor.c -- changed for emx by Eberhard Mattes -- Jul 1996 */
  /* BFD back end for traditional Unix core files (U-area and raw sections)
     Copyright 1988, 1989, 1991, 1992, 1993, 1994 Free Software Foundation, Inc.
     Written by John Gilmore of Cygnus Support.
***************
*** 31,36 ****
--- 32,41 ----
  
  #include <sys/user.h>		/* After a.out.h  */
  
+ #ifdef EMX
+ #define MAX_HEAP_OBJS   16
+ #endif /* EMX */
+ 
  #ifdef TRAD_HEADER
  #include TRAD_HEADER
  #endif
***************
*** 40,50 ****
--- 45,61 ----
        asection *data_section;
        asection *stack_section;
        asection *reg_section;
+ #ifdef EMX
+       asection *heap_section[MAX_HEAP_OBJS];
+ #endif /* EMX */
        struct user u;
      };
  
  #define core_upage(bfd) (&((bfd)->tdata.trad_core_data->u))
  #define core_datasec(bfd) ((bfd)->tdata.trad_core_data->data_section)
+ #ifdef EMX
+ #define core_heapsec(bfd,i) ((bfd)->tdata.trad_core_data->heap_section[i])
+ #endif /* EMX */
  #define core_stacksec(bfd) ((bfd)->tdata.trad_core_data->stack_section)
  #define core_regsec(bfd) ((bfd)->tdata.trad_core_data->reg_section)
  
***************
*** 67,72 ****
--- 78,87 ----
    int val;
    struct user u;
    struct trad_core_struct *rawptr;
+ #ifdef EMX
+   int hi, hn;
+   struct _user_heapobjs uho;
+ #endif /* EMX */
  
  #ifdef TRAD_CORE_USER_OFFSET
    /* If defined, this macro is the file position of the user struct.  */
***************
*** 83,88 ****
--- 98,121 ----
      }
  
    /* Sanity check perhaps??? */
+ #ifdef EMX
+   if (u.u_magic != UMAGIC)
+     return 0;
+   if (u.u_heapobjs_off == 0)
+     hn = 1;
+   else
+     {
+       if (bfd_seek (abfd, u.u_heapobjs_off, SEEK_SET) != 0
+           || bfd_read ((void *)&uho, 1, sizeof uho, abfd) != sizeof uho)
+         {
+           bfd_set_error (bfd_error_wrong_format);
+           return 0;
+         }
+       hn = 1 + uho.u_count;
+       if (hn > MAX_HEAP_OBJS)
+         hn = MAX_HEAP_OBJS;
+     }
+ #else /* !EMX */
    if (u.u_dsize > 0x1000000)	/* Remember, it's in pages... */
      {
        bfd_set_error (bfd_error_wrong_format);
***************
*** 129,134 ****
--- 162,168 ----
        }
  #endif
    }
+ #endif /* !EMX */
  
    /* OK, we believe you.  You're a core file (sure, sure).  */
  
***************
*** 155,169 ****
    core_regsec (abfd) = (asection *) bfd_zalloc (abfd, sizeof (asection));
    if (core_regsec (abfd) == NULL)
      return NULL;
  
    core_stacksec (abfd)->name = ".stack";
    core_datasec (abfd)->name = ".data";
    core_regsec (abfd)->name = ".reg";
  
    core_stacksec (abfd)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
    core_datasec (abfd)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
    core_regsec (abfd)->flags = SEC_HAS_CONTENTS;
! 
    core_datasec (abfd)->_raw_size =  NBPG * u.u_dsize
  #ifdef TRAD_CORE_DSIZE_INCLUDES_TSIZE
      - NBPG * u.u_tsize
--- 189,240 ----
    core_regsec (abfd) = (asection *) bfd_zalloc (abfd, sizeof (asection));
    if (core_regsec (abfd) == NULL)
      return NULL;
+ #ifdef EMX
+   for (hi = 0; hi < hn; ++hi)
+     {
+       core_heapsec (abfd, hi)
+         = (asection *) bfd_zalloc (abfd, sizeof (asection));
+       if (core_heapsec (abfd, hi) == NULL)
+         return NULL;
+     }
+ #endif /* EMX */
  
    core_stacksec (abfd)->name = ".stack";
    core_datasec (abfd)->name = ".data";
    core_regsec (abfd)->name = ".reg";
+ #ifdef EMX
+   if (hn == 1)
+     core_heapsec (abfd, 0)->name = ".heap";
+   else
+     for (hi = 0; hi < hn; ++hi)
+       {
+         char buf[20], *p;
+         sprintf (buf, ".heap%d", hi + 1);
+         p = bfd_alloc (abfd, strlen (buf) + 1);
+         if (p == NULL)
+           return NULL;
+         strcpy (p, buf);
+         core_heapsec (abfd, hi)->name = p;
+       }
+ #endif /* EMX */
  
    core_stacksec (abfd)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
    core_datasec (abfd)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
    core_regsec (abfd)->flags = SEC_HAS_CONTENTS;
! #ifdef EMX
!   for (hi = 0; hi < hn; ++hi)
!     core_heapsec (abfd, hi)->flags = SEC_ALLOC + SEC_LOAD + SEC_HAS_CONTENTS;
! #endif /* EMX */
! 
! #ifdef EMX
!   core_datasec (abfd)->_raw_size =  u.u_data_end - u.u_data_base;
!   core_stacksec (abfd)->_raw_size = u.u_stack_end - u.u_stack_low;
!   core_regsec (abfd)->_raw_size = sizeof (struct user);
!   core_heapsec (abfd, 0)->_raw_size = u.u_heap_brk - u.u_heap_base;
!   for (hi = 1; hi < hn; ++hi)
!     core_heapsec (abfd, hi)->_raw_size
!       = uho.u_objs[hi-1].u_brk - uho.u_objs[hi-1].u_base;
! #else /* not EMX */
    core_datasec (abfd)->_raw_size =  NBPG * u.u_dsize
  #ifdef TRAD_CORE_DSIZE_INCLUDES_TSIZE
      - NBPG * u.u_tsize
***************
*** 171,179 ****
--- 242,258 ----
        ;
    core_stacksec (abfd)->_raw_size = NBPG * u.u_ssize;
    core_regsec (abfd)->_raw_size = NBPG * UPAGES; /* Larger than sizeof struct u */
+ #endif /* not EMX */
  
    /* What a hack... we'd like to steal it from the exec file,
       since the upage does not seem to provide it.  FIXME.  */
+ #ifdef EMX
+   core_datasec (abfd)->vma = u.u_data_base;
+   core_stacksec (abfd)->vma = u.u_stack_low;
+   core_heapsec (abfd, 0)->vma = u.u_heap_base;
+   for (hi = 1; hi < hn; ++hi)
+     core_heapsec (abfd, hi)->vma = uho.u_objs[hi-1].u_base;
+ #else /* not EMX */
  #ifdef HOST_DATA_START_ADDR
    core_datasec (abfd)->vma = HOST_DATA_START_ADDR;
  #else
***************
*** 185,190 ****
--- 264,270 ----
  #else
    core_stacksec (abfd)->vma = HOST_STACK_END_ADDR - (NBPG * u.u_ssize);
  #endif
+ #endif /* not EMX */
  
    /* This is tricky.  As the "register section", we give them the entire
       upage and stack.  u.u_ar0 points to where "register 0" is stored.
***************
*** 202,224 ****
--- 282,324 ----
       using minor trickery to get around the offset-or-absolute-addr problem. */
    core_regsec (abfd)->vma = 0 - (bfd_vma) u.u_ar0;
  
+ #ifdef EMX
+   core_datasec (abfd)->filepos = u.u_data_off;
+   core_stacksec (abfd)->filepos = u.u_stack_off;
+   core_heapsec (abfd, 0)->filepos = u.u_heap_off;
+   for (hi = 1; hi < hn; ++hi)
+     core_heapsec (abfd, hi)->filepos = uho.u_objs[hi-1].u_off;
+ #else /* not EMX */
    core_datasec (abfd)->filepos = NBPG * UPAGES;
    core_stacksec (abfd)->filepos = (NBPG * UPAGES) + NBPG * u.u_dsize
  #ifdef TRAD_CORE_DSIZE_INCLUDES_TSIZE
      - NBPG * u.u_tsize
  #endif
        ;
+ #endif /* not EMX */
    core_regsec (abfd)->filepos = 0; /* Register segment is the upage */
  
    /* Align to word at least */
    core_stacksec (abfd)->alignment_power = 2;
    core_datasec (abfd)->alignment_power = 2;
+ #ifdef EMX
+   for (hi = 0; hi < hn; ++hi)
+     core_heapsec (abfd, hi)->alignment_power = 2;
+ #endif /* EMX */
    core_regsec (abfd)->alignment_power = 2;
  
    abfd->sections = core_stacksec (abfd);
    core_stacksec (abfd)->next = core_datasec (abfd);
+ #ifdef EMX
+   core_datasec (abfd)->next = core_regsec (abfd);
+   core_regsec (abfd)->next = core_heapsec (abfd, 0);
+   for (hi = 1; hi < hn; ++hi)
+     core_heapsec (abfd, hi-1)->next = core_heapsec (abfd, hi);
+   abfd->section_count = 3 + hn;
+ #else /* not EMX */
    core_datasec (abfd)->next = core_regsec (abfd);
    abfd->section_count = 3;
+ #endif /* not EMX */
  
    return abfd->xvec;
  }
diff -cr gdb-4.16/gdb/annotate.c \emx\gnu\gdb-4.16/gdb/annotate.c
*** gdb-4.16/gdb/annotate.c	Sat Nov 18 13:19:06 1995
--- \emx\gnu\gdb-4.16/gdb/annotate.c	Thu Jun 27 16:21:00 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* annotate.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* Annotation routines for GDB.
     Copyright 1986, 1989, 1990, 1991, 1992, 1995 Free Software Foundation, Inc.
  
***************
*** 323,328 ****
--- 324,356 ----
      printf_filtered ("\n\032\032display-end\n");
  }
  
+ #ifdef __EMX__
+ void
+ annotate_display_enable (num)
+      int num;
+ {
+   if (annotation_level > 1)
+     printf_filtered ("\n\032\032display-enable %d\n", num);
+ }
+ 
+ void
+ annotate_display_disable (num)
+      int num;
+ {
+   if (annotation_level > 1)
+     printf_filtered ("\n\032\032display-disable %d\n", num);
+ }
+ 
+ void
+ annotate_display_delete (num)
+      int num;
+ {
+   if (annotation_level > 1)
+     printf_filtered ("\n\032\032display-delete %d\n", num);
+ }
+ 
+ #endif /* __EMX__ */
+ 
  void
  annotate_arg_begin ()
  {
***************
*** 369,375 ****
--- 397,407 ----
    else
      printf_filtered ("\032\032");
  
+ #ifdef __EMX__
+   printf_filtered ("%s;%d;%d;%s;0x", filename,
+ #else /* not __EMX__ */
    printf_filtered ("%s:%d:%d:%s:0x", filename,
+ #endif /* not __EMX__ */
  		   line, character,
  		   mid ? "middle" : "beg");
    print_address_numeric (pc, 0, gdb_stdout);
diff -cr gdb-4.16/gdb/annotate.h \emx\gnu\gdb-4.16/gdb/annotate.h
*** gdb-4.16/gdb/annotate.h	Wed Aug  2 04:13:34 1995
--- \emx\gnu\gdb-4.16/gdb/annotate.h	Thu Jun 27 16:37:16 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* annotate.h -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* Annotation routines for GDB.
     Copyright 1986, 1989, 1990, 1991, 1992 Free Software Foundation, Inc.
  
***************
*** 65,70 ****
--- 66,76 ----
  extern void annotate_display_expression_end PARAMS ((void));
  extern void annotate_display_value PARAMS ((void));
  extern void annotate_display_end PARAMS ((void));
+ #ifdef __EMX__
+ extern void annotate_display_enable PARAMS ((int));
+ extern void annotate_display_disable PARAMS ((int));
+ extern void annotate_display_delete PARAMS ((int));
+ #endif /* __EMX__ */
  
  extern void annotate_arg_begin PARAMS ((void));
  extern void annotate_arg_name_end PARAMS ((void));
diff -cr gdb-4.16/gdb/command.c \emx\gnu\gdb-4.16/gdb/command.c
*** gdb-4.16/gdb/command.c	Sat Mar 30 06:58:14 1996
--- \emx\gnu\gdb-4.16/gdb/command.c	Sun Jun 30 11:00:22 1996
***************
*** 1,3 ****
--- 1,5 ----
+ /* command.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
+ 
  /* Handle lists of commands, their decoding and documentation, for GDB.
     Copyright 1986, 1989, 1990, 1991 Free Software Foundation, Inc.
  
***************
*** 1268,1273 ****
--- 1270,1279 ----
        
        fputs_filtered (" is ", gdb_stdout);
        wrap_here ("    ");
+ #ifdef __EMX__
+       if (annotation_level > 1)
+         printf_filtered ("\n\032\032show-value\n");
+ #endif /* __EMX__ */
        switch (c->var_type)
  	{
        case var_string:
***************
*** 1310,1315 ****
--- 1316,1325 ----
        default:
  	error ("gdb internal error: bad var_type in do_setshow_command");
        }
+ #ifdef __EMX__
+       if (annotation_level > 1)
+         printf_filtered ("\n\032\032show-value-end\n");
+ #endif /* __EMX__ */
        fputs_filtered (".\n", gdb_stdout);
      }
    else
***************
*** 1354,1359 ****
--- 1364,1373 ----
    int rc, status, pid;
    char *p, *user_shell;
  
+ #ifdef __EMX__
+   if (system ((arg == NULL ? "" : arg)) < 0)
+       error ("system() failed");
+ #else /* not __EMX__ */
    if ((user_shell = (char *) getenv ("SHELL")) == NULL)
      user_shell = "/bin/sh";
  
***************
*** 1381,1386 ****
--- 1395,1401 ----
        ;
    else
      error ("Fork failed");
+ #endif /* not __EMX__ */
  #endif /* Can fork.  */
  }
  
diff -cr gdb-4.16/gdb/core-aou.c \emx\gnu\gdb-4.16/gdb/core-aou.c
*** gdb-4.16/gdb/core-aou.c	Sat Mar 30 06:58:16 1996
--- \emx\gnu\gdb-4.16/gdb/core-aou.c	Thu May  9 20:47:56 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* core-aou.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* Extract registers from a "standard" core file, for GDB.
     Copyright (C) 1988-1995  Free Software Foundation, Inc.
  
***************
*** 84,91 ****
--- 85,96 ----
       CORE_REGISTER_ADDR to offset to the other registers.  If this is a modern
       core file without a upage, reg_ptr will be zero and this is all a big
       NOP.  */
+ #ifdef __EMX__
+   reg_ptr -= KERNEL_U_ADDR;
+ #else /* not __EMX__ */
    if (reg_ptr > (int) core_reg_size)
      reg_ptr -= KERNEL_U_ADDR;
+ #endif /* not __EMX__ */
  
    for (regno = 0; regno < numregs; regno++)
      {
diff -cr gdb-4.16/gdb/corelow.c \emx\gnu\gdb-4.16/gdb/corelow.c
*** gdb-4.16/gdb/corelow.c	Fri Mar  8 20:16:32 1996
--- \emx\gnu\gdb-4.16/gdb/corelow.c	Wed May  8 22:59:32 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* corelow.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* Core dump and executable file functions below target vector, for GDB.
     Copyright 1986, 1987, 1989, 1991, 1992, 1993, 1994, 1995
     Free Software Foundation, Inc.
***************
*** 161,176 ****
--- 162,194 ----
      }
  
    filename = tilde_expand (filename);
+ #ifdef __EMX__
+     {
+       char tmp[512];
+       if (_fullpath (tmp, filename, sizeof (tmp)) == 0)
+         {
+           strlwr (tmp);
+           filename = strsave (tmp);
+         }
+       else
+         filename = strsave (filename);
+     }
+ #else /* not __EMX__ */
    if (filename[0] != '/')
      {
        temp = concat (current_directory, "/", filename, NULL);
        free (filename);
        filename = temp;
      }
+ #endif /* not __EMX__ */
  
    old_chain = make_cleanup (free, filename);
  
+ #ifdef __EMX__
+   scratch_chan = open (filename, (write_files? O_RDWR: O_RDONLY) | O_BINARY, 0);
+ #else /* not __EMX__ */
    scratch_chan = open (filename, write_files ? O_RDWR : O_RDONLY, 0);
+ #endif /* not __EMX__ */
    if (scratch_chan < 0)
      perror_with_name (filename);
  
diff -cr gdb-4.16/gdb/dbxread.c \emx\gnu\gdb-4.16/gdb/dbxread.c
*** gdb-4.16/gdb/dbxread.c	Fri Feb 16 23:14:04 1996
--- \emx\gnu\gdb-4.16/gdb/dbxread.c	Tue Aug 13 21:23:32 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* dbxread.c -- changed for emx by Eberhard Mattes -- Aug 1996 */
  /* Read dbx symbol tables and convert to internal format, for GDB.
     Copyright 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996
     Free Software Foundation, Inc.
***************
*** 453,458 ****
--- 454,467 ----
        break;
  #endif
      case N_TEXT:
+ #ifdef EMX
+       /* The __POST$... symbols created by -mepilogue confuse GDB's
+          backtrace.  */
+       if (name[0] == '_' && name[1] == '_' && name[2] == '_' && name[3] == 'P'
+           && name[4] == 'O' && name[5] == 'S' && name[6] == 'T'
+           && name[7] == '$')
+         return;
+ #endif /* EMX */
      case N_NBTEXT:
      case N_FN:
      case N_FN_SEQ:
***************
*** 531,536 ****
--- 540,549 ----
       0 fixup crap. */
  
    if (strcmp (&objfile->name[val-2], ".o") == 0
+ #ifdef __EMX__
+       || strcmp (&objfile->name[val-4], ".dll") == 0
+       || strcmp (&objfile->name[val-4], ".DLL") == 0
+ #endif /* __EMX__ */
        || strcmp (&objfile->name[val-4], ".nlm") == 0)
      symfile_relocatable = 1;
  
***************
*** 1232,1238 ****
--- 1245,1253 ----
       for this source file out of the ELF symbol table, to compensate for
       Sun brain death.  This replaces the section_offsets in this psymtab,
       if successful.  */
+ #ifndef __EMX__
    elfstab_offset_sections (objfile, result);
+ #endif /* not __EMX__ */
  
    /* Deduce the source language from the filename for this psymtab. */
    psymtab_language = deduce_language_from_filename (filename);
***************
*** 2538,2544 ****
    return section_offsets;
  }
  
! static struct sym_fns aout_sym_fns =
  {
    bfd_target_aout_flavour,
    dbx_new_init,		/* sym_new_init: init anything gbl to entire symtab */
--- 2553,2562 ----
    return section_offsets;
  }
  
! #ifndef __EMX__
! static
! #endif /* not __EMX__ */
! struct sym_fns aout_sym_fns =
  {
    bfd_target_aout_flavour,
    dbx_new_init,		/* sym_new_init: init anything gbl to entire symtab */
diff -cr gdb-4.16/gdb/exec.c \emx\gnu\gdb-4.16/gdb/exec.c
*** gdb-4.16/gdb/exec.c	Sat Feb  3 19:06:16 1996
--- \emx\gnu\gdb-4.16/gdb/exec.c	Wed Jul 31 23:48:06 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* exec.c -- changed for emx by Eberhard Mattes -- Jul 1996 */
  /* Work with executable files, for GDB. 
     Copyright 1988, 1989, 1991, 1992, 1993, 1994 Free Software Foundation, Inc.
  
***************
*** 154,159 ****
--- 155,164 ----
  
    target_preopen (from_tty);
  
+ #ifdef __EMX__
+   if (annotation_level > 1)
+     printf_filtered ("\n\032\032exec-file-invalid\n");
+ #endif /* __EMX__ */
    /* Remove any previous exec file.  */
    unpush_target (&exec_ops);
  
***************
*** 183,188 ****
--- 188,207 ----
        scratch_chan = openp (getenv ("PATH"), 1, filename, 
  			    write_files? O_RDWR|O_BINARY: O_RDONLY|O_BINARY, 0,
  			    &scratch_pathname);
+ #ifdef __EMX__
+       if (scratch_chan < 0)
+         {
+           char *exe = append_exe (filename);
+           if (exe != NULL)
+             {
+               scratch_chan = openp (getenv ("PATH"), 1, exe, 
+                                     (write_files
+                                      ? O_RDWR|O_BINARY : O_RDONLY|O_BINARY),
+                                     0, &scratch_pathname);
+               free (exe);
+             }
+         }
+ #endif /* __EMX__ */
        if (scratch_chan < 0)
  	perror_with_name (filename);
        exec_bfd = bfd_fdopenr (scratch_pathname, gnutarget, scratch_chan);
***************
*** 270,275 ****
--- 289,300 ----
        /* Tell display code (if any) about the changed file name.  */
        if (exec_file_display_hook)
  	(*exec_file_display_hook) (filename);
+ #ifdef __EMX__
+       /* We could use exec_file_display_hook, but we have to patch
+          this function anyway -- see above. */
+       if (annotation_level > 1)
+ 	printf_filtered ("\n\032\032exec-file %s\n", filename);
+ #endif /* __EMX__ */
      }
    else if (from_tty)
      printf_unfiltered ("No exec file now.\n");
diff -cr gdb-4.16/gdb/gdbtypes.c \emx\gnu\gdb-4.16/gdb/gdbtypes.c
*** gdb-4.16/gdb/gdbtypes.c	Mon Jan 29 09:17:22 1996
--- \emx\gnu\gdb-4.16/gdb/gdbtypes.c	Sun Jun 30 10:39:52 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* gdbtypes.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* Support routines for manipulating internal types for GDB.
     Copyright (C) 1992, 1993, 1994, 1995 Free Software Foundation, Inc.
     Contributed by Cygnus Support, using pieces from other GDB modules.
***************
*** 1203,1208 ****
--- 1204,1212 ----
       struct type *t;
  {
    /* FIXME: Should we return true for references as well as pointers?  */
+ #ifdef __EMX__
+   if (t == NULL) return 0;
+ #endif /* __EMX__ */
    CHECK_TYPEDEF (t);
    return
      (t != NULL
diff -cr gdb-4.16/gdb/i386-tde.c \emx\gnu\gdb-4.16/gdb/i386-tde.c
*** gdb-4.16/gdb/i386-tde.c	Sat Mar 30 06:58:26 1996
--- \emx\gnu\gdb-4.16/gdb/i386-tde.c	Fri Aug 23 20:56:24 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* i386-tde.c -- changed for emx by Eberhard Mattes -- Aug 1996 */
  /* Intel 386 target-dependent stuff.
     Copyright (C) 1988, 1989, 1991, 1994, 1995, 1996 Free Software Foundation, Inc.
  
***************
*** 396,401 ****
--- 397,409 ----
    CORE_ADDR adr;
    int i;
    
+ #ifdef __EMX__
+   if (fip->fsr != NULL)
+     {
+       *fsrp = *fip->fsr;
+       return;
+     }
+ #endif /* __EMX__ */
    memset (fsrp, 0, sizeof *fsrp);
    
    /* if frame is the end of a dummy, compute where the
diff -cr gdb-4.16/gdb/i386v-na.c \emx\gnu\gdb-4.16/gdb/i386v-na.c
*** gdb-4.16/gdb/i386v-na.c	Thu Jan  4 22:07:50 1996
--- \emx\gnu\gdb-4.16/gdb/i386v-na.c	Wed Jul 31 18:16:42 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* i386v-na.c -- changed for emx by Eberhard Mattes -- Jul 1996 */
  /* Intel 386 native support for SYSV systems (pre-SVR4).
     Copyright (C) 1988, 1989, 1991, 1992, 1994, 1996 Free Software Foundation, Inc.
  
***************
*** 77,82 ****
--- 78,87 ----
    /* FIXME:  Should have better way to test floating point range */
    if (regnum >= FP0_REGNUM && regnum <= (FP0_REGNUM + 7)) 
      {
+ #ifdef __EMX__
+       fpstate = ubase + ((char *)&u.u_fpstate - (char *)&u);
+       return (fpstate + 28 + 10 * (regnum - FP0_REGNUM));
+ #else /* not __EMX__ */
  #ifdef KSTKSZ	/* SCO, and others? */
        ubase += 4 * (SS + 1) - KSTKSZ;
        fpstate = ubase + ((char *)&u.u_fps.u_fpstate - (char *)&u);
***************
*** 85,90 ****
--- 90,96 ----
        fpstate = ubase + ((char *)&u.i387.st_space - (char *)&u);
        return (fpstate + 10 * (regnum - FP0_REGNUM));
  #endif
+ #endif /* not __EMX__ */
      } 
    else
      {
***************
*** 285,291 ****
  
  #endif /* TARGET_HAS_HARDWARE_WATCHPOINTS */
  
! #if 0
  /* using FLOAT_INFO as is would be a problem.  FLOAT_INFO is called
     via a command xxx and eventually calls ptrace without ever having
     traversed the target vector.  This would be terribly impolite
--- 291,391 ----
  
  #endif /* TARGET_HAS_HARDWARE_WATCHPOINTS */
  
! 
! #ifdef __EMX__
! 
! /* Taken from i386-xdep.c of GDB 4.6 */
! /* and modified by Eberhard Mattes */
! 
! struct env387 
! {
!   unsigned short control;
!   unsigned short r0;
!   unsigned short status;
!   unsigned short r1;
!   unsigned short tag;
!   unsigned short r2;
!   unsigned long eip;
!   unsigned short code_seg;
!   unsigned short opcode;
!   unsigned long operand;
!   unsigned short operand_seg;
!   unsigned short r3;
!   unsigned char regs[8][10];
! };
! 
! static
! print_387_status (status, ep)
!      unsigned short status;
!      struct env387 *ep;
! {
!   int i;
!   int bothstatus;
!   int top;
!   int fpreg;
!   unsigned char *p;
!   
!   bothstatus = ((status != 0) && (ep->status != 0));
!   if (status != 0) 
!     {
!       if (bothstatus)
! 	printf ("u: ");
!       print_387_status_word (status);
!     }
!   
!   if (ep->status != 0) 
!     {
!       if (bothstatus)
! 	printf ("e: ");
!       print_387_status_word (ep->status);
!     }
!   
!   print_387_control_word (ep->control);
!   printf ("last exception: ");
!   printf ("opcode %s; ", local_hex_string(ep->opcode));
!   printf ("pc %s:", local_hex_string(ep->code_seg));
!   printf ("%s; ", local_hex_string(ep->eip));
!   printf ("operand %s", local_hex_string(ep->operand_seg));
!   printf (":%s\n", local_hex_string(ep->operand));
!   
!   top = (ep->status >> 11) & 7;
!   
!   printf ("reg    tag   msb              lsb  value\n");
!   for (fpreg = 7; fpreg >= 0; fpreg--) 
!     {
!       double val;
! 
!       printf ("st(%d): ", fpreg);
!       
!       switch ((ep->tag >> (((top + fpreg) & 7) * 2)) & 3)
! 	{
! 	case 0: printf ("valid "); break;
! 	case 1: printf ("zero  "); break;
! 	case 2: printf ("trap  "); break;
! 	case 3: printf ("empty "); break;
! 	}
!       for (i = 9; i >= 0; i--)
! 	printf ("%02x", ep->regs[fpreg][i]);
!       
!       floatformat_to_double (&floatformat_i387_ext, (char *)ep->regs[fpreg],
!                              &val);
!       printf ("  %g\n", val);
!     }
! #ifndef __EMX__ /* Nowadays (Pentium?) these are 0xffff */
!   if (ep->r0)
!     warning ("reserved0 is %s\n", local_hex_string(ep->r0));
!   if (ep->r1)
!     warning ("reserved1 is %s\n", local_hex_string(ep->r1));
!   if (ep->r2)
!     warning ("reserved2 is %s\n", local_hex_string(ep->r2));
!   if (ep->r3)
!     warning ("reserved3 is %s\n", local_hex_string(ep->r3));
! #endif /* not __EMX__ */
! }
! 
! #define U_FPSTATE(u) u.u_fpstate
! 
! /* __EMX__ #if 0 */
  /* using FLOAT_INFO as is would be a problem.  FLOAT_INFO is called
     via a command xxx and eventually calls ptrace without ever having
     traversed the target vector.  This would be terribly impolite
***************
*** 304,310 ****
--- 404,412 ----
    char fpvalid = 0;
    unsigned int rounded_addr;
    unsigned int rounded_size;
+ #ifndef __EMX__
    extern int corechan;
+ #endif /* not __EMX__ */
    int skip;
    
    uaddr = (char *)&u.u_fpvalid - (char *)&u;
***************
*** 368,371 ****
    print_387_status (fpstatep->status, (struct env387 *)fpstatep->state);
  }
  
! #endif /* never */
--- 470,473 ----
    print_387_status (fpstatep->status, (struct env387 *)fpstatep->state);
  }
  
! #endif /* __EMX__ */
diff -cr gdb-4.16/gdb/infcmd.c \emx\gnu\gdb-4.16/gdb/infcmd.c
*** gdb-4.16/gdb/infcmd.c	Fri Apr 12 07:09:56 1996
--- \emx\gnu\gdb-4.16/gdb/infcmd.c	Mon Jun 10 16:09:04 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* infcmd.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* Memory-access and commands for "inferior" process, for GDB.
     Copyright 1986, 1987, 1988, 1989, 1991, 1992, 1995, 1996 Free Software Foundation, Inc.
  
***************
*** 1369,1375 ****
--- 1370,1380 ----
    add_info ("float", float_info,
  	    "Print the status of the floating point unit\n");
  
+ #ifdef __EMX__
+   emx_inferior_args (&inferior_args);
+ #else /* not __EMX__ */
    inferior_args = savestring ("", 1);	/* Initially no args */
+ #endif /* not __EMX__ */
    inferior_environ = make_environ ();
    init_environ (inferior_environ);
  }
diff -cr gdb-4.16/gdb/inflow.c \emx\gnu\gdb-4.16/gdb/inflow.c
*** gdb-4.16/gdb/inflow.c	Fri Apr  5 09:05:48 1996
--- \emx\gnu\gdb-4.16/gdb/inflow.c	Wed May  8 23:00:20 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* inflow.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* Low level interface to ptrace, for GDB when running under Unix.
     Copyright 1986, 1987, 1989, 1991, 1992, 1995 Free Software Foundation, Inc.
  
***************
*** 98,103 ****
--- 99,108 ----
  
  enum {yes, no, have_not_checked} gdb_has_a_terminal_flag = have_not_checked;
  
+ #ifdef __EMX__
+ extern int switch_sessions;
+ #endif /* __EMX__ */
+ 
  /* Does GDB have a terminal (on stdin)?  */
  int
  gdb_has_a_terminal ()
***************
*** 196,201 ****
--- 201,210 ----
      {
        int result;
  
+ #ifdef __EMX__
+       if (switch_sessions)
+         ptrace (10, inferior_pid, 0, 2);
+ #endif /* __EMX__ */
  #ifdef F_GETFL
        /* Is there a reason this is being done twice?  It happens both
  	 places we use F_SETFL, so I'm inclined to think perhaps there
***************
*** 296,301 ****
--- 305,314 ----
  
        terminal_is_ours = 1;
  
+ #ifdef __EMX__
+       if (switch_sessions)
+         ptrace (10, inferior_pid, 0, 0);
+ #endif /* __EMX__ */
  #ifdef SIGTTOU
        if (job_control)
  	osigttou = (void (*) ()) signal (SIGTTOU, SIG_IGN);
diff -cr gdb-4.16/gdb/infptrac.c \emx\gnu\gdb-4.16/gdb/infptrac.c
*** gdb-4.16/gdb/infptrac.c	Sat Mar 30 06:58:28 1996
--- \emx\gnu\gdb-4.16/gdb/infptrac.c	Wed May  8 17:51:12 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* infptrac.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* Low level Unix child interface to ptrace, for GDB when running under Unix.
     Copyright 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996 Free Software Foundation, Inc.
  
***************
*** 463,473 ****
--- 464,482 ----
  	  buffer[i] = ptrace (PT_READ_I, inferior_pid,
  			      (PTRACE_ARG3_TYPE) addr, 0);
  	  if (errno)
+ #ifdef __EMX__
+             break;
+ #else /* not __EMX__ */
  	    return 0;
+ #endif /* not __EMX__ */
  	  QUIT;
  	}
  
        /* Copy appropriate bytes out of the buffer.  */
+ #ifdef __EMX__
+       if (i < count)
+         len = i * sizeof (int);
+ #endif /* __EMX__ */
        memcpy (myaddr,
  	      (char *) buffer + (memaddr & (sizeof (PTRACE_XFER_TYPE) - 1)),
  	      len);
diff -cr gdb-4.16/gdb/infrun.c \emx\gnu\gdb-4.16/gdb/infrun.c
*** gdb-4.16/gdb/infrun.c	Sat Mar 30 06:58:30 1996
--- \emx\gnu\gdb-4.16/gdb/infrun.c	Thu Jun 27 22:19:24 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* infrun.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* Target-struct-independent code to start (run) and stop an inferior process.
     Copyright 1986, 1987, 1988, 1989, 1991, 1992, 1993, 1994, 1995, 1996
     Free Software Foundation, Inc.
***************
*** 35,45 ****
--- 36,48 ----
  #include <signal.h>
  
  /* unistd.h is needed to #define X_OK */
+ #ifndef __EMX__
  #ifdef USG
  #include <unistd.h>
  #else
  #include <sys/file.h>
  #endif
+ #endif /* not __EMX__ */
  
  /* Prototypes for local functions */
  
***************
*** 702,707 ****
--- 705,715 ----
  			     &step_frame_address, &handling_longjmp,
  			     &another_trap);
  	  printf_filtered ("[Switching to %s]\n", target_pid_to_str (pid));
+ #ifdef __EMX__
+ 	  if (annotation_level > 1)
+ 	    printf_filtered ("\n\032\032thread-switch %d\n",
+ 			     pid_to_thread_id (pid));
+ #endif /* __EMX__ */
  
  	  flush_cached_frames ();
  	}
diff -cr gdb-4.16/gdb/inftarg.c \emx\gnu\gdb-4.16/gdb/inftarg.c
*** gdb-4.16/gdb/inftarg.c	Sat Mar 30 06:58:32 1996
--- \emx\gnu\gdb-4.16/gdb/inftarg.c	Fri May 31 19:45:30 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* inftarg.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* Target-vector operations for controlling Unix child processes, for GDB.
     Copyright 1990, 1991, 1992, 1993, 1994, 1995
     Free Software Foundation, Inc.
***************
*** 62,68 ****
--- 63,71 ----
  static int
  child_can_run PARAMS ((void));
  
+ #ifndef CHILD_THREAD_ALIVE
  static int child_thread_alive PARAMS ((int));
+ #endif
  
  extern char **environ;
  
***************
*** 248,254 ****
--- 251,261 ----
       char *arg;
       int from_tty;
  {
+ #ifdef __EMX__
+   error ("Use the \"run\" command to start an emx child process.");
+ #else /* not __EMX__ */
    error ("Use the \"run\" command to start a Unix child process.");
+ #endif /* not __EMX__ */
  }
  
  /* Stub function which causes the inferior that runs it, to be ptrace-able
***************
*** 318,332 ****
--- 325,346 ----
  void
  child_stop ()
  {
+ #ifndef __EMX__
    extern pid_t inferior_process_group;
  
    kill (-inferior_process_group, SIGINT);
+ #endif /* __EMX__ */
  }
  
  struct target_ops child_ops = {
    "child",			/* to_shortname */
+ #ifdef __EMX__
+   "emx child process",		/* to_longname */
+   "emx child process (started by the \"run\" command).",	/* to_doc */
+ #else /* not __EMX__ */
    "Unix child process",		/* to_longname */
    "Unix child process (started by the \"run\" command).",	/* to_doc */
+ #endif /* not __EMX__ */
    child_open,			/* to_open */
    0,				/* to_close */
    child_attach,			/* to_attach */
diff -cr gdb-4.16/gdb/main.c \emx\gnu\gdb-4.16/gdb/main.c
*** gdb-4.16/gdb/main.c	Sat Apr 13 05:51:36 1996
--- \emx\gnu\gdb-4.16/gdb/main.c	Tue Aug 13 20:55:54 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* main.c -- changed for emx by Eberhard Mattes -- Aug 1996 */
  /* Top level stuff for GDB, the GNU debugger.
     Copyright 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995
     Free Software Foundation, Inc.
***************
*** 77,86 ****
--- 78,93 ----
    char *corearg = NULL;
    char *cdarg = NULL;
    char *ttyarg = NULL;
+ #ifdef __EMX__
+   char *temp_command = NULL;
+ #endif /* __EMX__ */
  
    /* These are static so that we can take their address in an initializer.  */
    static int print_help;
    static int print_version;
+ #ifdef __EMX__
+   static int use_cmdline_args;
+ #endif /* __EMX__ */
  
    /* Pointers to all arguments of --command option.  */
    char **cmdarg;
***************
*** 119,124 ****
--- 126,135 ----
      alloca (4 - i);
  #endif
  
+ #ifdef __EMX__
+   setvbuf (stdout, NULL, _IOLBF, BUFSIZ);
+ #endif /* __EMX__ */
+ 
    /* If error() is called from initialization code, just exit */
    if (SET_TOP_LEVEL ()) {
      exit(1);
***************
*** 137,142 ****
--- 148,156 ----
    instream = stdin;
  
    getcwd (gdb_dirbuf, sizeof (gdb_dirbuf));
+ #ifdef __EMX__
+   strlwr (gdb_dirbuf);
+ #endif /* __EMX__ */
    current_directory = gdb_dirbuf;
  
    /* Parse arguments and options.  */
***************
*** 188,193 ****
--- 202,213 ----
  	{"w", no_argument, &use_windows, 1},
  	{"windows", no_argument, &use_windows, 1},
  	{"statistics", no_argument, 0, 13},
+ #ifdef __EMX__
+ 	/* This needs to implemented in this module anyway, so there's
+ 	   no point in using ADDITIONAL_OPTIONS. */
+ 	{"args", no_argument, &use_cmdline_args, 1},
+ 	{"temp-command", required_argument, 0, 254},
+ #endif /* __EMX__ */
  /* Allow machine descriptions to add more options... */
  #ifdef ADDITIONAL_OPTIONS
  	ADDITIONAL_OPTIONS
***************
*** 195,206 ****
--- 215,244 ----
  	{0, no_argument, 0, 0}
        };
  
+ #ifdef __EMX__
+     /* Set use_cmd_line_args if --args is present.  This is used to
+        decide whether REQUIRE_ORDER or PERMUTE mode will be used.  */
+     while (1)
+       {
+         c = getopt_long_only (argc, argv, "+", long_options, NULL);
+         if (c == EOF || c == '?')
+           break;
+       }
+     /* Restart.  */
+     optind = 0;
+ #endif /* __EMX__ */
+ 
      while (1)
        {
  	int option_index;
  
+ #ifdef __EMX__
+ 	c = getopt_long_only (argc, argv, use_cmdline_args ? "+" : "",
+ 			      long_options, &option_index);
+ #else /* not __EMX__ */
  	c = getopt_long_only (argc, argv, "",
  			      long_options, &option_index);
+ #endif /* not __EMX__ */
  	if (c == EOF)
  	  break;
  
***************
*** 286,291 ****
--- 324,335 ----
  	    }
  	    break;
  
+ #ifdef __EMX__
+ 	  case 254:		/* --temp-command */
+ 	    temp_command = optarg;
+ 	    break;
+ #endif /* __EMX__ */
+ 
  #ifdef ADDITIONAL_OPTION_CASES
  	  ADDITIONAL_OPTION_CASES
  #endif
***************
*** 301,306 ****
--- 345,369 ----
      if (print_help || print_version)
        use_windows = 0;
  
+ #ifdef __EMX__
+     if (use_cmdline_args)
+       {
+ 	/* The remaining arguments are the program to debug and the
+            arguments to be passed to that program. */
+ 
+ 	if (optind < argc)
+ 	  {
+ 	    symarg = argv[optind];
+ 	    execarg = argv[optind];
+ 	    optind++;
+ 	  }
+ 	if (optind < argc)
+ 	  {
+ 	    emx_set_cmdline_args (argv + optind, argc - optind);
+ 	    optind = argc;
+ 	  }
+       }
+ #endif /* __EMX__ */
      /* OK, that's all the options.  The other arguments are filenames.  */
      count = 0;
      for (; optind < argc; optind++)
***************
*** 378,383 ****
--- 441,450 ----
    --readnow          Fully read symbol files on first access.\n\
    --nw		     Do not use a window interface.\n\
  ", gdb_stdout);
+ #ifdef __EMX__
+       fputs_unfiltered ("  --args             Pass arguments following `executable-file' to the\n\
+                      program being debugged: gdb --args myprog.exe arg1 arg2.\n", gdb_stdout);
+ #endif /* __EMX__ */
  #ifdef ADDITIONAL_OPTION_HELP
        fputs_unfiltered (ADDITIONAL_OPTION_HELP, gdb_stdout);
  #endif
***************
*** 438,443 ****
--- 505,522 ----
  				       homedir was set.  */
      }
  
+ #ifdef __EMX__
+   if (cdarg != NULL) _fnslashify (cdarg);
+   for (i = 0; i < ndir; i++)
+     _fnslashify (dirarg[i]);
+   if (execarg != NULL) _fnslashify (execarg);
+   if (symarg != NULL) _fnslashify (symarg);
+   if (corearg != NULL) _fnslashify (corearg);
+   if (ttyarg != NULL) _fnslashify (ttyarg);
+   for (i = 0; i < ncmd; i++)
+     _fnslashify (cmdarg[i]);
+ #endif /* __EMX__ */
+ 
    /* Now perform all the actions indicated by the arguments.  */
    if (cdarg != NULL)
      {
***************
*** 518,523 ****
--- 597,614 ----
  	  source_command (gdbinit, 0);
        }
    do_cleanups (ALL_CLEANUPS);
+ 
+ #ifdef __EMX__
+   if (temp_command && !SET_TOP_LEVEL ())
+     {
+       FILE *f = fopen (temp_command, FOPEN_RT);
+       if (f == NULL)
+ 	perror_with_name (temp_command);
+       read_command_file (f);
+       fclose (f);
+       remove (temp_command);
+     }
+ #endif /* __EMX__ */
  
    for (i = 0; i < ncmd; i++)
      {
diff -cr gdb-4.16/gdb/printcmd.c \emx\gnu\gdb-4.16/gdb/printcmd.c
*** gdb-4.16/gdb/printcmd.c	Sat Mar 30 06:58:44 1996
--- \emx\gnu\gdb-4.16/gdb/printcmd.c	Thu Jun 27 15:53:20 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* printcmd.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* Print values for GNU debugger GDB.
     Copyright 1986, 1987, 1988, 1989, 1990, 1991, 1993, 1994, 1995
     Free Software Foundation, Inc.
***************
*** 1170,1175 ****
--- 1171,1179 ----
  free_display (d)
       struct display *d;
  {
+ #ifdef __EMX__
+   annotate_display_delete (d->number);
+ #endif /* __EMX__ */
    free ((PTR)d->exp);
    free ((PTR)d);
  }
***************
*** 1332,1338 ****
--- 1336,1346 ----
  
        printf_filtered (" = ");
  
+ #ifdef __EMX__
+       annotate_display_value ();
+ #else /* not __EMX__ */
        annotate_display_expression ();
+ #endif /* not __EMX__ */
  
        print_formatted (evaluate_expression (d->exp),
  		       d->format.format, d->format.size);
***************
*** 1370,1375 ****
--- 1378,1386 ----
      if (d->number == num)
        {
  	d->status = disabled;
+ #ifdef __EMX__
+ 	annotate_display_disable (num);
+ #endif /* __EMX__ */
  	return;
        }
    printf_unfiltered ("No display number %d.\n", num);
***************
*** 1429,1435 ****
--- 1440,1453 ----
    if (p == 0)
      {
        for (d = display_chain; d; d = d->next)
+ #ifdef __EMX__
+ 	{
+ 	  d->status = enabled;
+ 	  annotate_display_enable (d->number);
+ 	}
+ #else /* not __EMX__ */
  	d->status = enabled;
+ #endif /* not __EMX__ */
      }
    else
      while (*p)
***************
*** 1446,1451 ****
--- 1464,1472 ----
  	  if (d->number == num)
  	    {
  	      d->status = enabled;
+ #ifdef __EMX__
+ 	      annotate_display_enable (d->number);
+ #endif /* __EMX__ */
  	      goto win;
  	    }
  	printf_unfiltered ("No display number %d.\n", num);
***************
*** 1469,1475 ****
--- 1490,1503 ----
    if (p == 0)
      {
        for (d = display_chain; d; d = d->next)
+ #ifdef __EMX__
+ 	{
+ 	  d->status = disabled;
+ 	  annotate_display_disable (d->number);
+ 	}
+ #else /* not __EMX__ */
  	d->status = disabled;
+ #endif /* not __EMX__ */
      }
    else
      while (*p)
diff -cr gdb-4.16/gdb/source.c \emx\gnu\gdb-4.16/gdb/source.c
*** gdb-4.16/gdb/source.c	Fri Oct 27 00:54:30 1995
--- \emx\gnu\gdb-4.16/gdb/source.c	Sun Jun 30 15:07:44 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* source.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* List lines of source files for GDB, the GNU debugger.
     Copyright 1986, 1987, 1988, 1989, 1991, 1992, 1993, 1994, 1995
     Free Software Foundation, Inc.
***************
*** 42,47 ****
--- 43,55 ----
  #include "annotate.h"
  #include "gdbtypes.h"
  
+ #ifdef __EMX__
+ /* The file positions computed by GDB don't match a text file's file
+    positions.  Use binary mode instead. */
+ #undef FOPEN_RT
+ #define FOPEN_RT "rb"
+ #endif /* __EMX__ */
+ 
  /* Prototypes for local functions. */
  
  static int open_source_file PARAMS ((struct symtab *));
***************
*** 345,352 ****
--- 353,365 ----
  
        if (name[0] == '~')
  	name = tilde_expand (name);
+ #ifdef __EMX__
+       else if (name[0] != '$')
+ 	name = absfname (name);
+ #else /* not __EMX__ */
        else if (!ROOTED_P (name) && name[0] != '$') 
  	  name = concat (current_directory, SLASH_STRING, name, NULL);
+ #endif /* not __EMX__ */
        else
  	name = savestring (name, p - name);
        make_cleanup (free, name);
***************
*** 445,450 ****
--- 458,469 ----
    if (s->dirname)
      printf_filtered ("Compilation directory is %s\n", s->dirname);
    if (s->fullname)
+ #ifdef __EMX__
+     if (annotation_level > 1)
+       printf_filtered ("Located in \n\032\032source-location\n"
+                        "%s\n\032\032source-location-end\n\n", s->fullname);
+     else
+ #endif /* __EMX__ */
      printf_filtered ("Located in %s\n", s->fullname);
    if (s->nlines)
      printf_filtered ("Contains %d line%s.\n", s->nlines,
***************
*** 497,503 ****
--- 516,526 ----
    mode |= O_BINARY;
  #endif
  
+ #ifdef __EMX__
+   if (try_cwd_first || ROOTED_P (string))
+ #else /* not __EMX__ */
    if (try_cwd_first || SLASH_P (string[0]))
+ #endif /* not __EMX__ */
      {
        int i;
        filename = string;
***************
*** 559,567 ****
--- 582,595 ----
      {
        if (fd < 0)
  	*filename_opened = (char *) 0;
+ #ifndef __EMX__
        else if (ROOTED_P (filename))
  	*filename_opened = savestring (filename, strlen (filename));
+ #endif /* not __EMX__ */
        else
+ #ifdef __EMX__
+ 	*filename_opened = absfname (filename);
+ #else /* not __EMX__ */
  	{
  	  /* Beware the // my son, the Emacs barfs, the botch that catch... */
  	  
***************
*** 571,576 ****
--- 599,605 ----
    				     ? "": SLASH_STRING,
  				     filename, NULL);
          }
+ #endif /* not __EMX__ */
      }
  #ifdef MPW
    /* This is a debugging hack that can go away when all combinations
***************
*** 607,613 ****
--- 636,646 ----
    /* Quick way out if we already know its full name */
    if (s->fullname) 
      {
+ #ifdef __EMX__
+       result = open (s->fullname, O_RDONLY | O_BINARY);
+ #else /* not __EMX__ */
        result = open (s->fullname, O_RDONLY);
+ #endif /* not __EMX__ */
        if (result >= 0)
          return result;
        /* Didn't work -- free old one, try again. */
***************
*** 636,648 ****
--- 669,689 ----
  	}
      }
  
+ #ifdef __EMX__
+   result = openp (path, 0, s->filename, O_RDONLY | O_BINARY, 0, &s->fullname);
+ #else /* not __EMX__ */
    result = openp (path, 0, s->filename, O_RDONLY, 0, &s->fullname);
+ #endif /* not __EMX__ */
    if (result < 0)
      {
        /* Didn't work.  Try using just the basename. */
        p = basename (s->filename);
        if (p != s->filename)
+ #ifdef __EMX__
+ 	result = openp (path, 0, p, O_RDONLY | O_BINARY, 0, &s->fullname);
+ #else /* not __EMX__ */
  	result = openp (path, 0, p, O_RDONLY, 0, &s->fullname);
+ #endif /* not __EMX__ */
      }
  #ifdef MPW
    if (result < 0)
***************
*** 958,963 ****
--- 999,1008 ----
        printf_filtered ("%d\t", current_source_line++);
        do
  	{
+ #ifdef __EMX__
+           if (c == '\r')
+             ; else
+ #endif /* __EMX__ */
  	  if (c < 040 && c != '\t' && c != '\n' && c != '\r')
  	      printf_filtered ("^%c", c + 0100);
  	  else if (c == 0177)
***************
*** 1315,1320 ****
--- 1360,1368 ----
      if (c == EOF)
        break;
      do {
+ #ifdef __EMX__
+      if (c != '\r')
+ #endif /* __EMX__ */
        *p++ = c;
        if (p - buf == cursize)
  	{
***************
*** 1397,1402 ****
--- 1445,1453 ----
        if (c == EOF)
  	break;
        do {
+ #ifdef __EMX__
+         if (c != '\r')
+ #endif /* __EMX__ */
  	*p++ = c;
        } while (c != '\n' && (c = getc (stream)) >= 0);
  
diff -cr gdb-4.16/gdb/symfile.c \emx\gnu\gdb-4.16/gdb/symfile.c
*** gdb-4.16/gdb/symfile.c	Sat Apr  6 10:10:22 1996
--- \emx\gnu\gdb-4.16/gdb/symfile.c	Wed Jul 31 23:48:30 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* symfile.c -- changed for emx by Eberhard Mattes -- Jul 1996 */
  /* Generic symbol file reading for the GNU debugger, GDB.
     Copyright 1990, 1991, 1992, 1993, 1994, 1995, 1996
     Free Software Foundation, Inc.
***************
*** 815,820 ****
--- 816,833 ----
  
    /* Look down path for it, allocate 2nd new malloc'd copy.  */
    desc = openp (getenv ("PATH"), 1, name, O_RDONLY | O_BINARY, 0, &absolute_name);
+ #ifdef __EMX__
+   if (desc < 0)
+     {
+       char *exe = append_exe (name);
+       if (exe != NULL)
+         {
+           desc = openp (getenv ("PATH"), 1, exe, O_RDONLY | O_BINARY, 0,
+                         &absolute_name);
+           free (exe);
+         }
+     }
+ #endif /* __EMX__ */
    if (desc < 0)
      {
        make_cleanup (free, name);
diff -cr gdb-4.16/gdb/symtab.c \emx\gnu\gdb-4.16/gdb/symtab.c
*** gdb-4.16/gdb/symtab.c	Fri Feb 16 23:14:38 1996
--- \emx\gnu\gdb-4.16/gdb/symtab.c	Sat Jun 29 23:40:16 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* symtab.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* Symbol table lookup for the GNU debugger, GDB.
     Copyright 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995
               Free Software Foundation, Inc.
***************
*** 1941,1946 ****
--- 1942,1960 ----
        if (p[0] == ':' || p[0] == ' ' || p[0] == '\t')
  	break;
      }
+ #ifdef __EMX__
+   if (p == *argptr + 1 && p[0] == ':' && p[1] != ':'
+       && isascii (p[-1]) && isalpha (p[-1]))
+     {
+       int i;
+ 
+       for (i = 1; p[i] != 0; ++i)
+         if (p[i] == ' ' || p[i] == '\t' || p[i] == ':')
+           break;
+       if (p[i] == ':')
+         p = p + i;
+     }
+ #endif /* __EMX__ */
    while (p[0] == ' ' || p[0] == '\t') p++;
  
    if ((p[0] == ':') && !has_parens)
***************
*** 2543,2548 ****
--- 2557,2566 ----
      }
  
    wrap_here ("");
+ #ifdef __EMX__
+   if (annotation_level > 1)
+     printf_filtered ("\n\032\032source-file %s\n", name);
+ #endif /* __EMX__ */
    fputs_filtered (name, gdb_stdout);
  }  
  
diff -cr gdb-4.16/gdb/terminal.h \emx\gnu\gdb-4.16/gdb/terminal.h
*** gdb-4.16/gdb/terminal.h	Fri Mar  8 19:31:30 1996
--- \emx\gnu\gdb-4.16/gdb/terminal.h	Wed May  8 22:59:18 1996
***************
*** 1,3 ****
--- 1,5 ----
+ /* terminal.h -- changed for emx by Eberhard Mattes -- May 1996 */
+ 
  /* Terminal interface definitions for GDB, the GNU Debugger.
     Copyright 1986, 1989, 1991, 1992 Free Software Foundation, Inc.
  
***************
*** 63,69 ****
--- 65,75 ----
  #undef TIOCSETN
  #define TIOCSETN TCSETA
  #undef TIOCSETP
+ #ifdef __EMX__
+ #define TIOCSETP TCSETA
+ #else /* not __EMX__ */
  #define TIOCSETP TCSETAF
+ #endif /* not __EMX__ */
  #define TERMINAL struct termio
  
  #else /* sgtty */
diff -cr gdb-4.16/gdb/thread.c \emx\gnu\gdb-4.16/gdb/thread.c
*** gdb-4.16/gdb/thread.c	Wed Aug  2 04:24:36 1995
--- \emx\gnu\gdb-4.16/gdb/thread.c	Thu Jun 27 21:52:06 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* thread.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* Multi-process/thread control for GDB, the GNU debugger.
     Copyright 1986, 1987, 1988, 1993
  
***************
*** 53,58 ****
--- 54,62 ----
    int trap_expected;
    int handling_longjmp;
    int another_trap;
+ #ifdef __EMX__
+   int frozen;
+ #endif
  };
  
  static struct thread_info *thread_list = NULL;
***************
*** 105,112 ****
--- 109,123 ----
    tp->handling_longjmp = 0;
    tp->trap_expected = 0;
    tp->another_trap = 0;
+ #ifdef __EMX__
+   tp->frozen = 0;
+ #endif
    tp->next = thread_list;
    thread_list = tp;
+ #ifdef __EMX__
+   if (annotation_level > 1)
+     printf_filtered ("\n\032\032thread-add %d %d\n", tp->num, pid);
+ #endif /* __EMX__ */
  }
  
  static struct thread_info *
***************
*** 293,298 ****
--- 304,313 ----
  
        printf_filtered ("%d %s  ", tp->num, target_pid_to_str (tp->pid));
  
+ #ifdef __EMX__
+       printf_filtered ("%s  ", tp->frozen ? "disabled" : "enabled");
+ #endif
+ 
        thread_switch (tp->pid);
        print_stack_frame (selected_frame, -1, 0);
      }
***************
*** 310,315 ****
--- 325,334 ----
    if (pid == inferior_pid)
      return;
  
+ #ifdef __EMX__
+   if (annotation_level > 1)
+     printf_filtered ("\n\032\032thread-switch %d\n", pid_to_thread_id (pid));
+ #endif /* __EMX__ */
    inferior_pid = pid;
    flush_cached_frames ();
    registers_changed ();
***************
*** 449,454 ****
--- 468,522 ----
    print_stack_frame (selected_frame, selected_frame_level, 1);
  }
  
+ #ifdef __EMX__
+ 
+ static void
+ thread_enable_disable (tidstr, from_tty, enable)
+      char *tidstr;
+      int from_tty, enable;
+ {
+   int num;
+   struct thread_info *tp;
+ 
+   if (!target_has_execution)
+     error ("The program being debugged is not being run.");
+ 
+   if (!tidstr)
+     num = pid_to_thread_id (inferior_pid);
+   else
+     num = atoi (tidstr);
+ 
+   tp = find_thread_id (num);
+   if (!tp)
+     error ("Thread ID %d not known.  Use the \"info threads\" command to\n\
+ see the IDs of currently known threads.", num);
+ 
+   emx_thread_enable_disable (tp->pid, enable);
+   tp->frozen = !enable;
+   if (annotation_level > 1)
+     printf_filtered ("\n\032\032thread-%s %d\n",
+                      enable ? "enable" : "disable", num);
+ }
+ 
+ static void
+ thread_enable_command (tidstr, from_tty)
+      char *tidstr;
+      int from_tty;
+ {
+   thread_enable_disable (tidstr, from_tty, 1);
+ }
+ 
+ static void
+ thread_disable_command (tidstr, from_tty)
+      char *tidstr;
+      int from_tty;
+ {
+   thread_enable_disable (tidstr, from_tty, 0);
+ }
+ 
+ 
+ #endif
+ 
  void
  _initialize_thread ()
  {
***************
*** 463,468 ****
--- 531,545 ----
  		  "Use this command to switch between threads.\n\
  The new thread ID must be currently known.", &thread_cmd_list, "thread ", 1,
  		  &cmdlist);
+ 
+ #ifdef __EMX__
+   add_cmd ("enable", class_run, thread_enable_command,
+            "Enable (thaw) a thread.", &thread_cmd_list);
+   add_cmd ("disable", class_run, thread_disable_command,
+            "Disable (freeze) a thread.", &thread_cmd_list);
+   add_com_alias ("freeze", "thread disable", class_run, 1);
+   add_com_alias ("thaw", "thread enable", class_run, 1);
+ #endif
  
    add_prefix_cmd ("apply", class_run, thread_apply_command,
  		  "Apply a command to a list of threads.",
diff -cr gdb-4.16/gdb/top.c \emx\gnu\gdb-4.16/gdb/top.c
*** gdb-4.16/gdb/top.c	Sat Apr 13 05:51:42 1996
--- \emx\gnu\gdb-4.16/gdb/top.c	Wed May  8 17:52:06 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* top.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* Top level stuff for GDB, the GNU debugger.
     Copyright 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996
     Free Software Foundation, Inc.
***************
*** 2804,2809 ****
--- 2805,2813 ----
  {
    if (args) error ("The \"pwd\" command does not take an argument: %s", args);
    getcwd (gdb_dirbuf, sizeof (gdb_dirbuf));
+ #ifdef EMX
+   strlwr (gdb_dirbuf);
+ #endif /* EMX */
  
    if (!STREQ (gdb_dirbuf, current_directory))
      printf_unfiltered ("Working directory %s\n (canonically %s).\n",
***************
*** 2836,2841 ****
--- 2840,2848 ----
      perror_with_name (dir);
  
    len = strlen (dir);
+ #ifdef EMX
+   dir = current_directory = absfname (".");
+ #else /* not EMX */
    dir = savestring (dir, len - (len > 1 && SLASH_P(dir[len-1])));
    if (ROOTED_P(dir))
      current_directory = dir;
***************
*** 2887,2892 ****
--- 2894,2900 ----
  	  ++p;
  	}
      }
+ #endif /* not EMX */
  
    forget_cached_source_info ();
  
***************
*** 3321,3327 ****
--- 3329,3339 ----
      /* We include the current directory so that if the user changes
         directories the file written will be the same as the one
         that was read.  */
+ #ifdef EMX
+     history_filename = absfname ("!gdb_history");
+ #else /* not EMX */
      history_filename = concat (current_directory, "/.gdb_history", NULL);
+ #endif /* not EMX */
    }
    read_history (history_filename);
  }
diff -cr gdb-4.16/gdb/utils.c \emx\gnu\gdb-4.16/gdb/utils.c
*** gdb-4.16/gdb/utils.c	Tue Apr 23 05:35:12 1996
--- \emx\gnu\gdb-4.16/gdb/utils.c	Thu Aug  1 00:16:18 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* utils.c -- changed for emx by Eberhard Mattes -- Jul 1996 */
  /* General utility routines for GDB, the GNU debugger.
     Copyright 1986, 1989, 1990, 1991, 1992, 1995 Free Software Foundation, Inc.
  
***************
*** 74,79 ****
--- 75,84 ----
  #define ISATTY(FP)	(isatty (fileno (FP)))
  #endif
  
+ #ifdef __EMX__
+   extern FILE *gdbrxStream;
+ #endif /* __EMX__ */
+ 
  /* Chain of cleanup actions established with make_cleanup,
     to be executed if an error happens.  */
  
***************
*** 524,533 ****
--- 529,542 ----
    if (quit_pre_print)
      fprintf_unfiltered (gdb_stderr, quit_pre_print);
  
+ #ifdef __EMX__
+   if (1)
+ #else /* not __EMX__ */
    if (job_control
        /* If there is no terminal switching for this target, then we can't
  	 possibly get screwed by the lack of job control.  */
        || current_target.to_terminal_ours == NULL)
+ #endif /* not __EMX__ */
      fprintf_unfiltered (gdb_stderr, "Quit\n");
    else
      fprintf_unfiltered (gdb_stderr,
***************
*** 603,608 ****
--- 612,625 ----
    signal (signo, request_quit);
  
  
+ #ifdef __EMX__
+   {
+     sigset_t s;
+     sigemptyset (&s);
+     sigaddset (&s, signo);
+     sigprocmask (SIG_UNBLOCK, &s, NULL);
+   }
+ #endif /* __EMX__ */
  #ifdef REQUEST_QUIT
    REQUEST_QUIT;
  #else
***************
*** 1342,1347 ****
--- 1359,1372 ----
  
    if (linebuffer == 0)
      return;
+ 
+ #ifdef __EMX__
+   if ((stream == stdout || stream == stderr) && gdbrxStream != NULL)
+     {
+       fputs (linebuffer, gdbrxStream);
+       return;
+     }
+ #endif /* __EMX__ */
  
    /* Don't do any filtering if it is disabled.  */
    if (stream != gdb_stdout
diff -cr gdb-4.16/libibert/argv.c \emx\gnu\gdb-4.16/libibert/argv.c
*** gdb-4.16/libibert/argv.c	Fri Jul  7 23:48:28 1995
--- \emx\gnu\gdb-4.16/libibert/argv.c	Wed May  8 23:03:02 1996
***************
*** 1,3 ****
--- 1,5 ----
+ /* argv.c -- changed for emx by Eberhard Mattes -- May 1996 */
+ 
  /* Create and destroy argument vectors (argv's)
     Copyright (C) 1992 Free Software Foundation, Inc.
     Written by Fred Fish @ Cygnus Support
***************
*** 50,56 ****
--- 52,60 ----
  
  #endif	/* __STDC__ */
  
+ #if !defined (__EMX__)
  #include "alloca-conf.h"
+ #endif
  
  #ifndef NULL
  #define NULL 0
diff -cr gdb-4.16/libibert/basename.c \emx\gnu\gdb-4.16/libibert/basename.c
*** gdb-4.16/libibert/basename.c	Tue May 16 21:32:46 1995
--- \emx\gnu\gdb-4.16/libibert/basename.c	Wed May  8 17:46:16 1996
***************
*** 22,27 ****
--- 22,38 ----
  
  #include "config.h"
  
+ #ifdef __EMX__
+ 
+ #include <stdlib.h>
+ 
+ char *basename (const char *name)
+ {
+   return _getname (name);
+ }
+ 
+ #else
+ 
  #ifdef NEED_basename
  
  char *
***************
*** 39,43 ****
--- 50,56 ----
      }
    return (char *) base;
  }
+ 
+ #endif
  
  #endif
diff -cr gdb-4.16/libibert/cplus-de.c \emx\gnu\gdb-4.16/libibert/cplus-de.c
*** gdb-4.16/libibert/cplus-de.c	Wed Mar 20 07:06:16 1996
--- \emx\gnu\gdb-4.16/libibert/cplus-de.c	Wed May  8 17:47:20 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* cplus-de.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* Demangler for GNU C++ 
     Copyright 1989, 1991, 1994, 1995, 1996 Free Software Foundation, Inc.
     Written by James Clark (jjc@jclark.uucp)
***************
*** 216,222 ****
  #endif
  
  static int
! demangle_template PARAMS ((struct work_stuff *work, const char **, string *,
  			   string *));
  
  static int
--- 217,223 ----
  #endif
  
  static int
! demangle_template PARAMS ((struct work_stuff *, const char **, string *,
  			   string *));
  
  static int
diff -cr gdb-4.16/libibert/strsigna.c \emx\gnu\gdb-4.16/libibert/strsigna.c
*** gdb-4.16/libibert/strsigna.c	Tue May 16 21:33:10 1995
--- \emx\gnu\gdb-4.16/libibert/strsigna.c	Wed May  8 23:03:32 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* strsigna.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* Extended support for using signal values.
     Written by Fred Fish.  fnf@cygnus.com
     This file is in the public domain.  */
***************
*** 5,11 ****
--- 6,14 ----
  #include "ansidecl.h"
  #include "libiberty.h"
  
+ #if !defined (__EMX__)
  #include "config.h"
+ #endif
  
  #ifdef LOSING_SYS_SIGLIST
  #define sys_siglist no_such_symbol
***************
*** 211,216 ****
--- 214,224 ----
  #if defined (SIGSAK)
    ENTRY(SIGSAK, "SIGSAK", "Secure attention"),
  #endif
+ #if defined (__EMX__)
+ #if defined (SIGBREAK)
+   {SIGBREAK, "BREAK", "Break"},
+ #endif
+ #endif /* __EMX__ */
    ENTRY(0, NULL, NULL)
  };
  
diff -cr gdb-4.16/readline/emacs_ke.c \emx\gnu\gdb-4.16/readline/emacs_ke.c
*** gdb-4.16/readline/emacs_ke.c	Sun Jan 16 04:39:24 1994
--- \emx\gnu\gdb-4.16/readline/emacs_ke.c	Wed May  8 23:03:52 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* emacs_ke.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* emacs_keymap.c -- the keymap for emacs_mode in readline (). */
  
  /* Copyright (C) 1987, 1989, 1992 Free Software Foundation, Inc.
***************
*** 33,39 ****
--- 34,44 ----
  KEYMAP_ENTRY_ARRAY emacs_standard_keymap = {
  
    /* Control keys. */
+ #if defined (__EMX__)
+   { ISKMAP, (Function *)emacs_emx_keymap }, /* Control-@ */
+ #else
    { ISFUNC, (Function *)0x0 },		/* Control-@ */
+ #endif
    { ISFUNC, rl_beg_of_line },		/* Control-a */
    { ISFUNC, rl_backward },		/* Control-b */
    { ISFUNC, (Function *)0x0 },		/* Control-c */
***************
*** 883,885 ****
--- 888,1025 ----
    { ISFUNC, (Function *)0x0 }
  #endif /* KEYMAP_SIZE > 128 */
  };
+ 
+ #if defined (__EMX__)
+ 
+ KEYMAP_ENTRY_ARRAY emacs_emx_keymap = {
+   { ISFUNC, (Function *)0x0 },      /*   0 */
+   { ISFUNC, (Function *)0x0 },      /*   1 */
+   { ISFUNC, (Function *)0x0 },      /*   2 */
+   { ISFUNC, (Function *)0x0 },      /*   3 */
+   { ISFUNC, (Function *)0x0 },      /*   4 */
+   { ISFUNC, (Function *)0x0 },      /*   5 */
+   { ISFUNC, (Function *)0x0 },      /*   6 */
+   { ISFUNC, (Function *)0x0 },      /*   7 */
+   { ISFUNC, (Function *)0x0 },      /*   8 */
+   { ISFUNC, (Function *)0x0 },      /*   9 */
+   { ISFUNC, (Function *)0x0 },      /*  10 */
+   { ISFUNC, (Function *)0x0 },      /*  11 */
+   { ISFUNC, (Function *)0x0 },      /*  12 */
+   { ISFUNC, (Function *)0x0 },      /*  13 */
+   { ISFUNC, (Function *)0x0 },      /*  14 */
+   { ISFUNC, (Function *)0x0 },      /*  15 */
+   { ISFUNC, (Function *)0x0 },      /*  16 */
+   { ISFUNC, (Function *)0x0 },      /*  17 */
+   { ISFUNC, (Function *)0x0 },      /*  18 */
+   { ISFUNC, (Function *)0x0 },      /*  19 */
+   { ISFUNC, (Function *)0x0 },      /*  20 */
+   { ISFUNC, (Function *)0x0 },      /*  21 */
+   { ISFUNC, (Function *)0x0 },      /*  22 */
+   { ISFUNC, (Function *)0x0 },      /*  23 */
+   { ISFUNC, (Function *)0x0 },      /*  24 */
+   { ISFUNC, (Function *)0x0 },      /*  25 */
+   { ISFUNC, (Function *)0x0 },      /*  26 */
+   { ISFUNC, (Function *)0x0 },      /*  27 */
+   { ISFUNC, (Function *)0x0 },      /*  28 */
+   { ISFUNC, (Function *)0x0 },      /*  29 */
+   { ISFUNC, (Function *)0x0 },      /*  30 */
+   { ISFUNC, (Function *)0x0 },      /*  31 */
+   { ISFUNC, (Function *)0x0 },      /*  32 */
+   { ISFUNC, (Function *)0x0 },      /*  33 */
+   { ISFUNC, (Function *)0x0 },      /*  34 */
+   { ISFUNC, (Function *)0x0 },      /*  35 */
+   { ISFUNC, (Function *)0x0 },      /*  36 */
+   { ISFUNC, (Function *)0x0 },      /*  37 */
+   { ISFUNC, (Function *)0x0 },      /*  38 */
+   { ISFUNC, (Function *)0x0 },      /*  39 */
+   { ISFUNC, (Function *)0x0 },      /*  40 */
+   { ISFUNC, (Function *)0x0 },      /*  41 */
+   { ISFUNC, (Function *)0x0 },      /*  42 */
+   { ISFUNC, (Function *)0x0 },      /*  43 */
+   { ISFUNC, (Function *)0x0 },      /*  44 */
+   { ISFUNC, (Function *)0x0 },      /*  45 */
+   { ISFUNC, (Function *)0x0 },      /*  46 */
+   { ISFUNC, (Function *)0x0 },      /*  47 */
+   { ISFUNC, (Function *)0x0 },      /*  48 */
+   { ISFUNC, (Function *)0x0 },      /*  49 */
+   { ISFUNC, (Function *)0x0 },      /*  50 */
+   { ISFUNC, (Function *)0x0 },      /*  51 */
+   { ISFUNC, (Function *)0x0 },      /*  52 */
+   { ISFUNC, (Function *)0x0 },      /*  53 */
+   { ISFUNC, (Function *)0x0 },      /*  54 */
+   { ISFUNC, (Function *)0x0 },      /*  55 */
+   { ISFUNC, (Function *)0x0 },      /*  56 */
+   { ISFUNC, (Function *)0x0 },      /*  57 */
+   { ISFUNC, (Function *)0x0 },      /*  58 */
+   { ISFUNC, (Function *)0x0 },      /*  59 */
+   { ISFUNC, (Function *)0x0 },      /*  60 */
+   { ISFUNC, (Function *)0x0 },      /*  61 */
+   { ISFUNC, (Function *)0x0 },      /*  62 */
+   { ISFUNC, (Function *)0x0 },      /*  63 */
+   { ISFUNC, (Function *)0x0 },      /*  64 */
+   { ISFUNC, (Function *)0x0 },      /*  65 */
+   { ISFUNC, (Function *)0x0 },      /*  66 */
+   { ISFUNC, (Function *)0x0 },      /*  67 */
+   { ISFUNC, (Function *)0x0 },      /*  68 */
+   { ISFUNC, (Function *)0x0 },      /*  69 */
+   { ISFUNC, (Function *)0x0 },      /*  70 */
+   { ISFUNC, rl_beg_of_line },       /*  71: home */
+   { ISFUNC, rl_get_previous_history }, /*  72: cursor up */
+   { ISFUNC, rl_beginning_of_history }, /*  73: page up */
+   { ISFUNC, (Function *)0x0 },      /*  74 */
+   { ISFUNC, rl_backward },          /*  75: cursor left */
+   { ISFUNC, (Function *)0x0 },      /*  76: center cursor */
+   { ISFUNC, rl_forward },           /*  77: cursor right */
+   { ISFUNC, (Function *)0x0 },      /*  78 */
+   { ISFUNC, rl_end_of_line },       /*  79: end */
+   { ISFUNC, rl_get_next_history },  /*  80: cursor down */
+   { ISFUNC, rl_end_of_history },    /*  81: page down */
+   { ISFUNC, (Function *)0x0 },      /*  82: ins */
+   { ISFUNC, rl_delete },            /*  83: del */
+   { ISFUNC, (Function *)0x0 },      /*  84 */
+   { ISFUNC, (Function *)0x0 },      /*  85 */
+   { ISFUNC, (Function *)0x0 },      /*  86 */
+   { ISFUNC, (Function *)0x0 },      /*  87 */
+   { ISFUNC, (Function *)0x0 },      /*  88 */
+   { ISFUNC, (Function *)0x0 },      /*  89 */
+   { ISFUNC, (Function *)0x0 },      /*  90 */
+   { ISFUNC, (Function *)0x0 },      /*  91 */
+   { ISFUNC, (Function *)0x0 },      /*  92 */
+   { ISFUNC, (Function *)0x0 },      /*  93 */
+   { ISFUNC, (Function *)0x0 },      /*  94 */
+   { ISFUNC, (Function *)0x0 },      /*  95 */
+   { ISFUNC, (Function *)0x0 },      /*  96 */
+   { ISFUNC, (Function *)0x0 },      /*  97 */
+   { ISFUNC, (Function *)0x0 },      /*  98 */
+   { ISFUNC, (Function *)0x0 },      /*  99 */
+   { ISFUNC, (Function *)0x0 },      /* 100 */
+   { ISFUNC, (Function *)0x0 },      /* 101 */
+   { ISFUNC, (Function *)0x0 },      /* 102 */
+   { ISFUNC, (Function *)0x0 },      /* 103 */
+   { ISFUNC, (Function *)0x0 },      /* 104 */
+   { ISFUNC, (Function *)0x0 },      /* 105 */
+   { ISFUNC, (Function *)0x0 },      /* 106 */
+   { ISFUNC, (Function *)0x0 },      /* 107 */
+   { ISFUNC, (Function *)0x0 },      /* 108 */
+   { ISFUNC, (Function *)0x0 },      /* 109 */
+   { ISFUNC, (Function *)0x0 },      /* 110 */
+   { ISFUNC, (Function *)0x0 },      /* 111 */
+   { ISFUNC, (Function *)0x0 },      /* 112 */
+   { ISFUNC, (Function *)0x0 },      /* 113 */
+   { ISFUNC, (Function *)0x0 },      /* 114 */
+   { ISFUNC, rl_backward_word },     /* 115: ctrl cursor left */
+   { ISFUNC, rl_forward_word },      /* 116: ctrl cursor right */
+   { ISFUNC, rl_kill_line },         /* 117: ctrl end */
+   { ISFUNC, (Function *)0x0 },      /* 118: ctrl page down */
+   { ISFUNC, rl_backward_kill_line },/* 119: ctrl home */
+   { ISFUNC, (Function *)0x0 },      /* 120: alt 1 */
+   { ISFUNC, (Function *)0x0 },      /* 121 */
+   { ISFUNC, (Function *)0x0 },      /* 122 */
+   { ISFUNC, (Function *)0x0 },      /* 123 */
+   { ISFUNC, (Function *)0x0 },      /* 124 */
+   { ISFUNC, (Function *)0x0 },      /* 125 */
+   { ISFUNC, (Function *)0x0 },      /* 126 */
+   { ISFUNC, (Function *)0x0 },      /* 127 */
+ };
+ 
+ #endif
diff -cr gdb-4.16/readline/history.c \emx\gnu\gdb-4.16/readline/history.c
*** gdb-4.16/readline/history.c	Sun Jun 12 11:54:44 1994
--- \emx\gnu\gdb-4.16/readline/history.c	Wed May  8 23:04:06 1996
***************
*** 1,3 ****
--- 1,5 ----
+ /* history.c -- changed for emx by Eberhard Mattes -- May 1996 */
+ 
  /* History.c -- standalone history library */
  
  /* Copyright (C) 1989, 1992 Free Software Foundation, Inc.
***************
*** 469,477 ****
--- 471,484 ----
        if (!home)
  	home = ".";
  
+ #ifdef __EMX__
+       return_val = (char *)xmalloc (2 + strlen (home) + strlen ("!history"));
+       sprintf (return_val, "%s/!history", home);
+ #else /* not __EMX__ */
        return_val = (char *)xmalloc (2 + strlen (home) + strlen (".history"));
  
        sprintf (return_val, "%s/.history", home);
+ #endif /* not __EMX__ */
      }
  
    return (return_val);
diff -cr gdb-4.16/readline/keymaps.h \emx\gnu\gdb-4.16/readline/keymaps.h
*** gdb-4.16/readline/keymaps.h	Thu Feb 24 13:19:20 1994
--- \emx\gnu\gdb-4.16/readline/keymaps.h	Wed May  8 23:04:20 1996
***************
*** 1,3 ****
--- 1,5 ----
+ /* keymaps.h -- changed for emx by Eberhard Mattes -- May 1996 */
+ 
  /* keymaps.h -- Manipulation of readline keymaps. */
  
  /* Copyright (C) 1987, 1989, 1992 Free Software Foundation, Inc.
***************
*** 64,69 ****
--- 66,74 ----
  #define ISMACR 2
  
  extern KEYMAP_ENTRY_ARRAY emacs_standard_keymap, emacs_meta_keymap, emacs_ctlx_keymap;
+ #ifdef __EMX__
+ extern KEYMAP_ENTRY_ARRAY emacs_emx_keymap;
+ #endif /* __EMX__ */
  extern KEYMAP_ENTRY_ARRAY vi_insertion_keymap, vi_movement_keymap;
  
  /* Return a new, empty keymap.
diff -cr gdb-4.16/readline/readline.c \emx\gnu\gdb-4.16/readline/readline.c
*** gdb-4.16/readline/readline.c	Thu Jan  4 03:48:24 1996
--- \emx\gnu\gdb-4.16/readline/readline.c	Wed May  8 23:04:32 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* readline.c -- changed for emx by Eberhard Mattes -- May 1996 */
  /* readline.c -- a general facility for reading lines of input
     with emacs style editing and completion. */
  
***************
*** 1165,1170 ****
--- 1166,1180 ----
        screenheight = (int) window_size.ws_row;
      }
  #endif /* TIOCGWINSZ */
+ 
+ #if defined (__EMX__)
+   {
+     int size[2];
+ 
+     _scrsize (size);
+     screenwidth = size[0]; screenheight = size[1];
+   }
+ #endif /* __EMX__ */
  
    /* Environment variable COLUMNS overrides setting of "co" if IGNORE_ENV
       is unset. */
diff -cr gdb-4.16/readline/rldefs.h \emx\gnu\gdb-4.16/readline/rldefs.h
*** gdb-4.16/readline/rldefs.h	Tue Oct 31 19:40:46 1995
--- \emx\gnu\gdb-4.16/readline/rldefs.h	Sat Jun 29 01:49:52 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* rldefs.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* rldefs.h -- an attempt to isolate some of the system-specific defines
     for readline.  This should be included after any files that define
     system-specific constants like _POSIX_VERSION or USG. */
***************
*** 47,52 ****
--- 48,58 ----
  #undef HAVE_BSD_SIGNALS
  #define MINIMAL
  #endif
+ 
+ #ifdef __EMX__
+ #undef HAVE_BSD_SIGNALS
+ #define HAVE_POSIX_SIGNALS
+ #endif /* __EMX__ */
  
  #if defined (__linux__)
  #  include <termcap.h>
diff -cr gdb-4.16/readline/rltty.c \emx\gnu\gdb-4.16/readline/rltty.c
*** gdb-4.16/readline/rltty.c	Sun Oct  8 01:44:06 1995
--- \emx\gnu\gdb-4.16/readline/rltty.c	Mon Jun 10 17:13:30 1996
***************
*** 1,3 ****
--- 1,4 ----
+ /* rltty.c -- changed for emx by Eberhard Mattes -- Jun 1996 */
  /* rltty.c -- functions to prepare and restore the terminal for readline's
     use. */
  
***************
*** 159,164 ****
--- 160,169 ----
  /* Non-zero means that the terminal is in a prepped state. */
  static int terminal_prepped = 0;
  
+ #ifdef __EMX__
+ /* Old setmode() setting, either O_BINARY or O_TEXT. */
+ static int old_mode;
+ #endif /* __EMX__ */
  /* If non-zero, means that this process has called tcflow(fd, TCOOFF)
     and output is suspended. */
  #if defined (__ksr1__)
***************
*** 408,413 ****
--- 413,421 ----
  {
    readline_echoing_p = (otio.c_lflag & ECHO);
  
+ #if defined (__EMX__)
+   tiop->c_lflag &= ~IDEFAULT;
+ #endif /* __EMX__ */
    tiop->c_lflag &= ~(ICANON | ECHO);
  
    if ((unsigned char) otio.c_cc[VEOF] != (unsigned char) _POSIX_VDISABLE)
***************
*** 467,472 ****
--- 475,484 ----
    if (terminal_prepped)
      return;
  
+ #ifdef __EMX__
+   old_mode = setmode (tty, O_BINARY);
+ #endif /* __EMX__ */
+ 
    /* Try to keep this function from being INTerrupted. */
    block_sigint ();
  
***************
*** 502,507 ****
--- 514,523 ----
  
    if (!terminal_prepped)
      return;
+ 
+ #ifdef __EMX__
+   setmode (tty, old_mode);
+ #endif /* __EMX__ */
  
    /* Try to keep this function from being INTerrupted. */
    block_sigint ();
