#ifndef __GCAL_H
#  define __GCAL_H
/*
*  gcal.h:  Program specific macros, typedefs, prototypes...
*
*
*  Copyright (C) 1994, 1995, 1996 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for ANY damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*
*    Free Software Foundation, Inc.
*    59 Temple Place - Suite 330
*    Boston, MA 02111-1307,  USA
*/



/*
*  $Id: gcal.h 2.10 1996/07/02 02:01:00 tom Exp $
*/



/*
*  Include (sub)header files   ;<
*/
#if HAVE_STDIO_H || STDC_HEADERS
#  include <stdio.h>
#endif
#if HAVE_STDLIB_H || STDC_HEADERS
#  include <stdlib.h>
#endif
#if HAVE_STRING_H || STDC_HEADERS
#  include <string.h>
#else /* !HAVE_STRING_H && !STDC_HEADERS */
#  include <strings.h>
#  if !HAVE_STRCHR
#    define strchr       index
IMPORT char *strchr __P_((const char *s, int c));
#  endif /* !HAVE_STRCHR */
#  if !HAVE_STRRCHR
#    define strrchr      rindex
IMPORT char *strrchr __P_((const char *s, int c));
#  endif /* !HAVE_STRRCHR */
#endif
#ifdef __50SERIES
IMPORT char *getenv __P_((const char *env_var));
#endif



/*
*  Basic preprocessor statements and macros.
*/
#ifndef TRUE
#  define  TRUE          (0==0)
#endif
#ifndef FALSE
#  define  FALSE         (!TRUE)
#endif
#define  LOOP            for(;;)
#if HAVE_VOID
#  define  VOID_PTR      void *
#else /* !HAVE_VOID */
#  define  VOID_PTR      char *
#  define  void          int
#endif /* !HAVE_VOID */
#ifndef NULL
#  if !defined __cplusplus || defined __GNUC__
#    define  NULL          ((VOID_PTR)0) 
#  else /* __cplusplus && !__GNUC__ */
#  define  NULL            (0)
#  endif /* __cplusplus && !__GNUC__ */
#endif
#if !HAVE_STRSTR
#  define  strstr        my_strstr
#endif
#if HAVE_TIME_T
#  define  MY_TIME_T     time_t
#else /* !HAVE_TIME_T */
#  define  MY_TIME_T     long
#endif /* !HAVE_TIME_T */
#if !HAVE_UPPER_LOWER
#  define  islower(gc_c) (((gc_c) >= 'a') && ((gc_c) <= 'z'))
#  define  isupper(gc_c) (((gc_c) >= 'A') && ((gc_c) <= 'Z'))
#  define  tolower(gc_c) ((isupper(gc_c)) ? (gc_c) - 'A' + 'a' : (gc_c))
#  define  toupper(gc_c) ((islower(gc_c)) ? (gc_c) - 'a' + 'A' : (gc_c))
#endif
#if !HAVE_ISDIGIT
#  define  isdigit(gc_c) (((gc_c) >= '0') && ((gc_c) <= '9'))
#endif
#if !HAVE_ISALPHA
#  define  isalpha(gc_c) (isupper(gc_c) || islower(gc_c))
#endif
#if !HAVE_ISALNUM
#  define  isalnum(gc_c) (isalpha(gc_c) || isdigit(gc_c))
#endif
#if !HAVE_ISSPACE
#  define  isspace(gc_c) (   (gc_c) == ' '  || (gc_c) == '\f' || (gc_c) == '\n' \
                          || (gc_c) == '\r' || (gc_c) == '\t' || (gc_c) == '\v')
#endif


/*
*  Program specific preprocessor statements.
*/
#ifndef BUF_LEN
#  define BUF_LEN         16384        /* Maximum length of a file block buffer */
#endif
#ifndef MAXLEN_MAX
#  define  MAXLEN_MAX     1024         /* Default length of a "string" text buffer */
#endif
#ifndef MY_ARGC_MAX
#  define  MY_ARGC_MAX    64           /* Default number of command line arguments in `my_argv[]' table */
#endif
#ifndef  EXIT_STAT_HLP
#  define  EXIT_STAT_HLP  0            /* Programs exit status on: help, version, license */
#endif
#define  HD_ELEMS_MAX   100          /* Maximum amount of eternal holidays */
#define  LEN_HD_NAME    29           /* Maximum length of a holiday name inclusive `\0' */
#define  WARN_LVL_MAX   4            /* Maximum amount of debug/warning levels */
/*
*  Preprocessor statements for long options `Lopt_struct' field `symbolic_name'.
*/
#define  SYM_NIL                    0
#define  SYM_BLOCKS                 1
#define  SYM_CALENDAR_DATES         2
#define  SYM_CHRIST_HDY             3
#define  SYM_DATE_FORMAT            4
#define  SYM_DEBUG                  5
#define  SYM_DESC_HOLIDAY_LIST      6
#define  SYM_DE_HDY                 7
#define  SYM_DISABLE_HIGHLIGHTING   8
#define  SYM_EXCLUDE_HD_TITLE       9
#define  SYM_EXIT_STAT_HELP_127     10
#define  SYM_FORCE_HIGHLIGHTING     11
#define  SYM_GREG_REFORM            12
#define  SYM_HELP                   13
#define  SYM_HIGHLIGHTING           14
#define  SYM_HOLIDAY_DATES          15
#define  SYM_HOLIDAY_LIST           16
#define  SYM_LICENSE1               17
#define  SYM_LICENSE2               18
#define  SYM_LICENSE3               19
#define  SYM_LONG_HELP1             20
#define  SYM_LONG_HELP2             21
#define  SYM_MAIL                   22
#define  SYM_RESPONSE_FILE          23
#define  SYM_STARTING_DAY           24
#define  SYM_SUPPRESS_CALENDAR      25
#define  SYM_TYPE_OF_CALENDAR       26
#define  SYM_US_HDY                 27
#define  SYM_VERSION                28
#if USE_PAGER
#  define  SYM_PAGER                  100
#endif
#ifdef GCAL_SHELL
#  define  SYM_SCRIPT_FILE            101
#endif
#if USE_RC
#  define  SYM_ALTERNATIVE_FORMAT     200
#  define  SYM_DATE_VARIABLE          201
#  define  SYM_DESC_FIXED_DATES_LIST  202
#  define  SYM_END_OF_MONTH           203
#  define  SYM_END_OF_WEEK            204
#  define  SYM_END_OF_YEAR            205
#  define  SYM_EXCLUDE_RC_TITLE       206
#  define  SYM_EXPORT_LOCAL_DVARS     207
#  define  SYM_EXPORT_LOCAL_TVARS     208
#  define  SYM_FIXED_DATES            209
#  define  SYM_FIXED_DATES_LIST       210
#  define  SYM_GROUPING_TEXT          211
#  define  SYM_INCLUDE_CONS_NO        212
#  define  SYM_INCLUDE_FILENAME       213
#  define  SYM_INCLUDE_HOLIDAY        214
#  define  SYM_INCLUDE_TODAY          215
#  define  SYM_INCLUDE_WEEK_NO        216
#  define  SYM_LEAP_DAY               217
#  define  SYM_LIST_MODE              218
#  define  SYM_MONTH                  219
#  define  SYM_OMIT_DATE_PART         220
#  define  SYM_PERIOD                 221
#  define  SYM_RESOURCE_FILE          222
#  define  SYM_START_OF_MONTH         223
#  define  SYM_START_OF_WEEK          224
#  define  SYM_START_OF_YEAR          225
#  define  SYM_TEXT_VARIABLE          226
#  define  SYM_TODAY                  227
#  define  SYM_TOMORROW               228
#  define  SYM_WEEK                   229
#  define  SYM_YEAR                   230
#endif
/*
*  Preprocessor statements for long options `Lopt_struct' field `larg_mode'.
*/
#define  LARG_NO         0          /* --foo */
#define  LARG_NO_OR_ONE  1          /* --foo or --foo=BAR */
#define  LARG_ONE        2          /* --foo=BAR */
#define  LARG_ONE_OR_ARG 3          /* --foo=BAR or --foo=ARG */
/*
*  Further preprocessor statements used for long-style options.
*/
#define  LARG_MAX        6          /* Maximum number of arguments a long option may have */
#define  LARG_SEP        "="        /* Argument separator of a long option, e.g. --foo=BAR */
#define  LARG_TXT        "ARG"      /* Text of a symbolic long option argument shown if --long-help is given */
/*
*  Some other common environment variable names.
*/
#define  ENV_VAR_TZ    "TZ"          /* Name of the timezone environment variable */
#if USE_PAGER
#  define  ENV_VAR_LI    "LINES"       /* Name of number of terminal rows environment variable */
#  define  ENV_VAR_CO    "COLUMNS"     /* Name of number of terminal columns environment variable */
#  define  ENV_VAR_LI2   "LI"          /* Name of number of terminal rows environment variable */
#  define  ENV_VAR_CO2   "CO"          /* Name of number of terminal columns environment variable */
#endif
/*
   Further preprocessor symbols.
*/
#define  PSEUDO_BLANK  '_'           /* Used to insert an blank (' ') in places the OS normally forbits its use */
#define  REM_CHAR      ';'           /* Comment character of a resource/response file line */
#define  RSP_CHAR      '@'           /* Marker character of a response file (@response file) */
#define  QUOTE_CHAR    '\\'          /* Character used to quote RC_NL_CHAR etc. */
#define  PSEUDO_QUOTE  '\001'        /* Character used to replace a QUOTE_CHAR */
#define  DFORMAT_CHAR  '%'           /* Identifier leading the character used for ordering a displayed date */
#define  SEP           ":"           /* Separator char of user defined sequences -H<> -v<> */
#define  SWITCH        "-"           /* Default switch char, which defines an command line option */
#define  SWITCH2       "/"           /* First additional switch char */
#define  MLIST_SEP     ","           /* Separator of a list of months (mm,mm) */
#define  MRANGE_SEP    "-"           /* Separator of a range of months (mm-mm) */
#define  YLIST_SEP     ";"           /* Separator of a list of years (yyyy;yyyy) */
#define  YRANGE_SEP    "+"           /* Separator of a range of years (yyyy+yyyy) */
#define  YEAR_SEP      "/"           /* Separator of a standard year (mm/yyyy) */
#define  FYEAR_SEP     ":"           /* Separator of a fiscal year (mm:yyyy) */
#define  MONTH3_LIT    "."           /* Command for enabling 3-month mode (.|..|.+|.-) */
#define  DIS_HLS_PREF  "*"           /* Prefix to disable highlighting of a holiday */
#define  ASC_LIT       "+"           /* Modifier for moving ascending/forwards in date */
#define  DES_LIT       "-"           /* Modifier for moving descending/backwards in date */
#define  GDATE_SEP     ","           /* Separator of a Gregorian reformation date (yyyy,mm,dd,dd) */
#define  FMT_LEN_MIN   3             /* Mininum length of a day "cell" used in calendar sheets */
#define  TXTLEN_DAY    2             /* Minimum length of a textual day name */
#define  TXTLEN_MONTH  3             /* Minimum length of a textual month name */
#define  S_OUT_ROWS    3             /* Number of standard calsheet format default rows standard date */
#define  S_OUT_COLS    4             /* Number of standard calsheet format default columns standard date */
#define  J_OUT_ROWS    4             /* Number of standard calsheet format default rows special date */
#define  J_OUT_COLS    3             /* Number of standard calsheet format default columns special date */
#define  B_OUT_ROWS    12            /* Number of standard calsheet format default rows both dates */
#define  B_OUT_COLS    1             /* Number of standard calsheet format default columns both dates */
#define  SI_OUT_ROWS   4             /* Number of special calsheet format default rows standard date */
#define  SI_OUT_COLS   3             /* Number of special calsheet format default columns standard date */
#define  JI_OUT_ROWS   6             /* Number of special calsheet format default rows special date */
#define  JI_OUT_COLS   2             /* Number of special calsheet format default columns special date */
#define  BI_OUT_ROWS   B_OUT_ROWS    /* Number of special calsheet format default rows both dates */
#define  BI_OUT_COLS   B_OUT_COLS    /* Number of special calsheet format default columns both dates */
#if USE_RC
#  define  A2_OUT_ROWS   1             /* No of default 2-month mode rows both dates */
#  define  A2_OUT_COLS   2             /* No of default 2-month mode columns both dates */
#  define  B2_OUT_ROWS   2             /* No of default 2-month mode rows both dates */
#  define  B2_OUT_COLS   1             /* No of default 2-month mode columns both dates */
#endif
#define  S3_OUT_ROWS   1             /* No of standard calsheet format default 3-month mode rows standard date */
#define  S3_OUT_COLS   3             /* No of standard calsheet format default 3-month mode columns standard date */
#define  J3_OUT_ROWS   S3_OUT_ROWS   /* No of standard calsheet format default 3-month mode rows special date */
#define  J3_OUT_COLS   S3_OUT_COLS   /* No of standard calsheet format default 3-month mode columns special date */
#define  B3_OUT_ROWS   3             /* No of standard calsheet format default 3-month mode rows both dates */
#define  B3_OUT_COLS   1             /* No of standard calsheet format default 3-month mode columns both dates */
#define  SI3_OUT_ROWS  S3_OUT_ROWS   /* No of special calsheet format default 3-month mode rows standard date */
#define  SI3_OUT_COLS  S3_OUT_COLS   /* No of special calsheet format default 3-month mode columns standard date */
#define  JI3_OUT_ROWS  B3_OUT_ROWS   /* No of special calsheet format default 3-month mode rows special date */
#define  JI3_OUT_COLS  B3_OUT_COLS   /* No of special calsheet format default 3-month mode columns special date */
#define  BI3_OUT_ROWS  B3_OUT_ROWS   /* No of special calsheet format default 3-month mode rows both dates */
#define  BI3_OUT_COLS  B3_OUT_COLS   /* No of special calsheet format default 3-month mode columns both dates */
#define  CENTURY       1900          /* Operating system standard starting century, DON'T change ! */
/*
*  German language dependent preprocessor statements.
*/
#if USE_GER
#  define  HD_LIST_TITLE  "Ewige Feiertagsliste"
#  define  RESPONSE_TXT   "Antwortdatei"
#  define  CREATED_TXT    "Erzeugt"
#  define  INTERNAL_TXT   "Intern"
#  if USE_RC
#    define  TIME_SEP       "."             /* Used time separator hh.mm */
#    define  RC_AM_TXT      "am"            /* Trailing text of %time12 macro */
#    define  RC_PM_TXT      "pm"            /* Trailing text of %time12 macro */
#    define  RC_LIST_TITLE  "Terminliste"
#  endif
#  ifdef GCAL_SHELL
#    define  SCRIPT_TXT     "shell script"
#  endif
#endif /* USE_GER */
/*
   Important preprocessor symbols for the internal ranges.
*/
#define  DAY_LAST    365             /* Last day in a NON leap year */
#define  DAY_MIN     1               /* Minimum day of week/month/year */
#define  DAY_MAX     7               /* Maximum day/amount of days of week */
#define  WEEK_MAX    52              /* Maximum week number of year */
#define  MONTH_MIN   1               /* Minimum month of year */
#define  MONTH_MAX   12              /* Maximum month of year */
#define  YEAR_MIN    1               /* Minimum year able to compute */
#define  YEAR_MAX    9999            /* Maximum year able to compute */
#define  EASTER_MIN  464             /* Minimum year for computing Easter Sunday (463+1) */
#define  EASTER_MAX  YEAR_MAX        /* Maximum year for computing Easter Sunday */
#define  MONTH_COLS  6               /* Maximum number of columns of a month */
#define  VEC_BLOCK   42              /* Maximum number of elements per month (7*6) */
#define  VEC_ELEMS   504             /* Maximum number of elements per year (42*12) */
/*
*  Fixed date warnings/resource file specific preprocessor statements.
*/
#if USE_RC
#  ifndef RC_ELEMS_MAX
#    define  RC_ELEMS_MAX       1024      /* Default number of `rc_elems_table[]' entries */
#  endif
#  ifndef RC_FILES_MAX
#    define  RC_FILES_MAX       8         /* Default number of `rc_files_table[]' entries */
#  endif
#  define  RC_MIN_BCE_TO_1_CE 1721424L  /* Days between 1.5-Jan-4713 BCE and 1.5-Jan-0001 CE */
#  define  RC_DVAR_MAX        26        /* Maximum number of date variables */
#  define  RC_TVAR_MAX        RC_DVAR_MAX  /* Maximum number of text variables */
#  define  RC_DLIST_CHAR      ','       /* Separator of a list of days (www,www... or Nwww,Nwww... or wwwN,wwwN...) */
#  define  RC_DRANGE_CHAR     '#'       /* Separator of a range of days (www#www or Nwww#Nwww or wwwN#wwwN) */
#  define  RC_REPEAT_CHAR     ':'       /* Separator of a "repeat for N days since..." coding (e.g.: yyyymmdd:10) */
#  define  RC_APPEARS_CHAR    '.'       /* Separator of a "appears each N'th day since..." coding (e.g.: yyyymmdd:10.3) */
#  define  RC_ADATE_CHAR      '%'       /* Leading char of a modified actual date %... */
#  define  RC_HDY_CHAR        '@'       /* RC-file holiday/date-variable prefix in date part */
#  define  RC_NWD_CHAR        '*'       /* RC-file n'th weekday prefix in date part */
#  define  RC_NL_CHAR         '~'       /* Inserts a real newline '\n' character if found */
#  define  RC_EASTER_CHAR     'e'       /* Leading char of a @easter date part */
#  define  RC_TVAR_CHAR       '$'       /* RC-file text variable prefix */
#  define  RC_MACRO_CHAR      '%'       /* RC-file macro prefix */
#  define  RC_SDATE_CHAR      's'       /* Leading char of a %starting date macro */
#  define  RC_EDATE_CHAR      'e'       /* Leading char of a %ending date macro */
#  define  RC_WNAME_CHAR      'o'       /* Leading char of a %effective weekday name text macro */
#  define  RC_WNUMBER_CHAR    'k'       /* Leading char of a %week number macro */
#  define  RC_BYEAR_CHAR      'b'       /* Leading char of a %birthyear macro */
#  define  RC_DATE_CHAR       'n'       /* Leading char of a %effective date text macro */
#  define  RC_DAY_CHAR        'd'       /* Leading char of a %day macro */
#  define  RC_WEEK_CHAR       'w'       /* Leading char of a %week macro */
#  define  RC_MONTH_CHAR      'm'       /* Leading char of a %month macro */
#  define  RC_YEAR_CHAR       'y'       /* Leading char of a %year macro */
#  define  RC_TIME_CHAR       't'       /* Leading char of a %time macro */
#  define  RC_JDAYS_CHAR      'j'       /* Leading char of a %julian days since 1.5-Jan-4713 BCE macro */
#  define  RC_HLS1S_CHAR      '1'       /* Leading char of a %highlighting sequence 1 enable macro */
#  define  RC_HLS1E_CHAR      '2'       /* Leading char of a %highlighting sequence 1 disable macro */
#  define  RC_HLS2S_CHAR      '3'       /* Leading char of a %highlighting sequence 2 enable macro */
#  define  RC_HLS2E_CHAR      '4'       /* Leading char of a %highlighting sequence 2 disable macro */
#  define  RC_FNAME_SEP       "+"       /* List separator of resource file names -f|F<NAME[+NAME+...]>*/
#  define  RC_DVAR_ASSIGN     "="       /* Assignment operator of a date variable (dvar=mmdd) */
#  define  RC_TVAR_ASSIGN     RC_DVAR_ASSIGN   /* Assignment operator of a text variable ($tvar=TEXT) */
#  define  RC_DVAR_ADD        "+"       /* Add operator of a date variable (dvar++ | dvar+=<n> ...) */
#  define  RC_DVAR_SUB        "-"       /* Subtract operator of a date variable (dvar-- | dvar-=<n> ...) */
#  define  RC_GROUP_SEP       ""        /* Default grouping `text' of fixed date list [-c]g */
#  define  RC_INCL_STMENT     "#include"         /* Name of RC-file include statement (upper) */
#  define  RC_INCL_USR_ID     "\""               /* User include file name starts with */
#  define  RC_INCL_USR_OD     RC_INCL_USR_ID     /* User include file name ends with */
#  define  RC_INCL_SYS_ID     "<"                /* System include file name start with */
#  define  RC_INCL_SYS_OD     ">"                /* System include file name ends with */
#  define  ENV_VAR_USR_DATADIR "GCAL_USR_DATADIR"  /* Environment variable name of user datadir */
#  define  ENV_VAR_SYS_DATADIR "GCAL_SYS_DATADIR"  /* Environment variable name of system data dir */
#  define  USAGE_RC1          " c f"          /* Additional usage text */
#  define  USAGE_RC2          " v"            /* Additional usage text */
#else /* !USE_RC */
#  define  USAGE_RC1          ""
#  define  USAGE_RC2          ""
#endif /* !USE_RC */
#if USE_PAGER
#  define  PAGER_QUIT         "q"             /* Quits the internal pager */
#  define  USAGE_PAGER        " p"            /* Additional usage text */
#else /* !USE_PAGER */
#  define  USAGE_PAGER        ""
#endif /* !USE_PAGER */
#ifdef GCAL_EMAIL
#  define USAGE_MAIL          " m"            /* Additional usage text */
#else /* !GCAL_EMAIL */
#  define USAGE_MAIL          ""
#endif /* !GCAL_EMAIL */
#ifdef GCAL_SHELL
#  define USAGE_SHELL         " S"            /* Additional usage text */
#else /* !GCAL_SHELL */
#  define USAGE_SHELL         ""
#endif /* !GCAL_SHELL */


/*
*  And last but not least...
*/
#define  COPYRIGHT_TXT  "Copyright (C) 1994-1996 Thomas Esken"


/*
*  Common preprocessor macros.
*/
#define  S_NEWLINE(gc_fp)    fputc('\n', (gc_fp))
#ifndef MAX
#  define  MAX(gc_v1, gc_v2)   (((gc_v1)>(gc_v2)) \
                                 ? (gc_v1) \
                                 : (gc_v2))
#endif
#if USE_RC
#  define IDX(gc_c)            (tolower((gc_c)) - 'a')
#endif
#define  SYEAR(gc_d, gc_s)   (((gc_d)-(gc_s)+1) < DAY_MIN) \
                               ? ((gc_d)-(gc_s)+(DAY_MAX+1)) \
                               : ((gc_d)-(gc_s)+1)
#define  SMONTH(gc_d, gc_s)  (((gc_d)+(gc_s)-1) > MONTH_MAX) \
                               ? ((gc_d)+(gc_s)-(MONTH_MAX+1)) \
                               : ((gc_d)+(gc_s)-1)
#define  SDAY(gc_d, gc_s)    (((gc_d)+(gc_s)-1) > DAY_MAX) \
                               ? ((gc_d)+(gc_s)-(DAY_MAX+1)) \
                               : ((gc_d)+(gc_s)-1)



#ifdef CUT_LONGNAMES
/*
*  Cut resp., replace some long variable or function names to 6 significant
*    places so ANY linker should be able to bind an executable file.
*/
#  define compare_d_m_name             F_cdm
#  define comparemode                  V_cm
#  if !USE_RC
#    define days_of_feb                  V_dof
#  endif
#  if USE_RC
#    define fiscal_month                 V_fm
#    define fiscal_year                  V_fy
#  endif
#  define days_of_february             F_dof
#  if USE_HLS || USE_PAGER
#    define get_termcap_hls              F_ghl
#    define get_termcap_scr_attrib       F_gsc
#  endif
#  define get_tty_hls                  F_gth
#  if USE_PAGER
#    define get_tty_scr_size             F_gts
#  endif
#  define hd_title_flag                V_htf
#  define hd_title_shown               V_hts
#  define holiday_flag                 V_hf
#  define holiday_name                 V_hn
#  define holiday_prefix               V_hp
#  define holiday_vector               V_hv
#  define is_3month_mode               V_3m
#  define is_3month_mode2              V_3m2
#  if USE_RC
#    define insert_line_into_table       F_ilt
#    define insert_response_file         F_irf
#  endif
#  define is_ext_list                  V_iel
#  define is_ext_range                 V_ier
#  define is_ext_year                  V_iey
#  define is_tty                       V_it
#  define is_tty1                      V_it1
#  define is_tty2                      V_it2
#  define longopt                      V_lo
#  define longopt_symbolic             V_los
#  define module_line                  V_mdl
#  define module_name                  V_mdn
#  define month_list                   V_ml
#  define month_list_max               V_mlm
#  define month_name                   F_mn
#  define month_set                    V_ms
#  define my_argc                      V_mac
#  define my_argc_max                  V_max
#  define my_argv                      V_mav
#  define my_help_head_text            F_mhh
#  define my_help_tail_text            F_mht
#  if USE_RC
#    define num_of_range_chars           V_nrc
#    define num_of_repeat_chars          V_noc
#    define num_of_appears_chars         V_nfc
#    define precomp_date                 F_pd
#    define precomp_nth_wd               F_pwd
#  endif
#  define print_all_holidays           F_pah
#  define print_calendar               F_pc
#  define print_highlighted_date       F_phd
#  if USE_HLS
#    define print_hls                    V_phl
#  endif
#  if USE_RC
#    define print_line                   V_pl
#  endif
#  define print_single_holiday         F_psh
#  define print_text                   F_ptx
#  define print_unhighlighted_date     F_pud
#  if USE_RC
#    define print_twice                  V_ptw
#    define rc_elems_table               V_ret
#    define rc_elems_max                 V_rem
#    define rc_elems                     V_rei
#    define rc_enable_fn_flag            V_rfn
#    define rc_enable_hda_flag           V_rha
#    define rc_enable_hdl_flag           V_rhl
#    define rc_export_ldvar_flag         V_red
#    define rc_export_ltvar_flag         V_ret
#    define rc_feb_29_to_feb_28          V_f2f
#    define rc_feb_29_to_mar_01          V_f2m
#    define rc_files_table               V_rft
#    define rc_files_max                 V_rfm
#    define rc_files                     V_rfi
#    define rc_filename                  V_rfn
#    define rc_period                    V_rp
#    define rc_period_flag               V_rpf
#    define rc_period_list               V_rpl
#    define rc_use                       F_ru
#    define rc_use_flag                  V_ruf
#    define rc_week_flag                 V_rwf
#    define rc_weekno_flag               V_rwn
#    define rc_week_year_flag            V_rwy
#  endif
#  define short_day_name               F_sdn
#  define short_month_name             F_smn
#  define special_flag                 V_sf
#  define special_vector               V_sv
#  define users_date_format            V_ud
#  define users_greg                   V_ug
#  define use_day_suffix               V_uds
#  define use_day_zeroleaded           V_udz
#endif /* CUT_LONGNAMES */



/*
*  Type definitions.
*/
typedef
  unsigned char
  Uchar;
typedef
  unsigned int
  Uint;
#ifdef DJG
typedef
#  if __STDC__
  unsigned short int
#  else /* !__STDC__ */
  unsigned short
#  endif /* !__STDC__ */
  Usint;
#endif /* DJG */
typedef
#if __STDC__
  signed long int
#else /* !__STDC__ */
  long
#endif /* !__STDC__ */
  Slint;
typedef
#if __STDC__
  unsigned long int
#else /* !__STDC__ */
  unsigned long
#endif /* !__STDC__ */
  Ulint;
typedef
  int
  Bool;
/*
*  The quicksort function type.
*/
typedef
  int
  (*Func_cmp)(const VOID_PTR, const VOID_PTR);
/*
*  The long option record, see file `gcal.c' for detailed description of it!
*/
typedef
  struct long_option_type
   {
     int    symbolic_name;
     char  *long_name;
     char  *short_name[LARG_MAX];
     int    larg_mode;
     char  *largs[LARG_MAX];
   }
  Lopt_struct;
/*
*  The highlighting sequence record.
*/
typedef
  struct   hls_type
   {
     const char  *seq;
           int    len;
   }
  Hls_struct;
/*
*  The list/range of months/years record.
*/
typedef
  struct  ml_type
   {
     int  month;
     int  year;
   }
  Ml_struct;
/*
*  The supported date format record.
*/
typedef
  struct   date_format_type
   {
     char  *id;        /* Identifying text of the format */
     char  *info;      /* Description text of the format */
     char  *format;    /* The format text itself */
   }
  Df_struct;
/*
*  The Gregorian Reformation date record.
*/
typedef
  struct  greg_type
   {
     int  year;        /* Year of Gregorian Reformation */
     int  month;       /* Month of Gregorian Reformation */
     int  first_day;   /* First missing day of Reformation period */
     int  last_day;    /* Last missing day of Reformation period */
   }
  Greg_struct;
#if USE_RC
/*
*  The date variable records.
*/
typedef
  struct   dvar_base_type
   {
     char  month;
     char  day;
   }
  Dvar_base_struct;
typedef
  struct dvar_type
   {
     Dvar_base_struct  g;   /* Global date variables */
     Dvar_base_struct  l;   /* Local date variables */
   }
  Dvar_struct;
/*
*  The text variable records.
*/
typedef
  struct   tvar_base_type
   {
     char  *text;
   }
  Tvar_base_struct;
typedef
  struct   tvar_type
   {
     Tvar_base_struct  g;   /* Global text variables */
     Tvar_base_struct  l;   /* Local text variables */
   }
  Tvar_struct;
/*
*  The line part record.
*/
typedef
  struct   line_type
   {
     Bool   day_list;       /* List of days given? */
     Bool   day_range;      /* Range of days given? */
     char  *day_part;       /* Points to the list/range of days of a line, otherwise NULL */
     char  *repeat_part;    /* Points to the "repeat for N days since..." field of a line, otherwise NULL */
     char  *appears_part;   /* Points to the "appears each N'th day since..." field of a line, otherwise NULL */
     char  *text_part;      /* Points to the text part of a line (always) */
   }
  Line_struct;
/*
*  The file type record.
*/
typedef
  struct file_type
   {
     FILE              *fp;                         /* Actual file pointer */
     char              *filename;                   /* Name of actual resource/include file */
     long               line_number;                /* Actual line number of actual resource/include file */
     int                in_pool;                    /* Number of bytes still unhandled in self-managed buffer */
     char              *pool;                       /* Memory region of self-managed buffer */
     char              *ptr_pool;                   /* Pointer to next unmanaged character in self-managed buffer */
     Dvar_base_struct   local_dvars[RC_DVAR_MAX];   /* Buffered local date variables of a "previous" file */
     Tvar_base_struct   local_tvars[RC_TVAR_MAX];   /* Buffered local text variables of a "previous" file */
   }
  File_struct;
#endif /* USE_RC */
/*
*  General purpose enumerations.
*/
typedef
  enum compare_mode
   {
       DAy=1,
#if USE_RC
       DVar,
       EAster,
       WEek,
#endif
       MOnth
   }
  Cmode_enum;
typedef
  enum file_mode
   {
       REsponse=1,
#if USE_RC
       USr_include,
       SYs_include,
       REsource,
#endif
#ifdef GCAL_SHELL
       SCript,
#endif
       COmmon
   }
  Fmode_enum;
#if USE_RC
typedef
  enum dvar_mode
   {
       GLobal=1,
       LOcal
   }
  Dvar_enum;
typedef
  Dvar_enum
  Tvar_enum;
#endif
#endif /* __GCAL_H */
