PROGRAM ShowRandomGnomes; { witty sayings, jokes, etc. }
USES dos, crt;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  :1993/07/14.  First public release.  DDA
v1.00a :1993/08/30.  Fixed cursoron procedure, with thanks to David Cheung.
                      Increased allowable length of filename from 12 to 48
                      characters.  DDA
v1.01  :1993/09/10.  New getcursor and setcursor procedures, via Randall
                          Woodman.  Supercede cursoroff/ cursoron.     DDA
v1.02  :1993/09/27.  Refined getcursor and setcursor procedures, with much
                          help from Mark Shadley.  DDA
v1.03  :1994/08/18.  Rewrote and optimized many procedures.  DDA

------------------------------------------------------------------------------}

VAR
  maxwidth :byte;
  barline  :STRING;

PROCEDURE showhelp (problem :byte);
{----
 If any *foreseen* errors arise, we are sent
  here to give a little help and exit (relatively) peacefully
----}
CONST
  progdesc = 'GNOMES- Free DOS utility: random tagline displayer.';
  author   = 'v1.03: August 18, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';
  usage1   = 'Usage: GNOMES [/s (single)] [file from which to choose a gnome]';
  usage2   = ' >> Read gnomes.doc for explanation.';
VAR
  message :STRING[79];
BEGIN
  normvideo;
  writeln (progdesc);  writeln (author);   writeln;
  writeln (usage1);    writeln (usage2);   writeln;
  IF (problem > 0) THEN BEGIN
    CASE (problem) OF
      2 :message:='The first line in the gnomes file must be the number of gnomes in the file.';
      7 :message:='Error opening or closing the gnomes text file.';
    ELSE message:='Unknown error.';
    END;
    writeln ('Error encountered:'); writeln (message);
  END;
  halt (problem);
END;

{ these two cursor procedures are via Randall Woodman }

PROCEDURE getcursor (VAR csize :integer);
CONST
  videoio = $0010;
  getcur  = $0300;
VAR
  regs :registers;
BEGIN
  regs.ax:=getcur;
  intr (videoio, regs);
  csize:=regs.cx;                      { upper scan line }
END;

PROCEDURE setcursor (csize :integer);
CONST
  videoio = $0010;
  cshape  =     1;
VAR
  regs :registers;
BEGIN
  regs.cx:=csize;
  regs.ah:=cshape;
  intr (videoio, regs);
END;

PROCEDURE initvars (VAR gnomes :text; VAR numlines :longint; VAR lone :boolean);
VAR
  p1,
  gpath     :pathstr;
  gdir      :dirstr;
  gname     :namestr;
  gext      :extstr;
  line1     :STRING[7];
  valcode   :integer;
BEGIN
  p1:=paramstr (1);
  IF ('/'+upcase (p1[2]) = '/S') THEN BEGIN
    writeln;
    lone:=true;
    gpath:=paramstr (2);
  END
  ELSE BEGIN
    lone:=false;
    gpath:=p1;
  END;

  IF (gpath = '') THEN BEGIN
    fsplit (fexpand (paramstr (0)), gdir, gname, gext);
    gpath:=gdir+'gnomes.txt';
  END;

  assign (gnomes, gpath);
  {$i-} reset (gnomes);                {$i+}
  IF (ioresult <> 0) THEN
    showhelp (7);
  readln (gnomes, line1);
  val (line1, numlines, valcode);
  IF (valcode <> 0) THEN
    showhelp (2);
END;

FUNCTION leadingzero (w :word) :STRING;  {called by wdatetime to format time.}
VAR
  s :STRING;
BEGIN
  str (w :0, s);
  IF (length (s) = 1) THEN
    s:='0'+s;
  leadingzero:=s;
END;

PROCEDURE wdatetime;      {called by displaygnome to write system time.}
CONST
  st = 'System time is:'#32#32;
VAR
  hour,min,sec, hund :word;
BEGIN
  gettime (hour, min, sec, hund);
  writeln (st :maxwidth-8,
      leadingzero (hour), ':',
      leadingzero (min), ':',
      leadingzero (sec));
END;

FUNCTION wrapgnome (gnome :STRING) :STRING;
{---- Split line after maxwidth character or nearest preceding space ----}
CONST
  hyphen=#45; space=#32;   { single ways of minimizing typing errors }
VAR
  parta,partb  :STRING;    { first and second part of line }
  breakchar    :STRING[1]; { character which will eventually be a space }
  breakfound   :boolean;
  breakpos     :byte;
BEGIN
  breakpos:=maxwidth+2;
  breakfound:=false;
  {----
  Search for a space or a hyphen or the ASCII 255 non-displaying char,
  by decrementing the breakpos while checking validity
  ----}
  WHILE ((NOT breakfound) AND (breakpos > 1)) DO BEGIN
    dec (breakpos);
    breakfound:=gnome[breakpos] IN [space,hyphen,#255];
  END;
  {---- If unable to find a valid breakpoint, break at max width ----}
  IF (NOT breakfound) THEN breakpos:=maxwidth+1;

  parta:=copy (gnome, 1, breakpos-1);
  partb:=copy (gnome, breakpos+1, length (gnome)-(breakpos));
  breakchar:=gnome[breakpos];

  IF (NOT (breakchar[1] IN [space, #255])) THEN
  {save non-blank breakchar}
    IF (breakpos <= maxwidth) THEN parta:=parta+breakchar
                              ELSE partb:=breakchar+partb;

  {---- Write first part to the screen, and return the second part ----}
  writeln (parta);
  wrapgnome:=partb;
END;

PROCEDURE displaygnome (VAR gnomes :text; tlines :longint; lone :boolean);
VAR
  count,
  gnome_numb  :integer;
  gnome       :STRING;
BEGIN
  count:=0;
  textattr:=succ (textattr);
  IF ((textattr = 15) AND (NOT lone)) THEN BEGIN
    wdatetime;
    writeln (barline);
    textattr:=9;
  END;
  reset (gnomes);
  gnome_numb:=1+random (tlines);
  REPEAT
    readln (gnomes, gnome);
    inc (count);
  UNTIL (count = gnome_numb+1) or eof(gnomes);
  WHILE (length (gnome) > maxwidth) DO
    gnome:=wrapgnome (gnome);
  writeln (gnome);
  IF (NOT lone) THEN BEGIN
    writeln (barline);
    count:=0;
    WHILE ((NOT keypressed) AND (count < 50)) DO BEGIN
      delay (96);
      inc (count);
    END;
  END;
END;

VAR
  gfile    :text;
  numlines :longint;
  single   :boolean;
  cursor   :integer;

BEGIN
  maxwidth:=lo (windmax);
  barline[0]:=chr (maxwidth);
  fillchar (barline[1], maxwidth, #196);
  checkbreak:=false;
  initvars (gfile, numlines, single);
  getcursor (cursor);
  setcursor ($2000);                   { turn cursor off }
  textattr:=8;
  IF (NOT single) THEN clrscr;
  randomize;
  REPEAT
    displaygnome (gfile, numlines, single);
  UNTIL (keypressed OR single);
  IF (NOT single) THEN readkey;
  close (gfile);
  normvideo;
  setcursor (cursor);
END.
