unit Options;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Spin, ExtCtrls, SelDir;

type
  TFormOptions = class(TForm)
    PanelOptions: TPanel;
    BitBtnOK: TBitBtn;
    BitBtnCancel: TBitBtn;
    Bevel1: TBevel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    SpinEditBtnSize: TSpinEdit;
    Label2: TLabel;
    Label3: TLabel;
    EditBtnsPerPage: TEdit;
    ComboBoxGlyphs: TComboBox;
    ListBoxDirectory: TListBox;
    BitBtnAdd: TBitBtn;
    BitBtnDelete: TBitBtn;
    GroupBoxDelphiDir: TGroupBox;
    EditDelphiDir: TEdit;
    procedure BitBtnAddClick(Sender: TObject);
    procedure BitBtnOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtnDeleteClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation
uses
  Main;
{$R *.DFM}

procedure TFormOptions.BitBtnAddClick(Sender: TObject);
var FormSelectDirectory: TFormSelectDirectory;
begin
  FormSelectDirectory := TFormSelectDirectory.Create(Self);
  FormSelectDirectory.ShowModal;
  FormSelectDirectory.Free;
end;

procedure TFormOptions.BitBtnOKClick(Sender: TObject);
var
  i: integer;
begin
  with Form1 do
  begin
    ComboBoxDir.Clear;
    for i := 0 to ListBoxDirectory.Items.Count - 1 do
      ComboBoxDir.Items.Strings[i] :=
                                 ListBoxDirectory.Items.Strings[i];
    ComboBoxDir.ItemIndex := 0;
    SpeedButtonDisplay.Caption := '&Display';
    SpeedButtonPgDn.Enabled := FALSE;
    iButSize := StrToInt(SpinEditBtnSize.Text);
    iNumOfGlyphs := StrToInt(ComboBoxGlyphs.Text);
    iSetLimit := StrToInt(EditBtnsPerPage.Text);
    DeleteOldButs;
  end;
end;

procedure TFormOptions.FormCreate(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to Form1.ComboBoxDir.Items.Count - 1 do
    ListBoxDirectory.Items.Add(Form1.ComboBoxDir.Items.Strings[i]);
  ListBoxDirectory.ItemIndex := 0;
  ComboBoxGlyphs.Items.Add('1');
  ComboBoxGlyphs.Items.Add('2');
  ComboBoxGlyphs.Items.Add('3');
  ComboBoxGlyphs.Items.Add('4');
  ComboBoxGlyphs.Text := IntToStr(Form1.iNumOfGlyphs);
  EditBtnsPerPage.Text := IntToStr(Form1.iSetLimit);
  SpinEditBtnSize.Text := IntToStr(Form1.iButSize);
end;

procedure TFormOptions.BitBtnDeleteClick(Sender: TObject);
begin
  with ListBoxDirectory.Items do
    Delete(ListBoxDirectory.ItemIndex); { delete the highlighted item }
  ListBoxDirectory.ItemIndex := 0;
end;

end.
