;GIFRES v1.00 Copyright (C) 1993 R.JANORKAR 03/04/93
;Detects GIF image resolutions and returns ERRORLEVELs
;       0 = Resolution is 640x480 or better
;       1 = Resolution is under 640x480
;       2 = Not a GIF file
;     255 = File not found or read error.

;Compiled with MicroSoft Macro Assembler (MASM) v5.1
;Linked with MicroSoft Linker v5.13

;Freeware, NO registration required, use and distribute freely!
;The author retains all rights to this source code.

;This program and source code is provided with NO warrantees, expressed
;or implied. Use it at your own risk. The author of this program code
;will NOT be liable for any damages, direct or indirect, arising from the
;ability or disability to use this program. The use of this program on
;your computer system indicates your acceptance of these disclaimers.

;Simply reads first 10 bytes of file, identifies header (if GIF or not)
;then checks resolution. Returns over/under 640x480 resolution via
;DOS ERRORLEVELS.

;Syntax: GIFRES <\path\filename.ext>

;Feedback welcomed, Ron Janorkar
;                   651 Richmond Road,
;                   Staten Island, NY 10304-2409
;               BBS (718) 876-0337

STACK     SEGMENT PARA STACK 'STACK'

STACK     ENDS

_DATA     SEGMENT WORD PUBLIC 'DATA'

MESSAGE DB      ".GIF Resolution detection utility v1.00 (C)1993 R.Janorkar",0Dh,0Ah,24h
BAD_CMD DB      "Syntax error: GIFRES <\path\filename.ext>",0Dh,0Ah
        DB      "ERRORLEVELs returned: 0 = resolution 640x480 or better,",0Dh,0Ah
        DB      "                      1 = resolution under 640x480,",0Dh,0Ah
        DB      "                      2 = not a GIF file,",0Dh,0Ah
        DB      "                    255 = error File not found.",0Dh,0Ah,24h
BAD_FILE DB     "Error: File not found or unable to read file!",0Dh,0Ah,24h
GIF_ERR DB      "Not a GIF file!",0Dh,0Ah,24h
GOOD_RES DB     "Over 640x480 resolution.",0Dh,0Ah,24h
BAD_RES  DB     "Poor resolution GIF detected!",0Dh,0Ah,24h
READ_BUFF DB    10 DUP(0)

_DATA     ENDS

_TEXT     SEGMENT WORD PUBLIC 'CODE'
          ASSUME   CS:_TEXT,DS:_DATA,SS:STACK

start:
        MOV     SI,0080h                ;GET FILE NAME
        XOR     CH,CH

        LODSB           ;GET SIZE
        CMP     AL,0    ;IS IT 0?
        JZ      CMD_ERR ;THEN NO COMMAND LINE, ERROR
        CMP     AL,1    ;OR 1?
        JZ      CMD_ERR ;THEN NO COMMAND LINE, ERROR

        MOV     CL,AL   ;SAVE IN CX
        LODSB           ;DISCARD FIRST BYTE

LOSE_SPACE:
        DEC     CX      ;ADJUST COUNTER
        LODSB           ;GET CHARACTER
        CMP     AL,20h  ;IS IT A SPACE?
        JZ      LOSE_SPACE      ;REPEAT TILL NO MORE SPACES
        MOV     DX,SI   ;SAVE IN DX
        DEC     DX      ;ADJUST POINTER

FIND_SPACE:
        LODSB           ;GET NEXT CHARACTER
        CMP     AL,20h  ;IS IT SPACE?
        JZ      FOUND_SPACE     ;GET OUT
        CMP     AL,0Dh  ;IS IT END OF LINE?
        JZ      FOUND_SPACE     ;GET OUT
        LOOP    FIND_SPACE      ;REPEAT TILL END OF LINE
CMD_ERR:
        MOV     AX,_DATA        ;GET DS
        MOV     DS,AX
        MOV     DX,OFFSET BAD_CMD       ;SHOW MESSAGE

ERROR_HANDLER:
        MOV     AH,09h          ;SHOW IT
        INT     21h
        MOV     AX,4CFFh        ;TERMINATE WITH ERRORLEVEL 255
        INT     21h

FOUND_SPACE:
        DEC     SI      ;BACK UP A TAD
        XOR     AL,AL   ;STUFF ZERO (NULL TERMINATED)
        MOV     BYTE PTR[SI],AL

        MOV     AX,3D00h                ;OPEN FILE
        INT     21h
        JNC     FILE_OPENED     ;CARRY ON ERROR
FILE_ERR:
        MOV     AX,_DATA        ;GET DS
        MOV     DS,AX
        MOV     DX,OFFSET BAD_FILE      ;SHOW MESSAGE
        JMP     ERROR_HANDLER

FILE_OPENED:
        PUSH    AX

        MOV     AX,_DATA                ;GET DS
        MOV     DS,AX

        POP     BX              ;GET HANDLE
        MOV     AH,3Fh          ;READ FILE
        MOV     CX,10           ;READ ONLY 10 BYTES
        MOV     DX,OFFSET READ_BUFF     ;POINTER TO BUFFER
        INT     21h
        JC      FILE_ERR        ;CARRY ON ERROR

        MOV     AH,3Eh
        INT     21h             ;CLOSE THE FILE

        MOV     SI,OFFSET READ_BUFF
        LODSB           ;CHECK SIGNATURE
        CMP     AL,"G"
        JNZ     NOT_GIF
        LODSB
        CMP     AL,"I"
        JNZ     NOT_GIF
        LODSB
        CMP     AL,"F"
        JZ      IS_GIF

NOT_GIF:
        MOV     DX,OFFSET GIF_ERR       ;SHOW MESSAGE
        MOV     AH,09
        INT     21h
        MOV     AX,4C02h                ;ERRORLEVEL 2 NOT GIF
        INT     21h

IS_GIF:
        ADD     SI,3    ;JUMP OVER HEADER
        LODSW                   ;GET RESOLUTION
        CMP     AX,640          ;COMPARE AGAINST 640
        JAE     OVER_640
POOR:
        MOV     DX,OFFSET BAD_RES       ;SHOW MESSAGE FOR BAD RESOLUTION
        MOV     AH,09
        INT     21h
        MOV     AX,4C01h        ;TERMINATE ERRORLEVEL 1
        INT     21h

OVER_640:
        LODSW           ;GET RESOLUTION
        CMP     AX,480  ;COMPARE AGAINST 480
        JAE     OVER_480
        JMP     SHORT POOR

OVER_480:
        MOV     DX,OFFSET GOOD_RES      ;SHOW MESSAGE
        MOV     AH,09
        INT     21h
        MOV     AX,4C00h                ;TERMINATE ERRORLEVEL 0
        INT     21h

_TEXT     ENDS
          END    start
