;
; This file is a charset conversion module in text form.
;
; This module Converts Macintosh extended characters to IBM-PC characters.
;
; Format: ID, version, level,
;         from charset, to charset,
;         128 entries: first & second byte
;	  "END"
; Lines beginning with a ";" or a ";" after the entries are comments
;
; Unkown characters are mapped to the "?" character.
;
; cedilla = ,   ; dieresis = ..       ; acute = '
; grave = `     ; circumflex = ^      ; ring = o
; tilde = ~     ; caron = v 
; All of these are above the character, apart from the cedilla which is below.
;
; \ is the escape character: \0 means decimal zero,
; \dnnn where nnn is a decimal number is the ordinal value of the character
; \xnn where nn is a hexadecimal number
; e.g.: \d32 is the ASCII space character
; Two \\ is the character "\" itself.
;
0		; ID number
0		; version number
;
2		; level number
;
MAC		; from set
IBMPC		; to set
;
\0 \x8E         ; 128 A dieresis
\0 \x8F         ; 129 A ring
\0 \x80         ; 130 C cedilla
\0 \x90         ; 131 E acute
\0 \xA5         ; 132 N tilde
\0 \x94         ; 133 O dieresis
\0 \x9A         ; 134 U dieresis
\0 \xA0         ; 135 a acute
\0 \x85         ; 136 a grave
\0 \x83         ; 137 a circumflex
\0 \x84         ; 138 a dieresis
\0 a            ; 139 a tilde
\0 \x86         ; 140 a ring
\0 \x87         ; 141 c cedilla
\0 \x82         ; 142 e acute
\0 \x8A         ; 143 e grave
\0 \x88         ; 144 e circumflex
\0 \x89         ; 145 e dieresis
\0 \xA1         ; 146 i acute
\0 \x8D         ; 147 i grave
\0 \x8C         ; 148 i circumflex
\0 \x8B         ; 149 i dieresis
\0 \xA4         ; 150 n tilde
\0 \xA2         ; 151 o acute
\0 \x95         ; 152 o grave
\0 \x96         ; 153 o circumflex
\0 \x94         ; 154 o dieresis
\0 o            ; 155 o tilde
\0 \xA3         ; 156 u acute
\0 \x97         ; 157 u grave
\0 \x96         ; 158 u circumflex
\0 \x81         ; 159 u dieresis
\0 +            ; 160 dagger
\0 \xF8         ; 161 ring / degree
\0 \x9B         ; 162 cent
\0 \x9C         ; 163 pound sterling
\0 \x15         ; 164 section
\0 \xFE         ; 165 bullet
\0 \x14         ; 166 paragraph
\0 \xE1         ; 167 german double s
\0 R            ; 168 registered trademark
\0 c            ; 169 copyright
T M             ; 170 trademark
\0 '            ; 171 acute
\x1 ?           ; 172 dieresis
< >             ; 173 not equal
\0 \x92         ; 174 AE
\0 \x9d         ; 175 O slash (mapping for CP850/865)
\0 \xEC         ; 176 infinity
\0 \xF1         ; 177 plusminus
\0 \xF3         ; 178 smaller equals
\0 \xF2         ; 179 greater equals
\0 \x9D         ; 180 Yen
\0 \xE6         ; 181 mu
\0 \xEB         ; 182 delta
\0 \xE4         ; 183 Sigma (summation)
\x1 ?           ; 184 Pi
\0 \xE3         ; 185 pi
\x1 ?           ; 186 integral
\0 \xA6         ; 187 ord feminine
\0 \xA7         ; 188 ord masculine
\0 \xEA         ; 189 Omega
\0 \x91         ; 190 ae
\0 \x9b         ; 191 o slash (mapping for CP 850/865)
\0 \xA8         ; 192 question downwards
\0 \xAD         ; 193 exclam downwards
\0 \xAA         ; 194 logical not
\0 \xFB         ; 195 radical
\0 \x9F         ; 196 florin
\0 \xF7         ; 197 approx.
\0 \x7F         ; 198 Delta
\0 \xAF         ; 199 guillemot right
\0 \xAE         ; 200 guillemot left
. .             ; 201 ellipsis
\0 \d32         ; 202 non breaking space
\0 A            ; 203 A acute
\0 A            ; 204 A tilde
\0 O            ; 205 O tilde
O E             ; 206 OE
o e             ; 207 oe
\0 \xFA         ; 208 en dash
\0 -            ; 209 em dash
\0 "            ; 210 double quote left
\0 "            ; 211 double quote right
\0 `            ; 212 quote left
\0 '            ; 213 quote right
\0 \xF6         ; 214 divide
\0 \x04         ; 215 lozenge
\0 \x98         ; 216 y dieresis
\0 ?            ; 217
\0 ?            ; 218
\0 ?            ; 219
\0 ?            ; 220
\0 ?            ; 221
\0 ?            ; 222
\0 ?            ; 223
\0 ?            ; 224
\0 ?            ; 225
\0 ?            ; 226
\0 ?            ; 227
\0 ?            ; 228
\0 ?            ; 229
\0 ?            ; 230
\0 ?            ; 231
\0 ?            ; 232
\0 ?            ; 233
\0 ?            ; 234
\0 ?            ; 235
\0 ?            ; 236
\0 ?            ; 237
\0 ?            ; 238
\0 ?            ; 239
\0 ?            ; 240
\0 ?            ; 241
\0 ?            ; 242
\0 ?            ; 243
\0 ?            ; 244
\0 ?            ; 245
\0 ?            ; 246
\0 ?            ; 247
\0 ?            ; 248
\0 ?            ; 249
\0 ?            ; 250
\0 ?            ; 251
\0 ?            ; 252
\0 ?            ; 253
\0 ?            ; 254
\0 ?            ; 255
END
