;
; This file is a charset conversion module in text form.
;
; This module Converts IBM CP437 characters to K. Simonsen mnemonics.
;
; Format: ID, version, level,
;         from charset, to charset,
;         128 entries: first & second byte
;	  "END"
; Lines beginning with a ";" or a ";" after the entries are comments
;
; Unknown characters are mapped to the "?" character.
;
; cedilla = ,   ; dieresis = ..       ; acute = '
; grave = `     ; circumflex = ^      ; ring = o
; tilde = ~     ; caron = v 
; All of these are above the character, apart from the cedilla which is below.
;
; \ is the escape character: \0 means decimal zero,
; \dnnn where nnn is a decimal number is the ordinal value of the character
; \xnn where nn is a hexadecimal number
; e.g.: \d32 is the ASCII space character
; Two \\ is the character "\" itself.
;
0		; ID number
0		; version number
;
2		; level number
;
IBMPC		; from set
MNEMONIC        ; to set
;
\d29 C ,        ; 128 80 C with cedilla
\d29 u :        ; 129 81 u dieresis
\d29 e '        ; 130 82 e acute
\d29 a >        ; 131 83 a circumflex
\d29 a :        ; 132 84 a dieresis
\d29 a !        ; 133 85 a grave
\d29 a a        ; 134 86 a ring
\d29 c ,        ; 135 87 c cedilla
\d29 e >        ; 136 88 e circumflex
\d29 e :        ; 137 89 e dieresis
\d29 e !        ; 138 8A e grave
\d29 i :        ; 139 8B i dieresis
\d29 i >        ; 140 8C i circumflex
\d29 i !        ; 141 8D i grave
\d29 A :        ; 142 8E A dieresis
\d29 A A        ; 143 8F A ring
\d29 E '        ; 144 90 E acute
\d29 a e        ; 145 91 ae
\d29 A E        ; 146 92 AE
\d29 o >        ; 147 93 o circumflex
\d29 o :        ; 148 94 o dieresis
\d29 o '        ; 149 95 o acute
\d29 u >        ; 150 96 u circumflex
\d29 U !        ; 151 97 u grave
\d29 y :        ; 152 98 y dieresis
\d29 O :        ; 153 99 O dieresis
\d29 U :        ; 154 9A U dieresis
\d29 o /        ; 155 9B o slash (CP865/850 mapping)
\d29 P d        ; 156 9C pound sterling
\d29 O /        ; 157 9D O slash (CP865/850 mapping)
\d29 P t        ; 158 9E Pt
\d29 F l        ; 159 9F florin
\d29 a '        ; 160 A0 a acute
\d29 i '        ; 161 A1 i grave
\d29 o !        ; 162 A2 o grave
\d29 u !        ; 163 A3 u grave
\d29 n ?        ; 164 A4 n tilde
\d29 N ?        ; 165 A5 N tilde
\d29 - a        ; 166 A6 ord feminine
\d29 - o        ; 167 A7 ord masculine
\d29 ? I        ; 168 A8 question downwards
\d29 N I        ; 169 A9
\d29 N O        ; 170 AA logical not
\d29 1 2        ; 171 AB half fraction
\d29 1 4        ; 172 AC quarter fraction
\d29 ! I        ; 173 AD exclam downwards
\d29 < <        ; 174 AE guillemot left
\d29 > >        ; 175 AF guillemot right
\d29 . S        ; 176 B0
\d29 : S        ; 177 B1
\d29 ? S        ; 178 B2
\d29 v v        ; 179 B3
\d29 v l        ; 180 B4
\d29 v L        ; 181 B5
\d29 V l        ; 182 B6
\d29 D l        ; 183 B7
\d29 d L        ; 184 B8
\d29 V L        ; 185 B9
\d29 V V        ; 186 BA
\d29 L D        ; 187 BB
\d29 U L        ; 188 BC
\d29 U l        ; 189 BD
\d29 u L        ; 190 BE
\d29 d l        ; 191 BF
\d29 u r        ; 192 C0
\d29 u h        ; 193 C1
\d29 d h        ; 194 C2
\d29 v r        ; 195 C3
\d29 h h        ; 196 C4
\d29 v h        ; 197 C5
\d29 v R        ; 198 C6
\d29 V r        ; 199 C7
\d29 U R        ; 200 C8
\d29 D R        ; 201 C9
\d29 U H        ; 202 CA
\d29 D H        ; 203 CB
\d29 V R        ; 204 CC
\d29 H H        ; 205 CD
\d29 V H        ; 206 CE
\d29 u H        ; 207 CF
\d29 U h        ; 208 D0
\d29 d H        ; 209 D1
\d29 D h        ; 210 D2
\d29 U r        ; 211 D3
\d29 u R        ; 212 D4
\d29 D r        ; 213 D5
\d29 d R        ; 214 D6
\d29 V h        ; 215 D7
\d29 v H        ; 216 D8
\d29 u l        ; 217 D9
\d29 d r        ; 218 DA
\d29 F B        ; 219 DB
\d29 L B        ; 220 DC
\d29 l B        ; 221 DD
\d29 R B        ; 222 DE
\d29 T B        ; 223 DF
\d29 a *        ; 224 E0 alpha
\d29 b *        ; 225 E1 german double s (misused as Beta)
\d29 G *        ; 226 E2 Gamma
\d29 p *        ; 227 E3 pi
\d29 S *        ; 228 E4 Sigma (summation)
\d29 s *        ; 229 E5 sigma
\d29 m *        ; 230 E6 mu
\d29 t *        ; 231 E7 gamma
\d29 F *        ; 232 E8 Phi
\d29 H *        ; 233 E9 Theta
\d29 W *        ; 234 EA Omega
\d29 d *        ; 235 EB delta
\d29 0 0        ; 236 EC infinity
\d29 / 0        ; 237 ED empty set
\d29 e *        ; 238 EE element
\d29 ( U        ; 239 EF intersection
\d29 = 3        ; 240 F0 equivalence
\d29 + -        ; 241 F1 plusminus
\d29 > =        ; 242 F2 greater equals
\d29 < =        ; 243 F3 smaller equals
\d29 I u        ; 244 F4 integral top
\d29 I l        ; 245 F5 integral bottom
\d29 - :        ; 246 F6 divide
\d29 ? 2        ; 247 F7 approx.
\d29 O b        ; 248 F8 ring / degree
\d29 . M        ; 249 F9 centered dot
\d29 S b        ; 250 FA en dash
\d29 R T        ; 251 FB radical
\d29 n S        ; 252 FC to the n'th power
\d29 2 S        ; 253 FD to the second power
\d29 f S        ; 254 FE bullet
\d29 N S        ; 255 FF non-breaking space
END

