;
; This file is a charset conversion module in text form.
;
; This module Converts IBM CP850 characters to ISO 8859-1 characters.
;
; Format: ID, version, level,
;         from charset, to charset,
;         128 entries: first & second byte
;	  "END"
; Lines beginning with a ";" or a ";" after the entries are comments
;
; Unknown characters are mapped to the "?" character.
;
; cedilla = ,   ; dieresis = ..       ; acute = '
; grave = `     ; circumflex = ^      ; ring = o
; tilde = ~     ; caron = v 
; All of these are above the character, apart from the cedilla which is below.
;
; \ is the escape character: \0 means decimal zero,
; \dnnn where nnn is a decimal number is the ordinal value of the character
; \xnn where nn is a hexadecimal number
; e.g.: \d32 is the ASCII space character
; Two \\ is the character "\" itself.
;
0		; ID number
0		; version number
;
2		; level number
;
CP850           ; from set
LATIN-1		; to set
;               ; dec hx description
\0 \xC7         ; 128 80 C with cedilla
\0 \xFC         ; 129 81 u dieresis
\0 \xE9         ; 130 82 e acute
\0 \xE2         ; 131 83 a circumflex
\0 \xE4         ; 132 84 a dieresis
\0 \xE0         ; 133 85 a grave
\0 \xE5         ; 134 86 a ring
\0 \xE7         ; 135 87 c cedilla
\0 \xEA         ; 136 88 e circumflex
\0 \xEB         ; 137 89 e dieresis
\0 \xE8         ; 138 8A e grave
\0 \xEF         ; 139 8B i dieresis
\0 \xEE         ; 140 8C i circumflex
\0 \xEC         ; 141 8D i grave
\0 \xC4         ; 142 8E A dieresis
\0 \xC5         ; 143 8F A ring
\0 \xC9         ; 144 90 E acute
\0 \xE6         ; 145 91 ae
\0 \xC6         ; 146 92 AE
\0 \xF4         ; 147 93 o circumflex
\0 \xF6         ; 148 94 o dieresis
\0 \xF3         ; 149 95 o acute
\0 \xDB         ; 150 96 u circumflex
\0 \xD9         ; 151 97 u grave
\0 \xFF         ; 152 98 y dieresis
\0 \xD6         ; 153 99 O dieresis
\0 \xDC         ; 154 9A U dieresis
\0 \xF8         ; 155 9B o slash
\0 \xA3         ; 156 9C pound sterling
\0 \xD8         ; 157 9D O slash
\0 \xD7         ; 158 9E multiplication sign
F l             ; 159 9F dutch guilder sign (florin)
\0 \xE1         ; 160 A0 a acute
\0 \xCC         ; 161 A1 i grave
\0 \xF2         ; 162 A2 o grave
\0 \xF9         ; 163 A3 u grave
\0 \xF1         ; 164 A4 n tilde
\0 \xD1         ; 165 A5 N tilde
\0 \xAA         ; 166 A6 ord feminine
\0 \xBA         ; 167 A7 ord masculine
\0 \xBF         ; 168 A8 question downwards
\0 \xAE         ; 169 A9 registered sign
\0 \xAC         ; 170 AA logical not
\0 \xBD         ; 171 AB half fraction
\0 \xBC         ; 172 AC quarter fraction
\0 \xA1         ; 173 AD exclam downwards
\0 \xAB         ; 174 AE guillemot left
\0 \xBB         ; 175 AF guillemot right
\0 #            ; 176 B0 light shade
\0 #            ; 177 B1 medium shade
\0 #            ; 178 B2 dark shade
\0 |            ; 179 B3 frame single vertical
\0 |            ; 180 B4 frame single vertical and left
\0 \xC1         ; 181 B5 A acute
\0 \xC2         ; 182 B6 A circumflex
\0 \xC0         ; 183 B7 A grave
\0 \xA9         ; 184 B8 copyright sign
\0 |            ; 185 B9 frame double vertical and left
\0 |            ; 186 BA frame double vertical
\0 +            ; 187 BB frame double down and left
\0 +            ; 188 BC frame double up and left
\0 \xA2         ; 189 BD cent
\0 \xAE         ; 190 BE yen
\0 +            ; 191 BF frame single down and left
\0 +            ; 192 C0 frame single up and right
\0 -            ; 193 C1 frame single up and horizontal
\0 -            ; 194 C2 frame single down and horizontal
\0 |            ; 195 C3 frame single vertical and right
\0 -            ; 196 C4 frame single horizontal
\0 +            ; 197 C5 frame single vertical and horizontal
\0 \xE3         ; 198 C6 a tilde
\0 \xC3         ; 199 C7 A tilde
\0 +            ; 200 C8 frame double up and right
\0 +            ; 201 C9 frame double down and right
\0 =            ; 202 CA frame double up and horizontal
\0 =            ; 203 CB frame double down and horizontal
\0 |            ; 204 CC frame double vertical and right
\0 =            ; 205 CD frame double horizontal
\0 +            ; 206 CE frame vertical and horizontal
\0 \xA4         ; 207 CF currency
\0 \xF0         ; 208 D0 eth (icelandic)
\0 \xD0         ; 209 D1 Eth (icelandic)
\0 \xCA         ; 210 D2 E circumflex
\0 \xCB         ; 211 D3 E dieresis
\0 \xD4         ; 212 D4 E grave
\0 i            ; 213 D5 i dotless
\0 \xCD         ; 214 D6 I acute
\0 \xCE         ; 215 D7 I circumflex
\0 \xCF         ; 216 D8 I dieresis
\0 +            ; 217 D9 single frame bottom right corner
\0 +            ; 218 DA single frame top left corner
\0 #            ; 219 DB full block
\0 #            ; 220 DC lower half block
\0 \xA6         ; 221 DD broken bar
\0 \xCC         ; 222 DE I grave
\0 #            ; 223 DF upper half block
\0 \xD3         ; 224 E0 O acute
\0 \xDF         ; 225 E1 sharp s (german)
\0 \xD4         ; 226 E2 O circumflex
\0 \xD2         ; 227 E3 O grave
\0 \xF5         ; 228 E4 o tilde
\0 \xD5         ; 229 E5 O tilde
\0 \xB5         ; 230 E6 micro sign
\0 \xDE         ; 231 E7 Thorn (icelandic)
\0 \xFE         ; 232 E8 thorn (icelandic)
\0 \xDA         ; 233 E9 U acute
\0 \xDB         ; 234 EA U circumflex
\0 \xD9         ; 235 EB U grave
\0 \xFD         ; 236 EC y acute
\0 \xDD         ; 237 ED Y acute
\0 \xAF         ; 238 EE overbar (macron)
\0 \xB4         ; 239 EF acute
\0 \xAD         ; 240 F0 soft hyphen (or em dash)
\0 \xB1         ; 241 F1 plusminus
= =             ; 242 F2 left right double arrow
\0 \xBE         ; 243 F3 three quarters
\0 \xB6         ; 244 F4 pilcrow sign (paragraph)
\0 \xA7         ; 245 F5 section sign
\0 \xF7         ; 246 F6 division sign
\0 \xB8         ; 247 F7 cedilla
\0 \xB0         ; 248 F8 degree sign
\0 \xA8         ; 249 F9 dieresis
\0 .            ; 250 FA dot above
\0 \xB9         ; 251 FB superscript one
\0 \xB3         ; 252 FC superscript three (cubed)
\0 \xB2         ; 253 FD superscript two (squared)
\0 \xB7         ; 254 FE black square (bullet)
\0 \xA0         ; 255 FF non-breaking space
END

