/* -----------------------------------------------------------------------------

 GoldED API client example code, 1994 Dietmar Eilert. Dice:

 dcc main.c -// -proto -mRR -mi -2.0 -l tmsr.lib -o ram:dock

 Note: Compiling this code requires ToolManger includes & ToolManager linker
       libraries. ToolManager is 1990-1994 Stefan Becker.

 The following  example  uses  synchronous  ARexx  communication:  Requests  are
 PutMsg()'ed  to  GoldED's  port,  followed  by a WaitPort() to get the editor's
 response. This works fine since we need no ARexx communication  after  the  API
 link has been established. If there were ARexx communication AFTER the link has
 been established (i.e. after sending the 'API  PORT=...'  command  to  register
 with  GoldED),  we  would  have to use an asynchronous design beeing capable of
 answering incoming API messages while waiting for completion of ARexx  requests
 sent to GoldED.


 History;
 14 March 1994  -   15 icon API by Richard Bemrose
                    Internet: r.bemrose@shu.ac.uk
  
  ------------------------------------------------------------------------------
*/

/// "includes"

#define Prototype extern

#include <amiga20/exec/exec.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <intuition/intuition.h>
#include <rexx/errors.h>
#include <rexx/rxslib.h>
#include <utility/tagitem.h>
#include <clib/toolmanager_protos.h>
#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/rexxsyslib_protos.h>
#include "EIgolded.h"

Prototype void   main(int, char **);
Prototype ULONG *SendRexxCommand(char *, char *, struct MsgPort *, char *);
Prototype char  *xsprintf(char *, char *);

///
/// "main"

void
main(int argc, char **argv)
{
    if (argc == 2) {

        char *host = (char *)argv[1];

        struct MsgPort *replyPort;

        if (replyPort = CreateMsgPort()) {

            void *handle;

            struct TagItem exec1 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; project ask'",      host), TAG_DONE };
            struct TagItem exec2 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; open new oldpath ask'",         host), TAG_DONE };
            struct TagItem exec3 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; save all'",         host), TAG_DONE };
            struct TagItem exec4 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; freeze current'",   host), TAG_DONE };
            struct TagItem exec5 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; freeze ask'",     host), TAG_DONE };
            struct TagItem exec6 [] = { TMOP_ExecType, TMET_CLI, TMOP_Command, xsprintf("newshell con:160/320/500/185/AmigaShell/close/screenGOLDED.1 s:shell-startup",       host), TAG_DONE };
            struct TagItem exec7 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; layout ask'",       host), TAG_DONE };
            struct TagItem exec8 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; info text'",        host), TAG_DONE };
            struct TagItem exec9 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; func c'",           host), TAG_DONE };
            struct TagItem exec10 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; func struct'",           host), TAG_DONE };
            struct TagItem exec11 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; func A68K'",       host), TAG_DONE };
            struct TagItem exec12 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; \"RX PORT=GUIMAKE CMD=CONFIG MACRO=GOLDED:AREXX/GUI\"'",       host), TAG_DONE };
            struct TagItem exec13 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; \"RX PORT=GUIMAKE CMD=MODULES MACRO=GOLDED:AREXX/GUI\"'",       host), TAG_DONE };
            struct TagItem exec14 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; \"RX PORT=GUIMAKE CMD=OPTIONS MACRO=GOLDED:AREXX/GUI\"'",       host), TAG_DONE };
            struct TagItem exec15 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; \"RX PORT=GUIMAKE CMD=BUILD MACRO=GOLDED:AREXX/GUI\"'",       host), TAG_DONE };
            struct TagItem exec16 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; print all'",       host), TAG_DONE };
            struct TagItem exec17 [] = { TMOP_ExecType, TMET_ARexx, TMOP_Command, xsprintf("'address %s; help topic \"main\"'",       host), TAG_DONE };

            struct TagItem image1 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/projects",   TMOP_Data, NULL, TAG_DONE };
            struct TagItem image2 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/open", TMOP_Data, NULL, TAG_DONE };
            struct TagItem image3 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/save", TMOP_Data, NULL, TAG_DONE };
            struct TagItem image4 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/freeze", TMOP_Data, NULL, TAG_DONE };
            struct TagItem image5 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/unfreeze",   TMOP_Data, NULL, TAG_DONE };
            struct TagItem image6 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/shell",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image7 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/layout",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image8 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/info",    TMOP_Data, NULL, TAG_DONE };
            struct TagItem image9 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/mode_c",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image10 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/mode_h",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image11 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/mode_a",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image12 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/config",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image13 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/modules",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image14 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/options",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image15 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/build",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image16 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/printer",     TMOP_Data, NULL, TAG_DONE };
            struct TagItem image17 [] = { TMOP_File, "GoldED:tools/GEDDock/icons/help",     TMOP_Data, NULL, TAG_DONE };

            char *tool1[]  = {"e1",  "i1",  NULL};
            char *tool2[]  = {"e2",  "i2",  NULL};
            char *tool3[]  = {"e3",  "i3",  NULL};
            char *tool4[]  = {"e4",  "i4",  NULL};
            char *tool5[]  = {"e5",  "i5",  NULL};
            char *tool6[]  = {"e6",  "i6",  NULL};
            char *tool7[]  = {"e7",  "i7",  NULL};
            char *tool8[]  = {"e8",  "i8",  NULL};
            char *tool9[]  = {"e9",  "i9",  NULL};
            char *tool10[]  = {"e10",  "i10",  NULL};
            char *tool11[]  = {"e11",  "i11",  NULL};
            char *tool12[]  = {"e12",  "i12",  NULL};
            char *tool13[]  = {"e13",  "i13",  NULL};
            char *tool14[]  = {"e14",  "i14",  NULL};
            char *tool15[]  = {"e15",  "i15",  NULL};
            char *tool16[]  = {"e16",  "i16",  NULL};
            char *tool17[]  = {"e17",  "i17",  NULL};

            struct TagItem dock[] = {

                TMOP_PubScreen, NULL,
                TMOP_LeftEdge,  0,
                TMOP_TopEdge,   15,
                TMOP_Activated, TRUE,
                TMOP_Centered,  FALSE,
                TMOP_Columns,   1,
                TMOP_Vertical,  FALSE,
                TMOP_Text,      FALSE,
                TMOP_Pattern,   TRUE,
                TMOP_Tool,      tool1,
                TMOP_Tool,      tool2,
                TMOP_Tool,      tool3,
                TMOP_Tool,      tool4,
                TMOP_Tool,      tool5,
                TMOP_Tool,      tool6,
                TMOP_Tool,      tool7,
                TMOP_Tool,      tool8,
                TMOP_Tool,      tool9,
                TMOP_Tool,      tool10,
                TMOP_Tool,      tool11,
                TMOP_Tool,      tool12,
                TMOP_Tool,      tool13,
                TMOP_Tool,      tool14,
                TMOP_Tool,      tool15,
                TMOP_Tool,      tool16,
                TMOP_Tool,      tool17,
                TAG_DONE
            };

            if (handle = AllocTMHandle()) {

                char  command[255];
                ULONG *result;

                CreateTMObjectTagList(handle, "e1",  TMOBJTYPE_EXEC, exec1);
                CreateTMObjectTagList(handle, "e2",  TMOBJTYPE_EXEC, exec2);
                CreateTMObjectTagList(handle, "e3",  TMOBJTYPE_EXEC, exec3);
                CreateTMObjectTagList(handle, "e4",  TMOBJTYPE_EXEC, exec4);
                CreateTMObjectTagList(handle, "e5",  TMOBJTYPE_EXEC, exec5);
                CreateTMObjectTagList(handle, "e6",  TMOBJTYPE_EXEC, exec6);
                CreateTMObjectTagList(handle, "e7",  TMOBJTYPE_EXEC, exec7);
                CreateTMObjectTagList(handle, "e8",  TMOBJTYPE_EXEC, exec8);
                CreateTMObjectTagList(handle, "e9",  TMOBJTYPE_EXEC, exec9);
                CreateTMObjectTagList(handle, "e10",  TMOBJTYPE_EXEC, exec10);
                CreateTMObjectTagList(handle, "e11",  TMOBJTYPE_EXEC, exec11);
                CreateTMObjectTagList(handle, "e12",  TMOBJTYPE_EXEC, exec12);
                CreateTMObjectTagList(handle, "e13",  TMOBJTYPE_EXEC, exec13);
                CreateTMObjectTagList(handle, "e14",  TMOBJTYPE_EXEC, exec14);
                CreateTMObjectTagList(handle, "e15",  TMOBJTYPE_EXEC, exec15);
                CreateTMObjectTagList(handle, "e16",  TMOBJTYPE_EXEC, exec16);
                CreateTMObjectTagList(handle, "e17",  TMOBJTYPE_EXEC, exec17);

                CreateTMObjectTagList(handle, "i1",  TMOBJTYPE_IMAGE, image1);
                CreateTMObjectTagList(handle, "i2",  TMOBJTYPE_IMAGE, image2);
                CreateTMObjectTagList(handle, "i3",  TMOBJTYPE_IMAGE, image3);
                CreateTMObjectTagList(handle, "i4",  TMOBJTYPE_IMAGE, image4);
                CreateTMObjectTagList(handle, "i5",  TMOBJTYPE_IMAGE, image5);
                CreateTMObjectTagList(handle, "i6",  TMOBJTYPE_IMAGE, image6);
                CreateTMObjectTagList(handle, "i7",  TMOBJTYPE_IMAGE, image7);
                CreateTMObjectTagList(handle, "i8",  TMOBJTYPE_IMAGE, image8);
                CreateTMObjectTagList(handle, "i9",  TMOBJTYPE_IMAGE, image9);
                CreateTMObjectTagList(handle, "i10",  TMOBJTYPE_IMAGE, image10);
                CreateTMObjectTagList(handle, "i11",  TMOBJTYPE_IMAGE, image11);
                CreateTMObjectTagList(handle, "i12",  TMOBJTYPE_IMAGE, image12);
                CreateTMObjectTagList(handle, "i13",  TMOBJTYPE_IMAGE, image13);
                CreateTMObjectTagList(handle, "i14",  TMOBJTYPE_IMAGE, image14);
                CreateTMObjectTagList(handle, "i15",  TMOBJTYPE_IMAGE, image15);
                CreateTMObjectTagList(handle, "i16",  TMOBJTYPE_IMAGE, image16);
                CreateTMObjectTagList(handle, "i17",  TMOBJTYPE_IMAGE, image17);

                sprintf(command, "API PORT=%ld NAME=GoldDock MASK=%ld", replyPort, API_CLASS_ROOT | API_CLASS_SCREEN);

                if (result = SendRexxCommand(host, command, replyPort, NULL)) {

                    if (*result == RC_OK) {

                        BOOL active = TRUE;

                        do {

                            struct APIMessage *apiMsg;

                            WaitPort(replyPort);

                            for (apiMsg = (struct APIMessage *)GetMsg(replyPort); apiMsg; apiMsg = apiMsg->api_Next) {

                                if (apiMsg->api_State == API_STATE_NOTIFY) {

                                    switch (apiMsg->api_Class) {

                                        case API_CLASS_ROOT:

                                            switch (apiMsg->api_Action) {

                                                case API_ACTION_DIE:

                                                    active = FALSE;
                                                    DeleteTMObject(handle, "dock1");

                                                    break;

                                                default:

                                                    apiMsg->api_Error = API_ERROR_UNKNOWN;
                                            }

                                            break;

                                        case API_CLASS_SCREEN:

                                            switch (apiMsg->api_Action) {

                                                case API_ACTION_HIDE:

                                                    DeleteTMObject(handle, "dock1");
                                                    break;

                                                case API_ACTION_SHOW:

                                                    struct Screen *screen;

                                                    if (screen = LockPubScreen(apiMsg->api_Screen)) {

                                                        dock[0].ti_Data = apiMsg->api_Screen;
                                                        dock[1].ti_Data = screen->Width - 30;
                                                        dock[2].ti_Data = screen->BarHeight + 1;

                                                        UnlockPubScreen(NULL, screen);
                                                    }

                                                    CreateTMObjectTagList(handle, "dock1", TMOBJTYPE_DOCK, dock);

                                                    break;

                                                default:

                                                    apiMsg->api_Error = API_ERROR_UNKNOWN;
                                            }
                                            break;

                                        default:

                                            apiMsg->api_Error = API_ERROR_UNKNOWN;
                                    }
                                }

                                ReplyMsg((struct Message *)apiMsg);
                            }

                        } while (active);
                    }
                }

                FreeTMHandle(handle);
            }

            DeleteMsgPort(replyPort);

            exit(0);
        }

    }
    else
        puts("syntax error: dock <GoldED-Port>");

    exit(10);
}

///
/// "misc"

/* --------------------------------- xsprintf ----------------------------------

 sprintf frontend (malloc buffer); limited to string insertion into string

*/

char *
xsprintf(mask, var)

char *mask, *var;
{
    char *buffer;

    if (buffer = malloc(strlen(mask) + strlen(var)))
        sprintf(buffer, mask, var);

    return(buffer);
}

///
/// "ARexx"

/* ---------------------------------- SendRexxCommand -------------------------

 Send ARexx message & wait for answer. Return pointer to result or NULL.

*/

ULONG *
SendRexxCommand(port, cmd, replyPort, buffer)

char   *cmd, *port, *buffer;
struct MsgPort *replyPort;
{
    struct MsgPort *rexxport;

    Forbid();

    if (rexxport = FindPort(port)) {

        struct RexxMsg *rexxMsg, *answer;

        if (rexxMsg = CreateRexxMsg(replyPort, NULL, NULL)) {

            if (rexxMsg->rm_Args[0] = CreateArgstring(cmd, strlen(cmd))) {

                static ULONG result;

                rexxMsg->rm_Action = RXCOMM | RXFF_RESULT;

                PutMsg(rexxport, &rexxMsg->rm_Node);

                do {
                    
                    WaitPort(replyPort);

                    if (answer = (struct RexxMsg *)GetMsg(replyPort))
                        result = answer->rm_Result1;

                } while (!answer);

                Permit();

                if (answer->rm_Result1 == RC_OK) {

                    if (answer->rm_Result2) {

                        if (buffer)
                            strcpy(buffer, (char *)answer->rm_Result2);

                        DeleteArgstring((char *)answer->rm_Result2);
                    }
                }

                DeleteArgstring((char *)ARG0(answer));

                DeleteRexxMsg(answer);

                return(&result);
            }
        }
    }

    Permit();

    return(NULL);
}

///
