/* Prints (disk-)labels; done on suggestion of Olivier Toebosch    */
/* The label carrier (one sold by 'Zweckform') is supposed to      */
/* look like this:                                                 */
/*                                                                 */
/*     ----------------------------------------------              */
/*     |                                             | top offfset */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               | 3 columns  */
/*     |              |              |               | 5 rows      */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |---------------------------------------------|             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |              |              |               |             */
/*     |---------------------------------------------|             */
/*     |                                             | bottom      */
/*     ----------------------------------------------  margin      */

columns = 3     /* number of labels/line                           */
rows    = 5     /* number of lines                                 */
toffset = 22    /* top border    (must be at least 5 mm)           */
boffset = 22    /* bottom margin (must be at least 5-7 mm)         */
paperx  = 210   /* paper width  [mm]                               */
papery  = 298   /* paper height [mm]                               */

/* ----------------------------------------------------------------*/

options results
shell

address HISPEED.1

SET BOOK     OFF
SET HEADER   OFF          /* 5 mm still remain unusable :-(       */
SET DX 7                  /* i.e. left/right border = 3.5 mm      */
SET DY 10

'SET PAPERX' 210 + 7      /* add 7 mm for right border            */
'SET PAPERY' papery

SET SEPARATE OFF

SET LAYOUTX columns * 2   /* two columns/label                    */
SET LAYOUTY rows

SET QUALITY BOLD

SET TOP    toffset + 5
SET BOTTOM boffset
SET LEFT   7
SET RIGHT  7

/* consider position of DeskJet's middle platen (used as guide): */

QUERY BLOCKX  /* maximum entry length [characters] incl. CR */

blockx  = trunc(RESULT) - 1
labels  = columns * rows

if (blockx < 25) then do

  SET WARN " You should select a smaller font ;-)"

end

say ""
say " This script does support printing on labels by Zweckform "
say " (70 * 50.8 mm, on a 3 x 5 carrier), 2 columns per label. "
say ""
say " Tell me the number of the 1st label you want to print or "
say " 0 to exit. The sheet's top left label is considered to be"
say " 1, its right neighbour 2, the last label is " || labels

pull first

if (first < 1) | (first > labels) then do

  say " Done (please close window)."
  exit

end

say ""
say " I'm going to ask you for directories to scan. File- and  "
say " directory names will be used as label text (except system"
say " directories as 'FONTS' or icon files) ..."

QUERY BLOCKY           /* how many lines can be printed on a label ? */
lines = RESULT

maxEntries = lines * 2 /* max. number of entries/label (two columns) */

/* remove 'waste' of last run (if any) */

shell
DELETE ">NIL:" "T:LABELTEXT"
address HISPEED.1

/* open 'label' file (will become output file) */

R = open('txt', "T:LABELTEXT", 'WRITE')

if (R = 0) then do
  SET WARN "Error - couldn't create temporary file"
  exit
end

/* 'jump' to first label */

if (first > 1) then do
  do piece = 0 to (first - 2)
    do n = 1 to maxEntries
        R = writeln('txt', "")
    end
  end
end

/* Read directory. The original OS2.04 'list' command _must_ be  */
/* available since we depend on the layout !                     */

piece     = first - 1  /* count used labels   */
terminate = 0          /* user-interrupt flag */

do while (terminate = 0) & (piece < labels)

  say ""
  say " PREPARE LABEL N" (piece + 1) ":"
  say " Enter path to scan (e.g. DF0:) or <CR> to terminate."

  pull path

  if path = "" then

    terminate = 1

  else do

    /* Create directory list (last line/first line have to be ignored */

    say " scanning " path "..."

    shell
    LIST path " TO T:TEMP"

    /* Read list & count lines */

    address HISPEED.1

    R = open('ls', "T:TEMP", 'READ')

    entries = 0

    void = readln('ls')    /* ignore header line */

    do until EOF('ls') | (entries > maxEntries)

      iodata = readln('ls')
      iodata = upper(iodata)

      parse var iodata name type rest

      if ~EOF('ls') then
        if right(name, 5) ~= ".INFO" then
          if name ~= "S" then
            if name ~= "DEVS" then
              if name ~= "L" then
                if name ~= "LIBS" then
                  if name ~= "FONTS" then
                     if name ~= "T" then
                      if name ~= "ENV" then
                        if name ~= "C" then do
                          if type = "DIR" then
                            entry.entries = left(name, blockx - 3) || " []"
                          else
                            entry.entries = left(name, blockx)
                          entries = entries + 1
                        end
    end

    R = close('ls')

    /* create the next label (i.e. write detected file names to output file) */

    if (entries > maxEntries) then
      do
        say ""
        say " Sorry, too many files/directories. Some of them won't"
        say " get printed (maximum is " maxEntries ")."
      end
    else
      say " "entries " entries detected (maximum is " maxEntries ")"

    do n = 1 to maxEntries

      if n < entries then
        do
          index = n - 1
          R = writeln('txt', entry.index)
        end
      else
          R = writeln('txt', "")
    end

    if (entries = 0) then
      do
        say ""
        say " No files found. Please have another try ..."
      end
    else
      piece = piece + 1

  end

end

R = close('txt')

CLR
SET FILE "T:LABELTEXT"

/* anything to print ? */

QUERY JOBS

if RESULT = 0 then

  SET WARN " Couldn't set files. Maybe empty ?!"

else do

  SET ASK " Proceed with printing (Y/N) ?"
  if RESULT = 1 then
      PRINT
end

/* clean up ...  */

shell
DELETE ">NIL:" "T:TEMP"

say " Ready (please close window)."
