/*
    This script does look for words beginning with an '@'. These words
    (and their locations/page numbers) are written to "T:KEY".
    Afterwards, this file is transformed into a nice index & appended
    to our list of jobs.
*/

shell
options results

address HISPEED.1

SET REQUESTER ON

SET ASK "This script searches your document(s) for 'keywords'|(any word beginning with '@') and constructs a nice|appendix. Proceed ?"

if RESULT = 1 then do

  QUERY jobs

  if RESULT = 0 then
    REQUESTFILE

  QUERY JOBS
  jobcount = RESULT

  if jobcount ~= 0 then do

    /* extract keywords from text ... */

    SET KEYLIST 'T:KEY'           /* where to write the keyword list */
    SET KEYCODE '@'               /* look for @ */
    SET REQUESTER OFF             /* don't show scan-info */
    SCAN                          /* create the keyword list */
    SET REQUESTER ON              /* to show 'Done' requester ... */

    /* read list ... */

    R = open('KEY', 'T:KEY', 'READ')

    keys = 0                      /*  number of keywords */

    do until EOF('KEY')

      line = READLN('KEY')

      if ~EOF('KEY') then do

        parse var line job page name
        keypage.keys = page
        keyword.keys = name
        keys = keys + 1

      end

    end

    R = close('KEY')

    if keys ~= 0 then              /* any keywords at all ? */

      do

        if keys > 1 then do

          /* sort alphabetically ? */

          SET ASK keys || " keywords detected. Do you want to have them sorted ?|Warning: can take _quite_ a while; this is ARexx, not|assembler ;-)"

          if RESULT = 1 then do

            do until ready = 1
              ready = 1
              do n = 0 to keys - 2
                m = n+1
                if upper(keyword.n) > upper(keyword.m) then do
                  ready = 0
                  swapword  = keyword.n
                  swappage  = keypage.n
                  keyword.n = keyword.m
                  keypage.n = keypage.m
                  keyword.m = swapword
                  keypage.m = swappage
                end
              end
            end
          end
        end

        /* create final list */

        R = open('APDX', 'T:Appendix', 'WRITE')

        R = writeln('APDX', 'Appendix')
        R = writeln('APDX', '--------')
        R = writeln('APDX', '')

        last = ''

        do n = 0 to keys - 1
          if upper(keyword.n) ~= last then
            do
              R = writeln('APDX', '')
              R = writeln('APDX', '')
              R = writech('APDX', left(keyword.n || copies('.', 65), 65) || ' ' || keypage.n)
            end
          else do
              R = writeln('APDX', ',')
              R = writech('APDX', copies(' ', 66) || keypage.n)
          end
          last = upper(keyword.n)
        end

        R = writeln('APDX', '')
        R = close('APDX')

        /* add new index file to list of jobs */

        shell
        address HISPEED.1

        QUERY JOBS
        last = RESULT-1

        do n = 0 to last
          QUERY JOBNAME n
          parse var RESULT path.n name.n rest
        end

        if name.last = 'Appendix' then do
          CLR
          do n = 0 to last
            if name.n ~= 'Appendix' then
              SET FILE path.n || name.n
          end
        end

        SET FILE 'T:Appendix'
        SET WARN 'ARexx message: MakeAppendix finished.'
      end

    else

      SET WARN "No keywords found."
  end

end
