/*
    This script is used to adjust layout (borders) of a document
    to book mode. The goal is adjust the block with to the line
    width of your text (in other words: make border/dx as big as
    posssible).
*/

options results

address HISPEED.1

SET REQUESTER ON

QUERY BOOK

if RESULT ~= ON then
  do

    SET ASK "This script has been developed for BOOK mode|Switch to BOOK mode ?"

    if RESULT = 1 then
        SET BOOK ON
    else
        exit
  end

SET ASK "This script will adjust block width to maximum|column width of your document(s). The goal is to|center columns on page. Proceed ?"

if RESULT = 1 then

  do
    QUERY JOBS

    if RESULT = 0 then
      REQUESTFILE

    QUERY JOBS

    if RESULT ~= 0 then

      do

        SET REQUESTER OFF        /* we don't want any scan info window */

        SET LEFT 15              /* implies right = 15, too */
        SET DX   0
        SCAN

        QUERY MAXLINE
        maxline = RESULT

        QUERY BLOCKX
        width = RESULT

        done = 0

        do UNTIL (done ~= 0)

          QUERY LEFT
          border = RESULT

          QUERY DX
          distance = RESULT

          if width = maxline then

            done = 1

          else do

            if width < maxline then
              done = 1

            else do

              if (border * 2) < distance then
                do
                  border = border + 1
                  SET LEFT border
                end

              else do
                distance = distance + 1
                SET DX distance
              end

              QUERY BLOCKX
              width = RESULT
            end
          end
        end

        SET REQUESTER

        if (width < maxline) then
          SET WARN "Couldn't adjust: lines too long"
        else
          SET WARN "Ok, we got it right."

      end

  end
