// SPRITDEM.C - Introduction to sprite drawing

// Written by Phil Inch for Game Developers Magazine (issue 3).
// Contributed to the public domain.

// This program written and compiled with Borland C++ v3.1
// Compatibility with other compilers is not guaranteed.

// Usage of this program is subject to the disclaimer printed
// in the magazine.  You assume all risks associated with the use
// of this program.

//
// The sprite:
//
//   01234567890123456
//   **......*......** 0
//   **......*......** 1
//   ........*........ 2
//   **.....***.....** 3
//   **.....***.....** 4
//   **....*****....** 5
//   **....*****....** 6
//   **...*******...** 7
//   **..*********..** 8
//   **.***********.** 9
//   *****.*****.***** 0
//   ****..*****..**** 1
//   ***...*****...*** 2
//   **.............** 3
//   **.....***.....** 4
//   **....*.*.*....** 5


/****************************** SPRITE DATA ********************************/

/* Method one - two dimensional array, where

   method1_data[p][0] = X
   method1_data[p][1] = Y
   method1_data[p][2] = COLOUR                  */

char method1_data[139][3] = {
   {0,0,14}, {1,0,14}, {8,0,1}, {15,0,14}, {16,0,14},
   {0,1,14}, {1,1,14}, {8,1,1}, {15,1,14}, {15,1,15},
   {8,2,1},
   {0,3,12}, {1,3,12}, {7,3,12}, {8,3,12}, {9,3,12}, {15,3,12}, {16,3,12},
   {0,4,12}, {1,4,12}, {7,4,12}, {8,4,12}, {9,4,12}, {15,4,12}, {16,4,12},
   {0,5,12}, {1,5,12}, {6,5,12}, {7,5,12}, {8,5,12}, {9,5,12}, {10,5,12}, {15,5,12}, {16,5,12},
   {0,6,12}, {1,6,12}, {6,6,12}, {7,6,12}, {8,6,12}, {9,6,12}, {10,6,12}, {15,6,12}, {16,6,12},
   {0,7,12}, {1,7,12}, {5,7,12}, {6,7,12}, {7,7,12}, {8,7,12}, {9,7,12}, {10,7,12}, {11,7,12}, {15,7,12}, {16,7,12},
   {0,8,12}, {1,8,12}, {4,8,12}, {5,8,12}, {6,8,12}, {7,8,12}, {8,8,12}, {9,8,12}, {10,8,12}, {11,8,12}, {12,8,12}, {15,8,12}, {16,8,12},
   {0,9,12}, {1,9,12}, {3,9,12}, {4,9,12}, {5,9,12}, {6,9,12}, {7,9,12}, {8,9,12}, {9,9,12}, {10,9,12}, {11,9,12}, {12,9,12}, {13,9,12}, {15,9,12}, {16,9,12},
   {0,10,12}, {1,10,12}, {2,10,12}, {3,10,12}, {4,10,12}, {6,10,12}, {7,10,12}, {8,10,12}, {9,10,12}, {10,10,12}, {12,10,12}, {13,10,12}, {14,10,12}, {15,10,12}, {16,10,12},
   {0,11,12}, {1,11,12}, {2,11,12}, {3,11,12}, {6,11,12}, {7,11,12}, {8,11,12}, {9,11,12}, {10,11,12}, {13,11,12}, {14,11,12}, {15,11,12}, {16,11,12},
   {0,12,12}, {1,12,12}, {2,12,12}, {6,12,12}, {7,12,12}, {8,12,12}, {9,12,12}, {10,12,12}, {14,12,12}, {15,12,12}, {16,12,12},
   {0,13,12}, {1,13,12}, {15,13,12}, {16,13,12},
   {0,14,12}, {1,14,12}, {7,14,14}, {8,14,14}, {9,14,14}, {15,14,12}, {16,14,12},
   {0,15,12}, {1,15,12}, {6,15,14}, {8,15,14}, {10,15,14}, {15,15,12}, {16,15,12}
   };


/* Method two - two dimensional array of the same size as the sprite */

char method2_data[16][17] = {
   { 14,14,0,0,0,0,0,0,1,0,0,0,0,0,0,14,14 },
   { 14,14,0,0,0,0,0,0,1,0,0,0,0,0,0,14,14 },
   { 0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0 },
   { 12,12,0,0,0,0,0,12,12,12,0,0,0,0,0,12,12},
   { 12,12,0,0,0,0,0,12,12,12,0,0,0,0,0,12,12},
   { 12,12,0,0,0,0,12,12,12,12,12,0,0,0,0,12,12},
   { 12,12,0,0,0,0,12,12,12,12,12,0,0,0,0,12,12},
   { 12,12,0,0,0,12,12,12,12,12,12,12,0,0,0,12,12},
   { 12,12,0,0,12,12,12,12,12,12,12,12,12,0,0,12,12},
   { 12,12,0,12,12,12,12,12,12,12,12,12,12,12,0,12,12},
   { 12,12,12,12,12,0,12,12,12,12,12,0,12,12,12,12,12},
   { 12,12,12,12,0,0,12,12,12,12,12,0,0,12,12,12,12},
   { 12,12,12,0,0,0,12,12,12,12,12,0,0,0,12,12,12},
   { 12,12,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12},
   { 12,12,0,0,0,0,0,14,14,14,0,0,0,0,0,12,12},
   { 12,12,0,0,0,0,14,0,14,0,14,0,0,0,0,12,12}
   };


/* Method three - flat array which also contains the dimensions */

char method3_data[] = {
   17, 16,
   14,14,0,0,0,0,0,0,1,0,0,0,0,0,0,14,14,
   14,14,0,0,0,0,0,0,1,0,0,0,0,0,0,14,14,
   0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
   12,12,0,0,0,0,0,12,12,12,0,0,0,0,0,12,12,
   12,12,0,0,0,0,0,12,12,12,0,0,0,0,0,12,12,
   12,12,0,0,0,0,12,12,12,12,12,0,0,0,0,12,12,
   12,12,0,0,0,0,12,12,12,12,12,0,0,0,0,12,12,
   12,12,0,0,0,12,12,12,12,12,12,12,0,0,0,12,12,
   12,12,0,0,12,12,12,12,12,12,12,12,12,0,0,12,12,
   12,12,0,12,12,12,12,12,12,12,12,12,12,12,0,12,12,
   12,12,12,12,12,0,12,12,12,12,12,0,12,12,12,12,12,
   12,12,12,12,0,0,12,12,12,12,12,0,0,12,12,12,12,
   12,12,12,0,0,0,12,12,12,12,12,0,0,0,12,12,12,
   12,12,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12,
   12,12,0,0,0,0,0,14,14,14,0,0,0,0,0,12,12,
   12,12,0,0,0,0,14,0,14,0,14,0,0,0,0,12,12
   };


/**************************** THE PROGRAM **********************************/

#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include <mem.h>
#include <string.h>
#include <stdlib.h>

char far *screen=MK_FP(0xA000,0);

void	SetGraphicsMode( void ) {
	asm {
		mov	ax,0x13
    int	0x10
	  }
}

void	SetTextMode( void ) {
	asm {
  	mov	ax,0x03
    int	0x10;
    }
}

void SetPoint( int X, int Y, int C ) {
  *(screen+(Y*320)+X)=C;
}

void method1_draw( int sw, int sh, int sx, int sy ) {
   int c;

   for ( c = 0; c < 139; c++ )
       SetPoint( (int)(method1_data[c][0]+sx), (int)(method1_data[c][1]+sy), (int)method1_data[c][2] );
}

void method2_draw( int sw, int sh, int sx, int sy ) {
   int c, x, y;

   for ( y = 0; y < sh; y++ )
       for ( x = 0; x < sw; x++ )
           SetPoint( x+sx, y+sy, (int)method2_data[y][x] );

}

void method3_draw( int sx, int sy ) {
   int x, y, c, sw, sh, length;

   /* Retrieve the width and height */
   sw = method3_data[0];
   sh = method3_data[1];
   c = 2;

   for ( y = 0; y < sh; y++ )
       for ( x = 0; x < sw; x++ )
           SetPoint( sx+x, sy+y, (int) method3_data[c++] );
}

void main( void ) {
  char input[64];
  int d,sx,sy,number_of_sprites;

	clrscr();

	printf( "*** SPRITE DRAWING DEMO ***\n\n" );
	printf( "Suggestions for number of sprites:\n\n" );
	printf( "486/50:  5000\n" );
	printf( "486/33:  4000\n" );
	printf( "486/25:  3000\n" );
	printf( "386/40:  1000\n" );
	printf( "386/33:   500\n" );
	printf( "lower :   250\n\n" );

	printf( "Enter number of sprites to draw: " );
	gets( input );

	number_of_sprites = atol(input);
	if ( number_of_sprites <= 0 ) {
		printf( "That's not a valid number!" );
		exit(1);
		}

  SetGraphicsMode();

  gotoxy( 16, 12 ); printf( "Method 1" ); delay(3000);
  for ( d = 0; d < number_of_sprites; d++ ) {
    sx = rand()%320;
    sy = rand()%200;
    method1_draw( 17, 16, sx, sy );
    }
  SetGraphicsMode();  // quick way of clearing the graphics screen

  gotoxy( 16, 12 ); printf( "Method 2" ); delay(3000);
  for ( d = 0; d < number_of_sprites; d++ ) {
    sx = rand()%320;
    sy = rand()%200;
    method2_draw( 17, 16, sx, sy );
    }
  SetGraphicsMode();  // quick way of clearing the graphics screen

  gotoxy( 16, 12 ); printf( "Method 3" ); delay(3000);
  for ( d = 0; d < number_of_sprites; d++ ) {
    sx = rand()%320;
    sy = rand()%200;
    method3_draw( sx, sy );
    }

  SetTextMode();
}
