
/*  A Bison parser, made from grammar with Bison version GNU Bison version 1.21
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	DELETE	258
#define	GET	259
#define	LETTER	260
#define	NEW	261
#define	NUMBER	262
#define	SAVE	263
#define	STRING	264
#define	ALPHANUM	265
#define	SET	266
#define	QUIT	267
#define	GIFFILE	268
#define	DEBUG_ON	269
#define	DEBUG_OFF	270
#define	XBMFILE	271
#define	COMMENT	272
#define	ARC	273
#define	LINE	274
#define	PIXEL	275
#define	POLYGON	276
#define	RECTANGLE	277
#define	FILL	278
#define	FILLED	279
#define	TILED	280
#define	STYLE	281
#define	TILE	282
#define	TRANSPARENT	283
#define	INTERLACED	284
#define	BRUSH	285
#define	INFO	286
#define	NEWLINE	287
#define	COLOR	288
#define	ALL	289
#define	CLOSEST	290
#define	EXACT	291
#define	PRINT	292
#define	HELP	293
#define	UP	294
#define	BIG	295
#define	SMALL	296
#define	MB	297
#define	GIANT	298
#define	TINY	299

#line 45 "grammar"

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include "dict.h"
#include "gd.h"
#include "gdfontl.h"
#include "gdfonts.h"
#include "gdfontg.h"
#include "gdfontmb.h"
#include "gdfontt.h"
#include "gdit.h"

#ifdef SUNOS
#define strerror perror
#endif /* SUNOS */


/*
 *	A list of predefined colors.  Text names can be used to refer to
 *	these colors.  Table is terminated by Null name.
 *
 *	ISOish.
 *	These names will need changing to the proper names, if they exist.
 */

struct	predefined_colors pct[] = {
	"salmon", 255, 128, 128,
	"red", 255, 0, 0,
	"brown", 128, 64, 64,
	"dark_red", 128, 0, 0,
	"red_black", 64, 0, 0,
	"black", 0, 0, 0,
	"wheat", 255, 255, 128,
	"yellow", 255, 255, 0,
	"orange", 255, 128, 64,
	"orange_red", 255, 128, 0,
	"red_brown", 128, 64, 0,
	"forest_green", 128, 128, 0,
	"green_yellow", 128, 255, 128,
	"medium_green", 128, 255, 0,
	"green", 0, 255, 0,
	"dark_green", 0, 128, 0,
	"green_black", 0, 64, 0,
	"sienna", 128, 128, 64,
	"spring_green", 128, 255, 0,
	"blue_green", 0, 255, 64,
	"gun_metal", 0, 128, 128,
	"malachite", 0, 128, 64,
	"gray", 128, 128, 128,
	"aquamarine", 128, 255, 255,
	"sky_blue", 0, 255, 255,
	"blue", 0, 0, 255,
	"purple", 0, 0, 128,
	"ocean", 64, 128, 128,
	"slate_blue", 0, 128, 255,
	"cadet_blue", 0, 128, 192,
	"navy_blue", 0, 0, 160,
	"blue_black", 0, 0, 64,
	"light_gray", 192, 192, 192,
	"mauve", 128, 0, 128,
	"violet", 255, 128, 255,
	"magenta", 255, 0, 255,
	"violet_red", 255, 0, 128,
	"royal_blue", 128, 0, 255,
	"white", 255, 255, 255,
	"", 0, 0, 0
};
	
/*
 *	GDIT's color map.
 */

struct color_map_table cmt;

/*
 *	Dictionary of line styles
 */

Dict_t StyleDict;

/*
 *	Parameter list.  Up to MAXPARAM parameters are allowed
 */
/*	allow MAXSTYLE color changes in a style */
char	colors[MAXSTYLE][NAMELEN];
int	param[MAXPARAM];
int	pindex;

/*
 *	Last word returned by lexer
 */
char	*word;

/*
 *	Some globals
 */
char		style_name[NAMELEN];
FILE		*fp;
gdImagePtr	image_out = 0;
gdImagePtr	brush = 0;
gdImagePtr	tile = 0;
int		Closest = 0;
gdFontPtr	font;
char		*comment = 0;

struct idlist {
	char *	name;
	int	id;
};

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		140
#define	YYFLAG		-32768
#define	YYNTBASE	45

#define YYTRANSLATE(x) ((unsigned)(x) <= 299 ? yytranslate[x] : 59)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41,    42,    43,    44
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     8,    12,    16,    19,    23,    28,    34,
    39,    45,    52,    55,    58,    61,    63,    68,    72,    75,
    77,    80,    83,    87,    91,    94,    97,    99,   101,   103,
   109,   114,   117,   124,   132,   136,   140,   144,   148,   151,
   154,   157,   163,   170,   178,   185,   189,   193,   198,   204,
   208,   212,   217,   222,   227,   232,   238,   244,   251,   256,
   261,   267,   273,   274,   277,   281,   283,   285,   286,   288,
   289,   292,   294,   296,   298,   300,   302,   304,   306,   308,
   310,   312,   314,   316,   318
};

static const short yyrhs[] = {    -1,
    45,    32,     0,    45,    46,    32,     0,    45,    47,    32,
     0,    45,    12,    32,     0,     1,    32,     0,     6,     7,
     7,     0,     6,     7,     7,    54,     0,     6,     7,     7,
    54,    54,     0,     6,     7,     7,    53,     0,     6,     7,
     7,    53,    54,     0,     6,     7,     7,    53,    54,    54,
     0,     6,    16,     0,     6,    13,     0,     8,    13,     0,
     8,     0,     4,    20,     7,     7,     0,     4,    33,    31,
     0,     4,    31,     0,     3,     0,     3,    30,     0,     3,
    27,     0,     3,    26,    50,     0,     3,    26,    34,     0,
     3,    34,     0,    38,    10,     0,    38,     0,    14,     0,
    15,     0,    11,    20,     7,     7,    53,     0,    11,    26,
    50,    48,     0,    11,    54,     0,    11,    33,     7,     7,
     7,    10,     0,    11,    35,    33,     7,     7,     7,    10,
     0,    11,    28,    53,     0,    11,    28,     7,     0,    11,
    30,    13,     0,    11,    27,    13,     0,    11,    35,     0,
    11,    36,     0,    17,    56,     0,    37,     7,     7,    53,
    56,     0,    37,    55,     7,     7,    53,    56,     0,    37,
    39,    55,     7,     7,    53,    56,     0,    37,    39,     7,
     7,    53,    56,     0,    57,    51,    30,     0,    57,    51,
    53,     0,    57,    51,    26,    50,     0,    57,    51,    26,
    50,    30,     0,    58,    51,    53,     0,    58,    51,    30,
     0,    58,    51,    30,    24,     0,    58,    51,    25,    24,
     0,    58,    51,    53,    24,     0,    58,    51,    26,    50,
     0,    58,    51,    26,    50,    24,     0,    58,    51,    26,
    50,    30,     0,    58,    51,    26,    50,    30,    24,     0,
    23,     7,     7,    53,     0,    23,     7,     7,    25,     0,
    23,     7,     7,    53,    53,     0,    23,     7,     7,    25,
    53,     0,     0,    48,    49,     0,    48,     7,    49,     0,
    10,     0,    28,     0,     0,    10,     0,     0,    51,    52,
     0,     7,     0,    10,     0,    28,     0,    29,     0,    40,
     0,    41,     0,    43,     0,    42,     0,    44,     0,     9,
     0,    19,     0,    18,     0,    21,     0,    22,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   169,   170,   176,   182,   188,   195,   203,   207,   211,   215,
   219,   223,   227,   244,   263,   267,   271,   275,   292,   320,
   327,   334,   341,   347,   351,   355,   359,   363,   369,   377,
   381,   389,   398,   403,   408,   414,   418,   430,   442,   446,
   450,   461,   465,   469,   473,   479,   483,   487,   493,   501,
   505,   509,   513,   517,   521,   527,   533,   539,   548,   556,
   564,   572,   583,   584,   594,   603,   610,   620,   620,   626,
   627,   630,   640,   647,   651,   657,   661,   665,   669,   673,
   679,   689,   693,   699,   703
};

static const char * const yytname[] = {   "$","error","$illegal.","DELETE","GET",
"LETTER","NEW","NUMBER","SAVE","STRING","ALPHANUM","SET","QUIT","GIFFILE","DEBUG_ON",
"DEBUG_OFF","XBMFILE","COMMENT","ARC","LINE","PIXEL","POLYGON","RECTANGLE","FILL",
"FILLED","TILED","STYLE","TILE","TRANSPARENT","INTERLACED","BRUSH","INFO","NEWLINE",
"COLOR","ALL","CLOSEST","EXACT","PRINT","HELP","UP","BIG","SMALL","MB","GIANT",
"TINY","list","function","draw","names","style_color","style_name","values",
"number","color","style_type","font","string","lines","shapes",""
};
#endif

static const short yyr1[] = {     0,
    45,    45,    45,    45,    45,    45,    46,    46,    46,    46,
    46,    46,    46,    46,    46,    46,    46,    46,    46,    46,
    46,    46,    46,    46,    46,    46,    46,    46,    46,    47,
    47,    47,    47,    47,    47,    47,    47,    47,    47,    47,
    47,    47,    47,    47,    47,    47,    47,    47,    47,    47,
    47,    47,    47,    47,    47,    47,    47,    47,    47,    47,
    47,    47,    48,    48,    48,    49,    49,    50,    50,    51,
    51,    52,    53,    54,    54,    55,    55,    55,    55,    55,
    56,    57,    57,    58,    58
};

static const short yyr2[] = {     0,
     0,     2,     3,     3,     3,     2,     3,     4,     5,     4,
     5,     6,     2,     2,     2,     1,     4,     3,     2,     1,
     2,     2,     3,     3,     2,     2,     1,     1,     1,     5,
     4,     2,     6,     7,     3,     3,     3,     3,     2,     2,
     2,     5,     6,     7,     6,     3,     3,     4,     5,     3,
     3,     4,     4,     4,     4,     5,     5,     6,     4,     4,
     5,     5,     0,     2,     3,     1,     1,     0,     1,     0,
     2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1
};

static const short yydefact[] = {     0,
     0,     0,     6,    20,     0,     0,    16,     0,     0,    28,
    29,     0,    83,    82,    84,    85,     0,     2,     0,    27,
     0,     0,    70,    70,    68,    22,    21,    25,     0,    19,
     0,     0,    14,    13,    15,     0,    68,     0,    74,    75,
     0,     0,    39,    40,    32,     5,    81,    41,     0,     0,
     0,    76,    77,    79,    78,    80,     0,    26,     3,     4,
     0,     0,    69,    24,    23,     0,    18,     7,     0,    63,
    38,    36,    73,    35,    37,     0,     0,     0,     0,     0,
     0,     0,    72,    68,    46,    71,    47,     0,    68,    51,
    50,    17,    74,    10,     8,     0,    31,     0,     0,    60,
    59,     0,     0,     0,     0,    48,    53,    55,    52,    54,
    11,     9,    30,     0,    66,    67,    64,     0,     0,    62,
    61,    42,     0,     0,     0,    49,    56,    57,    12,    65,
    33,     0,    45,     0,    43,    58,    34,    44,     0,     0
};

static const short yydefgoto[] = {     2,
    21,    22,    97,   117,    65,    61,    86,    74,    45,    57,
    48,    23,    24
};

static const short yypact[] = {    47,
   -20,    83,-32768,   123,   -11,    21,     6,   112,   -16,-32768,
-32768,    17,-32768,-32768,-32768,-32768,    31,-32768,    34,    33,
    13,    20,-32768,-32768,    -2,-32768,-32768,-32768,    53,-32768,
    36,    64,-32768,-32768,-32768,    65,    70,    68,     4,-32768,
    77,    92,    74,-32768,-32768,-32768,-32768,-32768,    96,   101,
    85,-32768,-32768,-32768,-32768,-32768,   102,-32768,-32768,-32768,
   107,    86,-32768,-32768,-32768,   103,-32768,    -5,   106,-32768,
-32768,-32768,-32768,-32768,-32768,   111,   115,    -4,   109,   116,
   117,   124,-32768,    70,-32768,-32768,-32768,   110,    70,   119,
   120,-32768,-32768,    28,    28,   109,     3,   128,   129,   109,
   109,    17,   109,   139,   109,   100,-32768,    58,-32768,-32768,
    28,-32768,-32768,     5,-32768,-32768,-32768,   141,   145,-32768,
-32768,-32768,    17,   109,    17,-32768,-32768,   130,-32768,-32768,
-32768,   146,-32768,    17,-32768,-32768,-32768,-32768,   155,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,    44,   -35,   135,-32768,   -61,   -65,   113,
   -98,-32768,-32768
};


#define	YYLAST		164


static const short yytable[] = {    87,
    91,    70,    95,   122,    73,    73,    94,    63,    29,   114,
    72,     3,   115,    73,   115,    46,   101,   102,    35,    30,
   100,    31,    93,    40,   133,    47,   135,    32,   111,   112,
   116,    64,   116,    33,   113,   138,    34,    49,   120,   121,
    50,   123,    58,   125,    59,   129,    -1,     1,   106,    -1,
    -1,    60,    -1,   108,    -1,    93,    40,    -1,    -1,    66,
    -1,    -1,   134,    -1,    -1,    -1,    67,    -1,    -1,    -1,
    68,    69,    51,    52,    53,    54,    55,    56,    -1,    63,
    71,   127,   139,    -1,    -1,     4,     5,   128,     6,    75,
     7,    80,    83,     8,     9,    73,    10,    11,    76,    12,
    13,    14,    78,    15,    16,    17,    77,    79,    82,    92,
    88,    89,    96,    83,    18,    90,    73,    98,    73,    19,
    20,    99,   103,   104,    52,    53,    54,    55,    56,   126,
   105,    36,    84,   107,   118,   119,    85,    37,    38,    39,
    40,    41,   109,   110,    42,   124,    43,    44,    25,    26,
   131,   132,    27,   136,   140,   137,    28,   130,    62,     0,
     0,     0,     0,    81
};

static const short yycheck[] = {    61,
    62,    37,    68,   102,    10,    10,    68,    10,    20,     7,
     7,    32,    10,    10,    10,    32,    78,    79,    13,    31,
    25,    33,    28,    29,   123,     9,   125,     7,    94,    95,
    28,    34,    28,    13,    96,   134,    16,     7,   100,   101,
     7,   103,    10,   105,    32,   111,     0,     1,    84,     3,
     4,    32,     6,    89,     8,    28,    29,    11,    12,     7,
    14,    15,   124,    17,    18,    19,    31,    21,    22,    23,
     7,     7,    39,    40,    41,    42,    43,    44,    32,    10,
    13,    24,     0,    37,    38,     3,     4,    30,     6,    13,
     8,     7,     7,    11,    12,    10,    14,    15,     7,    17,
    18,    19,     7,    21,    22,    23,    33,     7,     7,     7,
    25,    26,     7,     7,    32,    30,    10,     7,    10,    37,
    38,     7,     7,     7,    40,    41,    42,    43,    44,    30,
     7,    20,    26,    24,     7,     7,    30,    26,    27,    28,
    29,    30,    24,    24,    33,     7,    35,    36,    26,    27,
    10,     7,    30,    24,     0,    10,    34,   114,    24,    -1,
    -1,    -1,    -1,    51
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <malloc.h>


/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 184 "bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
		 &yyls1, size * sizeof (*yylsp),
#endif
		 &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 171 "grammar"
{
			if (prompt) {
				printf("> ");
			}
		;
    break;}
case 3:
#line 177 "grammar"
{
			if (prompt) {
				printf("> ");
			}
		;
    break;}
case 4:
#line 183 "grammar"
{
			if (prompt) {
				printf("> ");
			}
		;
    break;}
case 5:
#line 189 "grammar"
{
			delete_all();
			fflush(stdout);
			fflush(stderr);
			return;
		;
    break;}
case 6:
#line 196 "grammar"
{	yyerrok;
			if (!silent) {
		  		printf("reenter last line\n> ");
			}
		;
    break;}
case 7:
#line 204 "grammar"
{
			new_image(yyvsp[-1], yyvsp[0], get_color("white"), 0);
		;
    break;}
case 8:
#line 208 "grammar"
{
			new_image(yyvsp[-2], yyvsp[-1], get_color("white"), yyvsp[0]);
		;
    break;}
case 9:
#line 212 "grammar"
{
			new_image(yyvsp[-3], yyvsp[-2], get_color("white"), (yyvsp[-1] | yyvsp[0]));
		;
    break;}
case 10:
#line 216 "grammar"
{
			new_image(yyvsp[-2], yyvsp[-1], yyvsp[0], 0);
		;
    break;}
case 11:
#line 220 "grammar"
{
			new_image(yyvsp[-3], yyvsp[-2], yyvsp[-1], yyvsp[0] );
		;
    break;}
case 12:
#line 224 "grammar"
{
			new_image(yyvsp[-4], yyvsp[-3], yyvsp[-2], (yyvsp[-1] | yyvsp[0]));
		;
    break;}
case 13:
#line 228 "grammar"
{
			int	i;

        		if (image_out != 0) {
				WARNING((stderr, "delete old image first!\n"));
			} else {
				image_out = open_as_xbm(word);
/*
 *				new image, colors will all need to
 *				be reallocated.
 */
				for(i=0; i < cmt.count; i++) {
					cmt.map[i].color = -1;
				}/* for */
			}
		;
    break;}
case 14:
#line 245 "grammar"
{
			int	i;

        		if (image_out != 0) {
				WARNING((stderr, "delete old image first!\n"));
			} else {
				image_out = open_as_gif(word);
/*
 *				new image, colors will all need to
 *				be reallocated.
 */
				if (image_out != NULL) {
					for(i=0; i < cmt.count; i++) {
						cmt.map[i].color = -1;
					}/* for */
				}
			}
		;
    break;}
case 15:
#line 264 "grammar"
{
			save_as_gif(word);
		;
    break;}
case 16:
#line 268 "grammar"
{
			save_as_gif(NULL);
		;
    break;}
case 17:
#line 272 "grammar"
{
			get_pixel(yyvsp[-1], yyvsp[0]);
		;
    break;}
case 18:
#line 276 "grammar"
{
			int	i;

			for (i=0; i < cmt.count; i++) {
				printf("%s:\tr=%d, g=%d, b=%d, ",
					cmt.map[i].name,
					cmt.map[i].v1,
					cmt.map[i].v2,
					cmt.map[i].v3);
				if (cmt.map[i].color == -1) {
					printf("not allocated\n");
				} else {
					printf("index=%d\n", cmt.map[i].color);
				}
			}/* for */
		;
    break;}
case 19:
#line 293 "grammar"
{
			if (image_out == 0) {
				if (!silent) {
					fprintf(stderr, "no current image\n");
				}
			} else if (!silent) {
				int index;

				printf("The image is:");
				if (gdImageGetInterlaced(image_out)) {
					printf(" interlaced,\n");
				} else {
					printf(" non-interlaced,\n");
				}
				printf("width %d, height %d,\n",
					gdImageSX(image_out),
					gdImageSY(image_out));
				index = gdImageGetTransparent(image_out);
				if (index == -1) {
					printf("no transparent color is set,\n");
				} else {
					printf("transparent color index is %d,\n", index);
				}
				printf("there are %d colors in the image.\n",
					gdImageColorsTotal(image_out));
			}
		;
    break;}
case 20:
#line 321 "grammar"
{
			if (image_out != 0) {
				gdImageDestroy(image_out);
			}
			image_out = 0;
		;
    break;}
case 21:
#line 328 "grammar"
{
			if (brush != 0) {
				gdImageDestroy(brush);
				brush = 0;
			}
		;
    break;}
case 22:
#line 335 "grammar"
{
			if (tile != 0) {
				gdImageDestroy(tile);
				tile = 0;
			}
		;
    break;}
case 23:
#line 342 "grammar"
{
			if (removeNode(&StyleDict, style_name) == 0) {
				WARNING((stderr, "style not found\n"));
			}
		;
    break;}
case 24:
#line 348 "grammar"
{
			del_all_styles();
		;
    break;}
case 25:
#line 352 "grammar"
{
			delete_all();
		;
    break;}
case 26:
#line 356 "grammar"
{
			help_topic(getfunc(word));
		;
    break;}
case 27:
#line 360 "grammar"
{
			help_topic(HELP);
		;
    break;}
case 28:
#line 364 "grammar"
{
#if YYDEBUG != 0
		yydebug = 1;
#endif
	;
    break;}
case 29:
#line 370 "grammar"
{
#if YYDEBUG != 0
		yydebug = 0;
#endif
	;
    break;}
case 30:
#line 378 "grammar"
{
			set_pixel(yyvsp[-2], yyvsp[-1], yyvsp[0]);
		;
    break;}
case 31:
#line 382 "grammar"
{
			if (pindex == -1) {
				pindex=0;
			} else {
				new_line_style(style_name);
			}
		;
    break;}
case 32:
#line 390 "grammar"
{
			if (yyvsp[0] == INTERLACED) {
				gdImageInterlace(image_out, 1);
			}
			if (yyvsp[0] == TRANSPARENT) {
				gdImageColorTransparent(image_out, -1);
			}
		;
    break;}
case 33:
#line 399 "grammar"
{
			define_color(yyvsp[-3], yyvsp[-2], yyvsp[-1], word, 0);
			
		;
    break;}
case 34:
#line 404 "grammar"
{
			define_color(yyvsp[-4], yyvsp[-3], yyvsp[-2], word, 1);
			
		;
    break;}
case 35:
#line 409 "grammar"
{
			if (yyvsp[0] != -1) {
				gdImageColorTransparent(image_out, yyvsp[0]);
			}
		;
    break;}
case 36:
#line 415 "grammar"
{
			gdImageColorTransparent(image_out, yyvsp[0]);
		;
    break;}
case 37:
#line 419 "grammar"
{
        		if (brush != 0) {
				WARNING((stderr, "delete old brush first\n"));
			} else if (image_out == 0) {
				WARNING((stderr, "no current image\n"));
			} else {
				if ((brush = open_as_gif(word)) != NULL) {
					gdImageSetBrush(image_out, brush);
				}
			}
		;
    break;}
case 38:
#line 431 "grammar"
{
        		if (tile != 0) {
				WARNING((stderr, "delete old tile first\n"));
			} else if (image_out == 0) {
				WARNING((stderr, "no current image\n"));
			} else {
				if ((tile = open_as_gif(word)) != NULL) {
					gdImageSetTile(image_out, tile);
				}
			}
		;
    break;}
case 39:
#line 443 "grammar"
{
			Closest=0;
		;
    break;}
case 40:
#line 447 "grammar"
{
			Closest=1;
		;
    break;}
case 41:
#line 451 "grammar"
{
			if (comment == 0) {
				comment = (char *) malloc(strlen(word) + 1);
				strcpy(comment, word);
			} else {
   				comment = (char *) realloc(comment,
							strlen(word));
				strcpy(comment, word);
			}
		;
    break;}
case 42:
#line 462 "grammar"
{
			print_string(0, gdFontSmall, yyvsp[-3], yyvsp[-2], yyvsp[-1], word);
		;
    break;}
case 43:
#line 466 "grammar"
{
			print_string(0, font, yyvsp[-3], yyvsp[-2], yyvsp[-1], word);
		;
    break;}
case 44:
#line 470 "grammar"
{
			print_string(1, font, yyvsp[-3], yyvsp[-2], yyvsp[-1], word);
		;
    break;}
case 45:
#line 474 "grammar"
{
			print_string(1, gdFontSmall, yyvsp[-3], yyvsp[-2], yyvsp[-1], word);
		;
    break;}
case 46:
#line 480 "grammar"
{
			draw_lines(yyvsp[-2], gdBrushed);
		;
    break;}
case 47:
#line 484 "grammar"
{
			draw_lines(yyvsp[-2], yyvsp[0]);
		;
    break;}
case 48:
#line 488 "grammar"
{
			if (set_line_style(style_name)) {
				draw_lines(yyvsp[-3], gdStyled);
			}
		;
    break;}
case 49:
#line 494 "grammar"
{
			if (set_line_style(style_name)) {
				draw_lines(yyvsp[-4], gdStyledBrushed);
			}
		;
    break;}
case 50:
#line 502 "grammar"
{ 
			draw_shape(yyvsp[-2], yyvsp[0], 0);
		;
    break;}
case 51:
#line 506 "grammar"
{ 
			draw_shape(yyvsp[-2], gdBrushed, 0);
		;
    break;}
case 52:
#line 510 "grammar"
{ 
			draw_shape(yyvsp[-3], gdBrushed, 1);
		;
    break;}
case 53:
#line 514 "grammar"
{ 
			draw_shape(yyvsp[-3], gdTiled, 1);
		;
    break;}
case 54:
#line 518 "grammar"
{ 
			draw_shape(yyvsp[-3], yyvsp[-1], 1);
		;
    break;}
case 55:
#line 522 "grammar"
{
			if (set_line_style(style_name)) {
				draw_shape(yyvsp[-3], gdStyled, 0);
			}
		;
    break;}
case 56:
#line 528 "grammar"
{
			if (set_line_style(style_name)) {
				draw_shape(yyvsp[-4], gdStyled, 1);
			}
		;
    break;}
case 57:
#line 534 "grammar"
{
			if (set_line_style(style_name)) {
				draw_shape(yyvsp[-4], gdStyledBrushed, 0);
			}
		;
    break;}
case 58:
#line 540 "grammar"
{
			if (set_line_style(style_name)) {
				draw_shape(yyvsp[-5], gdStyledBrushed, 1);
			}
		;
    break;}
case 59:
#line 549 "grammar"
{
			image_fill(
				yyvsp[-2],
				yyvsp[-1],
				yyvsp[0],
				-1);
		;
    break;}
case 60:
#line 557 "grammar"
{
			image_fill(
				yyvsp[-2],
				yyvsp[-1],
				gdTiled,
				-1);
		;
    break;}
case 61:
#line 565 "grammar"
{
			image_fill(
				yyvsp[-3],
				yyvsp[-2],
				yyvsp[-1],
				yyvsp[0]);
		;
    break;}
case 62:
#line 573 "grammar"
{
			image_fill(
				yyvsp[-3],
				yyvsp[-2],
				gdTiled,
				yyvsp[0]);
		;
    break;}
case 64:
#line 585 "grammar"
{
/*
 *			A Single color
 */
			if (pindex != -1) {
				param[pindex]=1;
				strncpy(colors[pindex++], word, NAMELEN);
			}
		;
    break;}
case 65:
#line 595 "grammar"
{
			if (pindex != -1) {
				param[pindex]=yyvsp[-1];
				strncpy(colors[pindex++], word, NAMELEN);
			}
		;
    break;}
case 66:
#line 604 "grammar"
{
		if (pindex==MAXSTYLE) {
			WARNING((stderr,"too many color changes\n"));
			pindex=-1;	/* an error occured */
		} 
	;
    break;}
case 67:
#line 611 "grammar"
{
		if (pindex==MAXSTYLE) {
			WARNING((stderr,"too many color changes\n"));
			pindex=-1;	/* an error occured */
		} 
	;
    break;}
case 69:
#line 621 "grammar"
{
		strncpy(style_name, word, NAMELEN);
	;
    break;}
case 72:
#line 631 "grammar"
{
			if (pindex==MAXPARAM) {
				WARNING((stderr,"too many parameters\n"));
			} else if (pindex != -1) {
				param[pindex++]=yyvsp[0];
			}
		;
    break;}
case 73:
#line 641 "grammar"
{
			yyval = get_color(word);
		;
    break;}
case 74:
#line 648 "grammar"
{
			yyval = TRANSPARENT;
		;
    break;}
case 75:
#line 652 "grammar"
{
			yyval = INTERLACED;
		;
    break;}
case 76:
#line 658 "grammar"
{
			font = gdFontLarge;
		;
    break;}
case 77:
#line 662 "grammar"
{
			font = gdFontSmall;
		;
    break;}
case 78:
#line 666 "grammar"
{
			font = gdFontGiant;
		;
    break;}
case 79:
#line 670 "grammar"
{
			font = gdFontMediumBold;
		;
    break;}
case 80:
#line 674 "grammar"
{
			font = gdFontTiny;
		;
    break;}
case 81:
#line 680 "grammar"
{
			char	*s;

			word++;	/* step over leading quote */
			s = (char *) strchr(word, '"');
			*s = '\0';
		;
    break;}
case 82:
#line 690 "grammar"
{
			yyval = LINE;
		;
    break;}
case 83:
#line 694 "grammar"
{
			yyval = ARC;
		;
    break;}
case 84:
#line 700 "grammar"
{
			yyval = POLYGON;
		;
    break;}
case 85:
#line 704 "grammar"
{
			yyval = RECTANGLE;
		;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 457 "bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 710 "grammar"
 /* start of programs */

/*
 *	get_color
 *	Gets the cmt index for the color.  This is either:
 *	+	from the current color map table
 * 	+	a special color
 *	or
 *	+	from the list of predefined colors.
 *
 *	changed.
 *
 *	RETURNS
 *	color index
 *		or
 *	-1 - The color wasn't found.
 */

int
get_color(
	char	*name	)
{
	register i;

/*
 *	Transparent is a special case.
 */
	if (strcmp(name, "transparent") == 0) {
		return gdTransparent;	/* special color */
	}
	if (cmt.count > 0) {
/*
 *		check cmt for color
 */
		for (i=0; i < cmt.count; i++) {
			if (strncmp(cmt.map[i].name, name, NAMELEN) == 0) {
				return i;	/* got it! */
			}
		}/* for */
	}
/*
 *	See if it's a predefined color, if so copy the parameters to the cmt
 *	but punt on allocating an index until we come to use it.
 */
	if (image_out == 0 || gdImageColorsTotal(image_out) < gdMaxColors) {
/* 
 *		Either no image or enough room for more colors.
 */
		if (cmt.count < gdMaxColors) {
		/*
		 * Still room for more colors in table.  Check
	 	 * Predefined table.
	 	 */
			for (i=0; *(pct[i].name) != '\0'; i++) {
				if (strncmp(pct[i].name, name, NAMELEN) == 0) {
					break;	/* got it! */
				}
			}/* for */
/* DBHG why not check against size? */
			if (*(pct[i].name) != '\0') {
				int c = cmt.count;
				/*
			 	 * found predefined color, copy it over.
				 */
				strncpy(cmt.map[c].name, name, NAMELEN);
				cmt.map[c].color=-1; /* not yet allocated */
				cmt.map[c].v1=pct[i].v1;
				cmt.map[c].v2=pct[i].v2;
				cmt.map[c].v3=pct[i].v3;
				i = cmt.count++;
			} else {
				WARNING((stderr,
					"color: %s has not been defined\n",
					name));
				return -1;
			}
		}
	}

	return i;
}/* get_color */


/*
 *	define_color
 *	User defined colors override any predefined colors.  Note: if the gdit
 *	color table is already full specifying closest won't cause this new
 *	color to be defined.  An existing color name should be used.
 *
 *	r,g,b	Red, Green, Blue intesities
 *	name	Name of color
 *	closest	if 1 try for closest color match.
 *
 *	RETURNS
 *	color index
 *		or
 *	-1
 */

int
define_color(
	int	r,
	int	g,
	int	b,
	char	*name,
	int	closest	)
{
	register i;

	if (cmt.count > 0) {
/*
 *		check cmt for color
 */
		for (i=0; i < cmt.count; i++) {
			if (strcmp(cmt.map[i].name, name) == 0) {
				WARNING((stderr, "%s, is already defined as %d, %d, %d\n", name, cmt.map[i].v1, cmt.map[i].v2, cmt.map[i].v3));
				return -1;
			}
		}/* for */
	}
	if (image_out && gdImageColorsTotal(image_out) == gdMaxColors ||
		cmt.count == gdMaxColors) {
		WARNING((stderr, "color table is full, delete another color first\n"));
		return -1;
	}
	/*
	 * copy it over.
	 */
	strcpy(cmt.map[cmt.count].name, name);
	cmt.map[cmt.count].v1=r;
	cmt.map[cmt.count].v2=g;
	cmt.map[cmt.count].v3=b;
	if (image_out == 0) {
		cmt.map[cmt.count].color=-1; /* not yet allocated */
	} else {
/*
 *		need to see if we can slot it in, maybe the image has already
 *		defined 256 colors.
 */
		if ((i = alloc_color(&cmt.map[cmt.count], closest)) == -1) {
			return -1;
		}
		cmt.map[cmt.count].color = i;
	}

	return ++cmt.count;
}/* define_color */


/*
 *	new_line_style
 *
 *	Set up a new line style.  Styles are simple descriptions of how
 *	line's should be drawn.  A gd library style is an array of color
 *	indexes, a red dotted line could be drawn as:
 *		red, red, red, transparent, transparent, transparent blue
 *
 *	GDIT uses color names rather then indexes.  This has the advantage
 *	that names are more meaningful to users.  Also styles can be used
 *	over multiple images because we store the style rather than the index
 *	(the GIF index for red may vary).  Counts can also be specified:
 *
 *	The above line would be:
 *		3 red 3 transparent blue
 */

int
new_line_style(
	char *name	)
{
	El_t		*pEl;
	Entry_t		*pEntry;
	register int	i;

	if (pindex == 1) {
		WARNING((stderr, "style must contain different colors\n"));
		pindex=0;
		return 0;
	}
	if ((pEntry = (Entry_t *) malloc(sizeof(Entry_t))) == 0) {
		WARNING((stderr, "out of memory!\n"));
		return 0;
	}
	strncpy(pEntry->Name, name, NAMELEN);
	if (addNode(&StyleDict, (Node_t*) pEntry)) {
		WARNING((stderr, "duplicate style\n"));
		free(pEntry);
		return 0;
	}
/*
 *	Set up style.  The format is:
 *	count1 color1... countn colorn
 *
 *	We don't care if the colors are valid at this stage.
 */
	pEntry->count=pindex;
	pEntry->total=0;
	if ((pEntry->pStyle = (El_t *) malloc(sizeof(El_t) * pindex)) == 0){
		WARNING((stderr, "out of memory!\n"));
		removeNode(&StyleDict, pEntry->Name);
		free(pEntry);
		return 0;
	}
	pEl = pEntry->pStyle;
	for (i = 0; i < pindex; i++, pEl++) {
		pEl->count=param[i];
		pEntry->total+= pEl->count;
		strncpy(pEl->color, colors[i], NAMELEN);
	}/* for */

	pindex=0;
	return 1;
}/* new_line_style */


/*
 *	set_line_style
 *
 *	name	name of style to set.
 *
 *	RETURN
 *	0	- can't set style
 *	1	- success
 */

int
set_line_style(
	char	*name	)
{
	Entry_t		*pEntry;
	El_t		*pEl;
	register int	i;
	int		*style,
			*pstyle;

	if (image_out == 0) {
		WARNING((stderr, "Can't set style because no image\n"));
		return 0;
	}
	if ((pEntry = (Entry_t *) getNode(&StyleDict, name)) == 0) {
		WARNING((stderr, "can't find style\n"));
		return 0;
	}

	pEl = pEntry->pStyle;
	if ((style = (int *) malloc(sizeof(int) * pEntry->total)) == 0) {
		WARNING((stderr, "out of memory!\n"));
		return 0;
	}
	pstyle = style;
	for (pEl = pEntry->pStyle, i=0; i < pEntry->count; i++, pEl++) {
		int color;
		int index;

		index=get_color(pEl->color);
		color = cmt.map[index].color;
		if (color == -1) {
			color = alloc_color(&cmt.map[index], Closest);
			if (color == -1) {
				free(style);
				return 0;
			}
			cmt.map[index].color = color;
		}
		index = pEl->count;
		for (index = 0; index < pEl->count; index++) {
			*pstyle++ = color;
		}/* for */
	}/* for */
	gdImageSetStyle(image_out, style, pEntry->total);

	free(style);
	return 1;
}/* set_line_style */


/*
 *	del_all_styles
 *
 *	Delete all line styles.
 */

void
del_all_styles()
{
	Entry_t		*pEntry;

	while((pEntry = (Entry_t *) getFirstNode(&StyleDict)) != 0) {
		pEntry = (Entry_t *) removeNode(&StyleDict, pEntry->Name);
		free(pEntry->pStyle);
		free(pEntry);
	}/* while */

	return;
}/* del_all_styles */


/*
 *	delete_all
 *
 *	Delete everyting!
 */

void
delete_all()
{
	if (image_out != 0) {
		gdImageDestroy(image_out);
		image_out = 0;
	}
	if (brush != 0) {
		gdImageDestroy(brush);
		brush = 0;
	}
	if (tile != 0) {
		gdImageDestroy(tile);
		tile = 0;
	}
	del_all_styles();
}/* delete_all */


/*
 *	new_image
 *
 *	Creates a new image, any existing image must be deleted first.
 *	Color index and style must be legal values.
 *
 *	width, height	Image dimensions in pixels
 *	color_index	gdit color value
 *	style		Interlaced	- interlaced GIF89 image.
 *			Transparent	- make color_index transparent.
 *
 *	RETURNS	0	failure
 *		1	success
 */

int
new_image(
	int	height,
	int	width,
	int	color_index,
	int	style	)
{
	register int	i;

	if (color_index == -1) {
		return 0;
	}
        if (image_out != 0) {
		WARNING((stderr, "delete the old image first!\n"));
		return 0;
	}
/*
 *	new image, colors will all need to be reallocated.
 */
	for(i=0; i < cmt.count; i++) {
		cmt.map[i].color = -1;
	}/* for */
	image_out = gdImageCreate(height, width);
	if (image_out == 0) {
		WARNING((stderr, "cannot create image\n"));
		return 0;
	}
/*
 *	First color is background
 */
	cmt.map[color_index].color = gdImageColorAllocate(
		image_out,
		cmt.map[color_index].v1,
		cmt.map[color_index].v2,
		cmt.map[color_index].v3 );

	if (style & INTERLACED) {
		gdImageInterlace(image_out, 1);
	}
	if (style & TRANSPARENT) {
		gdImageColorTransparent(image_out, cmt.map[color_index].color);
	}

	return 1;
}/* new_image */


/*
 *	get_pixel
 *
 *	Prints the color index and componenents for the given pixel to
 *	the screen.
 *
 *	x,y	coordinates
 *
 *	RETURNS	0	failure
 *		1	success
 */

int
get_pixel(
	int	x,
	int	y	)
{
	int	index;
        if (image_out == 0) {
		WARNING((stderr, "no current image\n"));
		return 0;
	}
	index = gdImageGetPixel(image_out, x, y);
	if (index >= 0 && index < 255) {
/*
 *		valid index
 */
		printf("index %d; RGB values are %d,%d,%d\n",
			index,
			gdImageRed(image_out, index),
			gdImageGreen(image_out, index),
			gdImageBlue(image_out, index));
	} else {
		return 0;
	}

	return 1;
}/* get_pixel */


/*
 *	set_pixel
 *
 *	Set pixel to specified color.
 *
 *	x,y	coordinates
 *	int	color_index
 *
 *	RETURNS	0	failure
 *		1	success
 */

int
set_pixel(
	int	x,
	int	y,
	int	color_index)
{
	int	color;

	if (color_index == -1) {
		return 0;
	}
        if (image_out == 0) {
		WARNING((stderr, "no current image\n"));
		return 0;
	} else {
		if ((color = cmt.map[color_index].color) == -1) {

			color = alloc_color(&cmt.map[color_index], Closest);
			if (color == -1) {
				return 0;
			}
			cmt.map[color_index].color = color;
		}
		gdImageSetPixel(
			image_out,
			x,
			y,
			color	);
	}

	return 1;
}/* set_pixel */


/*
 *	draw_line
 *
 *	Draws a line from points x1,y1 to points x2,y2.  The coordinates are
 *	passed in the params array.  
 *
 *	color_index	Color
 *
 *	RETURNS	0	failure
 *		1	success
 */

int
draw_line(
	int	color_index	)
{
	int	color;

	if (pindex != 4) {
		WARNING((stderr, "A line needs 2 sets of coordinates\n"));
		return 0;
	}
	if (color_index == -1) {
		return 0;
	}
	if (image_out == 0) {
		WARNING((stderr, "no current image\n"));
		return 0;
	}

	switch (color_index) {
	case gdBrushed:
	case gdStyled:
	case gdStyledBrushed:
		color = color_index;
		break;
	case gdTiled:
		WARNING((stderr,"can't tile a line\n"));
		return 0;
	default:
		if ((color = cmt.map[color_index].color) == -1) {
			color = alloc_color(&cmt.map[color_index], Closest);
			if (color == -1) {
				return 0;
			}
			cmt.map[color_index].color = color;
		}
		break;
	}/* switch */

	gdImageLine(
		image_out,
		param[0],
		param[1],
		param[2],
		param[3],
		color	); 

	return 1;
}/* draw line */


/*
 *	draw_shape
 *
 *	type		- POLYGON or RECTANGLE
 *	color_index	 - line color 
 *
 *	RETURNS
 *	1	Success
 *	0	Failure
 */

int
draw_shape(
	int	shape,
	int	color_index,
	int	filled	)
{
	switch (shape) {
	case POLYGON:
		draw_polygon(color_index, filled);
		break;
	case RECTANGLE:
		draw_rectangle(color_index, filled);
		break;
	}/* switch */

	pindex=0;
}/* draw_shape */


/*
 *	draw_lines
 *
 *	type		- ARC or LINE
 *	color_index	 - line color 
 *
 *	RETURNS
 *	1	Success
 *	0	Failure
 */

int
draw_lines(
	int	type,
	int	color_index	)
{
	switch (type) {
	case LINE:
		draw_line(color_index);
		break;
	case ARC:
		draw_arc(color_index);
		break;
	}/* switch */

	pindex=0;
}/* draw_lines */


/*
 *	draw_rectangle
 *
 *	Draws a rectangle.  Corners are passed globally in param array.
 *
 *	color_index	Border color
 *	style		0	- none
 *			1	- Filled
 *
 *	RETURNS
 *	1	Success
 *	0	Failure
 */

int
draw_rectangle(
	int	color_index,
	int	style)
{
	int color;

	if (color_index == -1) {
		return 0;
	}
	if (image_out == 0) {
		WARNING((stderr, "no current image\n"));
		return 0;
	} 
	if (pindex != 4) {
		WARNING((stderr, "Rectangle needs 2 sets of coordinates\n"));
		return 0;
	}

	switch (color_index) {
	case gdBrushed:
	case gdStyled:
	case gdTiled:
	case gdStyledBrushed:
		color = color_index;
		break;
	default:
		if ((color = cmt.map[color_index].color) == -1) {
			color = alloc_color(&cmt.map[color_index], Closest);
			if (color == -1) {
				return 0;
			}
			cmt.map[color_index].color = color;
		}
		break;
	}/* switch */

	if (style) {
		gdImageFilledRectangle(
			image_out,
			param[0],
			param[1],
			param[2],
			param[3],
			color );
	} else {
		gdImageRectangle(
			image_out,
			param[0],
			param[1],
			param[2],
			param[3],
			color );
	}

	return 1;
}/* draw rectangle */


/*
 *	draw arc
 *
 *	Draws a partial ellipse centered on x,y with the specified height
 *	width.  The arc begins at degree start and ends at end.  The line
 *	is drawn in the specified color.
 *
 *	PARAMETERS
 *	x,y		center
 *	width,height	size
 *	start,end	length
 *	color_index	color
 *
 *	RETURNS
 *	1	Success
 *	0	Failure
 */

int
draw_arc(int	color_index	)

{
	int color;

	if (pindex != 6) {
		WARNING((stderr, "An arc needs 6 pieces of data\n"));
		return 0;
	}
	if (color_index == -1) {
		return 0;
	}
	if (image_out == 0) {
		WARNING((stderr, "no current image\n"));
		return 0;
	} 
	switch (color_index) {
	case gdBrushed:
	case gdStyled:
	case gdStyledBrushed:
		color = color_index;
		break;
	case gdTiled:
		WARNING((stderr,"can't tile a line\n"));
		return 0;
	default:
		if ((color = cmt.map[color_index].color) == -1) {
			color = alloc_color(&cmt.map[color_index], Closest);
			if (color == -1) {
				return 0;
			}
			cmt.map[color_index].color = color;
		}

		break;
	}/* switch */

	gdImageArc(
		image_out,
		param[0],
		param[1],
		param[2],
		param[3],
		param[4],
		param[5],
		color	);

	return 1;
}/* draw arc */


/*
/*
 *	image_fill
 *
 *	PARAMETERS
 *	x,y
 *	color_index	color | gdTiled
 *	border_index	color
 *
 *	RETURNS
 *	1	Success
 *	0	Failure
 */

int
image_fill(
	int	x,
	int	y,
	int	color_index,
	int	border_index	)

{
	int	color,
		border;

	if (color_index == -1) {
		return 0;
	}
	if (image_out == 0) {
		WARNING((stderr, "no current image\n"));
		return 0;
	} 

	switch (color_index) {
	case gdTiled:
		if (tile == 0) {
			WARNING((stderr, "no tile set\n"));
			return 0;
		}
		color = gdTiled;
		break;
	default:
		if ((color = cmt.map[color_index].color) == -1) {
			color = alloc_color(&cmt.map[color_index], Closest);
			if (color == -1) {
				return 0;
			}
			cmt.map[color_index].color = color;
		}
		break;
	}/* switch */

	if (border_index != -1) {
		if ((border = cmt.map[border_index].color) == -1) {
			border = alloc_color(&cmt.map[color_index], Closest);
			if (border == -1) {
				return 0;
			}
			cmt.map[color_index].color = border;
		}
	}
	if (border_index == -1) {
		gdImageFill(
			image_out,
			x,
			y,
			color);
	} else {
		gdImageFillToBorder(
			image_out,
			x,
			y,
			border,
			color);
	}

	return 1;
}/* image_fill */


/*
 *	draw_polygon
 *
 *	Draw a polygon.  That is, a random closed shape.
 *
 *	color_index	Border color
 *	style		0 - hollow
 *			1 - filled
 *
 *	RETURNS
 *	1	Success
 *	0	Failure
 */

int
draw_polygon(
	int	color_index,
	int	style)
{ 
	int	color;
	gdPoint *Points,
		*p;
	int	points;
	int	i;

	if (color_index == -1) {
		return 0;
	}
	if (image_out == 0) {
		WARNING((stderr, "no current image\n"));
		return 0;
	} 
	if ((pindex % 2) != 0) {
		WARNING((stderr, "unmatched coordinate set\n"));
	}

	Points = (gdPoint *) malloc(sizeof(gdPoint) * (pindex >> 1));

	p = Points;
	i=0;
	while (i < pindex) {
		p->x=param[i++];
		p++->y=param[i++];
	}/* for */

	switch (color_index) {
	case gdBrushed:
	case gdStyled:
	case gdTiled:
	case gdStyledBrushed:
		color = color_index;
		break;
	default:
		if ((color = cmt.map[color_index].color) == -1) {
			color = alloc_color(&cmt.map[color_index], Closest);
			if (color == -1) {
				return 0;
			}
			cmt.map[color_index].color = color;
		}
		break;
	}/* switch */

	if (style) {
		gdImageFilledPolygon(
			image_out,
			Points,
			pindex >> 1,
			color );
	} else {
		gdImagePolygon(
			image_out,
			Points,
			pindex >> 1,
			color );
	}

	free(Points);
}/* draw_polygon */


/*
 *	open_as_gif
 *
 *	RETURNS
 *	Image pointer or
 *	NULL	- failed to open file.
 */

gdImagePtr
open_as_gif(
	char *filename	)
{
	gdImagePtr	im;
	FILE		*fp;

	if ((fp = fopen(filename, "rb")) == NULL) {
		fprintf(stderr, "cannot open input file: %s. %s\n", filename, strerror(errno));
		return NULL;
	} else if ((im = gdImageCreateFromGif(fp)) == NULL) {
		fprintf(stderr, "cannot create image from giffile: %s, errno: %d\n", filename, strerror(errno));
	}
	fclose(fp);


	return im;
}/* open_as_gif */


/*
 *	open_as_xbm
 *
 *	RETURNS
 *	Image pointer or
 *	NULL	- failed to open file.
 */

gdImagePtr
open_as_xbm(
	char *filename	)
{
	gdImagePtr	im;
	FILE		*fp;

	if ((fp = fopen(filename, "rb")) == NULL) {
		fprintf(stderr, "cannot open input file: %s. %s\n", filename, strerror(errno));
		return NULL;
	} else if ((im = gdImageCreateFromXbm(fp)) == NULL) {
		fprintf(stderr, "cannot create image from giffile: %s, errno: %d\n", filename, strerror(errno));
	}
	fclose(fp);

	return im;
}/* open_as_xbm */


/*
 *	save_as_gif
 *
 *	Saves the current image into the file specified by filename.
 *
 *	filename	Gif file name.
 *
 *	RETURNS		1	success
 *			0	failure
 */

int
save_as_gif(
	char	*filename )
{
	FILE		*fp = NULL;

	if (image_out == 0) {
		fprintf(stderr, "cannot save, no current image\n");
		return 0;
	}
	if (filename == NULL) {
		gdImageGif(image_out, stdout);
	} else {
		if ((fp = fopen(filename, "wb")) == NULL) {
			WARNING((stderr, "can't open file %s. %s\n", filename, strerror(errno)));
			return 0;
		}
		/* Write GIF */
		gdImageGif(image_out, fp);
		if (comment) {
/*
 *			Write the comment trailer
 */
			unsigned char len;

			fseek(fp, -1, SEEK_CUR);
			fputs("\041\376",fp);
			len = strlen(comment);
			len = len<256?len:255;
			fwrite((char *) &len,1,1,fp);
			fwrite(comment,len+1,1,fp);
			fputc(';', fp);
		}
		fclose(fp);
	}

	return 1;
}/* save_as_gif */


/*
 *	print_string
 *
 *	RETURNS		1	success
 *			0	failure
 */

int
print_string(
	int	style,
	gdFontPtr	font,
	int	x,
	int	y,
	int	color_index,
	char	*string	)
{
	int color;

	if (image_out == 0) {
		WARNING((stderr, "no current image\n"));
		return 0;
	}

	if ((color = cmt.map[color_index].color) == -1) {
		color = alloc_color(&cmt.map[color_index], Closest);
		if (color == -1) {
			return 0;
		}
		cmt.map[color_index].color = color;
	}

	if (style == 1) {
		gdImageStringUp(
			image_out,
			font,
			x, y,
			string,
			color);
	} else {
		gdImageString(
			image_out,
			font,
			x, y,
			string,
			color);
	}

	return 1;
}/* print */


/*
 * alloc_color
 *
 *	Attempts to allocate the color from the current images color table,
 *	If this fails it allocates a new color.
 *
 *	mapp		gdit color map	
 *	closest		get closest color if map is full.
 *
 *	RETURNS
 *	GIF color index	between 0 and 255
 *		or
 *	-1
 */

int
alloc_color(
	struct color_map *mapp,
	int	closest)
{
	mapp->color = gdImageColorExact(
		image_out,
		mapp->v1,
		mapp->v2,
		mapp->v3 );
	if (mapp->color == -1) {
		mapp->color = gdImageColorAllocate(
			image_out,
			mapp->v1,
			mapp->v2,
			mapp->v3 );
	}
	if (mapp->color == -1 && closest) {
		mapp->color = gdImageColorClosest(
			image_out,
			mapp->v1,
			mapp->v2,
			mapp->v3 );
	}

	return mapp->color;
}/* alloc_color */


/*
 *	Dictionary Functions
 */

/*
 *	NameCmp
 *	Comparison functions for searches.
 *
 *	Returns
 *	0     - Equal
 *	-ve   - Less Than
 *	+ve   - Greater Than
 */


int NameCmp(
    Entry_t	*dictname,
    char	*name	)
{
	return strncmp(dictname->Name, name, NAMELEN);
}


void
init_gdit(int debug)
{
#if YYDEBUG != 0
	yydebug=debug;	/* parser debugging */
#endif
	pindex=0;
	image_out = 0;
	brush = 0;
	tile = 0;
	initDict(&StyleDict, NameCmp);
}/* init_gdit */

void
help_topic(
	int	topic	)
{
	switch(topic) {
	case COMMENT:
		printf("set GIF comment string, max 255 characters\n");
		break;	
	case NEW:
		printf("new width height [color][transparent][interlaced]\n");
		printf("new <filename>.gif\n");
		break;
	case SAVE:
		printf("save <filename>.gif\n");
		break;
	case DELETE:
		printf("delete\n");
		printf("delete brush\n");
		printf("delete tile\n");
		printf("delete style <name>\n");
		printf("delete style all\n");
		printf("delete all\n");
		break;
	case SET:
		printf("set pixel x y <color>\n");
		printf("set transparent [color|index]\n");
		printf("set [closest] <color> <r> <g> <b> <name>\n");
		printf("set closest\n");
		printf("set exact\n");
		printf("set style <name> [count] <color>... [countn] <colorn>\n");
		printf("set brush <filename>.gif\n");
		printf("set tile <filename>.gif\n");
		break;
	case LINE:
		printf("line x1 y1 x2 y2 <color>\n");
		printf("line x1 y1 x2 y2 brushed\n");
		printf("line x1 y1 x2 y2 style <name> [brushed]\n");
		break;
	case POLYGON:
		printf("polygon x1 y1... xn yn <color> [filled]\n");
		printf("polygon x1 y1... xn yn style <name> [brushed][filled]\n");
		printf("polygon x1 y1... xn yn tiled filled\n");
		break;
	case RECTANGLE:
		printf("rectangle x1 y1 x2 y2 <color> [filled]\n");
		printf("rectangle x1 y1 x2 y2 style <name> [brushed][filled]\n");
		printf("rectangle x1 y1 x2 y2 tiled filled\n");
		break;
	case ARC:
		printf("arc x y height width start end <color>\n");
		printf("arc x y height width start end brushed\n");
		printf("arc x y height width start end style name [brushed]\n");
		break;
	case FILL:
		printf("fill x y <color> [<color>]\n");
		break;
	case GET:
		printf("get pixel x y\n");
		printf("get information\n");
		break;
	case PRINT:
		printf("print [up][large|small|giant|medium|tiny] x y <color> \"string\"\n");
		break;
	case HELP:
		printf("help is available on these topics:\n");
		printf("comment\n");
		printf("new\n");
		printf("save\n");
		printf("delete\n");
		printf("set\n");
		printf("line\n");
		printf("polygon\n");
		printf("rectangle\n");
		printf("arc\n");
		printf("fill\n");
		printf("get\n");
		printf("print\n");
		printf("\nplease enter\nhelp <topic>\n");
		break;
	default:
		printf("sorry no help on this topic\n");
		printf("\n\nplease enter\nhelp <topic>\n");
		break;
	}/* switch */
}


int
getfunc(char *ident)
{
	struct idlist fdl[] = {
		"a",		ARC,
		"bye",		QUIT,
		"c",		COMMENT,
		"del",		DELETE,
		"debug_on",	DEBUG_ON,
		"debug_off",	DEBUG_OFF,
		"f",		FILL,
		"g",		GET,
		"h",		HELP,
		"l",		LINE,
		"n",		NEW,
		"po",		POLYGON,
		"pr",		PRINT,
		"q",		QUIT,
		"r",		RECTANGLE,
		"s",		SAVE,
		"se",		SET,
		"set",		SET
	};

	return getid(ident, fdl, sizeof(fdl)/(sizeof(char *)+sizeof(int)));
}

int
getparam(char *ident)
{
	struct idlist pdl[] = {
		"al",		ALL,
		"bru",		BRUSH,
		"clos",		CLOSEST,
		"col",		COLOR,
		"ex",		EXACT,
		"fille",	FILLED,
		"giant",	GIANT,
		"inf",		INFO,
		"inter", 	INTERLACED,
		"lar",		BIG,
		"med",		MB,
		"pix",		PIXEL,
		"sma",		SMALL,
		"sty",		STYLE,
		"tile",		TILE,
		"tiled",	TILED,
		"tiny",		TINY,
		"tran",		TRANSPARENT,
		"up",		UP
	};

	return getid(ident, pdl, sizeof(pdl)/(sizeof(char *)+sizeof(int)));
}

/*
 *	Lex is good at basic tokenisation but can get overloaded, hence this
 *	routine for sorting out identifiers.
 */

int
getid(char *ident, struct idlist idl[], int size)
{
	int	count,
		cmp,
		len,
		best,
		id;

/*
 *	could make this chop search for speed, list would need to be
 *	ordered.
 */
	id = -1;
	best = 0;
	for (count = 0; count < size; count++) {
		len = strlen(idl[count].name);
		cmp = strncmp(idl[count].name, ident, len);
		if (cmp == 0) {
/*
 *			Try for a longer match
 */
			if (id != -1) {
				if (best < len) {
					id = idl[count].id;
					best = len;
				}
			} else {	/* first match */
				id = idl[count].id;
				best = len;
			}
		} else if (id != -1) {
			break;
		}	
	}/* for */

	return id;
}
#include "lex.yy.c"
