/*
 *	gdit.h
 */

extern int silent;
extern int prompt;
/*
 *  Macros
 */
#define MACRO_BEGIN do{
#define MACRO_END   }while(0);

#define WARNING(s)						\
	MACRO_BEGIN						\
		if (!silent) {					\
			fprintf s;				\
	}							\
	MACRO_END


/*
 *	Constants
 */
#define NAMELEN		 16
#define MAXSTYLE	 16
#define MAXPARAM	256

/*
 *	Image styles
 */
#define	TP	1
#define IL	2
#define FL	4

/*
 *	Predefined colors structure
 */

struct	predefined_colors {
	char	name[NAMELEN];
	int	v1, v2, v3;
};
	
/*
 *	Color map structure:
 *		16 character color name
 *		RGB values
 *		GIF color index.
 *		maximum number of user colors.
 */

struct	color_map {
	char name[NAMELEN];
	int	v1, v2, v3;
	int	color;	/* color index */
	int	max_colors;
};


/*
 *	color map table
 */

struct color_map_table {
	int	count;		/* number of colors allocated */
	struct color_map map[gdMaxColors];
};

/*
 *	Line style.
 */

typedef struct {
	int	count;
	char	color[NAMELEN];
} El_t;
	
typedef struct {
	Node_t	iNode;
	char	Name[NAMELEN];	/* Primary Key */
	El_t	*pStyle;
	int	count;		/* number of element in style */
	int	total;		/* total colors */
} Entry_t;


/*
 *	Prototypes
 */
int new_image(int height, int width, int color_index, int style);
int save_as_gif( char *filename);


gdImagePtr open_as_gif(char *filename);
gdImagePtr open_as_xbm(char *filename);
int NameCmp( Entry_t *dictname, char *name);
void del_all_styles();
void delete_all();
int set_pixel(int x, int y, int color_index);
int define_color(int r, int g, int b, char *name, int closest);
int alloc_color(struct color_map *mapp, int closest);
void help_topic(int topic);
void init_gdit(int debug);
