#!/usr/local/bin/perl
#
# Perl script to produce a graph of the top five memory users
#
$height = 200;
$width = 150;
$yaxis = 35;
$xaxis = $height - 45;

open(GD, "| /home/www/cgi-bin/gdit") || die "can't run gdit: $!";
printf(GD "n %d %d light_gray t i\n", $width, $height); 
#
# title and axis
#
printf(GD "l %d 25 %d 25 red\n", $width-97, $width-6);
printf(GD "p large %d 10 black \"Memory Hogs\"\n", $width-95);
printf(GD "l 0 %d %d %d black\n", $xaxis+1, $height, $xaxis+1);
printf(GD "l %d %d %d 0 black\n", ($yaxis-5), $height, ($yaxis - 5));
#
# Initialise top five list
#
$top=0;
while ($top++ < 5) {
	$hoglist[$top] = 0;
}

#
#	ps command BSD Syntax
#
open(PS, "ps -aux|");
$title = PS;
eval <<'EOF';
while ($cand = <PS>) {
	chop($cand);
	@psarray = split(' ', $cand);
	if ($psarray[1] != -1) {
		$top=0;
		while ($top < 5) {
			if ( $psarray[3] > $hoglist[$top] ) {
				$hoglist[$top] = $psarray[3];
				$top = 5;
			}
			$top++;
		}
	}
}
EOF

$index=0;
$scale = (($height - 50) /  $hoglist[0]);
while ($index < 5) {
	$x = $index * 20;
	printf(GD "r %d %d ", $x+$yaxis, int($xaxis - ($scale * $hoglist[$index])));
	printf(GD "%d, %d blue filled\n", $x+$yaxis+10, $xaxis);
#
#	Fake PID for demonstration purposes.
#
	printf(GD "p up small %d %d red \"%d\"\n", $x+35, $xaxis + 32, rand(32000));
	$index++
}
printf(GD "p small 5 %d black \"%d%%\"\n", int($xaxis - ($scale * $hoglist[0])), $hoglist[$0]);
printf(GD "p up small 5 %d navy_blue \"%% memory\"\n", $xaxis - 20);
printf(GD "p small %d %d aquamarine \"process\"\n", $yaxis+20, $xaxis + 35);
printf "HTTP/1.0 200 ok\n";
printf "MIME-Version: 1.0\n";
printf "Date: Monday, 29-May-95 00:36:49 GMT\n";
printf "Pragma: no-cache\n";
printf "Content-Type: image/gif\n\n";
#
# flush stdout
#
close(STDOUT);
printf(GD "s stdout\n");
printf(GD "q\n");
#
# Wait for GD to compete
#
close (GD);
