
/*

	EXPERIMENTAL: strong type checking for GCOOPE !!!

	July 10, 1994 by Brian Lee Price

	Its not exactly elegant but it is usable to some extent.
	Let me know if it is useful to you.


	if you want to use GCOOPE in a manner compatible with strong
	type checking using the following notations:

	(In the following genName is the name of a generic function)

	The proto-typedef for genName is genName.
	The genfunc index variable for genName is GFgenName.


	The definition for the macro PROTO used to create proto-typedefs
	for generic functions with strong type checking:

*/

#define PROTO(returnValue, genFuncName, passedParms) \
	typedef returnValue (* genFuncName)passedParms

/*

	Suggested declaration style for proto-typedefs:

PROTO(void *, testgen, (object, int, char));

	where testgen is the name of the generic function, and
	the true prototype for it would be:

		void * testgen(object, int, char);



	The following macro is used to call the function dispatcher when
	using strong type checking:

*/

#define G(genFunc) ((genFunc (*)(generic)) g)(GF##genFunc)

/*

	For the same genFunc function named testFunc, strong vs weak
	dispatcher calls would look like:

		... = G(testFunc) ...      strong type checking

		... = g(GFtestFunc) ...	   weak type checking


	This technique works well in most cases, however for Kill and
	Err it should not be used, they should remain weakly type checked.
	The genFunc New presents a special case.  You may use strong
	type casting with New however you should use the name Newclass
	for your proto-typedef function name where class is the name
	of the class, then use the following macro:

*/

#define NEW(className) \
    ((New##className (*)(generic)) g)(New)

/*

	Just remember that your passed parameters must still include
	className as the first parameter and it must be of type object.
	The following is a functional example of the necessary
	proto-typedef that declares a prototype for the genfunction
	New with the first parameter Class:

PROTO(object, NewClass, (object, int, int,...));



	proto-typedefs may only be declared once, unlike true prototypes,
	duplicate proto-typedefs will cause an error even if exactly the
	same.  Therefore if you intend to use proto-typedefs you should
	maintain a separate header file containing the proto-typedefs
	for all generic functions.


	    If you desire to use strong type checking for a generic
	function whose methods take different types and numbers of
	parameters, you may be able to get away with something like
	that suggested for the genFunc New, however it is doubtful.
	New is a special case because you know what class you will be
	dispatching to, many times you won't be entirely sure.

*/

