
/*

	StdStream object class definition for GCOOPE 1.0

	This class is for stream interface to standard ANSI-C streams

	  released as PUBLIC DOMAIN 4/25/94 modified for GCOOPE 7/21/94

*/


#define CLASS StdStream

#include "gcoope10.h"
#include "stream.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

object CLASS;
extern object String;

typedef struct {
	FILE *		stream;
	unsigned	flags;
	 } instVars;


USEGEN(getPos);
USEGEN(setPos);
USEGEN(Putc);
USEGEN(Getc);
USEGEN(UnGet);
USEGEN(Puts);
USEGEN(Gets);
USEGEN(Write);
USEGEN(Read);
USEGEN(SetBuf);
USEGEN(Flush);
USEGEN(clrErr);
USEGEN(Stat);
USEGEN(addressOf);
USEGEN(asString);

cmethod object m4New(object instance, FILE * fStream)
{
instVars * ivptr;

if(NULL==(ivptr=makeInst(&instance))) return 0;
ivptr->flags=0;
ivptr->stream=fStream;
return instance;
}


imethod object m4SetBuf(object instance,char * buffer, int type,
							word size)
{
return setvbuf(((instVars *) getIVptr(instance))->stream,buffer,type,size);
}


imethod object m4Flush(object instance)
{
return fflush(((instVars *) getIVptr(instance))->stream);
}



imethod long m4getPos(object instance)
{
return ftell(((instVars *) getIVptr(instance))->stream);
}



imethod object m4setPos(object instance, long newPos, int whence)
{
instVars * ivptr;

if(NULL==(ivptr=getIVptr(instance))) return FUNCFAIL;
if(newPos==0 && whence==SEEK_SET)
    {
    rewind(ivptr->stream);
    return FUNCOKAY;
    }
return fseek(ivptr->stream,newPos,whence);
}


imethod object m4clrErr(object instance)
{
clearerr(((instVars *) getIVptr(instance))->stream);
return FUNCOKAY;
}


imethod object m4Stat(object instance)
{
instVars * ivptr;

if(NULL==(ivptr=getIVptr(instance))) return EOF;
ivptr->flags|=(feof(ivptr->stream))?S_EOS:0;
ivptr->flags|=(ferror(ivptr->stream))?S_ERR:0;
return (object) (ivptr->flags);
}


imethod int m4Putc(object instance, char c)
{
return putc(c,((instVars *) getIVptr(instance))->stream);
}


imethod int m4Getc(object instance)
{
return getc(((instVars *) getIVptr(instance))->stream);
}



imethod int m4UnGet(object instance, char c)
{
return ungetc(c,((instVars *) getIVptr(instance))->stream);
}



imethod object m4Puts(object instance, object dataObj)
{
return (fputs(((VDPTRRV) g)(GEN(addressOf))(g(GEN(asString))(dataObj)),
    ((instVars *) getIVptr(instance))->stream)==EOF)?FUNCFAIL:FUNCOKAY;
}


imethod object m4Gets(object instance, int max)
{
char * d;
object rv;

d=s_malloc(max);
rv=(fgets(d,max,((instVars *) getIVptr(instance))->stream)==NULL)?END:
    g(New)(String,d);
s_free(d);
return rv;
}


imethod int m4Write(object instance, const char * ptr, word size,
								word n)
{
return fwrite(ptr,size,n,((instVars *) getIVptr(instance))->stream);
}


imethod int m4Read(object instance, char * ptr, word size, word n)
{
return fread(ptr,size,n,((instVars *) getIVptr(instance))->stream);
}


imethod void * m4addressOf(object instance)
{
return ((instVars *) getIVptr(instance))->stream;
}


CLASS_INSTALL
{
if(END==(CLASS=g(New)(Class, 0, sizeof(instVars),END))
    || addGMthd(CLASS, New, (method) m4New)
    || ADDGM(getPos) || ADDGM(setPos) || ADDGM(Putc) || ADDGM(Getc)
    || ADDGM(UnGet) || ADDGM(Puts) || ADDGM(Gets) || ADDGM(Write)
    || ADDGM(Read) || ADDGM(SetBuf) || ADDGM(Flush) || ADDGM(clrErr)
    || ADDGM(Stat) || ADDGM(addressOf)) return FUNCFAIL;
else return FUNCOKAY;
}
