/*


	GCOOPE version 1.0 external header file

		by Brian Lee Price

	Released as Public Domain  July, 1994.

*/

#ifndef _INTERNAL_
#define _EXTERNAL_
#endif

#include "gcstruct.h"

/* the following should always be used for method definition headers */

#define cmethod static
#define imethod static

#ifdef __STRONG_TYPING__

  #include "typing.h"

  /*
	Note: if strong typing is desired you should have a header file
	named generics.h with the proto-typedefs in it, it will be
	automatically included here when __STRONG_TYPING__ is defined.

	See "typing.h" for more info.
  */

  #include "generics.h"

#endif


/*

	NOTE: where the name of a generic function is:
	       symbolName

	    If you are using strong typing;

	    The variable referred to for generic functions
	    is GFsymbolName and the proto-typedef is symbolName.
	    See typing.h for further information.


	You are free, of course, to adopt your own standards in
	this regard.  Doing so will prevent use of most macros
	defined here.

*/


/*
	macro to name and declare installation routine.

	NOTE: the installation routine should return an stat value

	FUNCOKAY or FUNCFAIL.

*/

#define CONCAT(parm1,parm2) parm1##parm2

#define CLASS_INSTALL stat CONCAT(CLASS,_Install)(void)

#define INSTALL_CLASS(className) if(className##_Install()) goto err;


#ifdef __STRONG_TYPING__

  #define USEGEN(genFunc) extern generic GF##genFunc
  #define MAKEGEN(genFunc) generic GF##genFunc
  #define GEN(genFunc) GF##genFunc
  #define INSTGEN(genFunc) \
      if(MAX_GEN==(GF##genFunc=addGeneric((method) 0L))) goto err;

#else

  #define USEGEN(genFunc) extern generic genFunc
  #define MAKEGEN(genFunc) generic genFunc
  #define GEN(genFunc) genFunc
  #define INSTGEN(genFunc) \
      if(MAX_GEN==(genFunc=addGeneric((method) 0L))) goto err;

#endif

/* the following typedefs should be used when returning a float/double/ld */

typedef float (*floatMethod)(object,...);
typedef floatMethod (*floatRetVal)(generic);

#define FLTRV floatRetVal

typedef double (*doubleMethod)(object,...);
typedef doubleMethod (*doubleRetVal)(generic);

#define DBLRV doubleRetVal

typedef long double (*longDblMethod)(object,...);
typedef longDblMethod (*longDblRetVal)(generic);

#define LDBLRV longDblRetVal

/*

    example:

    float x;
    ....
    x=((floatRetVal) g)(valueOf)(floatObject);

	This allows the compiler to correctly deal with floating point,
    double precision, and long double type return values.


    NOTE: these are designed for use seperately from the strong typing
    option.  Although if you use the GEN macro you should be okay.

*/


/* in the same vein here are typedefs for common return types */

typedef char (*charMethod)(object,...);
typedef charMethod (*charRetVal)(generic);

#define CHRRV charRetVal

typedef byte (*byteMethod)(object,...);
typedef byteMethod (*byteRetVal)(generic);

#define BYTRV byteRetVal

typedef int (*intMethod)(object,...);
typedef intMethod (*intRetVal)(generic);

#define INTRV intRetVal

typedef short (*shortMethod)(object,...);
typedef shortMethod (*shortRetVal)(generic);

#define SHRTRV shortRetVal

typedef long (*longMethod)(object,...);
typedef longMethod (*longRetVal)(generic);

#define LNGRV longRetVal

typedef void * (*voidPtrMethod)(object,...);
typedef voidPtrMethod (*voidPtrRetVal)(generic);

#define VDPTRRV voidPtrRetVal

typedef unsigned short (*unsignedMethod)(object,...);
typedef unsignedMethod (*unsignedRetVal)(generic);

#define UNSGNDRV unsignedRetVal
#define WRDRV unsignedRetVal


/*
NOTE: normally you can safely use type object to return status info,
	ie. FUNCFAIL / FUNCOKAY.

*/


/*
    the following macros will assist method declarations as long as you
    use the name m4genFunc for a generic named genFunc.  (Also, when
    using the following do not preface genFunc with GF).
*/


#define ADDGM(genFunc) \
addGMthd(CLASS,GEN(genFunc),(method) CONCAT(m4,genFunc))

#define RMVGM(genFunc) \
rmvGMthd(CLASS,GEN(genFunc))

#define RENGM(oldGenFunc,oldClass,newGenFunc) \
cpyGMas(CLASS,GEN(newGenFunc),oldClass, GEN(oldGenFunc))

/*
    as long as you always give the first parameter in a method the name
    instance, instead of steer(ClassName, instance) you can use:
*/

#define ST(className) steer(className, instance)


/*
    some assistance macros for instance and class variable access.

*/

#define IVPTR ((instVar *) getIVptr(instance))

#define DECLAREIV instVars * ivptr

#define GETIVPTR(errRet) if(NULL==(ivptr=getIVptr(instance))) return errRet

#define DECLARECV classVars * cvptr

#define CVPTR ((classVars *) getCVptr(CLASS))

#define GETCVPTR(errRet) if(NULL==(cvptr=getCVptr(CLASS))) return errRet


/* finally, include the gcinit.h header file if not a class definition */

#ifndef CLASS
#include "gcinit.h"
#endif