/*

	Array class definition for GCOOPE 1.0

	Compatible with experimental strong typing option.

	Designed 7/21/94 by Brian L. Price

	Released as Public Domain  July, 1994.

	note: the type word is a synonym for unsigned short int

*/


#define CLASS Array

#include "gcoope10.h"
#include <mem.h>
#include <stdio.h>

object CLASS;

extern object Dynmem;

typedef struct {
	word	elemSize,
		numElems;
		} instVars;

USEGEN(addressOf);
USEGEN(reSize);
USEGEN(getElem);
USEGEN(putElem);
USEGEN(sizeOf);
USEGEN(numElems);

cmethod object m4New(object instance, word elemSize, word numElems)
{
instVars * ivptr;

if(NULL==(ivptr=makeInst(&instance))) return 0;
ivptr->elemSize=elemSize;
ivptr->numElems=numElems;
g(New)(ST(Dynmem), ivptr->elemSize * ivptr->numElems);

return instance;
}


imethod object m4reSize(object instance, word newNumElems)
{
instVars * ivptr;

if(NULL==(ivptr=getIVptr(instance))) return FUNCFAIL;
ivptr->numElems=newNumElems;
return g(GEN(reSize))(ST(Dynmem), ivptr->elemSize * newNumElems);
}


imethod object m4putElem(object instance, word elemNdx, void * newElem)
{
instVars * ivptr;

if(NULL==(ivptr=getIVptr(instance))
    || ivptr->numElems <= elemNdx || NULL==newElem) return FUNCFAIL;
memcpy(((char *) g(GEN(addressOf))(instance))
    + elemNdx * ivptr->elemSize, newElem, ivptr->elemSize);
return FUNCOKAY;
}


imethod void * m4getElem(object instance, word elemNdx)
{
instVars * ivptr;

if(NULL==(ivptr=getIVptr(instance)) || ivptr->numElems <= elemNdx)
    return NULL;
return ((char *) g(GEN(addressOf))(instance))+ elemNdx * ivptr->elemSize;
}


imethod word m4sizeOf(object instance)
{
return ((instVars *) getIVptr(instance))->elemSize;
}


imethod word m4numElems(object instance)
{
return ((instVars *) getIVptr(instance))->numElems;
}


CLASS_INSTALL
{
if(END==(CLASS=g(New)(Class, 0, sizeof(instVars), Dynmem, END))
    || addGMthd(CLASS,New,(method) m4New) || ADDGM(reSize)
    || ADDGM(putElem) || ADDGM(getElem) || ADDGM(sizeOf)
    || ADDGM(numElems)) return FUNCFAIL;
else return FUNCOKAY;
}

