REM @Echo Off
REM This file is extensively commented so you can see what's going on.
REM These comments are parsed by DOS when executing this file and 
REM will significantly slow down the UPCHECK processing.  If you're 
REM going to use this UPCHECK.BAT, make a copy and delete all the REM
REM statements and blank lines.
REM
REM This UPCHECK.BAT makes use of GAPECHO, a freebie utility written
REM by Bob Naken for communicating with the user from batch files
REM such as this one.  If you don't have GAPECHO, it should be 
REM available from The Crow's Nest.
REM
REM It is IMPERATIVE(!!!) that you have environment variables defined
REM for C_PORT and TEST_DIR.  C_PORT is the comm port in use on this 
REM node.  
REM 
REM TEST_DIR is just a temp directory where archives can be unzipped 
REM and scanned.  Any empty directory will do, but you MUST have one 
REM defined.  The UPCHECK process will immediately abort if the TEST_DIR 
REM does not exist.  You need to have the trailing '\' on the path.  The 
REM SET statement in my autoexec.bat is:
REM
REM             SET TEST_DIR=C:\GAP\UP\WORK1\TEST\
REM
REM Be sure to create this directory before attempting to run this file.
REM
REM GAP passes the following parameters to this batch file.
REM
REM             %1  -  Full path and name of file
REM             %2  -  Upload Directory path
REM             %3  -  Filename
REM             %4  -  Filename without the extension
REM             %5  -  Extension without the filename
REM             %6  -  0 = Remote Caller On, 1 = Sysop On Locally,
REM                    2 = Local User

REM Initialize the variables used in UPCHECK.BAT

    set old_date=800101
    set new_date=910101

REM Tell the user what we're doing

    GAPECHO %C_PORT%Testing Upload(s) for File Integrity...

REM Turn on HyperDisk Staged writes to speed up the check.
REM (If you don't use HyperDisk, just eliminate this line.)

    hyperdk S OR 

REM Verify that the TEST_DIR actually exists 

    if ##%TEST_DIR% == ## goto Abort

REM Branch according to the file extension.

    If %5 == LZH Goto LZH
    If %5 == GIF Goto GIF
    If %5 == TXT Goto TXT
    If %5 == DOC Goto TXT
    If %5 == ZIP Goto ZIP
    If %5 == ARJ Goto ARJ
    If %5 == ARC Goto ARC
    If %5 == EXE Goto EXE
    If %5 == COM Goto EXE
    If %5 == PAK Goto ARC
    if %5 == ZOM Goto Nosupport
    if %5 == DMS Goto Nosupport
    if %5 == WRP Goto Nosupport
    if %5 == LWP Goto Nosupport
    if %5 == ZOO Goto Nosupport 
    Goto Unknown


REM  Process EXE files.

:EXE

REM Check for self extracting file.

    GAPECHO %C_PORT%#Checking for self-extracting file. Please wait...
    Pkunzip -t %1
    If Errorlevel 1 goto isLZH
    Goto ZIP

:isLZH

    Lharc t /v %1
    If Errorlevel 1 goto isARC
    Goto LZH

:isARC

    pak t %1
    If Errorlevel 1 goto isEXE
    Goto ARC

:isEXE

REM The user has sent a regular .EXE file. (Bad user!)  Let's copy
REM it to the TEST_DIR, scan it for viruses, and then ZIP it up.

    GAPECHO %C_PORT%##File is not self-extracting!  Next time please
    GAPECHO %C_PORT%#Zip the file before sending.#
    Copy %1 %TEST_DIR%
    Scan /A %TEST_DIR%*.* /D /NOMEM
    If Errorlevel 1 Goto Bad
    GAPECHO %C_PORT%#No Viruses Detected.... Now Zipping File....
    Pkzip %2\%4 %TEST_DIR%*.*
    Erase %1 > nul
    Goto Comment

REM Process ARC files
    	
:ARC

    Pkunpak -t %1
    If Errorlevel 1 Goto Bad
    GAPECHO %C_PORT% File Integrity Ok#Now Checking for Viruses...
    Pkunpak %1 %TEST_DIR%
    scan /A %TEST_DIR%*.* /D /NOMEM
    If Errorlevel 1 Goto Bad
    GAPECHO %C_PORT%  No Viruses Detected#Now Checking File Dates...
    GAPwRAP /f /r %TEST_DIR% %2 %old_date% %new_date%
    if errorlevel 1 goto Too_Old

REM The contents of the ARC file are OK.  Let's ZIP them up and get
REM rid of the original file.

:A_ZIP

    GAPECHO %C_PORT%  File dates OK#Converting to ZIP Archive...
    Pkzip -m %2\%4 %TEST_DIR%*.*
    Erase %1 > nul
    GAPECHO %C_PORT%Files Converted#
    Goto Comment

REM Process ZIP file

:ZIP

    Pkunzip -t %1 > Fail.Txt
    If Errorlevel 1 Goto Bad
    GAPECHO %C_PORT%  File Integrity Ok#Now Checking for Viruses...
    Del Fail.Txt  > nul
    Pkunzip -o %1 %TEST_DIR%
    scan /A %TEST_DIR%*.* /D /NOMEM
    If Errorlevel 1 Goto Bad
    GAPECHO %C_PORT%  No Viruses Detected!#Now Checking File Dates...
    GAPwRAP /f /r /d %TEST_DIR% %2 %old_date% %new_date%
    if errorlevel 1 goto Too_Old
    Goto Comment

REM Process ARJ file

:ARJ

    ARJ t %1 > Fail.Txt
    If errorlevel 1 goto Bad
    GAPECHO %C_PORT%  File Integrity OK#Now Checking for Viruses...
    Del Fail.txt > nul
    ARJ e %1 %TEST_DIR%
    scan /A %TEST_DIR%*.* /D /NOMEM
    If errorlevel 1 Goto Bad
    GAPECHO %C_PORT%  No Viruses Detected#Now Checking File Dates...
    GAPwRAP /f /r %TEST_DIR% %2 %old_date% %new_date%
    if errorlevel 1 goto Too_Old

REM The contents of the ARJ file are OK.  Let's ZIP them up and get
REM rid of the original file.

:ARJ_ZIP

    GAPECHO %C_PORT%Files Dates are OK#Converting to ZIP Archive...
    Pkzip %2\%4 %TEST_DIR%*.*
    Erase %1 > nul
    GAPECHO %C_PORT%Files Converted#
    Goto Comment

REM Process .TXT file

:TXT

    GAPECHO %C_PORT%#Thank You for the Text File!
    Copy %1 %TEST_DIR%
    Pkzip %2\%4 %TEST_DIR%*.*
    Erase %1 > nul
    GAPECHO %C_PORT%#Now Zipping file to save storage space.
    GAPECHO %C_PORT%#Next time please Zip the file before sending.
    Goto Comment

REM Choosy perverts choose GIF!

:GIF

    GAPECHO %C_PORT%#Thank You for the GIF File!
    Goto Good

REM Process LZH file

:LZH

    Lharc t /v %1
    If Errorlevel 1 Goto Bad
    GAPECHO %C_PORT%  File Integrity Ok#Now Checking for Viruses...
    Lharc x %1 %TEST_DIR%
    scan /A %TEST_DIR%*.* /D /NOMEM
    If Errorlevel 1 Goto Bad
    GAPECHO %C_PORT%  No Viruses Detected#Now Checking File Dates...
    GAPwRAP /f /r %TEST_DIR% %2 %old_date% %new_date%
    if errorlevel 1 goto Too_Old
    GAPECHO %C_PORT%  Files Dates are OK#Now Converting to ZIP Archive...

REM The contents of the LZH file are OK.  Let's ZIP them up and get
REM rid of the original file.

:L_ZIP

    Pkzip %2\%4 %TEST_DIR%*.*
    Erase %1 > nul
    GAPECHO %C_PORT%  Files Converted#
    Goto Comment

REM I don't know WHAT this thing is!

:Unknown

    Copy %1 l:\bad_ups
    Del %1 > nul
    GAPECHO %C_PORT%#I Don't Recognize This File Type!
    GAPECHO %C_PORT%#The Sysop Will Examine It Before Posting for Download.
    Goto End

REM The file failed one of the validity checks.  Send it to the 
REM bad file graveyard and tell the user about it.

:Bad

    Copy %1 l:\bad_ups
    Del %1 > nul
    GAPECHO %C_PORT%#Errors Detected In This File!
    GAPECHO %C_PORT%#Please Check Your Copy for Validity/Viruses!
    Goto End

REM The file failed the date checks done by GAPwRAP.  Send it to the
REM bad file graveyard and tell the user about it.
REM You'll probably want to adjust this message to the date standards
REM you want to enforce.

:Too_Old

    Copy %1 l:\bad_ups
    Del %1 > nul
    GAPECHO %C_PORT%#  Files Too Old!
    GAPECHO %C_PORT%#All uploaded files must be less than two years old.
    GAPECHO %C_PORT%#Moving file to offline area for review prior to posting.
    Goto End

REM Add the BBS ad to the ZIP as a comment

:Comment

    Pkzip -z %2\%4 < c:\GAP\gen\zip.scr
    Goto Good

REM It's a good file!

:Good

    GAPECHO %C_PORT%  File Passed Integrity/Virus Check!#

REM Files.lst is the "raw" file listing created by GAP_LIST that I use
REM with HS/Link to check for duplicate uploads.  By echoing the name
REM of the newly uploaded file to the end of files.lst, the list will
REM be kept current at all times.

    echo %3 >> i:\gap\files\files.lst
    Goto End

REM The user has uploaded a file that UPCHECK.BAT does not support.

:Nosupport

    GAPECHO %C_PORT%#Virus check not performed.  This file type is not 
    GAPECHO %C_PORT%#supported by The Cookie Jar.
    Goto End

:End

REM Go back to write-through HyperDisk caching.  Remove this line if you
REM don't use HyperDisk.

    hyperdk W OR

:Abort
