''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Game Keys Keyboard Handler for PowerBASIC
' Copyright (c) 1996 by Dave Navarro, Jr.  All Rights Reserved.
'
' This .OBJ allows PowerBASIC programmers to get the state of any key on
' the keyboard.  Even better, if a key is held down it will NOT fill up your
' keyboard buffer and make that annoying beeping sound.
'
' While GameKeysOn() is active all other keyboard routines (INKEY$, INPUT,
' INPUT(), INSTAT, etc..) are disabled.
'
' If you call GameKeysOn() while game keys are already turned on, it will
' clear the state of all keys.
'
' I am releasing this sample code and binary object file (.OBJ) as Freeware.
' Feel free to use them in you own programs without requirement of any
' payment to the author.
'
' If you have any questions or suggestions, I can be reached via Internet
' email at:  dave@powerbasic.com
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

$LINK "GAMEKEY.OBJ"

DECLARE SUB GameKeysOn()  'turn on Game Keys
DECLARE SUB GameKeysOff() 'turn off Game Keys
DECLARE FUNCTION GetKeyState(BYVAL WhichKey AS INTEGER) AS INTEGER

%K_A           = &H1E
%K_B           = &H30
%K_C           = &H2E
%K_D           = &H20
%K_E           = &H12
%K_F           = &H21
%K_G           = &H22
%K_H           = &H23
%K_I           = &H17
%K_J           = &H24
%K_K           = &H25
%K_L           = &H26
%K_M           = &H32
%K_N           = &H31
%K_O           = &H18
%K_P           = &H19
%K_Q           = &H10
%K_R           = &H13
%K_S           = &H1F
%K_T           = &H14
%K_U           = &H16
%K_V           = &H2F
%K_W           = &H11
%K_X           = &H2D
%K_Y           = &H15
%K_Z           = &H2C
%K_1           = &H02
%K_2           = &H03
%K_3           = &H04
%K_4           = &H05
%K_5           = &H06
%K_6           = &H07
%K_7           = &H08
%K_8           = &H09
%K_9           = &H0A
%K_0           = &H0B
%K_DASH        = &H0C    ' -_
%K_EQUAL       = &H0D    ' =+
%K_LBRACKET    = &H1A    ' [{
%K_RBRACKET    = &H1B    ' ]}
%K_SEMICOLON   = &H27    ' ;:
%K_RQUOTE      = &H28    ' '"
%K_LQUOTE      = &H29    ' `~
%K_PERIOD      = &H33    ' .>
%K_COMMA       = &H34    ' ,<
%K_SLASH       = &H35    ' /?
%K_BACKSLASH   = &H2B    ' \|
%K_F1          = &H3B
%K_F2          = &H3C
%K_F3          = &H3D
%K_F4          = &H3E
%K_F5          = &H3F
%K_F6          = &H40
%K_F7          = &H41
%K_F8          = &H42
%K_F9          = &H43
%K_F10         = &H44
%K_ESC         = &H01
%K_BACKSPACE   = &H0E
%K_TAB         = &H0F
%K_ENTER       = &H1C
%K_CONTROL     = &H1D
%K_LSHIFT      = &H2A
%K_RSHIFT      = &H36
%K_PRTSC       = &H37
%K_ALT         = &H38
%K_SPACE       = &H39
%K_CAPSLOCK    = &H3A
%K_NUMLOCK     = &H45
%K_SCROLLLOCK  = &H46
%K_HOME        = &H47
%K_UP          = &H48
%K_PGUP        = &H49
%K_MINUS       = &H4A
%K_LEFT        = &H4B
%K_CENTER      = &H4C
%K_RIGHT       = &H4D
%K_PLUS        = &H4E
%K_END         = &H4F
%K_DOWN        = &H50
%K_PGDOWN      = &H51
%K_INS         = &H52
%K_DEL         = &H53


CLS

GameKeysOn

DO
  LOCATE 1,1
  IF GetKeyState(%K_LEFT) THEN
    PRINT "  LEFT: ON "
  ELSE
    PRINT "  LEFT: OFF"
  END IF
  IF GetKeyState(%K_RIGHT) THEN
    PRINT " RIGHT: ON "
  ELSE
    PRINT " RIGHT: OFF"
  END IF
  IF GetKeyState(%K_UP) THEN
    PRINT "    UP: ON "
  ELSE
    PRINT "    UP: OFF"
  END IF
  IF GetKeyState(%K_DOWN) THEN
    PRINT "  DOWN: ON "
  ELSE
    PRINT "  DOWN: OFF"
  END IF
  IF GetKeyState(%K_SPACE) THEN
    PRINT "  FIRE: ON "
  ELSE
    PRINT "  FIRE: OFF"
  END IF

LOOP UNTIL GetKeyState(%K_Esc)

GameKeysOff
