//GAME32 scrolling demo

#include "malloc.h"
#include "conio.h"
#include "stdio.h"
#include "stdlib.h"

#include "glib32.h"
#include "keycodes.h"

main()
{
  int a,x=160,y=100,dir=1,screen;
  unsigned char ch;

  //create buffer for cut-out
  unsigned char *bptr=(char *)malloc((63*63)+2);

  //get screen type
  printf("\nPress 1 for VGA, 2 for SVGA\n");
  ch=getch();
  if (ch=='1') screen=0; else screen=1;

  if (screen==0) {if (InitGameLib(320,800)) return(0);}//make buffer 4 VGA screens tall
  else if (InitGameLib(640,960)) return(0);//else make buffer 2 SVGA screens tall

  InitKeyScan();//start up key press scanning

  if (screen==0) SetVGA(); else if (SetSVGA()) quit("SVGA init error");

  //load in the pictures
  if (LoadPic1("backt.pcx",0)) Quit("Error loading PCX");
  if (LoadMBM("32.mbm",1)) Quit("Error loading MBM");

  //cover game buffer with backdrop image
  if (screen==0) {
    PutPic(0,0,0);
    PutPic(0,0,200);
    PutPic(0,0,400);
    PutPic(0,0,600);
  }
  else for(a=0; a<960; a+=200) {PutPic(0,0,a); PutPic(0,320,a);}

  //save backdrop area under foreground sphere
  CutOut(x-32,y-32,63,63,bptr);
  //draw foreground sphere
  PutMBM(1,x-32,y-32);

  a=0;

  //main loop
  do
  {
    //replace saved backdrop area over foreground sphere
    PutBitmap(x-32,y-32,bptr);

    //do movement left/right if relevant key pressed
    if (CheckKey(_RCURS)&&x<280) x+=2;
    if (CheckKey(_LCURS)&&x>40) x-=2;

    //move sphere in y dimension
    if (dir==1) y+=2; else y-=2;

    //reverse direction at top and bottom
    if (screen==0) {
      if (y>700) {y=700; dir=0;}
      else if (y<100) {y=100; dir=1;}
    }
    else {
      if (y>580) {y=580; dir=0;}
      else if (y<100) {y=100; dir=1;}
    }

    //save new backdrop area under foreground sphere
    CutOut(x-32,y-32,63,63,bptr);
    //put foreground sphere
    PutMBM(1,x-32,y-32);

    //display window on buffer, to the screen
    WaitVR(); DisplayBuffer(0,y-100);

    a++;
  }
  while(CheckKey(_ESC)!=1&&a<1000); //while escape key not pressed

  //close down
  FreeMem();
  SetTXT();
  CloseKeyScan();

  return(0);
}
