//Game32 general demo

#include "glib32.h"

//points defining a 2d square
int points[4][2] = {-32,-32, 32,-32, 32,32, -32,32};
//an array to put rotated and translated points in
int rpoints[4][2];
//points defining what area of the texture map image will be used
//(the whole image in this case)
int tpoints[4][2] = {0,0, 63,0, 63,63, 0,63};

void RTSquare(int angle,int x,int y);

int main()
{
  int a,b;

  if (InitGameLib(320,200)) return(0);

  SetVGA();//set VGA mode 13h

  //load in the pictures
  if (LoadPic1("backt.pcx",0)) Quit("Error loading Pcx");//background pic
  if (LoadMBM("test.mbm",1)) Quit("Error loading MBM");//fast MBM masked pic
  if (LoadPic("tm.pcx",2)) Quit("Error loading Pcx");//64x64 texture map
  if (LoadPic("sc.pcx",3)) Quit("Error loading Pcx");//Scale Pcx
  if (LoadPic("plane.pcx",4)) Quit("Error loading Pcx");//Plane Pcx

  if (LoadTXT("text.pcx",0,8,8)) Quit("Error loading Text file");//font image

  //set palette to black (directly)
  for(a=0; a<256; a++) SetColour(a,0,0,0);

  //cover game buffer with backdrop image
  PutPic(0,0,0);
  DisplayBuffer(0,0);

  //fade in to stored palette (as set by LoadPic1() above)
  PFadeUp(8);

  //move masked bitmaps across screen
  for(a=-100; a<420; a++) {
    //draw back
    PutPic(0,0,0);
    //draw masked pics
    PutMBM(1,a,20);
    PutMBM(1,a,100);
    PutMBM(1,260-a,40);
    PutMBM(1,260-a,120);
    PutMBM(1,60,a);
    PutMBM(1,200,a);
    //display the buffer
    WaitVR();//ensures smooth 60fps update
    DisplayBuffer(0,0);
  }

  //fade down to black
  PFadeDown(8);

  ClearBuffer(0); DisplayBuffer(0,0);//clear screen
  SetPal(); //back to stored palette

  //scale up scale-pic
  for(a=50; a>0; a--) {
    PutPicScale(3,160,100,(float)1/a);
    WaitVR(); DisplayBuffer(0,0);
  }
  //scale up scale-pic above 1:1
  for(a=40; a<120; a++) {
    PutPicScale(3,160,100,(float)a/40);
    WaitVR(); DisplayBuffer(0,0);
  }

  //scale pic X/Y independant
  for(a=0; a<60; a++) {
    PutPicScaleXY(3,60-a,0,200+(a*2),200);
    WaitVR(); WaitVR();//halve speed
    DisplayBuffer(0,0);
  }

  //show rotating squares using texture mapping
  for(a=0; a<360; a++) {
    //back
    PutPic(0,0,0);
    //roate and draw square textured polys
    RTSquare(359-a,80,100);
    dtpclip4(rpoints,tpoints,pcxptr[2]);

    RTSquare(a,160,100);
    dtpclip4(rpoints,tpoints,pcxptr[2]);

    RTSquare(359-a,240,100);
    dtpclip4(rpoints,tpoints,pcxptr[2]);
    //display
    WaitVR(); DisplayBuffer(0,0);
  }

  //draw some centred text to the screen over perspective planes
  for(a=0; a<600; a++) {
    draw_ground(a,a,110,pcxptr[4]);
    draw_sky(a+128,a,110,pcxptr[4]);
    PutTXTC(0,"THE GAME32 LIBRARY",255,150);
    WaitVR(); DisplayBuffer(0,0);
  }

  PFadeDown(12);//fade out

  //close down
  FreeMem();
  SetTXT();

  return(0);
}

//rotate and translate square's points using the Rotate() function
void RTSquare(int angle,int x,int y)
{
  int a;

  for(a=0; a<4; a++) {
    Rotate(angle,points[a][0],points[a][1],&rpoints[a][0],&rpoints[a][1]);
    rpoints[a][0]+=x; rpoints[a][1]+=y;
  }
}
