;
;
; Flynn Video Mode coded by:
;
; Written by: John McCarthy (aka Flynn)
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;
; Home phone,(905)831-1944, always willing to talk but don't call at 2 am eh!
;
; Send me a postcard from someplace near where you live.
;
;

custom_modes equ 1

         .386p

DGROUP   GROUP _TEXT
_TEXT    SEGMENT BYTE PUBLIC 'CODE'
         ASSUME CS:_TEXT,DS:DGROUP,ES:DGROUP

         ifdef custom_modes
         include 512.ext
         include xmode.ext
         endif

         public vmode_
         public sync_display_
         public wipeoffpalette_
         public turn_screen_off_
         public turn_screen_on_
         public get_palette_
         public put_palette_
         public clear_memory_

M320x200x256 =0                             ; constants for easy calling
M320x240x256 =1
M360x200x256 =2
M360x240x256 =3
M320x400x256 =4
M320x480x256 =5
M360x400x256 =6
M360x480x256 =7
M360x360x256 =8
M256x240x256 =9                             ; GREAT modes - ypos is upper byte, xpos is lower
M256x200x256 =10
M320x200x256 =11
M512x400x256 =12

attrib_ctrl     equ 03c0h      ; vga attribute controller
gc_index        equ 03ceh      ; vga graphics controller
sc_index        equ 03c4h      ; vga sequencer controller
sc_data         equ 03c5h      ; vga sequencer data port
crtc_index      equ 03d4h      ; vga crt controller
crtc_data       equ 03d5h      ; vga crt controller data
misc_output     equ 03c2h      ; vga misc register
input_1         equ 03dah      ; input status #1 register

dac_write_addr  equ 03c8h      ; vga dac write addr register
dac_read_addr   equ 03c7h      ; vga dac read addr register
pel_data_reg    equ 03c9h      ; vga dac/pel data register r/w

pixel_pan_reg   equ 033h       ; attrib index: pixel pan reg
map_mask        equ 002h       ; sequ index: write map mask reg
read_map        equ 004h       ; gc index: read map register
start_disp_hi   equ 00ch       ; crtc index: display start hi
start_disp_lo   equ 00dh       ; crtc index: display start lo

map_mask_plane1 equ 00102h     ; map register + plane 1
map_mask_plane2 equ 01102h     ; map register + plane 2
all_planes_on   equ 00f02h     ; map register + all bit planes

chain4_off      equ 00604h     ; chain 4 mode off
async_reset     equ 00100h     ; (a)synchronous reset
sequ_restart    equ 00300h     ; sequencer restart

latches_on      equ 00008h     ; bit mask + data from latches
latches_off     equ 0ff08h     ; bit mask + data from cpu

vert_retrace    equ 08h        ; input_1: vertical retrace bit
plane_bits      equ 03h        ; bits 0-1 of xpos = plane #
all_planes      equ 0fh        ; all bit planes selected
char_bits       equ 0fh        ; bits 0-3 of character data

;
; Set BIOS video mode
;

vmode_:
         int 10h
         ret

;
; sync_display_
;

sync_display_:
         push edx eax
         mov edx, input_1                   ; input status #1 register
sy_wait0:
         in al, dx                          ; get vga status
         and al, vert_retrace               ; in display mode yet?
         jnz short sy_wait0                 ; if not, wait for it
sy_wait1:
         in al, dx                          ; get vga status
         and al, vert_retrace               ; vertical retrace start?
         jz short sy_wait1                  ; if not, wait for it

         pop eax edx
         ret

;
; Wipe off palette to common colour.
;
; EBX = reg
; EDI = green
; ESI = blue
; ECX = number of pels to write (max 256)
; EAX = start pel
;
;

wipeoffpalette_:
         pushad
         mov dx,3c8h
         out dx,al
         inc dx
wipeit:
         mov eax,ebx
         out dx,al
         mov eax,esi
         out dx,al
         mov eax,edi
         out dx,al
         loop short wipeit

         popad
         ret

;
; Turn screen off so palette doesn't cause flicker
;

turn_screen_off_:
         push eax edx
         mov dx,03dah                       ; these are used when changing video modes
         in al,dx                           ; to avoid any flicker
         mov dx,03c0h
         mov al,0
         out dx,al
         pop edx eax
         ret

;
; Turn screen back on so user can see nice fancy graphics stuff
;

turn_screen_on_:
         push eax edx
         mov dx,03dah
         in al,dx
         mov dx,03c0h
         mov al,20h
         out dx,al
         pop edx eax
         ret

;
; Get_Palette - get current palette from video card
; In:
;   EDI - destination location
;    AL - start pel
;   ECX - number of pels to get (max 768)
;
; Notes: NOP's allow slow video cards to catch up with fast computers
;

get_palette_:
         push ecx edx eax
         mov edx, dac_read_addr             ; read block of pals
         out dx, al
         mov edx, pel_data_reg
         rep insb
         pop eax edx ecx
         ret

;
; Put_Palette - put new palette to video card
; In:
;   ESI - palette location
;    AL - start pel
;   ECX - number of pels to write (max 256)
;

put_palette_:
         push ecx edx eax
         mov edx, dac_write_addr
         out dx, al
         mov edx, pel_data_reg
         rep outsb
         pop eax edx ecx
         ret

;
; Clear video buffer memory
;
; In:
;  EDI = start location
;  ECX = length
;   AL = value
;
;

clear_memory_:
         mov ah,al
         push ax
         shl eax,16
         pop ax
         shr ecx,1
         pushf
         shr ecx,1
         rep stosd
         adc ecx,ecx
         rep stosw
         popf
         adc ecx,ecx
         rep stosb
         ret

;
; Set custom video mode and copy routine with virtual page flipping.
;
; In:
;  EAX = custom mode
; Out:
;  EAX = number of pages in that mode
;
; M320x200x256 =0                          ; Xmodes
; M320x240x256 =1
; M360x200x256 =2
; M360x240x256 =3
; M320x400x256 =4
; M320x480x256 =5
; M360x400x256 =6
; M360x480x256 =7
; M360x360x256 =8
; M256x240x256 =9                          ; GREAT modes - ypos is upper byte,
; M256x200x256 =10                         ; xpos is lower
; M320x200x256 =11                         ; mode 13h
; M512x400x256 =12                         ; Cirrus Logic only
;
;

         ifdef custom_modes

         public fmode_
         public video_mode_fit_
         public _copy_video_page
         public _flip_video_page
         public _virtual_video_tables
         public _virtual_video_width
         public _virtual_video_height
         public _actual_video_width
         public _actual_video_height
         public _number_of_pages

_actual_video_width  dd 0
_actual_video_height dd 0
_number_of_pages     dd 0
_virtual_video_tables dd 0
_virtual_video_width  dd 0
_virtual_video_height dd 0
_copy_video_page     dd offset ret_
_flip_video_page     dd offset ret_
_xmode_offset        dd 0
_xmode_xor           dd 0                   ; offset to next xmode page if any

fmode_:
         pushad
         mov ebx,_pages[eax*4]
         mov _number_of_pages,ebx
         mov ebx,_flip_addresses[eax*4]
         mov _flip_video_page,ebx
         mov ebx,_copyme[eax*4]
         mov _copy_video_page,ebx
         mov ebx,_xmode_flip[eax*4]
         mov _xmode_xor,ebx
         add ebx,0a0000h
         mov _xmode_offset,ebx
         mov ecx,_xsizes[eax*4]
         mov ebx,_ysizes[eax*4]
         mov _actual_video_width,ecx
         mov _actual_video_height,ebx
         call [_vmodetable+eax*4]
         popad
         mov eax,_number_of_pages
         ret

set_vmode_13h_:
         mov eax,13h
         int 10h
ret_:
         ret

_copyme  dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset xmode_copy_
         dd offset v13hcopy_
         dd offset v512copy_

_vmodetable label dword
         dd offset set_xmode_      ; 0
         dd offset set_xmode_      ; 1
         dd offset set_xmode_      ; 2
         dd offset set_xmode_      ; 3
         dd offset set_xmode_      ; 4
         dd offset set_xmode_      ; 5
         dd offset set_xmode_      ; 6
         dd offset set_xmode_      ; 7
         dd offset set_xmode_      ; 8
         dd offset set_xmode_      ; 9
         dd offset set_xmode_      ; 10
         dd offset set_vmode_13h_  ; 11
         dd offset set_512x400_    ; 12

_xsizes  dd 320 ; 0                  ; xmodes
         dd 320 ; 1
         dd 360 ; 2
         dd 360 ; 3
         dd 320 ; 4
         dd 320 ; 5
         dd 360 ; 6
         dd 360 ; 7
         dd 360 ; 8
         dd 256 ; 9
         dd 256 ; 10
         dd 320 ; 11                 ; flat model modes
         dd 512 ; 12

_ysizes  dd 200
         dd 240
         dd 200
         dd 240
         dd 400
         dd 480
         dd 400
         dd 480
         dd 360
         dd 240
         dd 200
         dd 200
         dd 400

_flip_addresses dd offset xmode_flip_
                dd offset xmode_flip_
                dd offset xmode_flip_
                dd offset xmode_flip_
                dd offset xmode_flip_
                dd offset ret_
                dd offset ret_
                dd offset ret_
                dd offset xmode_flip_
                dd offset xmode_flip_
                dd offset xmode_flip_
                dd offset ret_
                dd offset ret_

_xmode_flip dd 320/4*200*1 ; flip addresses for page flipping, 0 = 1 page only
            dd 320/4*240*1
            dd 360/4*200*1
            dd 360/4*240*1
            dd 320/4*400*1
            dd 320/4*480*0
            dd 360/4*400*0
            dd 360/4*480*0
            dd 360/4*360*1
            dd 256/4*240*1
            dd 256/4*200*1
            dd 0
            dd 0

_pages   dd 2,2,2,2,2,1,1,1,2,2,2,1,1       ; number of video pages for each mode

;
; Copy virtual pages
;
; void (*copy_video_page)(char *buf,int xoffset,int yoffset);
;
; eax = virtual tables (1st = offset to buffer)
; edx = x screen offset
; ebx = y screen offset
;
;

;
; 13h copy
;

v13hcopy_:
         pushad
         mov esi,eax

         cmp _virtual_video_width,320
         je short c13_doflatcopy

         lea edi,[ebx+ebx*4]
         shl edi,6
         lea edi,[0a0000h+edi+edx]

         mov eax,_virtual_video_width
         mov edx,320
         sub edx,eax
         mov ebx,_virtual_video_height

         test al,3
         jnz short c13_notword

         shr eax,2
c13_loop1:
         mov ecx,eax
         rep movsd
         add edi,edx
         dec ebx
         jnz short c13_loop1

         popad
         ret

c13_notword:
         test al,1
         jnz short c13_odd1

         shr eax,2
c13_loop2:
         mov ecx,eax
         rep movsd
         movsw
         add edi,edx
         dec ebx
         jnz short c13_loop2

         popad
         ret
c13_odd1:
         test al,2
         jz short c13_odd2

         shr eax,2
c13_loop3:
         mov ecx,eax
         rep movsd
         movsw
         movsb
         add edi,edx
         dec ebx
         jnz short c13_loop3

         popad
         ret

c13_odd2:
         shr eax,2
c13_loop4:
         mov ecx,eax
         rep movsd
         movsb
         add edi,edx
         dec ebx
         jnz short c13_loop4

         popad
         ret

c13_doflatcopy:
         lea edi,[ebx*4+ebx]
         shl edi,6
         add edi,0a0000h
         mov ecx,_virtual_video_height
         lea ecx,[ecx*4+ecx]
         shl ecx,4
         rep movsd
         popad
         ret

;
; 512x400 copy
;

v512copy_:
         pushad
         mov esi,eax

         cmp _virtual_video_width,512
         je c512_doflatcopy

         mov ebp,_virtual_video_width
         and ebp,3
         mov ebp,c512_routes[ebp*4]
         mov c512_reroute,ebp
         mov ebp,_virtual_video_height
         mov edi,ebx
         shl ebx,5                     ; * 32
         and bh,0f0h
         mov ah,bh
         and edi,07fh
         mov ebx,128
         sub ebx,edi
         shl edi,9                     ; * 512
         add edi,edx
         mov al,09h

c512_next_plane_i:
         push ebp edx
         mov dx,3ceh
         out dx,ax

         add edi,0a0000h

         cmp ebx,128
         jle short c512_oksize
         mov ebx,128
c512_oksize:
         push ebx
         mov edx,_virtual_video_width
         mov ebp,512
         sub ebp,edx
         shr edx,2
         call dword ptr [c512_reroute]
         pop ebx edx ebp
         add ah,16
         mov edi,edx
         sub ebp,ebx
         mov ebx,ebp
         jnle short c512_next_plane_i

         popad
         ret

c512_routes  dd offset c512_route0
             dd offset c512_route1
             dd offset c512_route2
             dd offset c512_route3
c512_reroute dd 0

c512_route0:
         mov ecx,edx
         rep movsd
         add edi,ebp
         dec ebx
         jnz short c512_route0
         ret

c512_route1:
         mov ecx,edx
         rep movsd
         movsb
         add edi,ebp
         dec ebx
         jnz short c512_route1
         ret

c512_route2:
         mov ecx,edx
         rep movsd
         movsw
         add edi,ebp
         dec ebx
         jnz short c512_route2
         ret

c512_route3:
         mov ecx,edx
         rep movsd
         movsw
         movsb
         add edi,ebp
         dec ebx
         jnz short c512_route3
         ret

c512_doflatcopy:
         mov ebp,_virtual_video_height
         mov edi,ebx
         shl ebx,5                     ; * 32
         and bh,0f0h
         mov ah,bh
         and edi,07fh
         add ebp,edi
         shl edi,9                     ; * 512
         mov dx,3ceh
         mov al,09h

c512_next_plane:
         out dx,ax

         mov ecx,512*128
         cmp ebp,128
         jae short c512_noclip
         mov ecx,ebp
         shl ecx,9                     ; * 512
c512_noclip:
         sub ecx,edi
         shr ecx,2
         add edi,0a0000h
         rep movsd

         add ah,16
         xor edi,edi
         sub ebp,128
         jnle short c512_next_plane

         popad
         ret

;
; Xmode copy routines
;

xcopy_even macro
         db 08ah,086h                       ; mov al,[esi+i]
         dd i
         db 08ah,0a6h                       ; mov ah,[esi+i+4]
         dd i+4
         i = i + 8
         stosw
         endm

xcopy_odd macro
         db 08ah,086h                       ; mov al,[esi+i]
         dd i
         i = i + 4
         stosb
         endm

_xplane  dw 0
_xcount  db 0
_xfine   db 0
_xblot   db 0,2,3,4
_xblit   dd 0,3,2,1
_xflit   dd 0,4,4,4
_xsave   dd 0
_xcross  dd 0

xmode_copy_:
         pushad
         mov esi,eax

         mov edi,edx                        ; save x screen offset
         mov cl,dl                          ; select first plane
         imul ebx,_actual_video_width       ; add in y offset
         mov _xcount,4
         add edi,ebx                        ; edi = start x screen offset
         shr edi,2
         add edi,_xmode_offset              ; add in xmode page flipping start
         mov dx,sc_index
         mov al,2
         and cl,11b
         mov ah,11h
         rol ah,cl
         mov _xplane,ax
         out dx,ax
         mov edx,_virtual_video_width
         sub esi,360
         add esi,edx
         mov ecx,edx
         mov eax,ecx
         and eax,3
         add ecx,3
         mov bl,_xblot[eax]
         mov _xfine,bl
         add esi,_xblit[eax*4]
         mov eax,_xflit[eax*4]
         mov _xcross,eax
         mov ebx,_actual_video_width
         shr ebx,2
         shr ecx,2
         sub ebx,ecx                        ; ebx = actual width - virtual width
         mov eax,[xm_jump_tables + ecx*4 - 4]
         mov _xsave,eax
         mov ecx,[xm_jump_tables + ecx*4]
xm_again:
         dec _xfine
         jnz short xm_blot
         sub esi,_xcross
         mov ecx,_xsave
         inc ebx
xm_blot:
         push edx edi esi
         mov ebp,_virtual_video_height
xm_loop:
         jmp ecx
xm_unrolled_loop:
         i = 0
         rept 360/8 - 1
         xcopy_even
         endm
xm_loopstart:
         xcopy_even
xm_loopend:
         add edi,ebx
         add esi,edx
         dec ebp
         jnz xm_loop

         mov dx,sc_index
         rol byte ptr _xplane+1,1           ; select next plane
         adc edi,0
         mov ax,_xplane
         out dx,ax
         pop esi edi edx
         inc esi
         dec _xcount
         jnz xm_again

         popad
         ret

xm_unrolled_loop_odd:
         i = - 4
         rept 360/8
         xcopy_even
         endm
         xcopy_odd
         jmp xm_loopend

xm_jump_tables label dword
         i = 360/8
         rept 360/8 + 1
         dd i * (offset xm_loopend - offset xm_loopstart) + offset xm_unrolled_loop
         dd i * (offset xm_loopend - offset xm_loopstart) + offset xm_unrolled_loop_odd
         i = i - 1
         endm

;
; page flipping routines (ignored if only 1 page - xmodes only)
;

xmode_flip_:
         push eax ebx edx
         mov bx,word ptr _xmode_offset
         mov dx,crtc_index
         mov al,0ch
         mov ah,bh                          ; write the HIGH byte
         out dx,ax
         inc al
         mov ah,bl                          ; write the LOW byte
         out dx,ax
         mov eax,_xmode_xor
         xor _xmode_offset,eax
         pop edx ebx eax
         ret

;
; Find closest video mode.
; int Video_mode_fit(int xsize,int ysize);
;
; In:
;  EBX = xsize
;  ECX = ysize
; Out:
;  EAX = video mode suitable for calling fmode. 0 = no video mode available
;
;

video_mode_fit_:
         push esi edi edx ebp ebx ecx
         and ebx,0ffffh
         and ecx,0ffffh
         mov eax,ebx
         imul ecx
         mov edi,eax
         mov esi,offset _sorted
vmf_again:
         lodsd
         mov ebp,eax
         lodsd
         push eax
         imul ebp
         pop edx
         cmp edi,eax
         lodsd
         ja short vmf_again
         cmp ecx,edx
         ja short vmf_again
         cmp ebx,ebp
         ja short vmf_again
         pop ecx ebx ebp edx edi esi
         ret

_sorted  dd 256,200,M256x200x256 ; 51200  ; sorted area's of video modes, and mode #
         dd 256,240,M256x240x256 ; 61440
         dd 320,200,M320x200x256 ; 64000
         dd 360,200,M360x200x256 ; 72000
         dd 320,240,M320x240x256 ; 76800
         dd 360,240,M360x240x256 ; 86400
         dd 320,400,M320x400x256 ; 128000
         dd 360,360,M360x360x256 ; 129600
         dd 360,400,M320x400x256 ; 144000
         dd 320,480,M320x480x256 ; 153600
         dd 360,480,M360x480x256 ; 172800
         dd 512,400,M512x400x256 ; 204800
         dd 64000,64000,0        ; default = error

         endif

_TEXT    ends
         end
