#include <stdio.h>#include <math.h>
#include "vmode.h"
#include "struct.def"
#include "tri.h"

#define skip 65536
#define M_PI 3.14159265
#define MIN(A,B)  ((A)>(B)?(B):(A))  /* Min macro definition */

struct vertex verticies[3];
struct poly_connection connection[3];
struct polygon surface[1];

/*
 0--3
 |  |
 |  |
 1--2
*/

int * allocate_video_buffer(int xsize,int ysize)
{
    int * bufloc;
    int z,y;

    if ((bufloc = (int *) malloc((xsize + sizeof(int)) * ysize))!=NULL) {
       y = (sizeof(int) * ysize) + (int) bufloc;
       for (z=0; z<ysize; z++)
           bufloc[z] = (xsize * z) + y;
    }
    return (bufloc);
}

main(int argc, char *argv[], char *envp[])
{
    int xax,yay;
    int x;
    float rad,per;

    if (argc==3)
    {
       xax = atoi(argv[1]);
       yay = atoi(argv[2]);
    }
    else
    {
       xax = 320;
       yay = 200;
    }

    rad = skip*MIN(yay,xax)/2 - 2;  // -2 for radius safety

    if ((virtual_video_tables = (int *) allocate_video_buffer(xax,yay))==NULL) {
        printf("Error allocating memory");
        exit(0);
    }
    virtual_video_width  = xax;
    virtual_video_height = yay;
    clear_memory((char *)virtual_video_tables[0],xax*yay,0);

    x = video_mode_fit(xax,yay);
    if (x!=0)
        {
        fmode(x);
        }
    else
        {
        free(virtual_video_tables);
        printf("\nVideo mode not supported - Max resolution 512x400 or 360x480");
        exit (0);
        }

    surface[0].pg_vertex_count = 3;
    surface[0].pg_poly_list    = &connection[0];

    connection[0].pc_this_vertex   = &verticies[0];
    connection[0].pc_next_link     = &connection[1];
    connection[0].pc_previous_link = &connection[2];

    connection[1].pc_this_vertex   = &verticies[1];
    connection[1].pc_next_link     = &connection[2];
    connection[1].pc_previous_link = &connection[0];

    connection[2].pc_this_vertex   = &verticies[2];
    connection[2].pc_next_link     = &connection[0];
    connection[2].pc_previous_link = &connection[1];

while (kbhit()==0) {

    per += 0.01;
    verticies[0].vtx_x2d = (cos(per         )*rad) + (xax/2*skip);
    verticies[0].vtx_y2d = (sin(per         )*rad) + (yay/2*skip);
    verticies[1].vtx_x2d = (cos(per+M_PI*4/3)*rad) + (xax/2*skip);
    verticies[1].vtx_y2d = (sin(per+M_PI*4/3)*rad) + (yay/2*skip);
    verticies[2].vtx_x2d = (cos(per-M_PI*4/3)*rad) + (xax/2*skip);
    verticies[2].vtx_y2d = (sin(per-M_PI*4/3)*rad) + (yay/2*skip);

    flat_polygon(&surface[0],233);

    sync_display();
    copy_video_page((char *)virtual_video_tables[0],0,0);
    clear_memory((char *)virtual_video_tables[0],xax*yay,0);
    flip_video_page();
}
    free(virtual_video_tables);
    getch();
    vmode(3);
}
