

                                                                4
                                                             Menu
                                                          Options


Pull-Down Menus
---------------

     A review of the various menu options will provide an
     analysis beyond that provided in Chapter 3.

            To call up the main menu press /.

            To select a main menu item move the cell-block
            over the choice and press ENTER

            To select a sub-menu item move the cell-block
            over the choice and press ENTER

            To move between sub-menus press either the left
            or right arrow keys

            To leave the sub-menu press ESC

            To leave the main menu press ESC

     The following are the main pull-down categories, each
     followed by their respective sub-categories.


CALCULATE
---------

     Calculate
     ---------

     To reach this level move the cell-block left to Calculate and
     press ENTER. A sub-menu will pull down. Move the new cell-
     block down to Calculate on the sub-menu (as this is the first
     choice the cell-block should already be over Calculate) and
     press ENTER. This selection will perform a re-calculation of all
     balance sheet, income statement, cash statement and ratio
     analysis amounts. You may not stop a calculation already in
     progress.

     Be alert for any BEEPS. If your file links to an account
     number which does not exist a beep will sound and an
     error message will be displayed in the lower left corner
     of the screen. The calculation will be completed. Errors
     are informational only.

     A slightly longer beep will sound when the calculation
     has been completed. The time to calculate will be
     displayed in the lower left corner of the screen. The pull-
     down menu will disappear and the cell-block will be
     positioned over Calculate on the main pull-down menu.

     All entered and calculated amounts must be within the
     range +2,147,483,647 and -2,147,483,647. If any
     amounts exceed this range, you will need to forecast
     amounts in thousands of dollars. Note this change in
     File Info, so that printouts will display the message
     '($000)' at the top of printed pages. Only the first nine
     digits will be displayed on screen.

     Numbers eight digits long will be displayed on screen
     with commas; e.i. 12,345,678. Numbers nine digits
     long will be displayed on screen without commas; e.i.
     123456789 or -123456789.


     Error Rprt
     ----------

     If error messages are noted during a re-calculation of
     the file an error report will be created by FW. As noted
     above, an error will occur if your file links to an account
     number which does not exist. Each error will be
     displayed in detail in the error report. Only the first 100
     errors will be maintained. Except for very complicated
     files, you should have very few errors, if any at all. This
     error report will be maintained until you re-calculate. In
     addition, the latest error report will be saved when you
     save a file.


     Auto Calc
     ---------

     Similar to other spreadsheet packages, FW provides you
     with an automatic re-calculate feature. If you make
     changes to a Data Entry screen, a re-calculation will be
     performed if you then call-up a Calc or Monthly Calc screen.
     The program displays the status of "Auto Calc" or "Manual Calc"
     in the lower right portion of the screen.

     This feature may also come in handy if your are making
     minor changes, and then re-calculating.


     Manual Calc
     -----------

     Changes to the Data Entry screens will not be reflected
     in the calculation screens unless you perform a re-
     calculation. To re-calculate use the pull-down menu,
     move to the Calculate heading, pull down the menu and
     select Calculate.

     Generally, you will operate under the Manual Calc mode.


     RatioMethod
     -----------

     Opinions differ on specific formulas used in calculating
     various ratios. The differences are with respect to
     whether balance sheet amounts should be determined
     at the beginning of the period, end of the period or an
     average of the current and the previous period. Opinions
     also differ from ratio to ratio. This author feels
     that whenever possible an average should be used.
     However in an effort to provide the user a say in this
     matter, FW has provided the user with the ability to
     select how the ratios will be calculated. Each ratio may
     be calculated differently. The screen is rather simple to
     use. Simply move the cell-block to the ratio to be
     changed and press your selection from the choices on
     screen.

     Some ratios will only show NONE. These accounts are
     not adjustable, however they have been included in case
     of future need. Also, methods dealing with days (360
     days/year or 365 days/year) use the keys (0) and (5)
     to represent 360 and 365 days, respectively.


     Calc Level
     ----------

     When linking accounts, you can change the default setting of 3. As
     noted in the chapter that explains formula method #141, each level
     reviews the current financial statement (B/S, I/S, C/S) 10 times to
     resolve simplistic linking of accounts. We recommend a setting of
     between 3 and 10 for most needs. The setting may be changed to
     from 1 to 1000.

     Increasing the number of levels can significantly increase the
     calculation time, if errors are present. FW will only use as many
     levels are needed. If an error is present (one account links to a
     second account which does not exist) FW will continue moving
     through all levels attempting to resolve the link. Only increase the
     number of levels if FW reports errors that will be resolved by
     increasing the number of levels.

     FW will not check for the existence of the linked account. This
     provides you with flexibility in Data Entry. You need not enter the
     linked account first. However, when you recalculate, should the
     linked account not exist an error message will be briefly displayed.
     Errors will be accumulated in the "ERROR RPRT" in the Calculate
     pull-down menu. This report will not change until the next time
     you run Calculate. The error report will be saved with your file
     when you store your file to the hard-disk.


SCREENS
-------

     Data Entry
     ----------

     There are six Data Entry screens. This is where you will
     spend most of your time, inputting forecast amounts and
     selecting formula methods. The six screens are

            1. B/S - Data Entry
            2. B/S - Formulas
            3. I/S - Data Entry
            4. I/S - Formulas
            5. C/S - Data Entry
            6. C/S - Formulas

     The first screen displayed will be the B/S - Data Entry if
     you are loading a new file. If you are loading a
     previously saved file, your last screen and screen location
     will be recalled.

     The three Data Entry screens contain approximately 250
     predefined accounts. These accounts have account
     numbers in even thousands (example: Cash is 100000
     and Inventories is 108000). New sub-accounts may be
     easily added (See "Add New Line" in Chapter 5). These
     sub-accounts have the same properties as the main
     account. For example, if you added a new Cash account
     #100001, all forecasted amounts would be added to
     cash in the calculation of Cash Flow and various Ratio
     Analyses. In addition, this account could, if you choose,
     be "rolled-up" into Cash in Financial Report printouts.

     As shown in the charts in chapter 1, the key commmands
     used to move around the spreadsheet are very similar to
     those already used on popular spreadsheet programs. If you
     are a spreadsheet user you will find FW easy to work with.
     In fact, because most of the power of FW is pre-programmed,
     you will find this program much easier to use than most
     spreadsheet programs since FW makes tremendous
     power available to even a first time user.

     By pressing F1 you will exit the B/S - Data Entry screen
     and enter the I/S - Data Entry screen. Pressing F1 again
     will exit the I/S - Data Entry screen and enter the C/S -
     Data Entry screen. Once more will return to the first
     screen, B/S - Data Entry screen.

     All file information is maintained in memory, with no disk
     swapping of data, so the screen flips are very fast. Parts
     of the program will be swapped from the disk drive, so
     the faster your computer the faster FW will appear. (FW
     writes directly to the screen, bypassing the computer's
     BIOS, resulting in fast screen display response. Also, the
     Data Entry and Calculation screens employ a special buffered
     screen-interface for superior screen display response).

     To enter or change the historical B/S you must use the
     left arrow key from the first forecast column. All other
     keys relate to the forecast columns only. As you will
     generally not be changing the opening B/S, HOME and
     CTRL + HOME relate to the first forecast column and
     not the opening B/S.

     In addition to the ease of changing Data Entry screens,
     FW remembers the three last used locations (the relative
     cell-location of each of the three financial screens). If you
     were at A/R #105000 in December 1990 and pressed
     F1 three times (flipping through the screens) you would
     arrive back at A/R #105000 in December 1990. The
     last locations of the I/S and C/S would also be retained
     regardless of your work in other parts of FW.

     FW goes even further. When you switch between Data Entry, Formulas,
     Calculations and Monthly Calc screens of the same type
     (B/S, I/S or C/S) your last used position will be retained.
     The screens column layout between the Data Entry and
     Monthly Calc screens (whether from the Data Entry to
     the Monthly Calc or vice-versa) is not the same,
     however, FW will determine a proper month/period
     location in the next screen. Therefore, you can easily
     switch between the Data Entry, Formulas, Calculations
     and Monthly Calc screens without changing your relative
     location. Although easy to use, FW actually consists of
     three spreadsheets, each with four dimensions, all working
     together as one set of financials.

     Depending on the formula methods chosen, you will
     enter "Dollar or Unit amounts", or "Percentages".
     To enter or change amounts or percentages simply move
     the cell-block to the desired location and enter the
     number (pressing the number is sufficient - there is no
     need to first press an edit key). The new number will be
     displayed as you type in the lower left corner of the
     screen. The old number stays in the spreadsheet as a
     guide. Press ENTER after you have completed entering
     the number. You may also use the arrow keys to both
     enter the new number and move the cell-block to a new
     location.

     If you mistype the new number, simply use the
     <-- (back-arrow key) to erase the last character(s) and
     continue entering the new number. Should you decide
     to leave the original number unchanged simply press
     ESC. You will be returned to the screen (use of the
     arrow keys prior to ESC will enter the new number or 0).

     The formula method for each individual cell will be
     displayed just below the Data Entry screen display. As
     you move about the screen, the formula method display
     will be updated. Entering or changing formula
     methods is a snap, and the power behind the
     120 methods available far exceeds that previously
     possible using a general spreadsheet package.
     In addition, EVERY INDIVIDUAL DATA ENTRY
     CELL MAY HAVE A DIFFERENT FORMULA METHOD.
     FW calculates each Data Entry cell individually, based on
     the results of the previous cell for that account (chronologically).
     Additionally, some of the formula methods link to the
     results of other accounts or sub-accounts, which in turn
     could be linked to the results of other accounts or sub-
     accounts.

     From the Data Entry screen, press F10. This will switch
     you into the Formulas screen for the respective financial
     statement (B/S, I/S or C/S). Unlike the Data Entry screen
     which provides one line to each account number the
     Formulas screen provides two lines to each account with
     one blank line between accounts. The first line displays
     the chosen formula method for that cell, with the second
     line providing the link account if needed (6 digit number)
     or the seasonality chart selected (2 digit number). To enter or
     change a selected method simply move the cell-block to
     the desired location and enter the new formula method's
     number (pressing the number is sufficient - there is no
     need to first press an edit key). The new number will be
     displayed as you type in the lower left corner of the
     screen.

     If you mistype the new number, simply use the
     <-- (back-arrow key) to erase the last character(s) and
     continue entering the new number. Should you decide
     to leave the original number unchanged simply press
     ESC. You will be returned to the screen (use of the
     arrow keys prior to ESC will enter the new number).
     Press ENTER after you have completed entering the
     number. You may also use the arrow keys to both enter
     the new number and move the cell-block to a new
     location. Should you choose a method requiring the
     entry of a link account number or selection of a seasonality
     chart number (1 to 100), you will then be
     prompted for the information. When you have
     finished entering or changing formula methods press F9
     or / to return to the respective Data Entry screen. You
     may only flip between Data Entry screens, not between
     Formulas screens.


     Calculations
     ------------

     There are three Calculations screens. FW will first
     calculate all results on a monthly basis (see Monthly
     Calc below). Then FW will display all balances (B/S) and
     cumulative amounts (I/S and C/S) in the same manner
     (column structure) as you used to input your forecast.
     The purpose of these screens is to provide you, the
     user, with results in the same groupings as that used for
     Data Entry. You should use these screens first, in
     reviewing results. The Monthly Calc screens may then
     be reviewed for the spreading of amounts.

     Remember, FW looks at each cell as a separate calculation.
     Most errors may be clearly identified from the Calculations
     screens. If you change the column structure of the Data
     Entry screens, the Calculations screens will also change,
     although you will need to re-calculate your file.

     Calculation screens are for display only. You may not
     make any changes to the results displayed.

     The three screens are

            1. B/S - Calculations
            2. I/S - Calculations
            3. C/S - Calculations


     Monthly Calc
     ------------

     There are three Monthly Calc screens. FW will first
     calculate all results on a monthly basis, and then display
     all balances (B/S) and amounts (I/S and C/S) on a
     monthly basis. You should use the Calculations screens
     first to review results. The Monthly Calc screens may
     then be reviewed for the spreading of amounts.

     Remember, FW looks at each cell as a separate
     calculation. Most errors may be clearly identified from the
     Calculations screens. If you change the column structure
     of the Data Entry screens, the Monthly Calc screens will
     not be affected, although you will need to re-calculate
     your file.

     Monthly Calc screens are for display only. You may not
     make any changes to the results displayed.

     The three screens are

            1. B/S - Monthly Calc
            2. I/S - Monthly Calc
            3. C/S - Monthly Calc


     Seasonality
     -----------

     There are 100 monthly Seasonality screens.  All formula
     methods relying on seasonal trends use these screens.
     You may make changes to seasonal trends at any time,
     and then re-calculate. FW will use the specific
     month/year percentages, for the screen number selected,
     in performing its calculations. For example, if the forecast
     period is the fourth quarter ending December 1990, the
     seasonal percentages provided by the user for Oct to
     Dec 1990 will be used by the program - This is
     automatic!

     Yearly percentages must equal 100 percent for all years
     forecast. Percentages may be entered to three decimal
     places, but may not be 0 percent or a negative percent for any
     month.


     DeletePeriod
     ------------

     You might expect that once you have set up a Data
     Entry columnar structure and entered amounts you
     would not be able to change it! FW to the rescue!
     DeletePeriod allows you to combine Data Entry periods,
     for example three monthly columns into one Quarterly
     column or four quarterly periods into one yearly period.

     DeletePeriod erases the unwanted periods. NO changes
     will be made to the unchanged period (column)
     remaining.

         For example, if you were to combine three
         monthly periods into one quarterly period the first
         two months of Data Entry and Formula methods
         would disappear. The remaining third month
         would be turned into a quarterly period. Amounts
         in that third period and respective formula
         methods will be unchanged. It will be up to the
         user to make any necessary changes. Forecast
         balances may not need changing, however,
         period amounts in the I/S and C/S will generally
         need some modification.


     InsertPeriod
     ------------

     FW also allows you to insert new periods. This allows
     you to refine your forecast by increasing your control
     over amounts forecast. In addition, this allows you to
     break-down early forecast periods in order to enter
     actual monthly or quarterly results, and then re-calculate
     your forecast based on these new historical results. In
     this manner your forecast acts not only as a one shot
     forecaster but as an ongoing analysis tool.

     InsertPeriod adds blank new periods. For example, if the
     current period was quarterly, two new monthly periods
     would be added before the existing period. The quarterly
     period would become the third monthly period of the
     quarter. All amounts and formula methods would remain
     in that third monthly period. It will be up to the user to
     make any necessary changes.

     The additional memory needed to store the added
     periods has already been allocated at start-up. This
     avoids the problem of the user building too large a
     model, and then not being able to use this feature.


     Move Columns
     ------------

     This feature allows you to move entire columns left or right within
     the existing spreadsheet. The insert/delete period features (described
     above) maintain your file's Data Entry setup (month/quarter/year).
     The "Move Columns" option ignores your Data Entry setup, and instead
     acts like a standard spreadsheet program.

     You may separately move your B/S, I/S, and C/S Data Entry columns.
     Your Monthly Calc cells will not be adjusted until you recalculate
     your file.

     Both the Data Entry amounts and its formulas will be moved.
 
     BE CAREFUL to reset any amounts entered into the Monthly Calc
     screens using formula method #99.

     The Monthly Calc cells are moved left or right while operating in
     either the REPORT or CONSOLIDATION mode.

     Representative Data Entry accounts (I/S or C/S) will also be moved.


     MoveBlkRows
     -----------

     This feature allows you to move a consecutive block of
     sub-accounts from one main account, to be placed as
     sub-accounts of another main account. For example, if
     there were 4 sub-accounts to be moved from under
     #216000 Factory Overhead to under #220000 Other
     Costs as follows

              Accounts to be moved    New Account
              --------------------    -----------
                   #216001              #220001
                   #216002              #220003
                   #216004
                   #216008

     and you chose to move all sub-accounts from #216001
     to #216008 to accounts starting at #220002 by 2's, the
     four accounts would become #220002, #220004,
     #220006 and #220008. Accounts #220001 and #220003
     would stay the same such that the new account would
     include the following accounts (by line order)


            New Accounts After Move
            -----------------------
                   #220001
                   #220002
                   #220003
                   #220004
                   #220006
                   #220008

     All Data Entry, Formulas, Calculations and Monthly Calc
     information will be moved. However, other variables
     linked to these accounts will need to be corrected by
     the user, and a re-calculation may be in order.

     If your proposed move would overwrite another account,
     FW will display an error message and request that you
     try again. Main account rows may not be moved.


     Move Row
     --------

     Move Row allows you to move one sub-account.
     (See MoveBlkRows discussion above)


     Goto Row
     --------

     This feature allows you to go to a row within the current
     screen. Screens include Data Entry, Formulas,
     Calculations and Monthly Calc. If the row number
     requested is outside the bounds of the active screen an
     error message will be displayed. If the row number
     requested is within the bounds of the active screen but
     does not exist, FW will go to the next closest row
     number. In this manner approximate row numbers are
     adequate.

     To use this feature move the pull-down menu (up) to
     Goto Row. The pull-down menu scrolls up as well as
     down.



PRINTOUT
--------

     Printouts
     ---------

     This selection will send to your printer those screens
     selected under PrintSelect. Printouts contain the account
     number, account description and amounts or percentages.
     Press 'S" to abort printing. Press 'E' to abort printing
     at the completion of the financial statement printing.


     PrintSelect
     -----------

     Select the screen printouts which you would like, then
     call the Printouts sub-menu to initiate the printing.
     Ten reports are available

          1. B/S Data Entry (including Formula method selections)
          2. B/S Calc
          3. B/S Monthly Calc
          4. I/S Data Entry (including Formula method selections)
          5. I/S Calc
          6. I/S Monthly Calc
          7. C/S Data Entry (including Formula method selections)
          8. C/S Calc
          9. C/S Monthly Calc
         10. Seasonality


     Print Option
     ------------

     You may change your printer setup at any time prior to
     printing Printouts or Reports. Don't be afraid to play with
     different typefaces or changing the lines per inch.
     Up to 43 different fonts are available. If you like
     condensed printouts (or reports) try superscript (16
     characters per inch) with 8 lines per inch printing. Or
     stick to a standard 10 characters per inch with 6 lines
     per inch. It's a snap to change! You can even change
     the margins on the printed page and the number of
     columns printed on each page. You may also change
     the printer provided the printer file was properly installed
     using the SLATE printer installation program.

     The following options are available in print options:

      1. Select Different Typeface
          Up to 43 different fonts are available (printer dependent). 10
          or 12 cpi is standard. 16cpi represents compressed mode.

      2. Change Lines Per Inch
          Select the number of lines printing on each page. Six is
          standard. Eight with a 16cpi font works well.

      3. Change Page Length
          A standard page is 11 inches long. Additional lines will print
          on longer paper, automatically.

      4. Change Page Width
          Standard page width is 8.5 inches wide.

      5. Change Margins / No. of $ Columns
          Set the left margin, or front and back left margins for two
          sided printing. Also, you can decrease or increase the number
          of ten digit dollar columns printing on each page. FW will
          automatically adjust for changes between 10, 12 and 16cpi on
          standard 8.5 inch wide paper. However if you need to use
          large left margins or have changed the width of the page you
          will need to change the number of $ columns printing on
          each line.

      6. List Printers Installed
          FW can address the SLATE database file from within FW.
          If you have installed several print drivers using the SLATE
          program, FW will allow you to easily change print drivers.
          A list of drivers installed will be displayed.

      7. List Active Printer & Typeface Selected
          The active print driver and font selected will be displayed.

      8. Select Print Driver for Primary Printer
          A listing of installed print drivers will be displayed. Select a
          new print driver. You will then be asked to select a new font.
          The print driver must have been installed prior to running
          your current session with FW.

      9. Print File Name & Date on Each Page ?
          At the top of each printed page will be displayed the name
          of the file and the date the file was last saved to the hard
          drive. Printing of this information can be suppressed.

     10. Print 2 Sided Paper ?
          FW will print two-sided. You need not have a two sided-
          printer. By setting the margins under #5 above, you can use
          a one-sided printer, print two-sided, then use the one-sided to
          two-sided feature of many copying machines to produce
          smaller reports. Theses can then be bound or placed into a
          ring-binder.

     11. Install other fonts ?
          The very popular HP LaserJet printer has limited font
          capability included. If you wish to use other available fonts
          "soft fonts" have been included under the directory
          \slate\font. Those included in the HP may produce sharper
          results.

     12. Print B/S Historical Period ?
          This is a simple yes or no choice. If you do not make a
          selection FW will assume that you do not wish to start all
          printouts and reports with the opening B/S.

     13. Change Currency Symbol, $ Separator & Date Display
          In addition, the "ASCII code" for the "$" (dollar) sign can be
          changed. This will allow you to print the British Pound
          sign, the Lira sign and others. Operation will be as follows:

          a) Dot matrix printers:  The symbol used must be included
             in one of the international character sets installed in
             your printer. Change the dip switch, or built-in
             software, in your printer. Enter into FW, the ASCII
             character code from the chart listed in your manual.
             You may need to turn your printer's power "off", then
             "on," to reset your selection.

          b) Laser printers :  Generally, you will NOT be able to use
             this feature. The installed print drivers will use the
             default font of your laser printer. Changes to your laser
             printer's control panel will have no effect.

             Some non-US countries use the "period" instead of the
             "comma" as a thousands and millions separator. Either the
             comma or the period may now be used. This option will be
             saved to the print environment, and not to the file, as is
             the case with all other print options.

             The date displayed on the screen and included in printouts
             may be either the US format Month/Day/Year or the
             European format of Day/Month/Year.

     14. Exclude Accounts With $0 Amounts - Print & Lotus 123
          The printing or conversion to Lotus 123 format, of any
          account with $0 (zero) balances for all periods can be
          turned-off. This option will be activated by default unless
          turned-off by the user. This will:

          a) allow users to avoid having to setup report layouts
             to turn-off the printing of accounts not used,

          b) eliminate the printing of accounts not used on "printouts,"

          c) eliminate the printing of certain accounts which you
             are not allowed to "turn-off,"

          d) eliminate excess accounts on conversions to Lotus.


REPORTS
-------

     Reports
     -------

     This selection will send to your printer those screens
     selected under ReportSelect. Reports contain the
     account description and amounts or percentages. Dollar
     signs and formal single and double lines are drawn as
     would be expected of a formal report.

     You may print all periods, or only a range. After selecting the
     "Reports" option, you will be given the option to "Print All
     Months/Periods" or "Print Selected Months/Periods".

     Selecting "Print Selected Months/Periods" will prompt you for the
     month/year to start and finish. As Data Entry periods may not
     match exactly to your selection, all periods that fall within your
     request will be printed.

     Example:  Say there are three annual Data Entry periods - 12/1990,
     12/1991 and 12/1992. Printing 11/1990 to 1/1992 will print the
     12/1990 and the 12/1991 Data Entry periods.

     The print option "Print B/S Historical Period ?" will be overridden
     by your selection to start printing from a set month/year. Starting
     your printout from the opening B/S date will also print $0 in the
     opening I/S and C/S reports. However, some I/S formula methods
     prompt you for historical amounts such as "last year's 12 month
     sales" or "last year's last month sales." FW actually stores this
     information in the normally unused first column (last year's endingcolumn). Therefore this is a way to print out the historical amounts
     entered into the I/S and C/S formula methods.

     Initially, the prompt for this option will contain "Blank" Selections,
     however an example minimum/maximum range will be provided.
     Entries will be maintained for future use until you exit FW. Entries
     will NOT be stored with the file.


     ReportSelect
     ------------

     Select the screen reports which you would like printed,
     then call the Reports sub-menu (noted above) to initiate
     printing. Eight reports are available

         1. B/S Calc
         2. B/S Monthly Calc
         3. I/S Calc
         4. I/S Monthly Calc
         5. C/S Calc
         6. C/S Monthly Calc
         7. FASB 95 - Calc
         8. FASB 95 - Monthly Calc

     The FASB 95 Cash Statements may use either the Direct or the
     indirect method; individually selectable at the time you
     print.


     Acct On/Off
     -----------

     Reports may be customized with this feature. Up to 20
     different report layouts may be stored and then selected
     for printing. Customization affects "reports" but not
     "printouts", as follows:

     1.  All accounts will be printed out, unless an
         account can be, and is, set to "Off"; see chapter 9.
         All accounts and sub-accounts are set to "On" by default.

     2.  If a sub-account is changed to "Off", any amounts
         in that account will be added to the main
         account. The line for that particular sub-account
         will not be printed. Sub-accounts may always be
         turned-off.

     3.  If the main account is changed to "Off", any
         amounts in that account will be added to its
         respective Other account. For example, if
         inventories were to be changed to "Off" its
         amount would be added to Other Current Assets.
         If Gross PP & E were to be changed to "Off" its
         amount would be added to Other Assets.

     4.  If both a main account and some or all of its
         sub-accounts were changed to "Off" those
         amounts would all be added to its respective
         Other account. The sub-accounts left "On" would
         print normally.

     5.  Accounts #300000 to 381000 are not normally
         printed in reports. The Print feature is not
         applicable to these accounts.


     RatioRepts
     ----------

     This selection will send to your printer those screens
     selected under RatRptSelect. Reports will print each
     Ratio Calc (based on your sensitivity range) and Ratio
     Review (ratio analysis description) on the same page,
     if you would like the descriptions printed.


     RatRptSelect
     ------------

     Select the ratio reports which you would like printed,
     then call the RatioRepts sub-menu (noted above) to
     initiate printing.

     After making your selections, FW will ask whether or not
     you would like the Ratio Review descriptions printed.
     Twenty-two reports are available

      1. Gross Profit Margin       12. Debt - Equity Ratio
      2. Operating Profit Margin   13. Debt - Capital Ratio
      3. Net Profit Margin         14. Equity Ratio
      4. Net Profit Retained Marg  15. Times Interest Earned
      5. Return on Investment      16. Total Asset Turnover
      6. Return on Equity          17. Inventory Turnover
      7. Return on ComStk Eqty     18. Days in Inventory
      8. Earnings Per Share        19. Accounts Rec Turnover
      9. Quick Ratio               20. Days in Receivables
     10. Current Ratio             21. Accounts Pay Turnover
     11. Debt Ratio                22. Days in Payables


     RatSensitive
     ------------

     With your knowledge of your own business, we have
     allowed you to grade your future - and hopefully modify
     your future (in both this forecast and in actual practice)
     if your forecast is not as you would like to see it. This
     management tool is both easy to use and extremely
     powerful. You simply enter your concept of what you
     would consider EXCELLENT, GOOD, AVERAGE, FAIR,
     and POOR. These parameters will then be used to rate
     your forecast. If areas need improvement, some
     descriptive analysis is available. Both the calculation of
     your sensitivity range and the description analyses are
     available in Ratio Calc, which is explained below.


     Ratio Calc
     ----------

     The results of your grading (described above) will be
     displayed. The grading will be applied to the latest re-
     calculation and is the same as the ratios displayed in
     the Cash Statement. The grades are applied based on
     your pre-determined grading system. You can change
     the grading system and review the changes in Ratio
     Calc without the need to re-calculate the entire file. By
     using the left/up and right/down arrows you can page
     through all 22 ratios. Pageup and pagedown will move
     five ratios at a time, home and end will move to the first
     and 22nd ratio, respectively.

     Press F1 to display our descriptive analyses. Press F1
     to return to the ratio calculations. Pressing an arrow key
     will move between the ratio calculations and not the
     descriptive analyses.



FILES
-----

     Load/Imp/Exp File
     -----------------

     This feature contains the following options:

     BUDGET MODE (default)
      1. Load Budget File

     REPORT MODE
      2. Create Report File from Saved Budget
      3. Load Report File

     CONSOLIDATION MODE
      4. Create/Modify Consolidation Setup
      5. Create Consolidation File From Setup
      6. Load Consolidation File

     IMPORT FACILITY
      7. Create/Modify Import/Export Setup
      8. Create OSAS Setup - Direct from GL
      9. Lotus Import Into BUDGET/RPT/CONSOL file
     10. OSAS Import Into BUDGET/RPT/CONSOL file (FW for OSAS version)


     EXPORT FACILITY
     11. Lotus Export (current file) Using Setup
     12. OSAS Export (current file) Using Setup (FW for OSAS version)


     Options Described:
     ------------------

     BUDGET MODE (default)
     1. Load Budget File - Budget Mode is the default mode.
        Generally you will operate within this mode. The use of
        formula methods, and the ability to forecast by quarter and
        year is exclusive to this mode.

        In selecting this option, a list of previously saved files will be
        displayed. Use the up and down arrow keys to highlight your
        selection, and press F10 to select. Only one file may be present
        at a time. The previously loaded file will be erased from memory.

     REPORT MODE
     2. Create Report File from Saved Budget - A Budget mode file
        must first be created, and saved to the hard drive. FW can then
        load the Budget file, modifying it into a Report Mode file. This
        process takes just a few seconds. Since Budget, Report and
        Consolidation Mode file use a different file name extension, the
        same file name (up to 8 characters) may be used.

        A separate chapter explains the Report Mode. This Mode allows
        you to make individual adjustments to the monthly calculations,
        and allows you to summarize the monthly amounts by quarter
        or year.

        You may add new sub-accounts and you may re-calculate files
        within the Report mode.

     3. Load Report File - In selecting this option, a list of previously
        saved Report Mode files will be displayed. Use the up and
        down arrow keys to highlight your selection, and press F10 to
        select. Only one file may be present at a time. The previously
        loaded file will be erased from memory.

     CONSOLIDATION MODE
     4. Create/Modify Consolidation Setup - FW allows you to create a
        SETUP file for consolidations. This is a listing of files to be
        consolidated. Several options are available. up to 100 files may
        be combined for each consolidation level.

        Budget Mode, Report Mode and Consolidation Mode files may
        be consolidated. All monthly calculations are maintained within
        a consolidation file, allowing for the display, printing, and
        export to Lotus 123 of either consolidating details or
        consolidation amounts.

        Since Consolidation Mode files may be consolidated, FW can
        produce multi-level consolidations without limits.

     5. Create Consolidation File From Setup - FW will prompt you
        for the consolidation SETUP file, previously created and saved.
        FW can consolidate files with different account structures.
        Amounts in accounts with the same account number will be
        combined.

     6. Load Consolidation File - In selecting this option, a list of
        previously saved Consolidation Mode files will be displayed.
        Use the up and down arrow keys to highlight your selection,
        and press F10 to select. Only one file may be present at a time.
        The previously loaded file will be erased from memory.

     IMPORT FACILITY
     7. Create/Modify Import/Export Setup - FW allows you to create
        a SETUP file for imports and exports. This is a listing of
        accounts to be imported or exported. Several options are
        available. The amounts for up to 5000 accounts may be
        imported or exported at a time.

        A matching of the account numbers from your accounting
        system and the account number within FW is created by this
        file.

        The same file may be used for imports and exports, for both
        OSAS and Lotus 123 operations.

     8. Create OSAS Setup - Direct from GL - As noted above, a
        matching of your OSAS General Ledger account numbers and
        your account numbers within FW must be created in a SETUP
        file. This feature allows you to quickly create one-half of this
        file. FW will use your OSAS MASK file to sort your OSAS GL
        file, to create a listing of all OSAS account numbers in a new
        SETUP file.

        Then call up option "7" above, and modify the file to match
        your OSAS account number to your FW account number.

     9. Lotus Import Into BUDGET/RPT/CONSOL file - Once your
        SETUP file has been created and saved, you may use that
        SETUP to import amounts from a WK1 file. FW will request
        the name of your SETUP file, the name of your WK1 file.
        Several options are available.

     10.OSAS Import Into BUDGET/RPT/CONSOL file - Once your
        SETUP file has been created and saved, you may use that
        SETUP to import amounts from your OSAS General Ledger.
        FW will request the name of your SETUP file, and the name
        and location of your OSAS GL file. The OSAS accounting
        systems does not need to be installed on the computer operating
        FW. Several options are available.

        Current year, budget, and prior year amounts may be imported
        into FW.


     EXPORT FACILITY
     11.Lotus Export (current file) Using Setup - Once your SETUP
        file has been created and saved, you may use that SETUP to
        export amounts from FW into a newly created WK1 file. FW
        will request the name of your SETUP file, and the name and
        location of the WK1 file to be created. Lotus 123 does not need
        to be installed on the computer operating FW. Several options
        are available.

        Unlike our "Lotus Conv" feature explained later in this chapter,
        this feature will not export complete sets of financials. Instead a
        row by row listing of "your accounting system's account
        number, the FW account decription, and the amounts exported"
        will be exported to a WK1 file. A range of account numbers to
        be exported may be set.

        The "Lotus Conv" feature exports complete sets of financials.
        Numerous range names are created for total columns, to allow
        easy modification within Lotus 123. Because complete financial
        statements are created, you may not set a range of account
        numbers to be exported.

     12.OSAS Export (current file) Using Setup - Once your SETUP
        file has been created and saved, you may use that SETUP to
        export (budgeted) amounts from FW into the monthly budget
        columns in your OSAS General Ledger. FW will request the
        name of your SETUP file, and the name and location of your
        OSAS GL file. The OSAS accounting systems does not need to
        be installed on the computer operating FW. Several options are
        available.


     Save File
     ---------

     This feature allows you to save all information in the
     current file. Screen colors, spreadsheet locations, error
     reports, etc. are all saved. You should frequently save your
     work to avoid the possibility of lost data.

     Budget Mode, Report Mode, and Consolidation Mode use different
     file name extensions. This allows you to use the same
     eight-character name for all three files.


     New File
     --------

     Call New File to create a brand-new file using
     the template supplied with FW.

     You will first be prompted for some general information,
     such as the name of the Company, the years to be
     forecast and the Company's month-end. All of this
     information may be changed at any time by pulling-down
     the Files menu and selecting File Info.

     You must then set up the periods of data entry.
     Although the structure chosen may be changed at a
     later date, this may entail considerable extra work on the
     part of the user, from the need to possibly change
     amounts or change forecast method selections. Press "/" when
     you have completed your setup. A set of financial accounts and
     account numbers will be created automatically.

     You will then be presented with a Seasonality screen.
     The Seasonality default values have been pre-selected.
     You may make changes representative of your business to one
     or all 100 screens. Seasonal rates may be changed at any time.
     Press "/" when you have completed customizing seasonality. You
     will then be left at the main pull-down menu. Use the
     right-arrow-key to move to Screens and press ENTER. Then use
     the down-arrow-key to move to Data Entry and press ENTER.
     (After initial start-up you will be able to re-enter the
     financial screens from the main pull-down menu by pressing
     ESC from the main menu).

     You are now at the position in order for you to enter
     data, or created new accounts to finish your corporate
     setup.

     NOTE: Once the file has been loaded you may use any
           of the pull-down menu selections.

     Once you have completed your file structure, we
     suggest that you use the Save File feature to
     permanently store the file. You may also wish to save
     this file under another name prior to making additional
     changes. This file could then be used as a template for
     future use, although FW has sufficient features to make
     and save templates from completed forecasts.


     New Struct
     ----------

     FW allows you to change the size or number of Data
     Entry periods. For example, if you use a previously
     saved file as a template and then blanked the amounts,
     you might also like to change the shape of the Data
     Entry periods.

        For example, say that Data Entry was quarterly for the
        first year and annual for the second and third year.
        You can now change to annual for all years, if so
        desired.

     Note: If you did not blank amounts, but for some reason
           wished to change the shape of the Data Entry amounts
           already entered, this feature would change the size of
           the various periods without disturbing the amounts
           already entered.

        For example, if you accidentally set up the first year
        to be quarterly and in error you entered annual data
        into the first three forecast periods, you would not
        have to retype the information. Just change the
        structure. The Data Entry amounts will be undisturbed.
        (Amounts entered into later Data Entry periods, no longer
        used, will be erased - but only on saving the file. So,
        if you make an error you can recover - but before you
        save and erase the existing file).


     DeleteFile
     ----------

     This feature allows you to erase FW files previously
     saved to your hard drive. This allows you to remove old
     files no longer needed, and this also allows you to
     remove old files in case there is insufficient space on
     your hard drive to store a newly created file.


     CopyFilDsk
     ----------

     This feature will copy a selected file from the hard drive
     to either drive A or B. A list of files will be supplied for your
     selection. The current file will only be listed if you have
     previously saved it. If you select the current file, the last
     saving of that file will be copied to the floppy disk - NOT
     the one in memory.

     This feature provides safety in case of a hard drive
     failure. It will do you no good unless you use it. Floppy
     disks are inexpensive, so backup your files often.


     File Info
     ---------

     Various items of information may be stored or changed
     here. They are

        1.  Company Name
        2.  Scenario Name
        3.  First Year(ex: 1990)
        4.  Last Year (ex: 1992)
        5.  Last Month of Year(ex: December=12)
        6.  $ Unit - (# of $0's) [0,3,6]
        7.  Currency Number[1 to 9999]
        8.  Loss Carryforward ($ Unit)
        9.  NOL(1) Carryback(2) or Ignore(3)

     The Company Name will appear on all printouts and reports.

     The Scenario Name will appear on all printouts and reports.

     All screens, printouts and reports will use the first year
     as entered here. Enter the year representing the first full
     year to be forecast. Years must be between 1900 and 2500.

     This version of FW will always produce a three year
     forecast, therefore #4 above, "Last Year" need not be
     completed. However, future versions of this program will
     make use of this information.

     Enter the numeric representation for the last month of
     your company's year. This must be between 1 and 12.

     If amounts are in $ enter 0 as the $ Unit, 1 if you are
     entering amounts in $1000 units, or 2 if you are entering
     amounts in $1,000,000 units. The $000's or $000,000
     Omitted will be noted at the top of each printed page.
     This will also allow our consolidation mode to combine
     different size files.

     Currency number can be set to 1. This feature may be used
     in the future by the consolidation mode.

     Loss carryforward represents tax loses available for all
     forecast years. These losses will be used if you select
     NOL(1) or Ignore(3) in choice #9. Enter amounts in units.
     If you have a $1,000,000 carryforward and you are working in
     $1000 units, enter $1000.

     Selecting NOL in choice #9 means that loss periods will increase
     available NOL's for future use.

     Carryforward in choice #9 means that there are adequate tax
     profits in previous years needed to carry losses back,
     reducing the current period's tax expense. Current tax rates
     are used.

     Ignore in choice #9 means that monthly losses will be ignored,
     however loss carryforwards from #8 above will be used
     against profits.


     Blank Amounts
     -------------

     This feature allows you to blank amounts, formulas or
     seasonal percentages. This allows you to use your
     completed files as templates to create new scenarios.
     Information may be blanked as follows

        1.  B/S Data Entry Amounts
        2.  I/S Data Entry Amounts
        3.  C/S Data Entry Amounts
        4.  B/S Data Entry Formulas
        5.  I/S Data Entry Formulas
        6.  C/S Data Entry Formulas
        7.  Seasonal Percentages


     Upper/Lower
     -----------

     This will allow you to convert account descriptions to
     Upper or Lower case on a global scale. When you
     convert to Lower case the first letter will be capitalized.
     Use of this feature can be a nice touch when printing
     final reports. Options available are as follows

        1.  B/S Accounts - To Upper
        2.  I/S Accounts - To Upper
        3.  C/S Accounts - To Upper
        4.  B/S Accounts - To Lower
        5.  I/S Accounts - To Lower
        6.  C/S Accounts - To Lower


     TL to Up/Lw
     -----------

     This will allow you to convert account total descriptions
     to Upper or Lower case on a global scale (account
     totals are accounts such as Total Current Assets and
     Total Assets). When you convert to Lower case the first
     letter will be capitalized. Use of this feature can be a
     nice touch when printing final reports. Options available
     are as follows

        1.  B/S Account Totals - To Upper
        2.  I/S Account Totals - To Upper
        3.  C/S Account Totals - To Upper
        4.  B/S Account Totals - To Lower
        5.  I/S Account Totals - To Lower
        6.  C/S Account Totals - To Lower


     Sp to Up/Lw
     -----------

     This will allow you to convert special account
     descriptions to Upper or Lower case on a global scale
     (special accounts are those reserved for use by FW,
     such as MARKETABLE SECURITIES (#1040000) and
     NOTES RECEIVABLE (#111000)). When you convert to
     Lower case the first letter will be capitalized. Use of this
     feature can be a nice touch when printing final reports.
     Options available are as follows

        1.  B/S Special Accounts - To Upper
        2.  I/S Special Accounts - To Upper
        3.  B/S Special Accounts - To Lower
        4.  I/S Special Accounts - To Lower


     LOTUS Conv
     ----------

     FW Calculation and Monthly Calc reports may be
     exported to LOTUS. FW creates data files in the "WONDER"
     directory on your hard drive which may then be called
     directly by LOTUS. Files created will be complete with
     pre-arranged cell widths, range names by group (ex: Total
     Current Assets), and SUM of rows or ranges. Although the
     LOTUS file will not be interactive, the range names will
     make it easy for you to modify the file if you wish.

                   File Created
                   ------------
     1. B/S Calc          - To Lotus    BSP.WK1
     2. B/S MonthlyCalc   - To Lotus    BSM.WK1
     3. I/S Calc          - To Lotus    ISP.WK1
     4. I/S MonthlyCalc   - To Lotus    ISM.WK1
     5. C/S Calc          - To Lotus    CSP.WK1
     6. C/S MonthlyCalc   - To Lotus    CSM.WK1
     7. FASB 95 - Calc    - To Lotus    RCSP.WK1
     8. FASB 95 - MCalc   - To Lotus    RCSM.WK1

     The FASB 95 Cash Statements may use either the Direct or the
     Indirect method; individually selectable at the time you
     create the Lotus files.

     As the files created are not arranged in strict LOTUS
     format, you may need to load these files into LOTUS,
     and re-save from LOTUS before using them in some
     LOTUS compatible spreadsheet programs - although we have not
     noted any such problem. Quattro, Excel, 1-2-3 2.0 and 2.01,
     Lotus Release 3, and SuperCalc5 can all read our files
     directly.

     Files created with the extension .WK1 are compatible
     with LOTUS version 2 and above. However, these files
     are also compatible with version 1a by renaming the files
     to use the .WKS extension or Symphony version 1.2 by
     renaming the files to use the .WR1 extension.


QUIT/DOS
--------

     DOS
     ---

     This will exit to DOS while maintaining your FW program.
     The program will call-up a second copy of
     COMMAND.COM. You will be able to perform all of your
     regular DOS commands. But, please refrain from calling
     up any fair sized programs as the second program
     would need room to co-exist with FW and might lock-
     up both programs. To return to FW, type EXIT at the
     DOS prompt. FW will continue from the point where you
     left. (NOTE: Your DOS PATH statement must be able to
     locate COMMAND.COM).


     Quit
     ----

     This will exit you from FW. Always exit FW through this
     feature so that allocated memory can be returned to the
     system. There is a safety prompt to avoid accidentally
     exiting the program prior to saving your work.
