

                                                                37
                                                   Troubleshooting



This section should alleviate any installation or operating
problems.

Note:
-----
Only a few of our customers will have any difficulty installing or
operating Financial Wonder. However, this is no consolation if
you are experiencing problems. We are software developers. We
do not have super expertise in writing operating systems or device
drivers. Nor are we hardware experts. However, this section may
be very beneficial to you; even if FW is operating to perfection.
Many of the suggestions made are the result of our own
experiences, both in testing FW, and in our own hardware
problems over the years. There are several excellent books on
maintaining and fixing computer equipment. We assume no
liability for our suggestions. We have provided this section to help
in pinpointing hardware and software problems you may be
experiencing.



Topics
======

   Hardware Requirements
   Networks & DesqView
   Toshiba DOS
   Windows 3.x
   Print Driver Setup
   Printer operates, but only prints on one line
   Printer Skips Several Lines
   Which Printer Version?
   Loading the Print Driver Took A Long Time
   Device Drivers
   Strange Happenings
   FW Memory Needs
   Determine Available Memory
   Increasing Available Memory



Hardware Requirements
=====================

Financial Wonder ("FW") requires:

      1)  an IBM PC or compatible
      2)  a hard drive with at least 3 megabytes available
      3)  640KB of memory
      4)  MS-DOS 3.1 or PC-DOS 3.1, or higher

A computer that does not meet these minimum requirements
cannot operate FW.



Networks & DesqView
===================

FW will operate across a network, but only one user should run FW
for each license purchased. FW does not contain file locking, so
care should be taken that two users are not updating the same file
at the same time. The second user's "save" would overwrite the first
user's work.

Those using NetWare should set the print setup (SLATE) to
"Network via NetWare", and the port number starting with "0".

Those using NETBIOS should use the standard "Parallel via
BIOS" and set the "printer timeout period" available on most
networks.

Although unlikely, you may experience some problems running
FW across a network or DesqView. Sharing violations may arise
while SHARE.EXE is operating. If this occurs, use the MS-DOS
"attrib" command to make the files FW.EXE, FW1.OVL, and
FW2.OVL "read only". However, remember to change their
attribute back, prior to updating for future versions.



Toshiba DOS
===========

Toshiba's EMM.SYS driver LIM 3.2, provided with their DOS 3.3,
is not fully compatible with the LIM 3.2 standard and will not
work with FW.

However, there is nothing incompatible about the Toshiba
machines. You have two choices.

1) Leave off (this is the default setting) our caching for code
   swapping for expanded memory only. This is detailed in
   chapter 36.

   You may use expanded memory for data storage
   (FW's spreadsheet file), as there appears to be no
   incompatibility with our virtual memory manager for data.
   FW will automatically use expanded memory for data storage,
   if present.

2) Simply use another EMM.SYS driver, such as QEMM, 386 to
   the MAX, or Memory Commander.

We have not as yet determined if their LIM 4.0 driver, supplied
with Toshiba DOS 4.0 has similar problems.



Windows 3.x
===========

FW's virtual memory management is compatible with the Microsoft
Windows 3.0 operating system. Although not a windows program,
FW will operate as a DOS program under the standard or 386
enhanced modes of Windows 3, using the full 5000 financial
account maximum. A PIF file should be set up within Windows to
allocate expanded or extended memory to FW, prior to running FW.
You should then operate FW from this PIF file, not the EXE file.
We have included an example PIF file in your WONDER directory.
You should modify this file to meet your available resources.



Print Driver Setup
==================

Setting up print drivers is a two step process.

1) Use SLATE.EXE to load the print driver.

2) Use SLATE.EXE to assign the printer to a hardware port.

In a typical computer with one parallel port, you will assign all
print drivers to that one port, LPT1.

Slate's main menu has three choices. The first two are the two
steps just covered. The third is meant for graphics and third party
fonts. FW does not support this third option.

   Number of Printers
   ------------------
     You may install any number of print drivers. While 10 or
     15 should not noticeably slow printing, the installation of
     many drivers will slow printing, and is not suggested.

     You should not install more than one setup for each printer. FW
     cannot distinguish between multiple installations of the same print
     driver.

   Ports
   -----
     As just noted, if you have one parallel port, you may
     assign all print drivers to that one port. As only one driver
     is used at a time, there will be no conflict.

   Printer Device
   --------------
     While assigning a port, you are asked for the printer
     manufacturer and type. Make your selections by first
     pressing F9. These names must be exact.

   Re-installing Drivers
   ---------------------
     If you have installed a particular print driver, DO NOT
     re-install that same driver. This may confuse FW, and
     result in your having to erase your file, slate.pdb, and start
     over. [If no slate.pdb file exists, slate.exe will create one].

   Erasing Slate.pdb file
   ----------------------
     The slate.pdb file stores all installed print drivers and port
     assignments. If you need to re-create slate.pdb you must
     install the print driver last used by FW. FW stores and
     retrieves the last used print driver. When FW is loaded,
     it expects the slate.pdb file to contain that last used
     driver. However, the order of that driver within the
     slate.pdb file, and its port assignment, are not important
     to FW.

     FW comes set to the HP LaserJet II. For compatibility
     with the current program, and all future upgrades, this
     driver should always be included in any installation.



Printer operates, but prints on only one line
=============================================

This is a situation where the printer operates, but does not move
to the next line. It keeps printing over the same line.

Your printer has an "AUTO FEED" setting. Turn this feature off,
so that auto feed will be "Not Fixed Internally", instead of "Fixed
Internally". This will allow FW, as well as other software
programs, to operate line feeds.



Printer Skips Several Lines
===========================

In this situation, the printer skips several lines at the top of the
first page. The second page skips twice the number of lines, etc.

Many printers have a "Skip Perforation" setting. Turn this setting
off.



Which Printer Version?
======================

Some printers have more than one version. Epson is a good
example of this. Different versions of the same printer operate
differently. You need to know which version of the printer you
own. This may be noted on the inside or outside of your printer.
If you are not sure, Epson may be able to tell you based on your
serial number. If all else fails, try each of the drivers available.
BrainChild Software does not have any listing to help you in this
regard.



Loading the Print Driver Took A Long Time
=========================================

If the installation of a print driver took a very long time, there is
a strong possibility that your operating system, presently in
memory, has been corrupted for one of a slew of reasons.

If this is the case, a simple reboot of the computer will be your
first step.

It is also safe to assume that you need to redo the installation. If
this is a first time installation, the safest course of action is to
erase the slate.exe and slate.pdb files, and reinstall FW. Only
these two files will be replaced by FW.



Device Drivers
==============

FW should work with all EMS 3.2 and 4.0 drivers
[Lotus/Intel/Microsoft Expanded Memory Specification].

In addition, FW should work with all XMS [Extended Memory
Specification] drivers. These drivers make use of upper memory
[640KB to 1024KB (1MB)], the High Memory Area [1024KB to
1088KB], and extended memory blocks [addresses above
1088KB].

Most of the third party products listed (see "Increasing
available memory", later in this chapter) include EMS 4.0 and
XMS drivers. In addition, some MS-DOS versions include EMS 3.2
drivers. If your present driver already provides XMS 2.0 or higher
support, DO NOT use the HIMEM.SYS driver supplied.

Only one driver appears to be incompatible. The EMS 3.2 driver
supplied with Toshiba's laptop MS-DOS 3.3 locks-up the
computer when FW exists. This same laptop [T-5100 80386]
operated perfectly with Quarterdeck's QEMM-386.

Generally, HIMEM.SYS must be positioned before any other
device drivers in your config.sys file. Although, QEMM-386
version 4.2 which did not include its own XMS driver, it appears,
should be positioned before HIMEM.SYS. Recent versions of
QEMM-386 now include the XMS driver.

Sometimes adding a new device driver to your config.sys causes
problems [with FW and other programs]. As you may already be
aware, your computer must be warm booted [Press CTRL and
ALT, hold down these keys and press DEL] to effect changes
made to your config.sys file. This also erases all programs
currently in memory. However, there have been occasions where
a warm boot is not sufficient. In these cases try a cold boot [turn
your computer off, wait 15-30 seconds, and then restart your
computer]. Several times we have seen a cold boot solve what a
warm boot would not.



Strange Happenings
==================

1)  PROBLEM:  Display problems appear. Reverse coloring does not
    appear. The program freezes. Information such as titles to columns
    will not display.

    This is most likely caused by first running a poorly written
    program from another manufacturer, then operating Financial
    Wonder. Try re-booting the computer (CTRL-ATL-DEL). If the
    problem persists perform a cold-boot by turning the computer off,
    wait 30 seconds, and turn the computer back on.

    Financial Wonder is a virtual memory program. Lotus 1-2-3
    version 2.3 and Quattro Pro are other examples. These programs are
    very advanced, and use the complete memory space of your
    computer. Therefore, they are more prone to memory corruption
    problems left over by improperly written software. If Financial
    Wonder operates or displays improperly, the culprit was one of the
    programs operated prior to running FW.


2)  PROBLEM:  FW operates as expected. Upon leaving FW the "C:"
    prompt appears, however the computer freezes at that point, or
    very shortly thereafter.

    This is most likely the result of an:
      a) incompatible device driver
      b) improper installation of that driver
      c) improper order of your drivers in your config.sys file
      d) or possibly a problem with one of the device driver's options
         on your particular machine.


3)  PROBLEM: Similar to the problem above, however other strange
    things are happening. "Sector not found errors" and MS-DOS error
    messages when copying files may also be present.

    This type of error can occur from using a faulty controller card, or
    formatting the hard drive with one model controller card, then
    switching controller cards.

    Another possibility is using a version of MS-DOS or PC-DOS not
    specifically approved by the computer's manufacturer. Each
    manufacturer modifies MS-DOS to fit their particular hardware. If
    you experience device driver problems, it may be the copy of
    MS-DOS you are using.


4)  PROBLEM: You may be experiencing many problems.

    a) Lotus files appear to take 20 minutes instead of a few seconds.
       The hard drive light is not lit.

    b) Another feature also takes an eternity. Once again the hard
       drive light is not lit.

    c) FW was operating for a time. Only now it takes a lot longer to
       load a file, and strange things are suddenly happening.

    d) Lots of garbage appears on the screen. Seconds or minutes later
       the program freezes.

    Although there is always the possibility of programming error, if
    this happens more than once there is an excellent chance that there
    is an equipment failure of some sort.

    Simple maintenance may solve the problem:

    1) Have you vacuumed out your computer recently, or cleaned
       your gold connectors. Dust and grime can cause overheating
       and missed electronic contacts.

    2) Has your floppy drive ever been cleaned. Dirt in your floppy
       drive may have caused an error when you installed FW.

    3) Hard drives can have fragmentation problems. Single files may
       be stored in several locations, with a part of your file in each
       location. After a while FW and your other programs start to
       have problems. This will be especially evident if one particular
       file is causing problems, while others do not. If this is the case
       try using Norton's "Speed Disk" or another de-fragmentor.

    4) Hard drives are rarely perfect. Several or even dozens of
       imperfections are common. If you have never checked out your
       hard drive, this could easily be your problem. It is also an easy
       one to check. Simply run a disk check from your Norton
       Integrator, PC Tools, or other utility program. If you do not
       own one of these programs get one! These tools can mark-off
       these bad areas forever.

       On occasion a bad sector will develop over time. Running your
       disk checker only takes a few minutes.

       If a bad sector is found and corrected, reinstall FW.

    5) Has it been several years since you performed a low-level
       format on your hard drive? The formatting that your program
       sits on is electronic. It fades with age. Even more important is
       drive alignment drift. Programs such as SpinRite II and Optune
       can save you from disaster. They can perform a low-level
       format without removing your present files. If this is the cause,
       it would be a good idea to re-install FW after using a program
       such as SpinRite II.
       (see PC Magazine's excellent article - January 29, 1991 page 379).

       Performing a low-level format (at least) every couple of years is
       just good maintenance. Don't wait for a software disaster to occur.

    6) If your computer is over a year old, some of your computer
       chips may have popped up slightly. Press down on all computer
       chips so that they are firmly seated in the board. Make sure
       that you first ground yourself before touching any internal parts.

    Hardware problems may also be the culprit:

    1) A bad hard drive can be causing your problem. Drives that are
       brand new, or very old, are the most likely candidates. SpinRite
       II and Optune can check out your hard drive in ways that few
       other programs can.

    2) A bad controller card can also cause problems. Errors in this
       computer part are especially hard to find, even with special
       maintenance programs.

    3) Test your memory chips, mother board, etc. Checkit is an
       excellent program for checking memory chips, hard drive bad
       sectors, floppy drives, DMA (direct memory access), interrupts, etc.

       Similar speed memory chips should be used. Do not mix
       different speed memory chips in the same bank. Also, some of
       the Japanese manufactured chips are much faster than their
       rating. If you mix different manufacturers' chips, you may be
       safer using all American or all Japanese.



FW Memory Needs
===============

On a standard 640K computer with MS-DOS 3.3, FW will leave about 100KB
available memory. At this point the entire FW program may be operated.



Determine Available Memory
==========================

Individuals are surprised to find that their 640KB computer does
not leave 640KB for applications such as FW. The DOS operating
system, files, buffers, etc. use some of this valuable memory.

Although the size of MS-DOS and some of the options vary from
computer to computer, the following will be reasonably accurate.

One particular computer contained the following memory uses:

      MS-DOS
      ------
        MS-DOS 3.3 uses 40,480 (this can vary up or down 2000
        bytes with different versions of MS-DOS 3.3).

      COMMAND.COM
      -----------
        Considered a part of MS-DOS, this uses 3536 bytes. In
        addition, an increase in the size of the environment space
        will increase the size of command.com.

      CONFIG.SYS
      ----------
        The setup of files, buffers, etc. uses 11,728 bytes (this may
        vary by a few hundred bytes). Device drivers, extra files
        and buffers, and other options will increase the size of the
        config.sys.

      FILES
      -----
        MS-DOS uses 8 files by default. Increasing the number of
        files uses from 48 to 56 bytes for each additional file.

      BUFFERS
      -------
        The default number of buffers varies based on hardware.
        On an 80386 this will likely be a default of 15 buffers.
        Increasing the number of buffers uses 528 bytes for each
        additional buffer.

      DEVICE DRIVERS
      --------------
        The amount of memory used by device drivers varies. On
        one particular computer we showed the following usage:

             ANSI.SYS                   1856 bytes
             HIMEM.SYS version 2.06     2144 bytes

      OTHER DOS OPTIONS
      -----------------
        One popular option is FASTOPEN. This is usually
        included at the end of your autoexec.bat file. On this
        particular computer FASTOPEN with the minimum
        number of 10, used 2128 bytes. Increasing the number
        uses about 37 byes for each additional number.

        Many computers have a mouse installed. Several
        companies produce mice. I will discuss the Microsoft
        mouse. The Microsoft mouse comes with two programs.
        The first is mouse.sys. This device driver is installed in
        your config.sys file. Our driver (dated 3/4/87) used 9744
        bytes. There is a second program, cpanel.com. This
        program appears to be only 11,180 bytes, but actually
        used 30,800 bytes. Cpanel.com is a TSR program that
        allows you to change the speed of the mouse, and is
        included in your autoexec.bat file. If you are looking for
        extra available memory, remove cpanel.com and save the
        30,800 bytes. Your mouse will still operate, only you will
        not be able to customize its speed.

      Typical System
      --------------
      1) Ok, let us try an example config.sys and autoexec.bat file:

            CONFIG.SYS
            ----------
              40,480 bytes      MS-DOS
               3,536            command.com
                 352            Increase environment space to 500
                                bytes to handle large autoexec.bat
                                files
              11,728            config.sys
                 648            Increase files to 20
               2,640            Increase buffers to 20
               1,856            ANSI.SYS
               9,744            MOUSE.SYS

            AUTOEXEC.BAT
            ------------
               3,608            FASTOPEN set to 50

      The use of third party programs, discussed below, will add
      additional memory.



Increasing Available Memory
===========================

Let's say that FW notifies you that there is sufficient memory to
operate FW.

You should now review your config.sys and autoexec.bat files.
These are generally found in your  C:\ [C drive, root directory]
drive. These may be viewed by moving to the C: drive and typing

    "TYPE CONFIG.SYS" or "TYPE AUTOEXEC.BAT".

Programs such as screen savers, which blank the screen while the
computer is not being used to extend the life of the monitor,
generally do not use much memory. However, network drivers
may be as large as 100KB. Mouse drivers and support programs
take from a few thousand to 40KB, menu selection screens take
additional memory, etc.

Once you have located the programs which are using up valuable
memory, you have a few options.

1)    Remove some of these programs from memory.

2)    Purchase a program such as
          V Communications: Memory Commander [80386, 80486]
          Quarterdeck:   QEMM-386 [80386]
                         QEMM-50/60 [IBM model 50 or 60]
                         QRAM [PC or AT with EMS 4.0 board]
          Qualitas:      386MAX 5.0 [80386]
                         BlueMAX [PS/2]
                         Move'em[Neat, AT/386 CHIPSet or fully
                         compatible EMS 4.0 memory board]
          Rybs Elect.:   HI386 [PC, XT, AT]

      These programs allow you to move drivers and smaller
      programs into upper memory (memory from 640KB to 1MB)
      and/or the High Memory Area (1MB to 1MB+64KB).

      In addition, these programs can also increase DOS memory
      by utilizing unused video memory addresses [starting at
      640KB]. Up to 96KB can be added from monochrome, color,
      EGA and VGA systems. Most will obtain benefits from
      monochrome and color card systems. Programs such as Rybs
      can obtain 96KB from EGA and VGA video systems.

      THE BEST SOLUTION
      -----------------
      For those with a 386 computer, and at least 512KB of extended
      memory, Memory Commander can provide up to 900KB+ of available
      contiguous DOS memory space.

      These programs will not only free up valuable memory for
      FW, but will also free up memory for Lotus, and all your
      other large applications.

      Memory Commander can move the location of video memory,
      however FW has been modified to be fully compatible with
      Memory Commander. This allows FW to continue writing
      directly to video memory for fast screen displays, only the
      location of video memory will be user selectable under
      Memory Commander.

      FW can operate at the highest level, "E", resulting in only a
      4K video area. Those operating FW across a network should
      use level "D". However, the highest level obtainable may
      vary with the video card installed.


