

                                                               36
                                                      Environment
                                                         Settings



FW has pre-selected cache sizes. You need not change these
settings. However, there may be times when you need to change
one of the settings.

Caches operate totally transparent to the user. Caches are
memory areas which are used to hold several parts of the FW
program. These caches may be overwritten as the user requests
other parts or features of FW. Caches speed the program as parts
of the program may be stored in memory, instead of having to be
called from the hard drive. The larger the cache, the more parts
of FW may be stored in memory, and the faster the program will
appear to operate. Caches may not be used to increase available
memory for your spreadsheet files.


Spreadsheet File Storage
------------------------

FW stores its spreadsheet in virtual memory. The spreadsheet you
view on the screen is not maintained in the 640KB MS-DOS
memory address space. All spreadsheet cells, formulas, and
calculations are stored in a combination of caches in conventional
memory (within 640KB), expanded memory, extended memory,
and temporary hard drive files - in that order.

FW (the program) operates within the 640KB address space. For
maximum speed, expanded memory should be provided. FW will
use available expanded memory first. If there is insufficient
expanded memory to meet FW's needs, additional memory will be
used from available extended memory. If additional memory is
needed, a temporary file will be set up on the hard drive under the
file name FW.DAT.

The retrieval of spreadsheet information from a temporary file on
the hard drive will be many times slower than if this information
were stored in memory chips, therefore we suggest that at least
1mb of expanded or extended memory be available. The first rows
in the spreadsheet will be moved into faster memory locations,
however some features require the need to review or change major
portions, or the entire spreadsheet. FW uses about 1000 bytes of
memory to store each financial account in its spreadsheet for a 36
month period.

At the same time that your spreadsheet is using virtual memory,
FW (the program) is storing major portions of its programming
instructions (code) on the hard drive. Portions of this code are
swapped in and out of memory, virtually. To speed up processing,
caches are set up in conventional, expanded and extended
memory -in that order.

Allocating large amounts of memory for program caching may
result in storing parts of the spreadsheet on the hard drive. If you
have available RAM memory (expanded or extended) there should
be no need to change the default settings.


Program Caches
--------------

The program caches can be modified (see the chapter on the
environment settings), however, if memory chips are scarce in your
machine, best results will be obtained by providing some expanded
memory for programming code, leaving the rest for storing
spreadsheet information (whatever is left will be used to store the
spreadsheet - automatically).

FW is a very advanced program. The program operates in
conventional memory with caches in conventional, expanded, and
extended memory. The spreadsheet stores its information
independently in its own set of caches in conventional, expanded
and extended memory, and a temporary hard drive file.

The spreadsheet's virtual memory can store up to 32 megabytes of
information. Some limitations on the number of rows or years of
information may apply to this specific version.


Conventional Memory
-------------------
  Those without expanded or extended memory will still have
  some caching available to them. The pre-set amount of 20KB
  can be increased to provide additional caching.


Expanded Memory
---------------
  FW can use expanded memory for caching.

  FW can run cached routines from expanded memory.
  Therefore, we do not need to copy these routines into
  conventional memory, which is the first 640K.

  The expanded memory manager must be compatible with
  EMS 3.2 or higher. FW cannot use expanded memory if your
  version is not compatible.


Extended Memory
---------------
  FW will use extended memory for caching. This includes
  memory starting at the 1064K memory location, and will not
  interfere with your use of the 64K High Memory Area, used by
  MS-DOS 5.0.

  FW cannot run cached routines from extended memory.
  However, copying routines from extended memory to either
  conventional memory or expanded memory is still faster than
  reading these routines from the hard drive. Expanded
  memory will operate faster than extended memory, however,
  extended will be faster than just using the hard drive.

  FW will not use extended memory unless an XMS driver
  version 2.0 or higher driver is installed. You may use the
  HIMEM.SYS driver (which is an XMS driver) that comes
  with FW, or a third party product that provides the equivalent
  of HIMEM.SYS. In addition, VDISK.SYS may not be used,
  unless you are using MS-DOS or PC-DOS 4.0 or higher.
  VDISK is not compatible with XMS using MS-DOS 3.3 or
  lower.



Pre-set environment
===================

FW uses caches in conventional (regular 640KB), expanded, and
extended memory.

These settings are as follows:

      Conventional       20KB

      Expanded           0KB

      Extended           100 percent available memory, not being used
                         by other XMS programs

FW also has a virtual memory arena for the swapping of code,
which is similar to a cache. The size of this area cannot be
changed.

Some expanded memory drivers do not appear to be 100% compatible,
such as Toshiba's EMS driver. If you have expanded memory
available, you should consider re-setting the default settings.
(This expanded memory caching affects the speed of operating
code. Spreadsheet file storage will automatically use expanded
memory if present, and has no problem with any driver tested.)


Changing the pre-set settings
=============================

These settings may be easily changed. Either add a SET
command to your autoexec.bat file, or enter the command prior
to running FW.

      Conventional Memory
        SET RTVMCONV=<maximum allocated>

      Expanded Memory
        SET RTVMEXP=<maximum allocated>

      Extended Memory
        SET RTVMEXT=<maximum allocated>

The maximum allocated amount may be in the form of kilobyes
(KB), or as a percentage of available memory.


  Example #1:
  -----------
    This will increase conventional memory caches from 20KB to
    50KB:

          SET RTVMCONV=50

    This will speed up the program's operation, however it will
    also reduce the memory space available to run FW.


  Example #2:
  -----------
    To allow up to 75 percent of available expanded memory to be
    used for caching, instead of 100 percent, type:

          SET RTVMEXP=75.<percent symbol>

          NOTE:
          -----
          Our on-line text cannot reproduce the percent symbol,
          instead of "<percent symbol>" press SHIFT and the number 5
          on your keyboard.

    In this example, 75 percent will be the maximum allocated. If
    less is needed, less will be used. As FW uses only conventional
    memory to store files, increasing expanded or extended memory
    will not reduce the space needed for files.

    Since FW can run cached routines from expanded memory,
    it may be more beneficial to use available expanded memory,
    instead of valuable conventional memory space.

    If you must increase conventional memory space, and you
    have available expanded memory, you might try eliminating
    the conventional cache by typing "SET RTVMCONV=0".
    The speed difference may not be significant.

FW uses the .RTLINK+ virtual memory linker from Pocket Soft,
Inc. If you have other programs produced with this virtual
memory linker, then any environment changes made with the SET
command will also apply to those other programs. The effect of
the SET command is temporary. These changes will be removed
is you reboot your system. For this reason, permanent changes
should be made in your autoexec.bat file.

