

                                                               35
                                                    Consolidation
                                                             Mode


Options
=======

The three available options in the REPORT and
CONSOLIDATION MODES will initially be set to NO whenever
you create or load a report file or consolidation file. This will
insure that previously created financial information will not be
modified until you elect to modify.

This message will appear on the screen the first time you attempt to
recalculate your newly created or previously saved file. Of course,
you may change any of these powerful options. This is meant as a
safety feature.



DEFINITIONS
===========

These definitions will help clarify FW's three modes of operation.


  BUDGET  MODE
  ------------
      Financial Wonder's spreadsheets can operate three different
      ways, called modes. The BUDGET MODE is the standard
      mode of operation. Budgets are produced by using either a
      previously saved (.WDR) file, or by requesting a new file.

      New files have a standard set of over 250 financial accounts,
      all pre-programmed. The most basic set of formula methods
      are used. New sub-accounts may then be created and changes
      may be made to formula methods. Opening balances and
      forecast amounts or percentages may now be entered.

      Previously created (.WDR) files may be loaded, modified, and
      then saved under the same, or a different name. This allows
      you to re-use previously created files. Features also allow you
      to erase the amounts, seasonality chart, and formula methods
      allowing you to create templates from previously saved files.

      Data is entered in a combination of monthly/quarterly/annual
      forecast periods. FW spreads your assumptions to create
      monthly sets of financials. For example, you might forecast
      each financial account for the next three years as three
      annual amounts or percentages. FW will create 36 complete
      sets of monthly forecasts for you. FW will also summarize the
      monthly amounts in the same period size as you selected. In
      this example, FW would display annual results, along with the
      individual monthly results.


  REPORT  MODE
  ------------
      REPORT MODE takes the BUDGET MODE one step
      further. Instead of working with formula methods, this mode
      allows you to work with the monthly results created in the
      BUDGET MODE.

      Simply load your BUDGET MODE file into the REPORT
      MODE, using the menu option "Create Report File from
      Saved Budget". THAT'S IT!

      Your use of spreadsheets is now reversed. Whereas you made
      use of formula methods and data entry periods in the
      BUDGET MODE, you no longer need formula methods.
      Modifications may be made to the monthly results, previously
      calculated in the BUDGET MODE. New sub-accounts may
      also be created, and of course you may recalculate your file
      to update cash flow, interest on cash flow, and taxation.

      The REPORT MODE also acts as a report writer. For
      example, in the BUDGET MODE you may have created your
      forecast by entering data into three annual periods. Within
      the BUDGET MODE, your results would be displayed in
      both annual and monthly spreadsheets. However, let's say that
      you would like to display your results quarterly. Once you
      enter the REPORT MODE, you may now summarize your
      monthly results in any fashion.

      REPORT MODE files cannot be turned-back into BUDGET
      MODE files.

      Financial accounts may not be "marked for deletion" in the
      REPORT MODE. However, new sub-accounts may be
      inserted, or deleted.

      A thorough discussion of the REPORT MODE is contained
      in chapter 34.


  .SET FILE
  ---------
      Before FW can perform its consolidation magic, the user must
      create a SETUP file. This file simply lists the files to be
      consolidated. There are several options for each file to be
      combined.


  .CFL FILE
  ---------
      After creating the .SET file, a consolidation can be created.
      Under the "LOAD FILE" menu selection, select the option to
      create a consolidation. Then select your .SET file from the
      listing provided. FW will store the monthly results from each
      file selected into a .CFL file using the same name as the .SET
      file (for example, AllFiles.SET and AllFiles.CFL). In this example,
      the resulting consolidated file will be named AllFiles.CNS.

      NOTE: You may change the name of your .CNS file when you save
      it, however, DO NOT change the name of the .CFL file. The
      .CNS file will forever retain the detail file's name
      [AllFiles.CFL].
      (When we refer to changing the name of the file, we mean
      the first eight characters of the file name up to the period.)


  CONSOLIDATION  MODE
  -------------------
      The CONSOLIDATION MODE (.CNS files) is exactly the
      same as the REPORT MODE, with only a few exceptions.

        1)  Instead of turning one BUDGET MODE file into a
            REPORT MODE file, many BUDGET, REPORT and
            CONSOLIDATION files are combined into one
            CONSOLIDATION MODE file.

        2)  Percentage of file, currency rate adjustment, and format
            (# of $000) adjustment may be performed on each file
            to be combined.

        3)  Consolidating details from each file are maintained in
            a separate .CFL file [on the hard drive]. This detail may
            be displayed on-line, printed, or converted into a Lotus
            1-2-3 readable file.

      CONSOLIDATION MODE files cannot be turned-back into
      BUDGET MODE files.

      Financial accounts may not be "marked for deletion" in the
      CONSOLIDATION MODE. However, new sub-accounts may
      be inserted, or deleted.


  CONSOLIDATED REPORTING
  ----------------------
      Consolidated reports consist of printouts, reports, and
      conversion to Lotus 1-2-3. These reports will show one total
      for each account.


  CONSOLIDATING OR DETAILED REPORTING
  -----------------------------------
      Consolidating reports consist of printouts and conversion to
      Lotus 1-2-3. These reports will all display the account
      number, account description [underlined], and the account
      total [underlined], followed by the individual amounts from
      each file plus any adjusting amount.

      EXAMPLE:
      --------
      Consolidated acct #100000, Cash, has a balance of $5000 (for
      the first month):

          File #1 contributed $400.
          File #2 contributed $0.
          File #3 contributed $1000.
          The difference of $3600 was an elimination entry made to
          the consolidated file.

      The printout will look as follows:

          Acct #       Account Description     1/1991
          ------       -------------------     ------

          100000       Cash                    $5000
                       ----                    -----
                       ELIMINATIONS             3600
                       File #1                   400
                       File #3                  1000

      File #2 will not be shown printed or converted to 1-2-3, since
      that file provided no dollar amounts [for any period in the
      three year forecast]. The title "ELIMINATIONS" is
      consistently used by the program, however, like the title "File
      #2", it will only be printed if adjustments have been made.
      The titles "File #1, File #2, and File #3" were selected by the
      user. Company names, or other descriptions may be used. FW
      uses the descriptions contained in the ".SET" file.



CONSOLIDATION MODE
==================

This MODE provides the following benefits:

1)  Consolidations is a fairly simple process. One SETUP screen
    is all that is needed.

2)  CONSOLIDATE of up to 100 files at a time. Different account
    structures may exist in the various files. NO template or other
    arrangement of the financial accounts by the user will be
    necessary. FW will review all the financial account structures,
    and perform all sorting, for you.

3)  BUDGET MODE (.WDR), REPORT MODE (.RPT), and CONSOLIDATION MODE
    (.CNS) may be consolidated.

    Since .CNS files may be consolidated, multi-level consolidations
    may be created. However, detailed reports will handle the .CNS
    file [to be consolidated] as one file, and will not [at this time]
    display the details that went into its creation.

    Multi-level consolidations allow for the consolidation of an
    unlimited number of files.

4)  Full consolidating details of the monthly results of each file
    consolidated will be preserved in a consolidating file (.CFL).

5)  Eliminations [elimination entries] may be made to the
    consolidated file, or a separate elimination file may be made
    as a .WDR or .RPT file.

6)  New sub-accounts may be added to the consolidated file.

7)  Consolidating detail for any account may be viewed on-line,
    at any time. FW will quickly sort through the corresponding
    .CFL, and will display all monthly amounts for that account
    for each of the [up to] 100 files combined, in a scrolling
    spreadsheet. Details may also be arranged according to your
    current Data Entry setup of months/quarters/years. Adjustments
    made to the consolidated file will be shown as "eliminations"
    on the spreadsheet.

8)  Detailed printouts and Lotus 1-2-3 files may be produced.

9)  CONSOLIDATION MODE files will be fully-functional. They will
    operate similar to REPORT MODE files, only with the added power
    to read details out of the .CFL file.

10) Multiple CONSOLIDATION MODE files may be created from just one
    .CFL file. This allows you to create and save various scenarios,
    all originating from one .CFL file.



CREATING CONSOLIDATED FILES
===========================

The following steps must be followed to create a consolidated file.

1)  All .WDR, .RPT and .CNS files should have been
    recalculated after final changes have been made.

    FW uses the last saved monthly calculations from each file.

2)  Create and save your SETUP file (explained below).

3)  Select the menu option "LOAD FILE", and choose "Create
    Consolidation File From Setup".

    FW will first verify that all files to be consolidated, exist in
    your \WONDER\DATA directory.

    FW will create the .CFL file (consolidating file containing the
    monthly details from each financial account for each file).

    FW will then sort all accounts, combine all amounts, and
    leave the user with a .CNS consolidated file.

    On a 20mhz computer, FW will need about 30 seconds (to
    update the .CFL file) per file being combined, plus an
    additional 20-30 seconds for sorting. When consolidating a
    large number of companies, you may wish to use multi-level
    consolidations to reduce processing time.

    WARNING
    -------
      FW will not know how many financial accounts a particular
      consolidation will produce, until it finishes its sort. It is
      possible that the completed .CNS file will be too large to fit
      within the number of accounts allocated at the start of the program.
      If the file is too large, FW will have no choice but to exit the
      program. As only one file can exist in FW at a time, this may be
      inconvenient, but should not cause any damage. Simply increase the
      maximum number of financial accounts, and re-run the consoliation.

      At this time, FW DOES NOT review your available hard
      drive space to determine if adequate space is available to
      hold the consolidating file (.CFL). Expect the size of your
      .CFL file to be at least 55K times the number of files to be
      combined.

      Duplicate numbered accounts (several files containing the
      same numbered account or sub-account), such as the use of
      a cash account #100001, will only have the memory
      requirements of one account. With available space on your
      hard drive, and memory to handle the total number of
      distinct accounts, you could create a 100 file consolidation.
      Expect your .CFL to be at least 55K in size times the number
      of files to be combined. A 100 file consolidation would have
      a .CFL file at least 5.5mb in size, and contain over 1,100,000
      financial numbers. Adding 200 to 300 new sub-accounts to
      each of these 100 files would increase the file's size to over
      10mb and over 2,000,000 financial calculation amounts. Amazing
      that all this can be accomplished on an XT or 286 machine.

4)  You should now save your .CNS file under the current, or a
    new name. IF YOU DO NOT SAVE YOUR FILE, YOU MUST RE-RUN STEP #3.
    ONLY A .CNS FILE CAN MAKE USE OF A .CFL FILE.



CREATING THE SETUP FILE
=======================
Before FW can perform its consolidation magic, the user must
create a SETUP file. SETUP files are stored as .SET files (all file
names will have an extension of .SET). They may be modified at
any time.

Standard spreadsheet commands operate. The entire width of the
spreadsheet is displayed, so there is no need to scroll to the right.
Down, Up, PageDown, PageUp, Home, and End allow you to
move up and down the spreadsheet.

    Company Number
    --------------
      FW can consolidate up to 100 files. The file number is
      displayed on the far left.

      Files include:
      1)  Any previously saved file (.WDR, .RPT, and .CNS).
      2)  The same file may be combined more than once.

      Files may be listed in any order. For example, FW can easily
      combine files numbered 1,3,5 and 7. They do not have to be
      listed in numerical order as 1,2,3 and 4.


    Company Name
    ------------
      Each file will have a company or file name. This name will
      appear on each detailed report. These names may be the
      file's company name, or any other description you choose.

      The company name may also be changed at any time after
      the consolidation is calculated.


    File Name / File Type
    ---------------------
      MS-DOS file names may be up to eight characters long,
      followed by a period and a three character file name
      extension.

      Enter the eight character file name under the column titled
      "File Name".

      Next, select your three character file name extension by
      selecting #1, #2 or #3 under the column titled "Type".

          #1 signifies .WDR files (BUDGET MODE files)
          #2 signifies .RPT files (REPORT MODE files)
          #3 signifies .CNS files (CONSOLIDATION MODE files)

      As you change your selection (1,2 or 3), the file name
      extension, displayed to the left of the column "Type" will
      display your selection as .WDR, .RPT or .CNS.

      Because FW can consolidate .CNS files, you may consolidate
      an unlimited number of files.

      Example:
      --------
        You can create 100 SETUP files, each consolidating 100
        files. The 100 SETUP files will create 100 .CNS files. These
        100 .CNS could then be combined to produce one final
        .CNS file. This one .CNS file would represent the
        consolidation of 10,000 individual files (100 SETUP's of 100
        files each). In this way multi-level consolidations may be
        produced, with an unlimited number of levels.

      .CNS files that are consolidated (included as a file in a
      SETUP) are considered one file. The details that went into
      creating that first .CNS file are not carried into the second
      SETUP file. In the above example, the second SETUP file
      will contain detail from the 100 .CNS files combined, not the
      10,000 files. Of course, you could load each of the 100 .CNS
      files to obtain further details.


    $
   ---
      The "$" column asks whether the file should be adjusted for
      $ Units.

      In the menu selection "Information for Setup", completed for
      each .WDR, .RPT or .CNS file, the "$ Unit" requested that
      you signify if amounts were represented in $, $1000 or
      $1,000,000. Printouts noted that amounts were rounded to the
      nearest $1000 or $1,000,000.

      By your selecting "Y" for Yes, FW will adjust these files, using
      the $ Unit selections of each .WDR, .RPT or .CNS file, into
      a new common $ Unit format.

      Example:
      --------
        If you select the new common $ Unit format to be $, and
        a .WDR file used amounts in $1000, all amounts in that
        file will be multiplied by 1000 for the consolidation.

      Upon the completion of changes to your SETUP file, FW will
      review your file for any "Y"'s. If any exist, you will be
      prompted for a new common $ Unit format.


    Level
    -----
      This is for display only. It reminds you that the first file is
      considered the top consolidation file, followed by the 1st
      subsidiary file, 2nd subsidiary file, etc.

      FW combines accounts by account number, not account
      descriptions. The order of your files, from "Top" to last "Sub"
      is significant for account descriptions, and the order of files
      for detailed reports. Account descriptions will be stored from
      the first file to contain that account number. Therefore, most
      of your combined file's account descriptions will be produced
      by your first, or "Top", file.


    S
   ---
      "S" in this column stands for setup. By setup, we are referring
      to a file's color selections, "Information for Setup", ratio
      analysis ranges, etc.

      The setup may only come from one file, and one file must be
      selected. This file may be a .WDR, .RPT or .CNS file.


    Percent Consolidate
    -------------------
      Although you will generally consolidate 100 percent of the file,
      there may be times where you wish to consolidate less than
      100 percent. For example, you may wish to consolidate your
      ownership percentage, instead of recording 100 percent ownership,
      less a minority interest offset.

      100 percent will record all file $ amounts without adjustment.



    $ Rate
    ------
      A different monetary conversion rate may be selected for
      each file.

      Each $ amount will be multiplied by your file's rate. A rate of
      1.0 will have no effect. A rate of .80, times a $100 amount,
      would be recorded as $80.


    Percent NOL's
    -------------
      This will combine the NOL (Net Operating Loss) from your
      files. FW uses the amount in the menu selection "Information
      for Setup", completed for each .WDR, .RPT or .CNS file.
      NOL amounts are used for the calculation of tax expense.

When you have finished creating a new .SET file or modifying an
existing .SET file, you may SAVE your file under the same file
name or a new file name, or you may ESCAPE without saving
your changes.



Features Available to a .CNS File
=================================

All features available to a REPORT MODE file are available to
a CONSOLIDATION MODE file.

Instead of making journal entries to record elimination entries,
you will change amounts directly on the screen.

A few other features are also available.

    On-Line Details
    ---------------
      From your MONTHLY CALC screen press CTRL-F7 (hold
      down the CTRL key and then press the F7 key). FW will load
      the .CNS file's .SET file, read the .SET file, and then load all
      of the monthly detail related to the financial account of the
      current row (the row where the cursor, or cell_block, resides).
      This information has been previously stored in your .CFL file.

      A spreadsheet will appear that contains all the monthly
      details for the entire 36 month forecast [plus the opening
      balance sheet], for all 100 files consolidated. Changes made
      to the spreadsheet will appear on the top row, and will be
      labeled "ELIMINATIONS".

      From this spreadsheet you may press CTRL-F7 again. This
      will now display your monthly detail summarized by
      month/quarter/year, according to your current data entry
      setup.

      Pressing the ESC key twice will lead you right back to your
      MONTHLY CALC spreadsheet; right where you left.

      A similar spreadsheet may also be obtained from your CALC
      screens. Your first screen will be displayed summarized.
      Pressing CTRL-F7 a second time will display the monthly
      details.

      NOTE:
      -----
        Most ratio accounts may not be displayed summarized by
        month/quarter/year, as this information cannot be readily
        obtained or summarized from the .CFL file.

        Accounts numbered 300000 to 313000, shares of stock and
        discount rates, will not show an elimination amount, as
        elimination amounts have no importance to these financial
        accounts.


    Printing Details / Lotus 1-2-3 Details
    --------------------------------------
      FW can print detailed printouts and detailed Lotus 1-2-3 files.
      Files which may be printed as detailed, are noted on the
      selection screens. All detailed reporting will display account
      numbers, account descriptions [underlined], consolidated
      totals [underlined], and all details.

      Because FW must review the .CFL file to build the details for
      each financial account, these printouts and 1-2-3 files will take
      longer to create than non-detailed reporting.


      See "CONSOLIDATING OR DETAILED REPORTING"
      under definitions above, for further details.

      EXAMPLE:
      --------
        The cash statement converted to a 1-2-3 file for a three file
        consolidation, will have a file size of about 500K and include
        40,000 cells. Calculation time on a 20mhz machine will be
        about 1.5 minutes. The balance sheet and income statement
        will be smaller, as there are fewer accounts.


