

                                                               30
                                              I/S Formula Method:
                                        Incr Prev Bal by Annual Percent



NUMBER       FORMULA METHOD DESCRIBED
------       ------------------------

231          I/S - Increment the PrevBal by an
                   Annual Percent - COMPOUNDED
                   Exact seasonal amount

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier (Monthly Calc) monthly amount to arrive at the current amount.
    The percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

         Size of Cur Prd     pct Entered     pctChange Used
         ---------------     ---------     ------------
         Month               10pct           .79741404pct
         Quarter             10pct           2.41136891pct
         Year                10pct           10pct

    The amount will be divided in such a manner as to create a constant rate
    of growth across the monthly amounts. These results (prior to rounding to
    the nearest whole dollar) are then adjusted on a monthly weighted
    seasonal basis. The seasonal percentages used are those related to the
    period chosen, as entered in the seasonal screen selected. As a result of 
    swings in the monthly seasonality, the cumulative amount at the end of 
    the period may not equal the growth over the previous monthly amount.

USE
    You as the forecaster determine the amount of annual growth or decline in
    the cumulative amount over the earlier (Monthly Calc) monthly amount.
    This amount is adjusted for period size differences. FW then calculates
    the monthly amounts in such a manner as to create a constant rate of
    growth across the monthly amounts. The growth rate assumes a monthly
    compounding of the rate. FW then uses the seasonal percentages input. The
    program knows which months relate to the current Data Entry period,
    obtains the related seasonal percentages from the seasonal screen,
    calculates a weighted average based on the total of these percentages and
    completes the calculation.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate and then
    seasonally adjusted before rounding is performed. Future forecast periods
    and the use of these amounts as a linked account refer to the final whole
    dollar results.

    Formula Method 231 is similar to 224 when used in an annual period.
    However, in a Quarterly or Monthly period Formula Method 231 calculates
    the compounded rate for the period size whereas 224 merely takes a
    portion of the annual rate (for example, 1/4 or 1/12). In addition,
    as a result of swings in the monthly seasonality, the balance at the
    end of the period may not equal the growth over the previous monthly
    amount.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 231 will not
    be used by FW. Instead Formula Method 222 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!

    Seasonality Adjustment
    ----------------------
    If the previous Data Entry formula method was a seasonal income formula
    method (methods 202, 204, 206, 208, 212, 214, 216, 218, 222, 224, 231 and
    232) then the last monthly calculated amount will have its seasonality
    removed (only for the purpose of performing the current period
    calculation - the previous amount will NOT actually be changed). This
    will eliminate over/under inflated calculations in the use of this method
    in the immediate subsequent period.

    For example, if the current quarterly period is forecast as $750 (or as a
    growth percentage), and the last calculated monthly amount used a
    seasonal income formula method, and that amount was $100 with a 5pct
    seasonal rate for that month, then the prior amount will be re-cast as
    follows:

           ($100 * 3(months in the current forecast period))
                          /
                   (5pct * 12(months)/100pct)
           =  $500.
           $750/$500 is a 50pct increase over the previous period.




NUMBER       FORMULA METHOD DESCRIBED
------       ------------------------

231          I/S - Increment the PrevBal by an
                   Annual Percent - COMPOUNDED
                   Exact seasonal amount

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $1200-December
          Assumption:   The earlier monthly amount (Nov 1990) is $1140
              Method:   Select Formula Method 231 for the Month Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would represent
                        a 7.97414043pct rate for one month with monthly
                        compounding ($1140 * 12 months * 110pct * .0797414043
                        = $1199.95 or $1200). Since the period size is only
                        one month, no spreading is necessary.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $714-Oct, $384-Nov, $242-Dec
          Assumption:   The earlier monthly amount (Sep 1990) is $377
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 231 for the Quarter Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would
                        represent a 2.41136891pct rate for one quarter with
                        monthly compounding, before seasonal adjustment
                        ($377 * 12 months * 110pct * .2411368908 = $1199.99
                        seasonally adjusted to $1340.19 or $1340). The
                        program will spread the $1340 over the current
                        quarter's monthly periods in such a manner as to
                        create a constant rate of growth across the monthly
                        amounts. These results are then adjusted on a monthly
                        weighted seasonal basis. Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!
   (Oct .0797414043 is calc by FW, representing the portion of the year:
    Nov .0803772734 = 10(1.00797414043^2 - 1 - .00797414043)
    Dec .0810182131 = 10(1.00797414043^3 - 1 - .00797414043 - .00803772734)

   Oct = $714 = $714.29 = $377 * 12 * 1.1 * .0797414043 * (15pct/(100pct/12))
   Nov = $384 = $383.99 = $377 * 12 * 1.1 * .0803772734 *  (8pct/(100pct/12))
   Dec = $242 = $241.91 = $377 * 12 * 1.1 * .0810182131 *  (5pct/(100pct/12))

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $690-Jan, $231-Feb, $234-Mar,
                        $471-Apr, $474-May, $479-Jun,
                        $337-Jul, $341-Aug, $147-Sep,
                        $740-Oct, $399-Nov, $250-Dec
          Assumption:   The earlier monthly amount (Dec 1989) is $364
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 231 for the Year Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen ($364 * 12 months * 110pct * 1 =
                        $4804.80 seasonally adjusted to $4793.43 or $4793).
                        The program will spread the $4793 over the current
                        year's monthly periods in such a manner as to create
                        a constant rate of growth across the monthly amounts.
                        These results are then adjusted on a monthly weighted
                        seasonal basis. (Although the spread in the results
                        is not dramatic, larger numbers would show a more
                        dramatic effect.) Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!
   (Jan .0797414043 is calc by FW, representing the portion of the year:
    Feb .0803772734 = 10(1.00797414043^2 - 1 - .00797414043)
    Mar .0810182131 = 10(1.00797414043^3 - 1 - .00797414043 - .00803772734)

   Jan = $690 = $689.65 = $364 * 12 * 1.1 * .0797414043 * (15pct/(100pct/12))
   Feb = $231 = $231.72 = $364 * 12 * 1.1 * .0803772734 *  (5pct/(100pct/12))
   Mar = $234 = $233.57 = $364 * 12 * 1.1 * .0810182131 *  (5pct/(100pct/12))
   Apr = $471 = $470.86 = $364 * 12 * 1.1 * .0816642637 * (10pct/(100pct/12))
   May = $474 = $474.61 = $364 * 12 * 1.1 * .0823154660 * (10pct/(100pct/12))
   Jun = $479 = $478.40 = $364 * 12 * 1.1 * .0829718611 * (10pct/(100pct/12))
   Jul = $337 = $337.55 = $364 * 12 * 1.1 * .0836334904 *  (7pct/(100pct/12))
   Aug = $341 = $340.24 = $364 * 12 * 1.1 * .0843003956 *  (7pct/(100pct/12))
   Sep = $147 = $146.98 = $364 * 12 * 1.1 * .0849726188 *  (3pct/(100pct/12))
   Oct = $740 = $740.76 = $364 * 12 * 1.1 * .0856502024 * (15pct/(100pct/12))
   Nov = $399 = $398.22 = $364 * 12 * 1.1 * .0863331891 *  (8pct/(100pct/12))
   Dec = $250 = $250.87 = $364 * 12 * 1.1 * .0870216221 *  (5pct/(100pct/12))




NUMBER       FORMULA METHOD DESCRIBED
------       ------------------------

232          I/S - Increment the PrevBal by an
                   Annual Percent - COMPOUNDED
                   Rounded seasonal amount

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier (Monthly Calc) monthly amount to arrive at the current amount.
    The percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

          Size of Cur Prd    Percent Entered    Percent Change Used
          ---------------    ---------------    -------------------
          Month              10pct              .79741404pct
          Quarter            10pct              2.41136891pct
          Year               10pct              10pct

    The amount will be divided in such a manner as to create a constant rate
    of growth across the monthly amounts. These results (prior to rounding to
    the nearest whole dollar) are then adjusted on a monthly weighted
    seasonal basis. The seasonal percentages used are those related to the
    period chosen, as entered in the seasonal screen selected. As a result of
    swings in the monthly seasonality, the cumulative amount at the end of
    the period may not equal the growth over the previous monthly amount.
    This method will take the difference between the pctChange Used (10pct is
    used in the examples) and that obtained under method 231, and allocates
    this amount to the individual months based on a weighted average basis.

    Example : in the Yearly example shown below, $409 with a 10pct growth =
              $449.9. However, the final month's result is $449.8. The
              difference of .10 would be allocated to January as follows:

              ($414.8706 - $409) / ($449.8018 - $409) * $0.10 = $0.0144
              $414.8706 + $0.0144 = $414.885 or $415.

    Needless to say this example looks awfully finicky. However, when dealing
    with large dollar amounts and big swings in seasonality or where rounding
    differences are bothersome, this method is available for your use. With
    FW you can afford to be finicky, sit back, and let the computer do all
    the hard work!

USE
    You as the forecaster determine the amount of annual growth or decline in
    the cumulative amount over the earlier (Monthly Calc) monthly amount.
    This amount is adjusted for period size differences. FW then calculates
    the monthly amounts in such a manner as to create a constant rate of
    growth across the monthly amounts. The growth rate assumes a monthly
    compounding of the rate. FW then uses the seasonal percentages input. The
    program knows which months relate to the current Data Entry period,
    obtains the related seasonal percentages from the seasonal screen,
    calculates a weighted average based on the total of these percentages and
    completes the calculation.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate and then
    seasonally adjusted before rounding is performed. Future forecast periods
    and the use of these amounts as a linked account refer to the final whole
    dollar results.

    Formula Method 232 is similar to 224 when used in an annual period.
    However, in a Quarterly or Monthly period Formula Method 231 calculates
    the compounded rate for the period size whereas 224 merely takes a
    portion of the annual rate (for example, 1/4 or 1/12). In addition,
    as a result of swings in the monthly seasonality, the cumulative
    amount at the end of the period may not equal the growth over the
    previous monthly amount.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 232 will not
    be used by FW. Instead Formula Method 222 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!

    Seasonality Adjustment
    ----------------------
    If the previous Data Entry formula method was a seasonal income formula
    method (methods 202, 204, 206, 208, 212, 214, 216, 218, 222, 224, 231 and
    232) then the last monthly calculated amount will have its seasonality
    removed (only for the purpose of performing the current period
    calculation - the previous amount will NOT actually be changed). This
    will eliminate over/under inflated calculations in the use of this method
    in the immediate subsequent period.

    For example, if the current quarterly period is forecast as $750 (or as a
    growth percentage), and the last calculated monthly amount used a
    seasonal income formula method, and that amount was $100 with a 5pct
    seasonal rate for that month, then the prior amount will be re-cast as
    follows:

           ($100 * 3(months in the current forecast period))
                          /
                   (5pct * 12(months)/100pct)
           =  $500.
           $750/$500 is a 50pct increase over the previous period.




NUMBER       FORMULA METHOD DESCRIBED
------       ------------------------

232          I/S - Increment the PrevBal by an
                   Annual Percent - COMPOUNDED
                   Rounded seasonal amount

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $1200-December
          Assumption:   The earlier monthly amount (Nov 1990) is $1140
              Method:   Select Formula Method 232 for the Month Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would represent
                        a 7.97414043pct rate for one month with monthly
                        compounding ($1140 * 12 months * 110pct * .0797414043
                        = $1199.95 or $1200). Since the period size is only
                        one month, no spreading is necessary.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $640-Oct, $343-Nov, $217-Dec
          Assumption:   The earlier monthly amount (Sep 1990) is $377
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 232 for the Quarter Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would represent
                        a 2.41136891pct rate for one quarter with monthly
                        compounding, before seasonal adjustment ($377 * 12
                        months * 110pct * .2411368908 = $1199.99 or $1200).
                        The program will spread the $1200 over the current
                        quarter's monthly periods in such a manner as to
                        create a constant rate of growth across the monthly
                        amounts. These results are then adjusted on a monthly
                        weighted seasonal basis. Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!
   (Oct .0797414043 is calc by FW, representing the portion of the year:
    Nov .0803772734 = 10(1.00797414043^2 - 1 - .00797414043)
    Dec .0810182131 = 10(1.00797414043^3 - 1 - .00797414043 - .00803772734)

   Oct = $637.75 = $377 * 12 * 1.1 * .0797414043 * (15pct/(28pct/3))
   Nov = $342.85 = $377 * 12 * 1.1 * .0803772734 * ( 8pct/(28pct/3))
   Dec = $215.99 = $377 * 12 * 1.1 * .0810182131 * ( 5pct/(28pct/3))

   Difference = $3.41 = $1200 - $1196.59( 637.75 + 342.85 + 215.99 )

   Oct = $560 = $639.56 = $637.75 + ($637.75/$1196.59) * $3.41
   Nov = $364 = $343.82 = $342.85 + ($342.85/$1196.59) * $3.41
   Dec = $276 = $216.60 = $215.99 + ($215.99/$1196.59) * $3.41

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $691-Jan, $233-Feb, $234-Mar,
                        $472-Apr, $475-May, $480-Jun,
                        $338-Jul, $341-Aug, $148-Sep,
                        $742-Oct, $399-Nov, $252-Dec
          Assumption:   The earlier monthly amount (Dec 1989) is $364
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 232 for the Year Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen ($364 * 12 months * 110pct * 1 =
                        $4804.80 or $4805). The program will spread the $4805
                        over the current year's monthly periods in such a
                        manner as to create a constant rate of growth across
                        the monthly amounts. These results are then adjusted
                        on a monthly weighted seasonal basis. (Although the
                        spread in the results is not dramatic, larger numbers
                        would show a more dramatic effect.) Rounding is
                        performed on the cumulative amount through each
                        monthly period (within the Data Entry period)!
   (Jan .0797414043 is calc by FW, representing the portion of the year:
    Feb .0803772734 = 10(1.00797414043^2 - 1 - .00797414043)
    Mar .0810182131 = 10(1.00797414043^3 - 1 - .00797414043 - .00803772734)

   Jan = $689.65 = $364 * 12 * 1.1 * .0797414043 * (15pct/(100pct/12))
   Feb = $231.72 = $364 * 12 * 1.1 * .0803772734 *  (5pct/(100pct/12))
   Mar = $233.57 = $364 * 12 * 1.1 * .0810182131 *  (5pct/(100pct/12))
   Apr = $470.86 = $364 * 12 * 1.1 * .0816642637 * (10pct/(100pct/12))
   May = $474.61 = $364 * 12 * 1.1 * .0823154660 * (10pct/(100pct/12))
   Jun = $478.40 = $364 * 12 * 1.1 * .0829718611 * (10pct/(100pct/12))
   Jul = $337.55 = $364 * 12 * 1.1 * .0836334904 *  (7pct/(100pct/12))
   Aug = $340.24 = $364 * 12 * 1.1 * .0843003956 *  (7pct/(100pct/12))
   Sep = $146.98 = $364 * 12 * 1.1 * .0849726188 *  (3pct/(100pct/12))
   Oct = $740.76 = $364 * 12 * 1.1 * .0856502024 * (15pct/(100pct/12))
   Nov = $398.22 = $364 * 12 * 1.1 * .0863331891 *  (8pct/(100pct/12))
   Dec = $250.87 = $364 * 12 * 1.1 * .0870216221 *  (5pct/(100pct/12))

   Difference = $11.37 = $4804.80 - $4793.43
                         (689.65 + 231.72 + 233.57 + 470.86 +
                          474.61 + 478.40 + 337.55 + 340.24 +
                          146.98 + 740.76 + 398.22 + 250.87)

   Jan = $691 = $691.29 = $689.65 + ($689.65/$4793.43) * $11.37
   Feb = $233 = $232.27 = $231.72 + ($231.72/$4793.43) * $11.37
   Mar = $234 = $234.12 = $233.57 + ($233.57/$4793.43) * $11.37
   Apr = $472 = $471.98 = $470.86 + ($470.86/$4793.43) * $11.37
   May = $475 = $475.74 = $474.61 + ($474.61/$4793.43) * $11.37
   Jun = $480 = $479.53 = $478.40 + ($478.40/$4793.43) * $11.37
   Jul = $338 = $338.35 = $337.55 + ($337.55/$4793.43) * $11.37
   Aug = $341 = $341.05 = $340.24 + ($340.24/$4793.43) * $11.37
   Sep = $148 = $147.33 = $146.98 + ($146.98/$4793.43) * $11.37
   Oct = $742 = $742.52 = $740.76 + ($740.76/$4793.43) * $11.37
   Nov = $399 = $399.16 = $398.22 + ($398.22/$4793.43) * $11.37
   Dec = $252 = $251.47 = $250.87 + ($250.87/$4793.43) * $11.37




NUMBER       FORMULA METHOD DESCRIBED
------       ------------------------

233          I/S - Increment the PrevBal by an
                   Annual Percent - COMPOUNDED
                   Non-seasonal amount
                   (no rounding required)

SCREENS
    All

DATA ENTRY
    Percentage

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of an annual change (growth or decline) of
    the earlier (Monthly Calc) monthly amount to arrive at the current amount.
    The percent change will be adjusted if the size of the current Data Entry
    period is other than one year.

          Size of Cur Prd    pct Entered    pctChange Used
          ---------------    ---------    ------------
          Month              10pct          .79741404pct
          Quarter            10pct          2.41136891pct
          Year               10pct          10pct

    The amount will be divided in such a manner as to create a constant rate
    of growth across the monthly amounts.

USE
    You as the forecaster determine the amount of annual growth or decline in
    the cumulative amount over the earlier (Monthly Calc) monthly amount.
    This amount is adjusted for period size differences. FW then calculates
    the monthly amounts in such a manner as to create a constant rate of
    growth across the monthly amounts. The growth rate assumes a monthly
    compounding of the rate.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate before
    rounding is performed. Future forecast periods and the use of these
    amounts as a linked account refer to the final whole dollar results.

    Formula Method 233 is similar to 223 when used in an annual period.
    However, in a Quarterly or Monthly period Formula Method 233 calculates
    the compounded rate for the period size whereas 223 merely takes a
    portion of the annual rate (for example, 1/4 or 1/12).

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 233 will not
    be used by FW. Instead Formula Method 221 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!

    Seasonality Adjustment
    ----------------------
    If the previous Data Entry formula method was a seasonal income formula
    method (methods 202, 204, 206, 208, 212, 214, 216, 218, 222, 224, 231 and
    232) then the last monthly calculated amount will have its seasonality
    removed (only for the purpose of performing the current period
    calculation - the previous amount will NOT actually be changed). This
    will eliminate over/under inflated calculations in the use of this method
    in the immediate subsequent period.

    For example, if the current quarterly period is forecast as $750 (or as a
    growth percentage), and the last calculated monthly amount used a
    seasonal income formula method, and that amount was $100 with a 5pct
    seasonal rate for that month, then the prior amount will be re-cast as
    follows:

           ($100 * 3(months in the current forecast period))
                          /
                   (5pct * 12(months)/100pct)
           =  $500.
           $750/$500 is a 50pct increase over the previous period.





NUMBER       FORMULA METHOD DESCRIBED
------       ------------------------

233          I/S - Increment the PrevBal by an
                   Annual Percent - COMPOUNDED
                   Non-seasonal amount
                   (no rounding required)

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $1200-December
          Assumption:   The earlier monthly amount (Nov 1990) is $1140
              Method:   Select Formula Method 233 for the Month Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would represent
                        a 7.97414043pct rate for one month with monthly
                        compounding ($1140 * 12 months * 110pct * .0797414043
                        = $1199.95 or $1200). Since the period size is only
                        one month, no spreading is necessary.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $397-Oct, $400-Nov, $403-Dec
          Assumption:   The earlier monthly amount (Sep 1990) is $377
              Method:   Select Formula Method 233 for the Quarter Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen. A 10pct annual rate would represent
                        a 2.41136891pct rate for one quarter with monthly
                        compounding ($377 * 12 months * 110pct * .2411368908
                        = $1199.99 or $1200). The program will spread the
                        $1200 over the current quarter's monthly periods in
                        such a manner as to create a constant rate of growth
                        across the monthly amounts. Rounding is performed on
                        the cumulative amount through each monthly period
                        (within the Data Entry period)!
   (Oct .0797414043 is calc by FW, representing the portion of the year:
    Nov .0803772734 = 10(1.00797414043^2 - 1 - .00797414043)
    Dec .0810182131 = 10(1.00797414043^3 - 1 - .00797414043 - .00803772734)

   Oct = $397 = $396.83 = $377 * 12 * 1.1 * .0797414043:(calc by FW)
   Nov = $400 = $399.99 = $377 * 12 * 1.1 * .0803772734
   Dec = $403 = $403.18 = $377 * 12 * 1.1 * .0810182131

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $383-Jan, $386-Feb, $390-Mar,
                        $392-Apr, $396-May, $398-Jun,
                        $402-Jul, $405-Aug, $408-Sep,
                        $412-Oct, $415-Nov, $418-Dec
          Assumption:   The earlier monthly amount (Dec 1989) is $364
              Method:   Select Formula Method 233 for the Year Ending
                        December 1990 and enter 10pct in the December 1990
                        Data Entry screen ($364 * 12 months * 110pct * 1 =
                        $4804.8 or $4805). The program will spread the $4805
                        over the current year's monthly periods in such a
                        manner as to create a constant rate of growth across
                        the monthly amounts. (Although the spread in the
                        results is not dramatic, larger numbers would show a
                        more dramatic effect.) Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!
   (Jan .0797414043 is calc by FW, representing the portion of the year:
    Feb .0803772734 = 10(1.00797414043^2 - 1 - .00797414043)
    Mar .0810182131 = 10(1.00797414043^3 - 1 - .00797414043 - .00803772734)

   Jan = $383 = $383.14 = $364 * 12 * 1.1 * .0797414043:(calc by FW)
   Feb = $386 = $386.20 = $364 * 12 * 1.1 * .0803772734
   Mar = $390 = $389.28 = $364 * 12 * 1.1 * .0810182131
   Apr = $392 = $392.38 = $364 * 12 * 1.1 * .0816642637
   May = $396 = $395.51 = $364 * 12 * 1.1 * .0823154660
   Jun = $398 = $398.66 = $364 * 12 * 1.1 * .0829718611
   Jul = $402 = $401.84 = $364 * 12 * 1.1 * .0836334904
   Aug = $405 = $405.05 = $364 * 12 * 1.1 * .0843003956
   Sep = $408 = $408.28 = $364 * 12 * 1.1 * .0849726188
   Oct = $412 = $411.53 = $364 * 12 * 1.1 * .0856502024
   Nov = $415 = $414.81 = $364 * 12 * 1.1 * .0863331891
   Dec = $418 = $418.12 = $364 * 12 * 1.1 * .0870216221

