

                                                               26
                                              I/S Formula Method:
                                          Incr Prev Bal by an Amt


NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

205             I/S - Increase Previous Balance by an Amount
                      Spread Evenly

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares which will be added to the earlier (Data Entry) forecast
    amount to arrive at the current amount. The amount will be divided evenly
    on a monthly basis.

USE
    You as the forecaster determine the amount of growth or decline in the
    cumulative amount over the earlier (Data Entry) forecast amount. FW
    calculates the monthly amounts.

    This formula method behaves similar to methods 201, 211, 215 and 221.

    Formula Method 201 is the same as 205, with the exception that 201
    represents the cumulative amount and not the increment. If you do not
    wish the current amount to fluctuate in response to changes to earlier
    forecast periods, then use 201 instead of 205.

    Formula Methods 211, 215 and 221 allow you to state the current period as
    a percentage instead of as an amount.

OVERRIDE
    None




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

205             I/S - Increase Previous Balance by an Amount
                      Spread Evenly

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $1200-December
          Assumption:   The earlier forecast amount (Month of Nov 1990) is
                        $800
              Method:   Select Formula Method 205 for the Month Ending
                        December 1990 and enter $400 in the December 1990
                        Data Entry screen ($800+$400). Since the period size
                        is only one month, no spreading is necessary. Formula
                        Methods 206, 207 and 208 will produce a similar
                        result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $400-Oct, $400-Nov, $400-Dec
          Assumption:   The earlier forecast amount (Qtr of Sep 1990) is $800
              Method:   Select Formula Method 205 for the Quarter Ending
                        December 1990 and enter $400 in the December 1990
                        Data Entry screen ($800 + $400 = $1200). The program
                        will spread the $1200 amount over the current
                        quarter's monthly periods in even $400 amounts.
                        Rounding is performed on the cumulative amount
                        through each monthly period (within the Data Entry
                        period)!

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $100-Jan, $101-Feb, $100-Mar,
                        $100-Apr, $100-May, $101-Jun,
                        $100-Jul, $100-Aug, $100-Sep,
                        $101-Oct, $100-Nov, $100-Dec
          Assumption:   The earlier forecast amount (Yr of Dec 1989) is $1080
              Method:   Select Formula Method 205 for the Year Ending
                        December 1990 and enter $123 in the December 1990
                        Data Entry screen ($1080 + $123 = $1203). The program
                        will spread the $1203 amount over the current Year's
                        monthly periods in even $100.25 amounts. Rounding is
                        performed on the cumulative amount through each
                        monthly period (within the Data Entry period)!




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

206             I/S - Increase Previous Balance by an Amount
                      Spread Seasonally

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares which will be added to the earlier (Data Entry) forecast
    amount to arrive at the current amount. The amount will be divided on a
    monthly weighted seasonal basis. The seasonal percentages used are those
    related to the period chosen, as entered in the seasonal screen selected.

USE
    You as the forecaster determine the amount of growth or decline in the
    cumulative amount over the earlier (Data Entry) forecast amount. FW
    calculates the monthly amounts using the seasonal percentages input. FW
    knows which months relate to the current Data Entry period, obtains the
    related seasonal percentages from the seasonal screen, calculates a
    weighted average based on the total of these percentages and completes
    the calculation.

    This formula method behaves similar to methods 202, 212, 216 and 222.

    Formula Method 202 is the same as 206, with the exception that 202
    represents the cumulative amount and not the increment. If you do not
    wish the current amount to fluctuate in response to changes to earlier
    forecast periods, then use 202 instead of 206.

    Formula Methods 212, 216 and 222 allow you to state the current period as
    a percentage instead of as an amount.

OVERRIDE
    None




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

206             I/S - Increase Previous Balance by an Amount
                      Spread Seasonally

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $1200-December
          Assumption:   The earlier forecast amount (Month of Nov 1990) is
                        $800
              Method:   Select Formula Method 206 for the Month Ending
                        December 1990 and enter $400 in the December 1990
                        Data Entry screen ($800 + $400). Since the period
                        size is only one month, no spreading is necessary.
                        Formula Methods 205, 207 and 208 will produce a
                        similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $643-Oct, $343-Nov, $214-Dec
          Assumption:   The earlier forecast amount (Qtr of Sep 1990) is $800
                        Seasonal Percentages are
                        15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 206 for the Quarter Ending
                        December 1990 and enter $400 in the December 1990
                        Data Entry screen ($800 + $400 = $1200). The program
                        will spread the $1200 amount over the current
                        quarter's monthly periods based on a weighted average
                        of seasonal percentages for that quarter. Rounding is
                        performed on the cumulative amount through each
                        monthly period (within the Data Entry period)!
   Oct = $643 = $642.86 = $1200 * ( 15pct/(15pct+8pct+5pct) )
   Nov = $343 = $342.86 = $1200 * (  8pct/(15pct+8pct+5pct) )
   Dec = $214 = $214.29 = $1200 * (  5pct/(15pct+8pct+5pct) )

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $180-Jan, $ 61-Feb, $ 60-Mar,
                        $120-Apr, $120-May, $121-Jun,
                        $ 84-Jul, $ 84-Aug, $ 36-Sep,
                        $181-Oct, $ 96-Nov, $ 60-Dec
          Assumption:   The earlier forecast amount (Yr of Dec 1989) is $800
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 206 for the Year Ending
                        December 1990 and enter $403 in the December 1990
                        Data Entry screen ($800 + $403 = $1203). The program
                        will spread the $1203 amount over the current year's
                        monthly periods based on a weighted average of
                        seasonal percentages for that year. Rounding is
                        performed on the cumulative amount through each
                        monthly period (within the Data Entry period)!
   Jan = $180 = $180.45 = $1203 * ( 15pct /100pct )
   Feb = $ 61 = $ 60.15 = $1203 * (  5pct /100pct )
   Mar = $ 60 = $ 60.15 = $1203 * (  5pct /100pct )
   Apr = $120 = $120.30 = $1203 * ( 10pct /100pct )
   May = $120 = $120.30 = $1203 * ( 10pct /100pct )
   Jun = $121 = $120.30 = $1203 * ( 10pct /100pct )
   Jul = $ 84 = $ 84.21 = $1203 * (  7pct /100pct )
   Aug = $ 84 = $ 84.21 = $1203 * (  7pct /100pct )
   Sep = $ 36 = $ 36.09 = $1203 * (  3pct /100pct )
   Oct = $181 = $180.45 = $1203 * ( 15pct /100pct )
   Nov = $ 96 = $ 96.24 = $1203 * (  8pct /100pct )
   Dec = $ 60 = $ 60.15 = $1203 * (  5pct /100pct )




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

207             I/S - Increase Previous Balance by an Amount
                      Spread by Geometric Progression

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares which will be added to the earlier (Data Entry) forecast
    amount to arrive at the current amount. The amount will be divided in
    such a manner as to create a constant rate of growth across the monthly
    balances. The growth rate assumes a monthly compounding of the rate.

USE
    You as the forecaster determine the amount of growth or decline in the
    cumulative amount over the earlier (Data Entry) forecast amount. FW
    calculates the monthly amounts in such a manner as to create a constant
    rate of growth across the monthly amounts. The growth rate assumes a
    monthly compounding of the rate.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate before
    rounding is performed. Future forecast periods and the use of these
    amounts as a linked account refer to the final whole dollar results.

    This formula method behaves similar to methods 203, 213, 217 and 223.

    Formula Method 203 is the same as 207, with the exception that 203
    represents the cumulative amount and not the increment. If you do not
    wish the current amount to fluctuate in response to changes to earlier
    forecast periods ,then use 203 instead of 207.

    Formula Methods 213, 217 and 223 allow you to state the current period
    as a percentage instead of as an amount.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 207 will not
    be used by FW. Instead Formula Method 205 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!

    Seasonality Adjustment
    ----------------------
    If the previous Data Entry formula method was a seasonal income formula
    method (methods 202, 204, 206, 208, 212, 214, 216, 218, 222, 224, 231 and
    232) then the last monthly calculated amount will have its seasonality
    removed (only for the purpose of performing the current period
    calculation - the previous amount will NOT actually be changed). This
    will eliminate over/under inflated calculations in the use of this method
    in the immediate subsequent period.

    For example, if the current quarterly period is forecast as $750 (or as a
    growth percentage), and the last calculated monthly amount used a
    seasonal income formula method, and that amount was $100 with a
    5pct season rate for that month, then the prior amount will be re-cast as
    follows:

             ($100 * 3(months in the current forecast period))
                                /
                       (5pct * 12(months)/100pct)
             =  $500.
             $750/$500 is a 50pct increase over the previous period.




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

207             I/S - Increase Previous Balance by an Amount
                      Spread by Geometric Progression

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $1200-December
          Assumption:   The earlier forecast amount (Month of Nov 1990) is
                        $800
              Method:   Select Formula Method 207 for the Month Ending
                        December 1990 and enter $400 in the December 1990
                        Data Entry screen ($800 + $400 = $1200). Since the
                        period size is only one month, no spreading is
                        necessary. Formula Methods 205, 206 and 208 will
                        produce a similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $325-Oct, $395-Nov, $480-Dec
          Assumption:   The earlier forecast amt (Qtr of Sep 1990) is $800
                        with $267 in the month of Sep 1990
              Method:   Select Formula Method 207 for the Quarter Ending
                        December 1990 and enter $400 in the December 1990
                        Data Entry screen ($800 + $400 = $1200). The program
                        will spread the $1200 amount over the current
                        quarter's monthly periods in such a manner as to
                        create a constant rate of growth between the monthly
                        amounts. Rounding is performed on the cumulative
                        amount through each monthly period (within the Data
                        Entry period)!
 Oct = $325 = $324.73=$1200 * .2706077927 (calc by FW - 21.62pct = $325/$267)
 Nov = $395 = $394.94=$1200 * .3291165593 (21.62pct growth = .32912/.27061)
 Dec = $480 = $480.33=$1200 * .4002756480 (21.62pct growth = .40028/.32912)

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $283-Jan, $301-Feb, $318-Mar,
                        $339-Apr, $358-May, $381-Jun,
                        $403-Jul, $428-Aug, $454-Sep,
                        $482-Oct, $511-Nov, $542-Dec
          Assumption:   The earlier forecast amt (Qtr of Dec 1989) is $800
                        with $267 in the month of Dec 1989
              Method:   Select Formula Method 207 for the Year Ending
                        December 1990 and enter $4000 in the December 1990
                        Data Entry screen ($800 + $4000 = $4800). The program
                        will spread the $4800 amount over the current year's
                        monthly periods in such a manner as to create a
                        constant rate of growth between the monthly amounts.
                        Rounding is performed on the cumulative amount
                        through each monthly period (within the Data Entry
                        period)!
 Jan = $283 = $283.24= $4800 * .0590086955 (calc by FW - 6.08pct = $283/$267)
 Feb = $301 = $300.46= $4800 * .0625950583 (6.08pct growth = .06260/.05901)
 Mar = $318 = $318.72= $4800 * .0663993888
 Apr = $339 = $338.09= $4800 * .0704349346
 May = $358 = $358.64= $4800 * .0747157481
 Jun = $381 = $380.43= $4800 * .0792567360
 Jul = $403 = $403.55= $4800 * .0840737109
 Aug = $428 = $428.08= $4800 * .0891834463
 Sep = $454 = $454.10= $4800 * .0946037353
 Oct = $482 = $481.70= $4800 * .1003534525
 Nov = $511 = $510.97= $4800 * .1064526193
 Dec = $542 = $542.03= $4800 * .1129224744 (6.08pct growth = .11292/.10645)

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $283-Jan, $301-Feb, $318-Mar,
                        $339-Apr, $358-May, $381-Jun,
                        $403-Jul, $428-Aug, $454-Sep,
                        $482-Oct, $511-Nov, $542-Dec
          Assumption:   The earlier forecast amount (Yr of Dec 1989) is
                        $3200 with $267 in the month of Dec 1989
              Method:   Select Formula Method 207 for the Year Ending
                        December 1990 and enter $1600 in the December 1990
                        Data Entry screen ($3200 + $1600 = $4800). The
                        program will spread the $4800 amount over the current
                        year's monthly periods in such a manner as to create
                        a constant rate of growth between the monthly amounts.
                        Rounding is performed on the cumulative amount
                        through each monthly period (within the Data Entry
                        period)!
 Jan = $283 = $283.24= $4800 * .0590086955 (calc by FW - 6.08pct = $283/$267)
 Feb = $301 = $300.46= $4800 * .0625950583 (6.08pct growth = .06260/.05901)
 Mar = $318 = $318.72= $4800 * .0663993888
 Apr = $339 = $338.09= $4800 * .0704349346
 May = $358 = $358.64= $4800 * .0747157481
 Jun = $381 = $380.43= $4800 * .0792567360
 Jul = $403 = $403.55= $4800 * .0840737109
 Aug = $428 = $428.08= $4800 * .0891834463
 Sep = $454 = $454.10= $4800 * .0946037353
 Oct = $482 = $481.70= $4800 * .1003534525
 Nov = $511 = $510.97= $4800 * .1064526193
 Dec = $542 = $542.03= $4800 * .1129224744 (6.08pct growth = .11292/.10645)




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

208             I/S - Increase Previous Balance by an Amount
                      Spread by Geometric Prog - Seasonally

SCREENS
    All

DATA ENTRY
    Dollar or unit amount

LINK ACCOUNT
    Not needed

EXPLANATION
    This method allows the entry of either a dollar amount or number of
    capital shares which will be added to the earlier (Data Entry) forecast
    amount to arrive at the current amount. The amount will be divided in
    such a manner as to create a constant rate of growth across the monthly
    amounts. These results (prior to rounding to the nearest whole dollar)
    are then adjusted on a monthly weighted seasonal basis. The seasonal
    percentages used are those related to the period chosen, as entered
    in the seasonal screen selected.

USE
    You as the forecaster determine the amount of growth or decline in the
    cumulative amount over the earlier (Data Entry) forecast amount. FW
    calculates the monthly amounts in such a manner as to create a constant
    rate of growth across the monthly amounts. The growth rate assumes a
    monthly compounding of the rate. FW then uses the seasonal percentages
    input. The program knows which months relate to the current Data Entry
    period, obtains the related seasonal percentages from the seasonal screen,
    calculates a weighted average based on the total of these percentages and
    completes the calculation.

    The computed growth rate is very accurate. The user will notice a slight
    change in the growth rate as a result of rounding the individual results
    to the nearest whole dollar. All monthly amounts within a Data Entry
    period are first calculated using the calculated growth rate and then
    seasonally adjusted before rounding is performed. Future forecast periods
    and the use of these amounts as a linked account refer to the final whole
    dollar results.

    This formula method behaves similar to methods 204, 214, 218 and 224.

    Formula Method 204 is the same as 208, with the exception that 204
    represents the cumulative amount and not the increment. If you do not
    wish the current amount to fluctuate in response to changes to earlier
    forecast periods, then use 204 instead of 208.

    Formula Methods 214, 218 and 224 allow you to state the current period as
    a percentage instead of as an amount.

OVERRIDE
    If the previous Data Entry period or opening (historical) balance sheet,
    income or cash statement amount is $0, then Formula Method 208 will not
    be used by FW. Instead Formula Method 206 will be used by default.
    (see also chapter 16)
    NO ERROR MESSAGE WILL BE RETURNED!

    Seasonality Adjustment
    ----------------------
    If the previous Data Entry formula method was a seasonal income formula
    method (methods 202, 204, 206, 208, 212, 214, 216, 218, 222, 224, 231 and
    232) then the last monthly calculated amount will have its seasonality
    removed (only for the purpose of performing the current period
    calculation - the previous amount will NOT actually be changed). This
    will eliminate over/under inflated calculations in the use of this method
    in the immediate subsequent period.

    For example, if the current quarterly period is forecast as $750 (or as a
    growth percentage), and the last calculated monthly amount used a
    seasonal income formula method, and that amount was $100 with a
    5pct season rate for that month, then the prior amount will be re-cast as
    follows:

             ($100 * 3(months in the current forecast period))
                                /
                       (5pct * 12(months)/100pct)
             =  $500.
             $750/$500 is a 50pct increase over the previous period.




NUMBER          FORMULA METHOD DESCRIBED
------          ------------------------

208             I/S - Increase Previous Balance by an Amount
                      Spread by Geometric Prog - Seasonally

EXAMPLES
   Data Entry Period:   Month Ending December 1990
    Forecast Results:   $1200-December
          Assumption:   The earlier forecast amount (Month of Nov 1990) is
                        $800
              Method:   Select Formula Method 208 for the Month Ending
                        December 1990 and enter $400 in the December 1990
                        Data Entry screen ($800 + $400). Since the period
                        size is only one month, no spreading is necessary.
                        Formula Methods 205, 206 and 207 will produce a
                        similar result.

   Data Entry Period:   Quarter Ending December 1990
    Forecast Results:   $560-Oct, $364-Nov, $276-Dec
          Assumption:   The earlier forecast amount (Qtr of Sep 1990) is $800
                        with $267 in the month of Sep 1990
                        Seasonal pcts are 15pct-Oct, 8pct-Nov, 5pct-Dec
              Method:   Select Formula Method 208 for the Quarter Ending
                        December 1990 and enter $400 in the December 1990
                        Data Entry screen ($800 + $400 = $1200). The program
                        will spread the $1200 amount over the current
                        quarter's monthly periods in such a manner as to
                        create a constant rate of growth between the monthly
                        amounts. These results are then adjusted on a monthly
                        weighted seasonal basis. Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!
   Oct = $521.89 = $1200 * .2706077927 * (15pct/(28pct/3))
   Nov = $338.52 = $1200 * .3291165593 * ( 8pct/(28pct/3))
   Dec = $257.32 = $1200 * .4002756480 * ( 5pct/(28pct/3))

   Difference = $82.27 = $1200 - $1117.73( 521.89 + 338.52 + 257.32 )

   Oct = $560 = $560.30 = $521.89 + ($521.89/$1117.73) * $82.27
   Nov = $364 = $363.44 = $338.52 + ($338.52/$1117.73) * $82.27
   Dec = $276 = $276.26 = $257.32 + ($257.32/$1117.32) * $82.27

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $519-Jan, $183-Feb, $195-Mar,
                        $412-Apr, $438-May, $464-Jun,
                        $345-Jul, $366-Aug, $166-Sep,
                        $882-Oct, $499-Nov, $331-Dec
          Assumption:   The earlier forecast amount (Qtr of Dec 1989) is $800
                        with $267 in the month of Dec 1989
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 208 for the Year Ending
                        December 1990 and enter $4000 in the December 1990
                        Data Entry screen ($800 + $4000 = $4800). The program
                        will spread the $4800 amount over the current
                        quarter's monthly periods in such a manner as to
                        create a constant rate of growth between the monthly
                        amounts. These results are then adjusted on a monthly
                        weighted seasonal basis. Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!
   Jan = $509.84 = $4800 * .0590086955 * (15pct/(100pct/12))
   Feb = $180.27 = $4800 * .0625950583 *  (5pct/(100pct/12))
   Mar = $191.23 = $4800 * .0663993888 *  (5pct/(100pct/12))
   Apr = $405.71 = $4800 * .0704349346 * (10pct/(100pct/12))
   May = $430.36 = $4800 * .0747157481 * (10pct/(100pct/12))
   Jun = $456.52 = $4800 * .0792567360 * (10pct/(100pct/12))
   Jul = $338.99 = $4800 * .0840737109 *  (7pct/(100pct/12))
   Aug = $359.59 = $4800 * .0891834463 *  (7pct/(100pct/12))
   Sep = $163.48 = $4800 * .0946037353 *  (3pct/(100pct/12))
   Oct = $867.05 = $4800 * .1003534525 * (15pct/(100pct/12))
   Nov = $490.53 = $4800 * .1064526193 *  (8pct/(100pct)12))
   Dec = $325.22 = $4800 * .1129224744 *  (5pct/(100pct/12))

   Difference = $81.21 = $4800 - $4718.79( 509.84 + 180.27 +
                         191.23 + 405.71 + 430.36 + 456.52 + 338.99 +
                         359.59 + 163.48 + 867.05 + 490.53 + 325.22)

   Jan = $519 = $518.61 = $509.84 + ($509.84/$4718.79) * $81.21
   Feb = $183 = $183.38 = $180.27 + ($180.27/$4718.79) * $81.21
   Mar = $195 = $194.52 = $191.23 + ($191.23/$4718.79) * $81.21
   Apr = $412 = $412.69 = $405.71 + ($405.71/$4718.79) * $81.21
   May = $438 = $437.77 = $430.36 + ($430.36/$4718.79) * $81.21
   Jun = $464 = $464.38 = $456.52 + ($456.52/$4718.79) * $81.21
   Jul = $345 = $344.82 = $338.99 + ($338.99/$4718.79) * $81.21
   Aug = $366 = $365.78 = $359.59 + ($359.59/$4718.79) * $81.21
   Sep = $166 = $166.29 = $163.48 + ($163.48/$4718.79) * $81.21
   Oct = $882 = $881.98 = $867.05 + ($867.05/$4718.79) * $81.21
   Nov = $499 = $498.98 = $490.53 + ($490.53/$4718.79) * $81.21
   Dec = $331 = $330.81 = $325.22 + ($325.22/$4718.79) * $81.21

   Data Entry Period:   Year Ending December 1990
    Forecast Results:   $519-Jan, $183-Feb, $195-Mar,
                        $412-Apr, $438-May, $464-Jun,
                        $345-Jul, $366-Aug, $166-Sep,
                        $882-Oct, $499-Nov, $331-Dec
          Assumption:   The earlier forecast amount (Yr of Dec 1989) is $3200
                        with $267 in the month of Dec 1989
                        Seasonal Percentages are
                        15pct-Jan,  5pct-Feb,  5pct-Mar,
                        10pct-Apr, 10pct-May, 10pct-Jun,
                         7pct-Jul,  7pct-Aug,  3pct-Sep,
                        15pct-Oct,  8pct-Nov,  5pct-Dec
              Method:   Select Formula Method 208 for the Year Ending
                        December 1990 and enter $1600 in the December 1990
                        Data Entry screen ($3200 + $1600 = $4800). The
                        program will spread the $4800 amount over the current
                        quarter's monthly periods in such a manner as to
                        create a constant rate of growth between the monthly
                        amounts. These results are then adjusted on a monthly
                        weighted seasonal basis. Rounding is performed on the
                        cumulative amount through each monthly period (within
                        the Data Entry period)!
   Jan = $509.84 = $4800 * .0590086955 * (15pct/(100pct/12))
   Feb = $180.27 = $4800 * .0625950583 *  (5pct/(100pct/12))
   Mar = $191.23 = $4800 * .0663993888 *  (5pct/(100pct/12))
   Apr = $405.71 = $4800 * .0704349346 * (10pct/(100pct/12))
   May = $430.36 = $4800 * .0747157481 * (10pct/(100pct/12))
   Jun = $456.52 = $4800 * .0792567360 * (10pct/(100pct/12))
   Jul = $338.99 = $4800 * .0840737109 *  (7pct/(100pct/12))
   Aug = $359.59 = $4800 * .0891834463 *  (7pct/(100pct/12))
   Sep = $163.48 = $4800 * .0946037353 *  (3pct/(100pct/12))
   Oct = $867.05 = $4800 * .1003534525 * (15pct/(100pct/12))
   Nov = $490.53 = $4800 * .1064526193 *  (8pct/(100pct)12))
   Dec = $325.22 = $4800 * .1129224744 *  (5pct/(100pct/12))

   Difference = $81.21 = $4800 - $4718.79( 509.84 + 180.27 +
                         191.23 + 405.71 + 430.36 + 456.52 + 338.99 +
                         359.59 + 163.48 + 867.05 + 490.53 + 325.22)

   Jan = $519 = $518.61 = $509.84 + ($509.84/$4718.79) * $81.21
   Feb = $183 = $183.38 = $180.27 + ($180.27/$4718.79) * $81.21
   Mar = $195 = $194.52 = $191.23 + ($191.23/$4718.79) * $81.21
   Apr = $412 = $412.69 = $405.71 + ($405.71/$4718.79) * $81.21
   May = $438 = $437.77 = $430.36 + ($430.36/$4718.79) * $81.21
   Jun = $464 = $464.38 = $456.52 + ($456.52/$4718.79) * $81.21
   Jul = $345 = $344.82 = $338.99 + ($338.99/$4718.79) * $81.21
   Aug = $366 = $365.78 = $359.59 + ($359.59/$4718.79) * $81.21
   Sep = $166 = $166.29 = $163.48 + ($163.48/$4718.79) * $81.21
   Oct = $882 = $881.98 = $867.05 + ($867.05/$4718.79) * $81.21
   Nov = $499 = $498.98 = $490.53 + ($490.53/$4718.79) * $81.21
   Dec = $331 = $330.81 = $325.22 + ($325.22/$4718.79) * $81.21
