#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

//----------------------------------------------------------------------------//

CLIPPER SCROLLWIND() // OW()  hWnd, nX, nY, aRect, aClip   --> nil
{
   RECT rctScroll, rctClip;

   if( ISARRAY( 4 ) )
   {
      rctScroll.top    = _parni( 4, 1 );
      rctScroll.left   = _parni( 4, 2 );
      rctScroll.bottom = _parni( 4, 3 );
      rctScroll.right  = _parni( 4, 4 );
   }

   if( ISARRAY( 5 ) )
   {
      rctClip.top    = _parni( 5, 1 );
      rctClip.left   = _parni( 5, 2 );
      rctClip.bottom = _parni( 5, 3 );
      rctClip.right  = _parni( 5, 4 );
   }

   ScrollWindow( _parni( 1 ), _parni( 2 ), _parni( 3 ),
                 IF( ISARRAY( 4 ), &rctScroll, 0 ),
                 IF( ISARRAY( 5 ), &rctClip, 0 ) );
}

//----------------------------------------------------------------------------//

CLIPPER WScroll()
{
   HWND hWnd   = _parni( 1 );
   WORD wRows  = _parni( 2 );
   HFONT hFont = _parni( 3 );
   HFONT hOldFont;
   HDC hDC     = GetDC( hWnd );
   TEXTMETRIC tm;

   if( hFont )
      hOldFont = SelectObject( hDC, hFont );

   GetTextMetrics( hDC, &tm );
   ScrollWindow( hWnd, 0, -( tm.tmHeight * wRows ), 0, 0 );

   if( hFont )
      SelectObject( hDC, hOldFont );

   ReleaseDC( hWnd, hDC );
}

//----------------------------------------------------------------------------//

CLIPPER WBrwScroll()
{
   HWND hWnd   = _parni( 1 );
   WORD wRows  = _parni( 2 );
   HFONT hFont = _parni( 3 );
   HFONT hOldFont;
   HDC hDC     = GetDC( hWnd );
   RECT rct;
   TEXTMETRIC tm;

   if( hFont )
      hOldFont = SelectObject( hDC, hFont );

   GetClientRect( hWnd, &rct );
   GetTextMetrics( hDC, &tm );

   rct.top += tm.tmHeight;
   ScrollWindow( hWnd, 0, -( tm.tmHeight * wRows ), 0, &rct );

   if( hFont )
      SelectObject( hDC, hOldFont );

   ReleaseDC( hWnd, hDC );
}

//----------------------------------------------------------------------------//
