#include "FiveWin.ch"
#include "Constant.ch"
#include "InKey.ch"

#define SW_NORMAL              1
#define SW_MAXIMIZE            3
#define SW_MINIMIZE            6

#define WM_MENUSELECT        287
#define WM_SYSCOMMAND        274    // 0x112
#define WM_LBUTTONDBLCLK     515    // 0x203
#define WM_SETFONT            48    // 0x30
#define WM_QUERYDRAGICON      55    // 0x37
#define WM_CTLCOLOR           25    // 0x19
#define WM_ERASEBKGND         20    // 0x14
#define WM_CHILDACTIVATE      34    // 0x22
#define WM_ICONERASEBKGND     39    // 0x27
#define WM_MEASUREITEM        44    // 0x2C
#define WM_DRAWITEM           43    // 0x2B
#define WM_GETFONT            49    // 0x0031
#define WM_NCPAINT           133    // 0x085

#define WS_EX_DLGMODALFRAME    1

#define CBN_SELCHANGE          1

#define IDC_ARROW          32512

#define SIZE_MINIMIZED         1

#define SC_RESTORE         61728
#define SC_CLOSE           61536   // 0xF060
#define SC_CLOSE_OPEN      61539   // 0xF063  Close and Popup already opened
#define SC_MINIMIZE        61472
#define SC_NEXT            61504
#define SC_MAXIMIZE        61488   // 0xF030

#define SW_HIDE                0
#define SW_SHOWNA              8

#define BM_SETSTYLE  WM_USER + 4
#define DLGC_BUTTON         8192   // 0x2000

#define CS_DBLCLKS             8
#define CW_USEDEFAULT      32768

#define HORZRES             8
#define VERTRES            10

extern SetFocus                    // linker bug ?

static aWindows    := {}
static lRegistered := .f.
static oWndDefault                 // Defaulf DEFINEd Window

//----------------------------------------------------------------------------//

function nWindows() ; return Len( aWindows )

//----------------------------------------------------------------------------//

CLASS TWindow

   DATA   hWnd, nOldProc
   DATA   bInit, bMoved, bLClicked, bKeyDown, bPainted, bRClicked
   DATA   bResized, bLDblClick, bWhen, bValid, bKeyChar, bMMoved
   DATA   bGotFocus, bLostFocus, bDropFiles, bDdeInit, bDdeExecute
   DATA   hDrop
   DATA   cCaption, cPS, nPaintCount, cMsg
   DATA   Cargo                              // Ok here you have it <g>
   DATA   hDC, nId
   DATA   lActive, lVisible, lFocused
   DATA   lVbx AS LOGICAL
   DATA   nStyle, nChrHeight, nChrWidth, nLastKey
   DATA   nTop, nLeft, nBottom, nRight
   DATA   nClrPane, nClrText
   DATA   nResult, lValidating, nHelpId, hCtlFocus
   DATA   aControls
   DATA   oBar, oBrush, oCursor, oFont, oIcon, oMenu
   DATA   oSysMenu, oPopup, oMsgBar, oWnd, oVScroll, oHScroll

   METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu,;
               oBrush, oIcon, oParent, lVScroll, lHScroll,;
               nClrFore, nClrBack, oCursor,;
               cBorder, lSysMenu, lCaption, lMin, lMax ) CONSTRUCTOR

   METHOD Activate( cShow, bLClicked, bRClicked, bMoved, bResized, bPainted,;
                    bKeyDown, bInit,;
                    bUp, bDown, bPgUp, bPgDn,;
                    bLeft, bRight, bPgLeft, bPgRight, bValid, bDropFiles )

   METHOD AddControl( oControl ) INLINE ;
                        If( ::aControls == nil, ::aControls := {},),;
                        AAdd( ::aControls, oControl ), ::lValidating := .f.

   METHOD BeginPaint() BLOCK ;      // it has to be BLOCK
          { | Self, cPS | ::nPaintCount := 1,;
                          ::hDC := BeginPaint( ::hWnd, @cPS ), ::cPS := cPS }

   METHOD Box( nTop, nLeft, nBottom, nRight )

   METHOD Capture() INLINE  SetCapture( ::hWnd )

   METHOD Center( oWnd ) INLINE  WndCenter( ::hWnd, oWnd:hWnd )

   METHOD Command( nWParam, nLParam )
   METHOD Circle( nRow, nCol, nWidth )

   METHOD CoorsUpdate()

   METHOD Copy( lAll ) INLINE  WndCopy( ::hWnd, lAll )

   METHOD Create( cClsName )

   METHOD CtlColor( hWndChild, hDCChild ) INLINE ;
                               SendMessage( hWndChild, FM_COLOR, hDCChild )

   METHOD cTitle( cNewTitle ) SETGET
   
   METHOD DdeInitiate( hWndClient, nAppName, nTopicName ) INLINE ;
          If( ::bDdeInit != nil,;
              ( Eval( ::bDdeInit, hWndClient,;
                GlobalGetAtomName( nAppName ),;
                GlobalGetAtomName( nTopicName ) ),;
                SendMessage( hWndClient, WM_DDE_ACK, ::hWnd,;
                             nMakeLong( nTopicName, nAppName ) ) ),)

   METHOD DdeAck( hWndSender, nLParam ) INLINE  DdeAck( hWndSender, nLParam )

   METHOD DdeExecute( hWndSender, nCommand ) INLINE ;
          If( ::bDdeExecute != nil,;
              ( Eval( ::bDdeExecute, hWndSender, DdeGetCommand( nCommand ) ),;
                PostMessage( hWndSender, WM_DDE_ACK, ::hWnd, 1 ) ),)

   METHOD DdeTerminate( hWndSender ) INLINE DdeTerminate( hWndSender )

   METHOD Disable()  INLINE ::lActive := .f.,;
                            If( ::hWnd != nil, EnableWindow( ::hWnd, .f. ),)

   METHOD DrawItem( nIdCtl, pItemStruct ) INLINE ;
              SendMessage( GetDlgItem( ::hWnd, nIdCtl ),;
                           FM_DRAW, 0, pItemStruct )

   METHOD DropFiles( hDrop )

   METHOD Enable()   INLINE ::lActive := .t.,;
                            If( ::hWnd != nil, EnableWindow( ::hWnd, .t. ),)

   METHOD End() BLOCK ;   // It has to be Block
      { | Self, lEnd | If( lEnd := ::lValid(), ::PostMsg( WM_CLOSE ),), lEnd }

   METHOD EndPaint() INLINE ::nPaintCount--,;
                     EndPaint( ::hWnd, ::cPS ), ::cPS := nil, ::hDC := nil

   METHOD EraseBkGnd( hDC )

   METHOD FloodFill( nRow, nCol, nRGBColor ) INLINE ;
          FloodFill( ::hDC, nRow, nCol, nRGBColor )

   METHOD FocusNext( hCtrl, lPrevious )

   METHOD cGenPrg()

   METHOD nGetChrHeight() INLINE ;
                          ::nChrHeight := nWndChrHeight( ::hWnd,;
                          If( ::oFont != nil, ::oFont:hFont,) )

   METHOD GetCliRect()

   METHOD GetFont()

   METHOD GetRect()

   METHOD GetDC() INLINE ;
       If( ::hDC == nil, ::hDC := GetDC( ::hWnd ),),;
       If( ::nPaintCount == nil, ::nPaintCount := 1, ::nPaintCount++ ), ::hDC

   METHOD GetDlgCode( nLastKey ) VIRTUAL

                                   // It has to be BLOCK

   METHOD GetWidth( cText, oFont ) BLOCK { | Self, cText, oFont, nSize | ;
                    nSize := GetTextWidth( ::GetDC(), cText,;
                    If( oFont != nil, oFont:hFont,) ),;
                    ::ReleaseDC(), nSize }

   METHOD GoNextCtrl( hCtrl )
   METHOD GoPrevCtrl( hCtrl )

   METHOD GotFocus()

   METHOD GoTop() INLINE BringWindowToTop( ::hWnd )

   METHOD HandleEvent( nMsg, nWParam, nLParam ) EXTERN ;
                                WndHandleEvent( nMsg, nWParam, nLParam )

   METHOD HardCopy( nScale, lFromUser )

   METHOD Hide() INLINE ShowWindow( ::hWnd, SW_HIDE )

   METHOD HScroll( nWParam, nLParam )

   METHOD Iconize() INLINE CloseWindow( ::hWnd )

   METHOD KeyDown( nKey, nFlags )
   METHOD KeyChar( nKey, nFlags )

   METHOD KillFocus( hWndFocus ) INLINE ::LostFocus()

   METHOD LButtonDown( nRow, nCol, nKeyFlags )
   METHOD LDblClick( nRow, nCol, nKeyFlags )

   METHOD Line( nTop, nLeft, nBottom, nRight )
   METHOD Link( lSubClass )
   
   METHOD LostFocus() INLINE ::lFocused := .f.,;
                      If( GetParent( GetFocus() ) != ::hWnd .and. ;
                          ::bLostFocus != nil, Eval( ::bLostFocus ),)

   METHOD MenuSelect( nIdItem )

   // METHOD NcActivate( lOnOff ) VIRTUAL

   METHOD NcActivate( lOnOff ) INLINE If( ! lOnOff .and. ::bLostFocus != nil,;
                                      Eval( ::bLostFocus ),), nil

   METHOD lWhen() INLINE  If( ::bWhen != nil, Eval( ::bWhen ), .t. )

   METHOD Maximize() INLINE ShowWindow( ::hWnd, SW_MAXIMIZE )

   METHOD MeasureItem( nIdCtl, pMitStruct )

   METHOD Minimize() INLINE  ShowWindow( ::hWnd, SW_MINIMIZE )

   METHOD MouseMove( nRow, nCol, nKeyFlags ) INLINE ;
                    If( ::oCursor != nil, SetCursor( ::oCursor:hCursor ),;
                        CursorArrow() ),;
                    ::SetMsg( ::cMsg ),;
                    If( ::bMMoved != nil,;
                        Eval( ::bMMoved, nRow, nCol, nKeyFlags ),), 0

   METHOD Move( nTop, nLeft, nWidth, nHeight, lRepaint )

   METHOD Normal() INLINE ShowWindow( ::hWnd, SW_NORMAL )

   // METHOD NcPaint() VIRTUAL

   METHOD Paint()

   METHOD PaletteChanged( hWndPalChg ) INLINE PalChgEvent( hWndPalChg )

   METHOD PostMsg( nMsg, nWParam, nLParam ) INLINE ;
               PostMessage( ::hWnd, nMsg, nWParam, nLParam )

   METHOD Print( oTarget, nRow, nCol, nScale ) INLINE ;
                      WndPrint( ::hWnd, oTarget:hDC, nRow, nCol, nScale )

   METHOD QueryDragIcon() INLINE ;
          If( ::oIcon != nil, ::oIcon:hIcon, ExtractIcon( "user.exe" ) )

   METHOD QueryEndSession() INLINE If( ::End(), 1, 0 )

   METHOD QueryNewPalette() INLINE If( IsIconic( ::hWnd ), 0, QryNewPalEvent() )

   METHOD RButtonDown( nRow, nCol, nKeyFlags )
   METHOD Destroy()     // previously called Release()

   METHOD ReleaseDC() INLINE  If( --::nPaintCount == 0,;
                              If( ReleaseDC( ::hWnd, ::hDC ), ::hDC := nil,),)

   
   METHOD Refresh( lErase ) INLINE InvalidateRect( ::hWnd,;
                                   If( lErase != nil, lErase, .t. ) )

   METHOD Register( nClsStyle )
          

   METHOD ReSize( nSizeType, nWidth, nHeight )
   METHOD Say( nRow, nCol, cText, nClrFore, nClrBack, oFont, lPixel )

   METHOD SayBitmap( nRow, nCol, coBitmap, nWidth, nHeight )

   METHOD SayRect( nRow, nCol, cText, nClrFore, nClrBack, nWidth )

   METHOD SelColor( lFore )  INLINE ;
          lFore := If( lFore == nil, lFore := .f., lFore ),;
          ::SetColor( If( lFore, ChooseColor( ::nClrText ), ::nClrText ),;
                      If( lFore, ::nClrPane, ChooseColor( ::nClrPane ) ) ),;
          ::Refresh()

   METHOD SendMsg( nMsg, nWParam, nLParam ) INLINE ;
                           SendMessage( ::hWnd, nMsg, nWParam, nLParam )
   
   METHOD SetBrush( oBrush ) INLINE If( ::oBrush != nil, ::oBrush:End(),),;
                                    ::oBrush := oBrush, ::Refresh()

   METHOD SetColor( nClrFore, nClrBack, oBrush )

   METHOD SetCoors( oRect )

   METHOD SetFocus() INLINE  If( ::lWhen(), SetFocus( ::hWnd ),)

   METHOD SelFont() BLOCK { | Self, nClr | nClr := ::nClrText,;
                            ::SetFont( If( ::oFont == nil,;
                            TFont():New( ,,,.t. ),;
                            ::oFont:Choose( @nClr ) ) ),;
                            ::nClrText := nClr, ::Refresh() }

   METHOD SetFont( oFont ) INLINE If( ::oFont != nil .and. ;
                                  ::oFont:hFont != oFont:hFont, ::oFont:End(),),;
                                  ::oFont := oFont,;
                                  ::SendMsg( WM_SETFONT, oFont:hFont )
                                  // ::Refresh( .f. ) produces blinking !!!

   METHOD SetMenu( oMenu ) INLINE  SetMenu( ::hWnd, oMenu:hMenu ),;
                                   ::oMenu := oMenu, oMenu:oWnd := Self
   
   METHOD SetMsg( cText )

   METHOD SetPixel( nX, nY, nColor ) INLINE ;
                               SetPixel( ::GetDC(), nX, nY, nColor ),;
                               ::ReleaseDC()

   METHOD SetText( cText ) INLINE ;
                          ::cCaption := cText, SetWindowText( ::hWnd, cText )

   METHOD Show() INLINE  ShowWindow( ::hWnd, SW_SHOWNA )

   METHOD SysCommand( nWParam, nLParam )

   METHOD Timer( nTimerId ) INLINE  TimerEvent( nTimerId )

   METHOD UnLink()

   METHOD Update() INLINE AEval( ::aControls,;
                   { | oCtrl | If( oCtrl:lUpdate, oCtrl:Refresh(),) } )

   METHOD lValid() INLINE If( ::bValid != nil, Eval( ::bValid ), .t. )

   METHOD VScroll( nCode, nPos )

   METHOD nVertRes() BLOCK ;
          { | Self, nRes | nRes := GetDeviceCaps( ::GetDC(), VERTRES  ),;
                           ::ReleaseDC(), nRes }


   METHOD nHorzRes() BLOCK ;
          { | Self, nRes | nRes := GetDeviceCaps( ::GetDC(), HORZRES  ),;
                           ::ReleaseDC(), nRes }

   METHOD AEvalWhen()

   METHOD VbxFireEvent( pEventInfo ) INLINE VBXEvent( pEventInfo )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD Register( nClsStyle )  CLASS TWindow

   DEFAULT nClsStyle  := nOR( CS_VREDRAW, CS_HREDRAW ),;
           ::nClrPane := CLR_GRAY, ::oBrush := TBrush():New( ,::nClrPane )

   nClsStyle = nOr( nClsStyle, CS_GLOBALCLASS, CS_DBLCLKS )

   RegisterClass( ::ClassName(), nClsStyle,,,, 0,;
                  ::oBrush:hBrush )

Return nil

//----------------------------------------------------------------------------//

METHOD Create( cClsName )  CLASS TWindow

   DEFAULT cClsName := ::ClassName(), ::cCaption := "",;
           ::nStyle := WS_OVERLAPPEDWINDOW,;
           ::nTop   := 0, ::nLeft := 0, ::nBottom := 10, ::nRight := 10,;
           ::nId    := 0

   if ::oWnd != nil
      ::nStyle = nOR( ::nStyle, WS_CHILD )
   endif

   if ::nBottom != CW_USEDEFAULT
      ::hWnd = CreateWindow( cClsName, ::cCaption, ::nStyle, ;
                             ::nLeft, ::nTop, ::nRight - ::nLeft + 1, ;
                             ::nBottom - ::nTop + 1, ;
                             If( ::oWnd != nil, ::oWnd:hWnd, 0 ), ;
                             ::nId )
    else
      ::hWnd = CreateWindow( cClsName, ::cCaption, ::nStyle, ;
                             ::nLeft, ::nTop, ::nRight, ::nBottom, ;
                             If( ::oWnd != nil, ::oWnd:hWnd, 0 ), ;
                             ::nId )
    endif

   ::Link()

   if ::oFont != nil
      ::SetFont( ::oFont )
   endif
   
return nil

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu,;
            oBrush, oIcon, oWnd, lVScroll, lHScroll, nClrFore, nClrBack,;
            oCursor, cBorder, lSysMenu, lCaption, lMin, lMax ) ;
                                                               CLASS TWindow

   DEFAULT nTop     := 2, nLeft := 2, nBottom := 20, nRight := 70,;
           lVScroll := .f., lHScroll := .f.,;
           nClrFore := CLR_WHITE, nClrBack := CLR_GRAY,;
           nStyle   := 0,;
           cBorder  := "SINGLE", lSysMenu := .f., lCaption := .t.,;
           lMin     := .t., lMax := .t.

   if nStyle == 0
      nStyle = nOr( WS_CLIPCHILDREN,;
                    If( cBorder == "NONE",   WS_POPUP, 0 ),;
                    If( cBorder == "SINGLE", WS_THICKFRAME, 0 ),;
                    If( lCaption, WS_CAPTION, 0 ),;
                    If( lSysMenu .and. lCaption, WS_SYSMENU, 0 ),;
                    If( lMin .and. lCaption, WS_MINIMIZEBOX, 0 ),;
                    If( lMax .and. lCaption, WS_MAXIMIZEBOX, 0 ),;
                    If( lVScroll, WS_VSCROLL, 0 ),;
                    If( lHScroll, WS_HSCROLL, 0 ) )
   endif

   ::nTop      = nTop    * WIN_CHARPIX_H	// 16
   ::nLeft     = nLeft   * WIN_CHARPIX_W	// 8
   ::nBottom   = nBottom * WIN_CHARPIX_H	//16
   ::nRight    = nRight  * WIN_CHARPIX_W	// 8
   ::nStyle    = nStyle
   ::cCaption  = cTitle
   ::oCursor   = oCursor
   ::oMenu     = oMenu
   ::oWnd      = oWnd
   ::oIcon     = oIcon
   ::lVisible  = .t.               // As soon as we create it, it exists!
   ::aControls = {}
   ::nLastKey  = 0

   ::SetColor( nClrFore, nClrBack, oBrush )

   if ! lRegistered               // Windows API conexion
      ::Register()
   endif
   
   ::Create()

   if oMenu != nil
      SetMenu( ::hWnd, oMenu:hMenu )
      oMenu:oWnd = Self
   endif

   if lVScroll
      DEFINE SCROLLBAR ::oVScroll VERTICAL OF Self
   endif
   if lHScroll
      DEFINE SCROLLBAR ::oHScroll HORIZONTAL OF Self
   endif

   ::GetFont()     // Thanks HMP

   SetWndDefault( Self )                   // Set Default DEFINEd Window

return nil

//----------------------------------------------------------------------------//

METHOD Activate( cShow, bLClicked, bRClicked, bMoved, bResized, bPainted,;
                 bKeyDown, bInit, bUp, bDown, bPgUp, bPgDown,;
                 bLeft, bRight, bPgLeft, bPgRight, bValid, bDropFiles ) CLASS TWindow

   local oVScroll, oHScroll

   DEFAULT cShow := "NORMAL"

   ::nResult     = nil
   ::lValidating = .f.
   ::bValid      = bValid

   if bDropFiles != nil
      ::bDropFiles = bDropFiles
      DragAcceptFiles( ::hWnd, .t. )
   endif

   if bPainted != nil
      if ::ChildLevel( TMdiFrame() ) > 0
         ::oWndClient:bPainted = bPainted
      else
         ::bPainted  = bPainted
      endif
   endif

   if bRClicked != nil
      if ::ClassName() == "TMDIFRAME"
         ::oWndClient:bRClicked = bRClicked
      else
         ::bRClicked = bRClicked
      endif
   endif

   if ::oFont != nil
      ::SetFont( ::oFont )
   endif


   // For WS_VSCROLL and WS_HSCROLL styles

   if ::ClassName() == "TMDIFRAME"
      oVScroll = ::oWndClient:oVScroll
      oHScroll = ::oWndClient:oHScroll
   else
      oVScroll = ::oVScroll
      oHScroll = ::oHScroll
   endif

   if oVScroll != nil       // When using VSCROLL clause
      if bUp != nil
         oVScroll:bGoUp = bUp
      endif
      if bDown != nil
         oVScroll:bGoDown = bDown
      endif
      if bPgUp != nil
         oVScroll:bPageUp = bPgUp
      endif
      if bPgDown != nil
         oVScroll:bPageDown = bPgDown
      endif
   endif

   if oHScroll != nil       // When using HSCROLL clause
      if bLeft != nil
         oHScroll:bGoUp = bLeft
      endif
      if bRight != nil
         oHScroll:bGoDown = bRight
      endif
      if bPgLeft != nil
         oHScroll:bPageUp = bPgLeft
      endif
      if bPgRight != nil
         oHScroll:bPageDown = bPgRight
      endif
   endif

   ::AEvalWhen()

   ShowWindow( ::hWnd, AScan( { "NORMAL", "ICONIZED", "MAXIMIZED" }, cShow ) )
   UpdateWindow( ::hWnd )

   ::lVisible = .t.

   if ! lWRunning()
       SetWndApp( ::hWnd )
   endif
   
   if ::bInit != nil
      Eval( ::bInit, Self )
   endif

   if ::oWnd == nil
      if ! lWRunning()
         WinRun( Self:hWnd )
      endif
   endif

   ::lVisible = .f.

return nil

//----------------------------------------------------------------------------//

METHOD Circle( nRow, nCol, nWidth ) CLASS TWindow

   ::GetDC()
   Ellipse( ::hDC, nCol, nRow, nCol + nWidth - 1, nRow + nWidth - 1 )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD Command( nWParam, nLParam ) CLASS TWindow

   do case
      case ::oPopup != nil
           ::oPopup:Command( nWParam )

      case nLoWord( nLParam ) == 0 .and. ::oMenu != nil
           ::oMenu:Command( nWParam )

      case nWParam > 0
           do case
              case nHiWord( nLParam ) == BN_CLICKED
                   SendMessage( nLoWord( nLParam ), FM_CLICK, 0, 0 )

              case nHiWord( nLParam ) == CBN_SELCHANGE
                   SendMessage( nLoWord( nLParam ), FM_CHANGE, 0, 0 )
           endcase
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD CoorsUpdate() CLASS TWindow

   local aRect := GetCoors( ::hWnd )

   ::nTop    = aRect[ 1 ]
   ::nLeft   = aRect[ 2 ]
   ::nBottom = aRect[ 3 ]
   ::nRight  = aRect[ 4 ]

return nil

//----------------------------------------------------------------------------//

METHOD cTitle( cNewTitle ) CLASS TWindow

   if cNewTitle != nil
      SetWindowText( ::hWnd, cNewTitle )
   endif

return GetWindowText( ::hWnd )

//----------------------------------------------------------------------------//

METHOD DropFiles( hDrop ) CLASS TWindow

   local aFiles
   local aCoors := { 0, 0 }

   ::hDrop = hDrop

   if ! Empty( ::bDropFiles )
      DragQueryPoint( hDrop, aCoors )
      Eval( ::bDropFiles, aCoors[ 2 ], aCoors[ 1 ], DragQueryFiles( hDrop ) )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD cGenPRG( cFileName ) CLASS TWindow

   local cPrg := ""

   ::CoorsUpdate()

   cPrg += '#include "FiveWin.ch"' + CRLF + CRLF
   cPrg += "static oWnd" + CRLF + CRLF
   cPrg += "//" + Replicate( "-", 76 ) + "//" + CRLF + CRLF
   cPrg += "function Main()" + CRLF + CRLF

   if ::oBar != nil
      cPrg += "   local oBar" + CRLF
   endif

   if ::oBrush != nil
      cPrg += "   local oBrush" + CRLF
   endif

   if ::oBrush != nil
      cPrg += ::oBrush:cGenPRG()
   endif

   cPrg += CRLF + ;
           '   DEFINE WINDOW oWnd TITLE "' + ::cTitle + '" ;' + CRLF + ;
           "      FROM " + ;
           Str( ::nTop / WIN_CHARPIX_H , 3 ) + ", " + Str( ::nLeft / WIN_CHARPIX_W, 3 ) + " TO " + ;				  // 16, 8
           Str( ::nBottom / WIN_CHARPIX_H, 3 ) + ", " + Str( ::nRight / WIN_CHARPIX_W, 3 )							  // 16,8

   if ::oMenu != nil
      cPrg += " ;" + CRLF + "      MENU BuildMenu()"
   endif

   if ::oBrush != nil
      cPrg += " ;" + CRLF + "      BRUSH oBrush" + CRLF
   endif

   if ::oBar != nil
      cPrg += ::oBar:cGenPRG()
   endif

   if ::oMsgBar != nil
      cPrg += CRLF + CRLF + '   SET MESSAGE OF oWnd TO "' + ;
              ::oMsgBar:cMsgDef + '"'
   endif

   if ! Empty( ::aControls )
      AEval( ::aControls, { | oCtrl | cPrg += oCtrl:cGenPRG() } )
   endif

   cPrg += CRLF + "   ACTIVATE WINDOW oWnd" + CRLF + CRLF
   cPrg += "return nil" + CRLF + CRLF
   cPrg += "//" + Replicate( "-", 76 ) + "//" + CRLF

   if ! Empty( cFileName )
      MemoWrit( cFileName, cPrg )
   endif

return cPrg

//----------------------------------------------------------------------------//

METHOD EraseBkGnd( hDC ) CLASS TWindow

   if IsIconic( ::hWnd )
      if ::oWnd != nil
         FillRect( hDC, GetClientRect( ::hWnd ), ::oWnd:oBrush:hBrush )
         return 1
      endif
         return 0
   endif

   if ::oBrush != nil
      FillRect( hDC, GetClientRect( ::hWnd ), ::oBrush:hBrush )
      return 1
   endif

return nil

//----------------------------------------------------------------------------//

METHOD GetCliRect() CLASS TWindow

   local aRect := GetClientRect( ::hWnd )

return TRect():New( aRect[ 1 ], aRect[ 2 ], aRect[ 3 ], aRect[ 4 ] )

//----------------------------------------------------------------------------//

METHOD GetRect() CLASS TWindow

   local aRect := GetWndRect( ::hWnd )

return TRect():New( aRect[ 1 ], aRect[ 2 ], aRect[ 3 ], aRect[ 4 ] )

//----------------------------------------------------------------------------//

/*  Now all this method is written in C language
    and it is incredibly fast !!!!!!!!!  Really incredible !!!

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TWindow

   do case                            // Sort Speed: many thanks to HMP
      case nMsg == WM_MOUSEMOVE
           return ::MouseMove( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_COMMAND
           return ::Command( nWParam, nLParam )

      case nMsg == WM_SETFOCUS
           return ::GotFocus()

      case nMsg == WM_TIMER
           return ::Timer( nWParam, nLParam ) 

      case nMsg == WM_CTLCOLOR
           return ::CtlColor( nLoWord( nLParam ), nWParam )

      case nMsg == WM_GETDLGCODE
           return ::GetDlgCode( nWParam )

      case nMsg == WM_PAINT
           ::BeginPaint()
           ::Paint()
           ::EndPaint()
           return 0

      case nMsg == WM_DRAWITEM
           return ::DrawItem( nWParam, nLParam )

      case nMsg == WM_MEASUREITEM
           return ::MeasureItem( nWParam, nLParam )

      case nMsg == WM_PALETTECHANGED
           return ::PaletteChanged( nWParam ) 

      case nMsg == WM_QUERYNEWPALETTE
           return ::QueryNewPalette() 

      // case nMsg == WM_NCPAINT
      //      return ::NCPaint()

      case nMsg == WM_DDE_ACK
           return ::DdeAck( nWParam, nLParam )

      case nMsg == WM_DDE_TERMINATE
           return ::DdeTerminate( nWParam )

      case nMsg == WM_LBUTTONDOWN
           return ::LButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_QUERYDRAGICON
           return ::QueryDragIcon()

      case nMsg == WM_RBUTTONDOWN
           return ::RButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_LBUTTONDBLCLK
           return ::LDblClick( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_CHAR
           return ::KeyChar( nWParam, nLParam )

      case nMsg == WM_KEYDOWN
           return ::KeyDown( nWParam, nLParam )

      case nMsg == WM_SIZE
           return ::ReSize( nWParam, nLoWord( nLParam ), nHiWord( nLParam ) )

      // case nMsg == WM_MOVE
      //      if ::oBrush != nil
      //         SetBrushOrg( ::hWnd, ::oBrush:hBrush, 0, 0 )
      //      endif

      case nMsg == WM_SYSCOMMAND
           return ::SysCommand( nWParam, nLParam )

      case nMsg == WM_VSCROLL
           return ::VScroll( nWParam, nLParam )

      case nMsg == WM_HSCROLL
           return ::HScroll( nWParam, nLParam )

      case nMsg == WM_ERASEBKGND
           return ::EraseBkGnd( nWParam )

      case nMsg == WM_MENUSELECT
           return ::MenuSelect( nWParam )

      case nMsg == WM_DESTROY
           return ::Destroy()

      case nMsg == WM_QUERYENDSESSION
           return ::QueryEndSession()
   endcase

return nil

*/

//----------------------------------------------------------------------------//

METHOD MeasureItem( nIdCtl, pMitStruct ) CLASS TWindow

   local nAt

   // Warning: On this message the Controls still are not initialized
   // because WM_MEASUREITEM is sent before of WM_INITDIALOG

   if ( nAt := AScan( ::aControls, { | oCtrl | oCtrl:nId == nIdCtl } ) ) != 0
      return ::aControls[ nAt ]:FillMeasure( pMitStruct )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD MenuSelect( nIdItem ) CLASS TWindow

   local oItem

   if ::oMenu != nil .or. ::oPopup != nil
      if ::oPopup != nil
         oItem = ::oPopup:GetMenuItem( nIdItem )
      else
         oItem = ::oMenu:GetMenuItem( nIdItem )
      endif
      ::SetMsg( If( oItem != nil, oItem:cMsg,) )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Say( nRow, nCol, cText, nClrFore, nClrBack, oFont, lPixel ) CLASS TWindow

   DEFAULT nClrFore := ::nClrText,;
           nClrBack := ::nClrPane,;
           oFont    := ::oFont,;
           lPixel   := .f.

   if ValType( nClrFore ) == "C"      //  xBase Color string
      nClrBack = nClrFore
      nClrFore = nGetForeRGB( nClrFore )
      nClrBack = nGetBackRGB( nClrBack )
   endif

   ::GetDC()
   WSay( ::hWnd, ::hDC, nRow, nCol, cValToChar( cText ), nClrFore, nClrBack,;
         If( oFont != nil, oFont:hFont, 0 ), lPixel )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD SayBitmap( nRow, nCol, coBitmap, nWidth, nHeight ) CLASS TWindow

   local hDib, hPal
   local cType := ValType( coBitmap )

   if cType == "C"
      DEFINE BITMAP coBitmap FILENAME coBitmap
   endif

   PalBmpDraw( ::GetDC(), nRow, nCol, coBitmap:hBmpPal, nWidth, nHeight )
   ::ReleaseDC()

   if cType == "C"
      coBitmap:End()
   endif

return nil

//----------------------------------------------------------------------------//

METHOD SayRect( nRow, nCol, cText, nClrFore, nClrBack, nWidth ) CLASS TWindow

   DEFAULT nClrFore := CLR_BLACK, nClrBack := CLR_WHITE

   ::GetDC()
   WSayRect( ::hWnd, ::hDC, nRow, nCol, cText, nClrFore, nClrBack, nWidth )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD LButtonDown( nRow, nCol, nKeyFlags ) CLASS TWindow

   if ::bLClicked != nil
      return Eval( ::bLClicked, nRow, nCol, nKeyFlags )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD LDblClick( nRow, nCol, nKeyFlags ) CLASS TWindow

   if ::bLDblClick != nil
      Eval( ::bLDblClick, nRow, nCol, nKeyFlags )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Line( nTop, nLeft, nBottom, nRight ) CLASS TWindow

   ::GetDC()
   MoveTo( ::hDC, nLeft, nTop )
   LineTo( ::hDC, nRight, nBottom )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD RButtonDown( nRow, nCol, nKeyFlags ) CLASS TWindow

   if ::bRClicked != nil
      Eval( ::bRClicked, nRow, nCol, nKeyFlags )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD SetMsg( cText ) CLASS TWindow

   if ::oMsgBar != nil   // Thanks to HMP
      ::oMsgBar:SetMsg( cText )
   else
      if ::oWnd != nil
         ::oWnd:SetMsg( cText )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Box( nTop, nLeft, nBottom, nRight ) CLASS TWindow

   ::GetDC()
   WndBox( ::hDC, nTop, nLeft, nBottom, nRight )
   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD Link( lSubClass ) CLASS TWindow

   local nAt := AScan( aWindows, 0 )

   DEFAULT lSubClass := .t.

   if ::hWnd != 0
      if nAt != 0
         aWindows[ nAt ] = Self
         while GetProp( ::hWnd, "WP" ) != nAt
            SetProp( ::hWnd, "WP", nAt )
         end
      else
         AAdd( aWindows, Self )
         while GetProp( ::hWnd, "WP" ) != Len( aWindows )
            SetProp( ::hWnd, "WP", Len( aWindows ) )
         end
      endif

      if Len( aWindows ) == 1
         WindowsFix()
      endif

      if lSubClass
         ::nOldProc = ChangeProc( ::hWnd )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Destroy() CLASS TWindow

   if ::oBrush != nil
      ::oBrush:End()
   endif
   if ::oCursor != nil
      ::oCursor:End()
   endif
   if ::oIcon != nil
      ::oIcon:End()
   endif
   if ::oFont != nil
      ::oFont:End()
   endif
   if ::oMenu != nil
      ::oMenu:Destroy()  // Don't use End() here because it sends a Msg !!!
   endif
   if ::oSysMenu != nil
      ::oSysMenu:End()
   endif
   if ::bDropFiles != nil
      DragFinish( ::hDrop )
   endif

   if ::oVScroll != nil
      ::oVScroll:Destroy()
   endif
   if ::oHScroll != nil
      ::oHScroll:Destroy()
   endif

   ::UnLink()

   if GetWndApp() == ::hWnd
      PostQuitMessage( 0 )
   endif

   if ::ChildLevel( TDialog() ) != 0 ; // TDialog Class or inherited Class
      .and. ! ::lModal
      DeRegDialog( ::hWnd )
   endif

return nil

//----------------------------------------------------------------------------//

DLL STATIC FUNCTION VbxTerm() AS VOID PASCAL LIB "BIVBX10.DLL"

//----------------------------------------------------------------------------//

METHOD ReSize( nSizeType, nWidth, nHeight ) CLASS TWindow

   ::CoorsUpdate()

   if ::oMsgBar != nil
      ::oMsgBar:Adjust()
   endif

   if ::oBar != nil
      ::oBar:Adjust()
   endif

   if nSizeType == SIZE_MINIMIZED .and. ::ChildLevel( TMdiChild() ) == 0
      // SelectPalette( ::hWnd, 0, .t. )    // to stabilize desktop palette
   endif

   if ::bResized != nil
      Eval( ::bResized, nWidth, nHeight )
   endif

return 0

//----------------------------------------------------------------------------//

METHOD SetCoors( oRect ) CLASS TWindow

   SetWindowPos( ::hWnd, 0, oRect:nTop, oRect:nLeft,;
                 oRect:nRight - oRect:nLeft + 1,;
                 oRect:nBottom - oRect:nTop + 1, 4 )    // Important:
                                                        // Use 4 for
   ::nTop    = oRect:nTop                               // for keeping
   ::nLeft   = oRect:nLeft                              // ZOrder !!!!
   ::nBottom = oRect:nBottom
   ::nRight  = oRect:nRight

return nil

//----------------------------------------------------------------------------//

METHOD UnLink() CLASS TWindow

   local nAt := If( ::hWnd != 0, GetProp( ::hWnd, "WP" ), 0 )

   if ::nOldProc != nil .and. ::hWnd != 0
      RestProc( ::hWnd, ::nOldProc )
      ::nOldProc = nil
   endif

   if nAt > 0 .and. nAt <= Len( aWindows )
      aWindows[ nAt ] = 0
   endif

   SetProp( ::hWnd, "WP", 0 )
   RemoveProp( ::hWnd, "WP" )

return nil

//----------------------------------------------------------------------------//

METHOD VScroll( nWParam, nLParam ) CLASS TWindow

   local nScrHandle := nHiWord( nLParam )

   if nScrHandle == 0                   // Window ScrollBar
      do case
         case nWParam == SB_LINEUP
              ::oVScroll:GoUp()

         case nWParam == SB_LINEDOWN
              ::oVScroll:GoDown()

         case nWParam == SB_PAGEUP
              ::oVScroll:PageUp()

         case nWParam == SB_PAGEDOWN
              ::oVScroll:PageDown()

         case nWParam == SB_THUMBPOSITION
              ::oVScroll:ThumbPos( nLoWord( nLParam ) )

         case nWParam == SB_ENDSCROLL
              return 0
      endcase
   else                                 // Control ScrollBar
      do case
         case nWParam == SB_LINEUP
              SendMessage( nScrHandle, FM_SCROLLUP )

         case nWParam == SB_LINEDOWN
              SendMessage( nScrHandle, FM_SCROLLDOWN )

         case nWParam == SB_PAGEUP
              SendMessage( nScrHandle, FM_SCROLLPGUP )

         case nWParam == SB_PAGEDOWN
              SendMessage( nScrHandle, FM_SCROLLPGDN )

         case nWParam == SB_THUMBPOSITION
              SendMessage( nScrHandle, FM_THUMBPOS, nLoWord( nLParam ) )
      endcase
   endif

return 0

//----------------------------------------------------------------------------//

METHOD HScroll( nWParam, nLParam ) CLASS TWindow

   local nScrHandle := nHiWord( nLParam )

   if nScrHandle == 0                   // Window ScrollBar
      do case
         case nWParam == SB_LINEUP
              ::oHScroll:GoUp()

         case nWParam == SB_LINEDOWN
              ::oHScroll:GoDown()

         case nWParam == SB_PAGEUP
              ::oHScroll:PageUp()

         case nWParam == SB_PAGEDOWN
              ::oHScroll:PageDown()

         case nWParam == SB_THUMBPOSITION
              ::oHScroll:ThumbPos( nLoWord( nLParam ) )

         case nWParam == SB_ENDSCROLL
              return 0
      endcase
   else                                 // Control ScrollBar
      do case
         case nWParam == SB_LINEUP
              SendMessage( nScrHandle, FM_SCROLLUP )

         case nWParam == SB_LINEDOWN
              SendMessage( nScrHandle, FM_SCROLLDOWN )

         case nWParam == SB_PAGEUP
              SendMessage( nScrHandle, FM_SCROLLPGUP )

         case nWParam == SB_PAGEDOWN
              SendMessage( nScrHandle, FM_SCROLLPGDN )

         case nWParam == SB_THUMBPOSITION
              SendMessage( nScrHandle, FM_THUMBPOS, nLoWord( nLParam ) )
      endcase
   endif

return 0

//----------------------------------------------------------------------------//

METHOD SysCommand( nWParam, nLParam ) CLASS TWindow

   if ::oSysMenu != nil .and. nWParam < 61440           // 0xF000
      ::oSysMenu:Command( nWParam )
   else
      do case
         case nWParam == SC_CLOSE .or. nWParam == SC_CLOSE_OPEN
              return ::End()
      endcase
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Paint() CLASS TWindow

   if IsIconic( ::hWnd )
      if ::ChildLevel( TMdiChild() ) > 0
         ::SendMsg( WM_ERASEBKGND, ::hDC, 0 )
      else
         ::SendMsg( WM_ICONERASEBKGND, ::hDC, 0 )
      endif
      DrawIcon( ::hDC, 0, 0,;
      If( ::oIcon != nil, ::oIcon:hIcon, ExtractIcon( "user.exe" ) ) )
   else
      if ValType( ::bPainted ) == "B"
         Eval( ::bPainted, Self )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD HardCopy( nScale, lUser ) CLASS TWindow

   local oPrn

   DEFAULT lUser := .t.

   if lUser
      PRINT oPrn NAME ::cTitle FROM USER
   else
      PRINT oPrn NAME ::cTitle
   endif

      PAGE
         ::Refresh()
         SysRefresh()                      // Let Windows process
         ::Print( oPrn, 0, 0, nScale )
      ENDPAGE
   ENDPRINT

return nil

//----------------------------------------------------------------------------//

METHOD Move( nTop, nLeft, nBottom, nRight, lRepaint ) CLASS TWindow

   MoveWindow( ::hWnd, nTop, nLeft, nBottom, nRight, lRepaint )

   ::nBottom = nTop + ( ::nBottom - ::nTop )
   ::nRight  = nLeft + ( ::nRight - ::nLeft )
   ::nTop    = nTop
   ::nLeft   = nLeft

return nil

//----------------------------------------------------------------------------//

METHOD SetColor( nClrFore, nClrBack, oBrush ) CLASS TWindow

   // DEFAULT colors get assigned at :Colors() method
   // because there we _do_ have a hDC already created

   if ValType( nClrFore ) == "C"
      nClrBack = nClrFore                   // It is a dBase Color string
      nClrFore = nGetForeRGB( nClrFore )
      nClrBack = nGetBackRGB( nClrBack )
   endif

   ::nClrText = nClrFore
   ::nClrPane = nClrBack

   if ::oBrush != nil
      ::oBrush:End()
   endif
   if oBrush != nil
      ::oBrush = oBrush
   else
      ::oBrush = TBrush():New(,nClrBack,)
   endif

return nil

//----------------------------------------------------------------------------//

METHOD KeyChar( nKey, nFlags ) CLASS TWindow

   local bKeyAction := SetKey( nKey )

   if bKeyAction != nil     // Clipper SET KEYs !!!
      return Eval( bKeyAction, ProcName( 4 ), ProcLine( 4 ) )
   endif

   if ::bKeyChar != nil
      return Eval( ::bKeyChar, nKey, nFlags )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD KeyDown( nKey, nFlags ) CLASS TWindow

   local bKeyAction := SetKey( nKey )

   if nKey == VK_TAB .and. ::oWnd != nil
      ::oWnd:GoNextCtrl( ::hWnd )
      return 0
   endif

   if nKey == VK_F4 .and. GetKeyState( VK_CONTROL ) .and. ;
      ::oWnd != nil .and. ::oWnd:ChildLevel( TMdiChild() ) > 0
      ::oWnd:KeyDown( nKey, nFlags )
      return 0
   endif

   if nKey == VK_F6 .and. GetKeyState( VK_CONTROL ) .and. ;
      ::oWnd != nil .and. ::oWnd:ChildLevel( TMdiChild() ) > 0
      ::oWnd:KeyDown( nKey, nFlags )
      return 0
   endif

   if nKey == VK_F1
      if Empty( ::nHelpId )
         HelpIndex()
      else
         HelpTopic( ::nHelpId )
      endif
      return 0
   endif

  if bKeyAction != nil     // Clipper SET KEYs !!!
     Eval( bKeyAction, ProcName( 4 ), ProcLine( 4 ) )
     return 0
   endif

   if ::bKeyDown != nil
      return Eval( ::bKeyDown, nKey, nFlags )
   endif

return nil

//----------------------------------------------------------------------------//
// Some friends functions

function SetWndDefault( oWnd ) ; oWndDefault := oWnd ; return nil

function GetWndDefault() ; return oWndDefault

//----------------------------------------------------------------------------//

METHOD GotFocus() CLASS TWindow

   ::lFocused = .t.

   if ::hCtlFocus != nil
      SetFocus( ::hCtlFocus )
   else
      if ::aControls != nil .and. Len( ::aControls ) > 0
         ::hCtlFocus = ::aControls[ 1 ]:hWnd
         SetFocus( ::hCtlFocus )
      endif
   endif

   if ::bGotFocus != nil
      Eval( ::bGotFocus )
   endif

return 0

//----------------------------------------------------------------------------//

METHOD FocusNext( hCtrl, lPrevious ) CLASS TWindow

   DEFAULT lPrevious := .f.

   if lPrevious
      return ::GoPrevCtrl( hCtrl )
   else
      return ::GoNextCtrl( hCtrl )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD GoNextCtrl( hCtrl ) CLASS TWindow

   local hCtlNext := NextDlgTab( ::hWnd, hCtrl )

   if hCtlNext != hCtrl
      SetFocus( hCtlNext )
      ::hCtlFocus = hCtlNext
   endif

return nil

//----------------------------------------------------------------------------//

METHOD GoPrevCtrl( hCtrl ) CLASS TWindow

   local hCtlPrev := NextDlgTab( ::hWnd, hCtrl, .t. )

   if hCtlPrev != hCtrl
      SetFocus( hCtlPrev )
      ::hCtlFocus = hCtlPrev
   endif

return nil

//----------------------------------------------------------------------------//

METHOD GetFont() CLASS TWindow

   local hFont := ::SendMsg( WM_GETFONT )
   local aInfo := GetFontInfo( hFont )
   local oFont

   if ::oFont == nil
      oFont := ::oFont := TFont()
      oFont:hFont   = hFont
      oFont:nHeight = aInfo[ 1 ]
      oFont:nWeight = aInfo[ 2 ]
      oFont:lBold   = aInfo[ 3 ]
   endif

return ::oFont

//----------------------------------------------------------------------------//

METHOD AEvalWhen() CLASS TWindow

   local n
   local aControls := ::aControls

   if ! Empty( aControls )
      for n = 1 to Len( aControls )
          if aControls[ n ]:bWhen != nil
             if Eval( aControls[ n ]:bWhen )
                ::aControls[ n ]:Enable()   // keep this as ::
             else
                ::aControls[ n ]:Disable()  // keep this as ::
             endif
         endif
      next
   endif

return nil

//----------------------------------------------------------------------------//
