// A partial sample developed by a FiveWin user

//-----------------------------------------------------------------------//
//                                                                       //
//      Versin del programa BANCO52 del MS-DOS ahora en Windows         //
//                                                                       //
//      FiveWin 1.5                                                      //
//-----------------------------------------------------------------------//

#include "FiveWin.ch"

// Antonio lo declaro todo STATIC para no tenerlos que pasar en las funciones y
// sean visibles en toda la aplicacin:

STATIC  oWnd

STATIC  cIncPath,;
        cLibPath

STATIC  wBnCod,;
        wBcNom,;
        wBcSuc,;
        wBcCue,;
        wBcTe1,;
        wBcTe2,;
        wBcAti,;
        wBnSal

STATIC  nCod,;
        nImp,;
        cEstado

STATIC  wHnOpe,;
        wHnCod,;
        wHdFec,;
        wHcDes,;
        wHnImp

// Objetos GET's:

STATIC  oBnCod,;
        oBcNom,;
        oBcSuc,;
        oBcCue,;
        oBcTe1,;
        oBcTe2,;
        oBcAti,;
        oBnSal

STATIC  oHnOpe,;
        oHnCod,;
        oHdFec,;
        oHcDes,;
        oHnImp

// Objetos BUTTONS:

Static oBBusca,;
       oBMidif,;
       oBAltas,;
       oBBajas,;
       oBPrime,;
       oBUltim,;
       oBSalir

// Objetos BROWSE's:

STATIC oLbx

//----------------------------------------------------------------------------//

FUNCTION Main()

    LOCAL oBrush, oIco, oBar
    LOCAL hBorland := LoadLibrary( ".\BWCC.dll" )

    cEstado := "I"

    nCod    := 0
    nImp    := 0

    wBnCod  :=  0
    wBcNom  :=  Space(35)
    wBcSuc  :=  Space(35)
    wBnSal  :=  0

    wHnOpe  :=  0
    wHnCod  :=  0
    wHdFec  :=  CTod("  /  /  ")
    wHcDes  :=  Space( 20 )
    wHnImp  :=  0


    SET RESOURCES TO ".\WBanco.dll"
    SET 3DLOOK ON

    DEFINE BRUSH oBrush STYLE TILED

    DEFINE WINDOW oWnd FROM 03, 03 TO MaxRow() - 2, MaxCol() - 3 ;
        TITLE "Windows Bancos" ;
        BRUSH oBrush ;
        MENU BuildMenu()

    SET MESSAGE OF oWnd TO "Progrma realizado por M.E.S."

    USE D_Bancos    INDEX D_BaCodi  ALIAS BB NEW
    USE D_Histor    INDEX D_HiOper,;
                          D_HiFech,;
                          D_HiCodi  ALIAS HH NEW

    ACTIVATE WINDOW oWnd MAXIMIZED

    DbCloseAll( )

    SET RESOURCES TO

    FreeLibrary( hBorland )

RETURN nil

//----------------------------------------------------------------------------//

FUNCTION BuildMenu()

   LOCAL oMenu

   MENU oMenu
        MENUITEM "&Bancos"      ;
            ACTION Bancos() MESSAGE "Mantenimiento del ficero de Cuentas"
        MENUITEM "&Movimientos" ;
            ACTION Movimientos() MESSAGE "Mantenimiento de Movimientos en las cuentas"
        MENUITEM "&Fin"         ;
            ACTION Fin() MESSAGE OemToAnsi( "Finalizar la ejecucin del programa." )
   ENDMENU

RETURN oMenu

//----------------------------------------------------------------------------//

FUNCTION Bancos()

    MsgInfo( OemToAnsi( "Aqu va el mantenimiento de bancos" ) )

RETURN nil


//-----------------------------------------------------------------------//

FUNCTION Movimientos()

    LOCAL oDlg

    DEFINE DIALOG oDlg NAME "MOVIMIENTOS"

    HRegAVar()
    RegAvar()


//  Para los datos del maestro:

    REDEFINE SAY oBnCod PROMPT AllTrim( Str( wBnCod ) ) ID 10 OF oDlg CENTERED
    REDEFINE SAY oBcNom PROMPT wBcNom ID 20 OF oDlg CENTERED
    REDEFINE SAY oBcSuc PROMPT wBcSuc ID 30 OF oDlg CENTERED
    REDEFINE SAY oBcCue PROMPT wBcSuc ID 40 OF oDlg CENTERED
    REDEFINE SAY oBnSal PROMPT wBnSal ID 50 OF oDlg CENTERED


// Movimientos en el historico:

    REDEFINE LISTBOX oLbx FIELDS ID 100 ;
        OF oDlg ;
        ON CHANGE Refresca();
        FIELDSIZES 70,               50,        70,       250,        90 ;
        HEAD      "Oper.",OemToAnsi("Cd."),"Fecha","Concepto","Importe"


// Registro del histrico activo:

    REDEFINE SAY oHnOpe PROMPT AllTrim( Str( wHnOpe ) ) ID 60 ;
             OF oDlg CENTERED

    REDEFINE GET oHnCod VAR wHnCod ID 101 ;            // Antonio las PICT
        PICTURE "999" VALID( VHCod( wHnCod ) ) OF oDlg // no van bien sobre
    REDEFINE GET oHdFec VAR wHdFec ID 102 OF oDlg      // la de la fecha (prueba
    REDEFINE GET oHcDes VAR wHcDes ID 103 ;            // a meter una errnea y
        PICTURE "@!" OF oDlg                           // dale a ENTER |:-/
    REDEFINE GET oHnImp VAR wHnImp ID 104 ;            // Aqu he tenido que quitar
        PICTURE "999999999" OF oDlg ;                  // PICT "@E 999,999,99".
        VALID( Gestor( ) )                              // Para que no meta
                                                        // sin ser controlados
                                                        // por los 'Buttones'...
// Botones de acciones:

    REDEFINE BUTTON oBBusca ID 105 OF oDlg ;
        ACTION  HBusca( )                               // OK!!  :-)
    REDEFINE BUTTON oBMidif ID 106 OF oDlg ;
        ACTION  ( cEstado := "M", Acepta( oDlg ) )      // KO!! 8-(
    REDEFINE BUTTON oBAltas ID 107 OF oDlg ;
        ACTION  ( cEstado := "A", Acepta( oDlg ) )      // KO!! 8-(
    REDEFINE BUTTON oBBajas ID 108 OF oDlg ;
        ACTION  HBorraReg( )                            // OK!! :-)
    REDEFINE BUTTON oBPrime ID 109 OF oDlg ;            //
        ACTION  IrPrimero( )                            // OK!! :-) con los bug
    REDEFINE BUTTON oBUltim ID 110 OF oDlg ;            //            del
        ACTION  IrUltimo( )                             // OK!! :-) BROWSE
    REDEFINE BUTTON oBSalir ID 111 OF oDlg ;
        ACTION If( MsgYesNo( OemToAnsi( " Desea terminar ?" ) ), oDlg:End( ), )


    ACTIVATE DIALOG oDlg CENTERED

RETURN nil


//-----------------------------------------------------------------------//

FUNCTION Fin()

    If( MsgYesNo( OemToAnsi( " Desea terminar ?" ) ),;
         oWnd:End(),MsgInfo("Sigue"))

RETURN nil


//-------------------------------------------------------------------------//

FUNCTION Acepta( oDlg )

    if cEstado == "A"               // Si es un alta
        VaciaVar()                  // vacio el buffer de memoria del maestro
        HVaciaVar()                 // y del historico y luego
        RefrescaGets()              // refresco los oGET's   OK!!
    else                            // si no es una modificacion

        HRegAVar()                  // Muevo el registro al buffer de memoria
        RegAvar()                   // Historico y maestro
        RefrescaGets()              // refresco oGET's

        nCod := wHnCod              // Capturo codigo de banco y el importe para
        nImp := wHnImp              // saber si se han modificado

    endif

    Desactiva( )                    // Desactivo todo

    oHnCod:SetFocus()           // el foco aqui, me tengo que venir con el
                                // ratn !!!!!!!! Qu hago mal?
return nil

//-------------------------------------------------------------------------//
// Funcin para controlar que los datos que se metan eb los GETS son buenos
// por que vienen de ALTAS  MODIFICACION.
//   Cmo pregunto que me estoy saliendo para que no me d el mensaje?
// ya que el FOCO se queda ah despus de un ALTA o MODIF.
//
FUNCTION Gestor( )

//    LOCAL lVerdad := .F.

    if cEstado $ "AM"                   // Los algoritmos para actualizar el
                                        // banco no estn muy finos, pero de
        //lVerdad := .T.                // ya me encargar....

        if MsgYesNo( OemToAnsi( " Es seguro ?" ) )

            if cEstado == "A"

                HH->( DbGoBottom() )
                wHnOpe := HH->H_nOpe + 1
                HH->( DbAppend() )
                HVarAReg()
                BB->B_nSal := BB->B_nSal + HH->H_nImp // Actualizo maestro

            elseif cEstado == "M"

                HVarAReg()

                if nCod != wHnCod  // Se ha modificado el banco:
                    if BB->( DbSeek( nCod ) )  // Cambio Saldo Banco final
                        BB->B_nSal := BB->B_nSal - HH->H_nImp
                    else
                        MsgInfo( "Se ha producido ERROR en banco final" )
                    endif

                    if BB->( DbSeek( wHnCod ) )  // Cambio Saldo Banco inicial
                        BB->B_nSal := BB->B_nSal + HH->H_nImp
                    else
                        MsgInfo(  "Se ha producido ERROR en banco inicial"  )
                    endif
                endif

                if nImp != wHnImp  // Se ha modificado el importe
                    BB->B_nSal := BB->B_nSal - ( nImp - wHnImp )
                endif

                HVarAReg()

            else
                MsgInfo( OemToAnsi( "Ha cancelado la modificacin" ) )
            EndIf

        endif

        Activa( )
        oLbx:Refresh( )
        Refresca( )
        cEstado := "I"

// Si no ha pasado por botones que saque esto... Pero como controlo
// que me quiero ir por ejemplo despus de un alta!

    else
        MsgInfo( "Debe presionar uno de los botones ALTAS o MODIFICA" )
        cEstado := "I"
    endif
// Hay veces que eto tampoco va, creo que interfiere tu proteccin
// ya lo comprobar.
    oBBusca:setFocus( .T. )

RETURN .T. //lVerdad

//-----------------------------------------------------------------------//
//-----------------------------------------------------------------------//
//          Funciones secundarias
//-----------------------------------------------------------------------//
//-----------------------------------------------------------------------//

FUNCTION VaciaVar()

        wBnCod   :=  0
        wBcNom   :=  Space(35)
        wBcSuc   :=  Space(35)
        wBnSal   :=  0

RETURN nil


//-----------------------------------------------------------------------//

FUNCTION HVaciaVar()

        wHnOpe   :=  0
        wHnCod   :=  0
        wHdFec   :=  CTod("  /  /  ")
        wHcDes   :=  Space( 20 )
        wHnImp   :=  0

RETURN nil

//----------------------------------------------------------------------------//
//        Pasa el actual valor de las variables al registro                   //
//----------------------------------------------------------------------------//
FUNCTION RegAVar()

    wBnCod   :=  BB->B_nCod
    wBcNom   :=  BB->B_cNom
    wBcSuc   :=  BB->B_cSuc
    wBcCue   :=  BB->B_cCue
    wBcTe1   :=  BB->B_cTe1
    wBcTe1   :=  BB->B_cTe1
    wBcAti   :=  BB->B_cAti
    wBnSal   :=  BB->B_nSal

RETURN nil


//--------------------------------------------------------------------------//

FUNCTION HVarAReg( )

    HH->H_nOpe :=   wHnOpe
    HH->H_nCod :=   wHnCod
    HH->H_dFec :=   wHdFec
    HH->H_cDes :=   wHcDes
    HH->H_nImp :=   wHnImp

RETURN( NIL )

//----------------------------------------------------------------------------//
//        Pasa el actual valor de las variables al registro                   //
//----------------------------------------------------------------------------//

FUNCTION HRegAVar( )

     wHnOpe  :=  HH->H_nOpe
     wHnCod  :=  HH->H_nCod
     wHdFec  :=  HH->H_dFec
     wHcDes  :=  HH->H_cDes
     wHnImp  :=  HH->H_nImp

RETURN( NIL )

//--------------------------------------------------------------------------//
//          Valida que el cdigo este en D_Bancos.dbf                       //
//--------------------------------------------------------------------------//

FUNCTION VHCod( Cod )

    LOCAL lVerdad := .F.

    if cEstado $ "AM"

        if BB->(DbSeek( Cod ))
            lVerdad :=  .T.
        else
            MsgInfo( OemToAnsi( "No existe ese Cdigo de Banco" ) )
            lVerdad :=  .F.
        endif
    else
        MsgInfo( "Debe presionar el boton de ALTAS o MODIFICACIONES" )
        lVerdad := .T.
    endif

RETURN lVerdad


//---------------------------------------------------------------------------//

FUNCTION Refresca( )


    IF BB->( DbSeek( HH->H_nCod ) )
        wBnCod   :=  BB->B_nCod
        wBcNom   :=  OemToAnsi( BB->B_cNom )
        wBcSuc   :=  OemToAnsi( BB->B_cSuc )
        wBcCue   :=  OemToAnsi( BB->B_cCue )
        wBnSal   :=  BB->B_nSal
    else
        wBnCod   := 0
        wBcNom   := "Banco Desconocido"
        wBcSuc   := Space(35)
        wBnSal   := 0
    ENDIF

    HRegAVar()

      oBnCod:SetText( AllTrim( Str( wBnCod ) ) )
      oBcNom:SetText( wBcNom )
      oBcSuc:SetText( wBcSuc )
      oBcCue:SetText( wBcCue )
      oBnSal:SetText( wBnSal )

      oHnOpe:SetText( AllTrim( Str( wHnOpe) ) )

      oHnCod:Refresh()
      oHdFec:Refresh()
      oHcDes:Refresh()
      oHnImp:Refresh()

RETURN nil


//--------------------------------------------------------------------------//

FUNCTION RefrescaGets()

      oHnCod:Refresh()
      oHdFec:Refresh()
      oHcDes:Refresh()
      oHnImp:Refresh()

RETURN nil


//--------------------------------------------------------------------------//

FUNC IrPrimero( )

    HH->( DbGoTop() )
    oLbx:Refresh()
    Refresca()

RETURN nil

//--------------------------------------------------------------------------//

FUNC IrUltimo( )

    HH->( DbGoBottom() )
    oLbx:Refresh()
    Refresca()

RETURN nil

//----------------------------------------------------------------------------//

FUNCT HBorraReg( )

    If MsgYesNo( OemToAnsi("Borra la operacin: " + ;
                        AllTrim( Str( HH->H_nOpe ) ) + " ?") )
        if !Deleted( )
        **********************************************************
            // Repone el saldo anterior:                       //*
            BB->B_nSal := BB->B_nSal - HH->H_nImp              //*
        **********************************************************
            HH->( DbDelete() )
            PACK
        endif
        oLbx:Refresh( )
        Refresca( )
    endif

RETURN nil

//-----------------------------------------------------------------------//

FUNCT HBusca( )

    LOCAL oDlg2
    LOCAL oValor
    LOCAL nValor := 0
    LOCAL nPres  := 0

    DEFINE DIALOG oDlg2 NAME "HBUSCAR"

        REDEFINE SAY ID 100 OF oDlg2 CENTERED
        REDEFINE GET oValor VAR nValor ID 101 OF oDlg2

        REDEFINE BUTTON ID 102 OF oDlg2 ACTION ( oDlg2:End( ), nPres := 1 )
        REDEFINE BUTTON ID 103 OF oDlg2 ACTION oDlg2:End( )

    ACTIVATE DIALOG oDlg2 CENTERED

    If nPres == 1

        if HH->( DbSeek( nValor ) )
            oLbx:Refresh( )
            Refresca( )
        else
            HH->( DbSeek( wHnOpe ) )

            ////////////////////////////////////////////////
            oLbx:Refresh()   // Por el fallo encontrado   //
            Refresca()     // en el browse   es mo??  //
            ////////////////////////////////////////////////

            MsgInfo( OemToAnsi( "No existe el N de Operacin " ) +;
                                 AllTrim( Str( nValor ) ) )
        endif
    EndIf

RETURN nil

//--------------------------------------------------------------------------//

FUNCTION Desactiva( )

    oBBusca:disable()
    oBMidif:disable()
    oBAltas:disable()
    oBBajas:disable()
    oBPrime:disable()
    oBUltim:disable()
    oBSalir:disable()

    oLbx:disable()

RETURN nil

//--------------------------------------------------------------------------//

FUNCTION Activa( )

    oBBusca:enable()
    oBMidif:enable()
    oBAltas:enable()
    oBBajas:enable()
    oBPrime:enable()
    oBUltim:enable()
    oBSalir:enable()

    oLbx:enable()

RETURN nil


//------------ EOF WBanco.PRG -------------------//


