#include "FiveWin.ch"

Function WaveAudio()
   Local cPrompt    // Declared to avoid array range error. See FOR loop
   Local oDlg,lMute,lLeft,lRight,lOpen
   Local oPLay,oStop,oAvTrack,oReTrack,oOpenClose,oSalir
   Local oT1,oT2,oT3,oT4,oT5,oT6,oT7,oT8,oT9,oT10
   Local oL1,oL2,oL3,oL4,oL5,oL6,oL7,oL8,oN9,oN10,l1,l2,l3,l4,l5,l6,l7,l8,n9,n10
   Local cBuffer:=Space(200),oSBRight,oSBLeft,nVolR:=0,nVolL:=0
   Local oTextLV,oTextRV
   Local oTimer,oTracks[25]
   Local aoStat[18],acStat[18]
   Local cFile:=Space(30),oFind
   Local nA,oFile,oType

   DEFINE DIALOG oDlg RESOURCE "WAVEAUDIO"
   
   mciSendStr("OPEN WAVEAUDIO ALIAS WAVE",@cBuffer,oDlg:hWnd)

	DEFINE TIMER oTimer INTERVAL 2000 ACTION (GetStat(@acStat,@oDlg),RefreshStat(@aoStat,@acStat))

   mciSendStr("CAPABILITY WAVE CAN EJECT"      ,@cBuffer,oDlg:hWnd)
   l1 :=  cBuffer=="verdadero"
   mciSendStr("CAPABILITY WAVE CAN PLAY"       ,@cBuffer,oDlg:hWnd)  
   l2 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY WAVE CAN RECORD"     ,@cBuffer,oDlg:hWnd)
   l3 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY WAVE CAN SAVE"       ,@cBuffer,oDlg:hWnd)
   l4 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY WAVE COMPOUND DEVICE",@cBuffer,oDlg:hWnd)
   l5 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY WAVE HAS AUDIO"      ,@cBuffer,oDlg:hWnd)
   l6 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY WAVE HAS VIDEO"      ,@cBuffer,oDlg:hWnd)
   l7 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY WAVE USES FILES"      ,@cBuffer,oDlg:hWnd)
   l8 := cBuffer=="verdadero"
   mciSendStr("CAPABILITY WAVE INPUTS"      ,@cBuffer,oDlg:hWnd)
   n9 := Trim(cBuffer)
   mciSendStr("CAPABILITY WAVE OUTPUTS"      ,@cBuffer,oDlg:hWnd)
   n10 := Trim(cBuffer)

   REDEFINE BUTTON oPlay      ID 103 OF oDlg ACTION mciSendStr("PLAY WAVE FROM 0",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oStop      ID 109 OF oDlg ACTION mciSendStr("STOP WAVE",@cBuffer,oDlg:hWnd)
   REDEFINE BUTTON oAvTrack   ID 101 OF oDlg ACTION ( AvPista(@oDlg),mciSendStr("PLAY WAVE",@cBuffer,oDlg:hWnd) )
   REDEFINE BUTTON oReTrack   ID 106 OF oDlg ACTION ( RePista(@oDlg),mciSendStr("PLAY WAVE",@cBuffer,oDlg:hWnd) )
   REDEFINE BUTTON oOpenClose ID 107 OF oDlg ACTION OpenClose(@oDlg)
   REDEFINE BUTTON oSalir     ID 115 OF oDlg ACTION ( mciSendStr("STOP WAVE",@cBuffer,oDlg:hWnd),mciSendStr("CLOSE WAVE",@cBuffer,oDlg:hWnd),oDlg:End() )

   REDEFINE BUTTON oFind ID 116 OF oDlg ACTION (cFile:=cGetFile("Wave Audio File (*.wav) | *.wav","Select a Wave Audio File"),;
    mciSendStr("CLOSE WAVE",@cBuffer,oDlg:hWnd),;
    mciSendStr("OPEN WAVEAUDIO!"+Upper(Alltrim(cFile))+" ALIAS WAVE",@cBuffer,oDlg:hWnd),;
    oFile:Refresh()==nil)

   REDEFINE GET oFile VAR cFile ID 300 OF oDlg VALID;
   (If(Empty(cFile),(cFile:=cGetFile("Wave Audio File (*.wav) | *.wav","Select a Wave Audio File"))!=nil,.t.),;
    mciSendStr("CLOSE WAVE",@cBuffer,oDlg:hWnd)!=-1,;
    mciSendStr("OPEN WAVEAUDIO!"+Upper(Alltrim(cFile))+" ALIAS WAVE",@cBuffer,oDlg:hWnd)!=-1,;
    oFile:Refresh()==nil)


   REDEFINE CHECKBOX oL1 VAR l1 ID 150 OF oDlg
   REDEFINE CHECKBOX oL2 VAR l2 ID 151 OF oDlg
   REDEFINE CHECKBOX oL3 VAR l3 ID 152 OF oDlg
   REDEFINE CHECKBOX oL4 VAR l4 ID 153 OF oDlg
   REDEFINE CHECKBOX oL5 VAR l5 ID 154 OF oDlg
   REDEFINE CHECKBOX oL6 VAR l6 ID 155 OF oDlg
   REDEFINE CHECKBOX oL7 VAR l7 ID 156 OF oDlg
   REDEFINE CHECKBOX oL8 VAR l8 ID 157 OF oDlg
   REDEFINE SAY oN9  PROMPT n9  ID 158 OF oDlg
   REDEFINE SAY oN10 PROMPT n10 ID 159 OF oDlg

   mciSendStr("CAPABILITY WAVE DEVICE TYPE"      ,@cBuffer,oDlg:hWnd)
   REDEFINE SAY oType PROMPT UPPER(cBuffer) ID 190 OF oDlg

   AuxGetVol(5,@nVolL,@nVolR)
   REDEFINE SAY oTextLV PROMPT Str(nVolR) ID 122 OF oDlg
   REDEFINE SAY oTextRV PROMPT Str(nVolR) ID 123 OF oDlg

   GetStat(@acStat,@oDlg)
   For nA=1 TO LEN(aoStat)
      cPrompt := acStat[nA]
      REDEFINE SAY aoStat[nA] PROMPT cPrompt ID 160+(nA-1) OF oDlg
   Next nA

   REDEFINE SCROLLBAR oSBRight ID 130 RANGE 0,32 ;
    ON UP   (AuxGetVol(5,@nVolL,@nVolR),;
             AuxSetVol(5,if(nVolL<63000,nVolL+2047,nVolL),nVolR),;
             AuxGetVol(5,@nVolL,@nVolR),;
             oTextLV:SetText(Str(nVolL)),oTextRV:SetText(Str(nVolR)) ) ;
    ON DOWN (AuxGetVol(5,@nVolL,@nVolR),;
             AuxSetVol(5,if(nVolL>2047,nVolL-2047,nVolL),nVolR),;
             AuxGetVol(5,@nVolL,@nVolR),;
             oTextLV:SetText(Str(nVolL)),oTextRV:SetText(Str(nVolR)) )  OF oDlg

   REDEFINE SCROLLBAR oSBLeft  ID 131 RANGE 0,32 ;
    ON UP  (AuxGetVol(5,@nVolL,@nVolR),;
            AuxSetVol(5,nVolL,if(nVolR<63000,nVolR+2040,nVolR)),;
            AuxGetVol(5,@nVolL,@nVolR),;
            oTextLV:SetText(Str(nVolL)),oTextRV:SetText(Str(nVolR)) ) ;
    ON DOWN (AuxGetVol(5,@nVolL,@nVolR),;
             AuxSetVol(5,nVolL,if(nVolR>2047,nVolR-2040,nVolR)),;
             AuxGetVol(5,@nVolL,@nVolR),;
             oTextLV:SetText(Str(nVolL)),oTextRV:SetText(Str(nVolR)) ) OF oDlg

   ACTIVATE DIALOG oDlg ON INIT (oSBLeft:SetPos(nVolL/2047)==oSBRight:SetPos(nVolR/2047),oTimer:Activate()==Nil)

   RELEASE TIMER oTimer   

   RETURN Nil

Static Function GetStat(acStat,oDlg)
   Local cBuffer:=Space(200),aMessages:={"STATUS WAVE ALIGNMENT",;
                                         "STATUS WAVE BITSPERSAMPLE",;
                                         "STATUS WAVE BYTESPERSEC",;
                                         "STATUS WAVE CHANNELS",;
                                         "STATUS WAVE CURRENT TRACK",;
                                         "STATUS WAVE FORMAT TAG",;
                                         "STATUS WAVE INPUT",;
                                         "STATUS WAVE LENGTH",;
                                         "STATUS WAVE LEVEL",;
                                         "STATUS WAVE MEDIA PRESENT",;
                                         "STATUS WAVE MODE",;
                                         "STATUS WAVE NUMBER OF TRACKS",;
                                         "STATUS WAVE OUTPUT",;
                                         "STATUS WAVE POSITION",;
                                         "STATUS WAVE READY",;
                                         "STATUS WAVE SAMPLESPERSEC",;
                                         "STATUS WAVE START POSITION",;
                                         "STATUS WAVE TIME FORMAT" }
   Local nA,cActTrack

   For nA=1 TO Len(aMessages)
      mciSendStr(aMessages[nA],@cBuffer,oDlg:hWnd)
      acStat[nA]=Upper(trim(cBuffer))
   Next nA
   Return nil

Static Function RefreshStat(aoStat,acStat)
   Local nA
   
   For nA=1 to Len(aoStat)
      aoStat[nA]:SetText(acStat[nA])
   Next nA
   Return nil


Static Function ActPista(oDlg)
   Local nActPista,cBuffer:=Space(200)

   mciSendStr("STATUS WAVE CURRENT TRACK",@cBuffer,oDlg:hWnd)
   nActPista=Val(cBuffer)

   Return "TRACK : "+Ltrim(Str(nActPista))


Static Function OpenClose(oDlg)
   Local cStatus,cBuffer:=Space(200)

   mciSendStr("STATUS WAVE MODE",@cBuffer,oDlg:hWnd)

   If Upper(cBuffer)="ABIERTO" //.or. Empty(Upper(cBuffer))
      mciSendStr("SET WAVE DOOR CLOSED",@cBuffer,oDlg:hWnd)
   Else
      mciSendStr("SET WAVE DOOR OPEN",@cBuffer,oDlg:hWnd)
   Endif
  
   Return nil


Static Function AvPista(oDlg)
   Local nActPista,cBuffer:=Space(200)

   mciSendStr("STATUS WAVE CURRENT TRACK",@cBuffer,oDlg:hWnd)
   nActPista=Val(cBuffer)

   mciSendStr("SEEK WAVE TO "+ltrim(Str(nActPista+1)),@cBuffer,oDlg:hWnd)
  
   Return nil

Static Function RePista(oDlg)
   Local nActPista,cBuffer:=Space(200)

   mciSendStr("STATUS WAVE CURRENT TRACK",@cBuffer,oDlg:hWnd)
   nActPista=Val(cBuffer)

   mciSendStr("SEEK WAVE TO "+ltrim(Str(nActPista-1)),@cBuffer,oDlg:hWnd)
   
   Return nil
