// FiveWin - Visual Basic VBX controls support !!!
// Ready to use !!!!!

#include "FiveWin.ch"
#include "Constant.ch"
#include "Set.ch"

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TVbControl FROM TControl

   CLASSDATA aEventNames           // Just one array to all object instances

   DATA   hCtl
   DATA   aEvents

   METHOD New( nRow, nCol, nWidth, nHeight, oWnd, cVbxFile, cVbxClass,;
               aEvents, bWhen, bValid ) CONSTRUCTOR

   METHOD ReDefine( nId, oWnd, nClrFore, nClrBack, aEvents, bWhen,;
                    bValid ) CONSTRUCTOR

   METHOD Init( hDlg )

   METHOD GetPropName( nProp ) INLINE VBXGetPrpName( ::hCtl, nProp - 1 )

   METHOD aGetProps()

   METHOD Default()

   METHOD SetProp( nProp, uValue ) INLINE VBXSetProp( ::hCtl, nProp - 1, uValue )

   METHOD GetName() INLINE GetClassName( ::hWnd )

   METHOD nGetProps() INLINE VBXGetNumProps( ::hCtl )

   METHOD nGetEvents() INLINE VBXGetNumEvents( ::hCtl )

   METHOD GetEvent( nEvent ) INLINE VBXGetEveName( ::hCtl, nEvent - 1 )

   METHOD GetEnums( cnProp ) INLINE VBXGetEnums( ::hCtl, cnProp )

   METHOD Get( cPropName ) INLINE VBXGetPrpByName( ::hCtl, cPropName )

   METHOD Set( cPropName, uValue ) INLINE ;
                          VBXSetPrpByName( ::hCtl, cPropName, uValue )

   METHOD GetProp( nProp ) INLINE VBXGetProp( ::hCtl, nProp - 1 )

   METHOD GetPropType( nProp ) INLINE VBXGetPrpType( ::hCtl, nProp - 1 )

   METHOD HandleEvent( nMsg, nWParam, nLParam )

   METHOD VbxEvent( hCtl, bEvent, cEvent ) EXTERN __VBXEvent()

   METHOD MouseMove( nRow, nCol, nFlags ) VIRTUAL

   METHOD VbxInherit()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, nWidth, nHeight, oWnd, cVbxFile, cVbxClass,;
            aEvents, bWhen, bValid ) CLASS TVbControl

   DEFAULT nWidth := 60, nHeight := 60, oWnd := GetWndDefault(),;
           cVbxClass := Upper( SubStr( cVbxFile, 1, At( ".", cVbxFile ) - 1 ) ),;
           aEvents := {}

   ::nTop     = nRow * SAY_CHARPIX_H
   ::nLeft    = nCol * SAY_CHARPIX_W
   ::nBottom  = nRow + nHeight - 1
   ::nRight   = nCol + nWidth - 1
   ::oWnd     = oWnd
   ::cCaption = ""
   ::nStyle   = nOr( WS_CHILD, WS_VISIBLE, WS_TABSTOP )  // Default VBX style
   ::lDrag    = .f.
   ::aEvents  = aEvents
   ::bWhen    = bWhen
   ::bValid   = bValid

   ::Default()

   if File( cVbxFile )
      if Empty( ::hCtl := VBXCreate( oWnd:hWnd, ::GetNewId(), cVbxFile,;
                          cVbxClass, ::cCaption, ::nStyle, ::nLeft, ::nTop,;
                          nWidth, nHeight, 0 ) )
         MsgAlert( "Could not create VBX" )
         return nil
      else
         ::hWnd = VBXGetHWnd( ::hCtl )
         ::Link()
         ::VbxInherit()
      endif
   else
      MsgAlert( "VBX not found!" )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, oWnd, nClrFore, nClrBack, aEvents, bWhen, bValid ) CLASS TVbControl

   DEFAULT aEvents := {}

   ::nId     = nId
   ::oWnd    = oWnd
   ::hCtl    = 0
   ::aEvents = aEvents
   ::bWhen   = bWhen
   ::bValid  = bValid

   ::SetColor( nClrFore, nClrBack )

   if oWnd != nil
      oWnd:DefControl( Self )
   endif

   ::Default()

return nil

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TVbControl

   Super:Init( hDlg )

   if Empty( ::hCtl := VBXGetHCtl( ::hWnd ) )
      MsgAlert( "Error initializing VBX control ID: " + Str( ::nId, 4 ) )
      return nil
   endif

   ::VbxInherit()

return nil

//----------------------------------------------------------------------------//

METHOD InitEvents() CLASS TVbControl

   local n, nEvents, aEvents

   aEvents = {}
   nEvents = ::nGetEvents()

   for n = 1 to nEvents
      AAdd( aEvents, ::GetEvent( n ) )
   next
   ::aEventNames = aEvents

return nil

//----------------------------------------------------------------------------//

METHOD aGetProps() CLASS TVbControl

   local aProps := {}
   local nProps := ::nGetProps()
   local n

   for n = 1 to nProps
      AAdd( aProps, ::cGetProp( n ) )
   next

return aProps

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TVbControl

   if nMsg == FM_VBXEVENT
        
      return ::VbxEvent( ::hCtl,;
                         ::aEvents[ nWParam + 1 ],;
                         nLParam )
   endif

return Super:HandleEvent( nMsg, nWParam, nLParam )

//----------------------------------------------------------------------------//

METHOD Default() CLASS TVbControl

   if ! lRegistered

      // VbxInit() has to be called before Registering "VbControl" !!!

      if ! VbxInit( GetInstance(), "" )
         MsgAlert( "VBX support not available" )
         return nil
      endif

      lRegistered = .t.
      RegisterClass( "VbControl", nOR( CS_VREDRAW, CS_HREDRAW ) )
   endif

   ::oWnd:lVbx = .t.

return nil

//----------------------------------------------------------------------------//

METHOD VBXInherit() CLASS TVbControl

    static oTVbControl

    local nProps  := ::nGetProps()
    local nEvents := ::nGetEvents()
    local nClassH, n, cName, aEvents, nAt
    local lExact  := Set( _SET_EXACT, .t. )

    if oTVbControl == nil
        oTVbControl = TVbControl()
    endif

    if ( nClassH := _NewClass( ::GetName(), oTVbControl ) ) > 0

        if nEvents > 0

            CLASSDATA aEventNames

            aEvents = Array( nEvents )

            for n = 1 to nEvents
                aEvents[ n ] = Upper( ::GetEvent( n ) )
            next

        endif

        for n = 1 to nProps
            cName = ::GetPropName( n )
            if VBXIsArray( ::hCtl, n - 1 )
                _AddMethod( cName, bArrayProp( n - 1 ), 0, 3 )
            else
                _AddMethod( cName, bGetProp( n - 1 ), 0, 3 )
                _AddMethod( "_" + cName, bSetProp( n - 1 ), 0, 3 )
            endif
        next

        SetClsHandle( Self, nClassH )

        ::aEventNames = aEvents

    elseif ( nClassH := __CLASSHANDLE( ::GetName() ) ) > 0
        SetClsHandle( Self, nClassH )
    endif

    aEvents = Array( nEvents )

    if ! Empty( ::aEvents )
        for n = 1 to Len( ::aEvents ) STEP 2
            if ! Empty( ::aEvents[ n ] ) .and. ;
               ( nAt := AScan( ::aEventNames, Upper( ::aEvents[ n ] ) ) ) > 0
                aEvents[ nAt ] = ::aEvents[ n + 1 ]
            endif
        next
    endif

    ::aEvents = aEvents

    Set( _SET_EXACT, lExact )

return nil

//---------------------------------------------------------------------------//

static function bGetProp( n )
return { | Self | VBXGetProp( ::hCtl, n ) }

//---------------------------------------------------------------------------//

static function bSetProp( n )
return { | Self, uValue | VBXSetProp( ::hCtl, n, uValue ) }

//---------------------------------------------------------------------------//

static function bArrayProp( n )
return { | Self, nIndex, uValue | if( pCount() > 2, ;
                                  VBXArrayAt( ::hCtl, n, nIndex - 1, uValue ),;
                                  VBXArrayAt( ::hCtl, n, nIndex - 1 ) ) }

//---------------------------------------------------------------------------//
