// FiveWin Text editing Class
// FiveWin Editing tools

// Warning: Under construction. Not available yet!

#include "FiveWin.ch"

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TText FROM TWBrowse

   DATA    aLines, cKeyWords, aKeyColors
   DATA    cFileName
   DATA    cOperators, nOperators

   METHOD  New( nTop, nLeft, nWidth, nHeight, cFileName, oWnd ) CONSTRUCTOR
   METHOD  Load( cFileName )

   METHOD  DrawLine( nRow, nClrBack )

   METHOD  DrawSelect() INLINE ::DrawLine( ::nRowPos, ::nClrBackFocus )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nWidth, nHeight, cFileName, oWnd ) CLASS TText

   Super:New( nTop, nLeft, nWidth, nHeight, { || { "" } }, { "Editing" },;
              { 300 }, oWnd )

   ::cKeyWords  = "function  " + ;
                  "MENU      " + ;
                  "MENUITEM  " + ;
                  "#include  " + ;
                  "BRUSH     " + ;
                  "nil       " + ;
                  "local     " + ;
                  "REDEFINE  " + ;
                  "if        " + ;
                  "endif     " + ;
                  "else      "

   ::cOperators = "+-/:==%(){}@"
   ::aKeyColors = { CLR_HRED, CLR_HCYAN, CLR_HBLUE, CLR_YELLOW, CLR_WHITE,;
                    CLR_HGREEN, CLR_YELLOW, CLR_HRED, CLR_YELLOW,;
                    CLR_YELLOW, CLR_YELLOW }
   ::nOperators = CLR_WHITE

   ::Load( cFileName )
   ::SetArray( ::aLines )
   ::bLine = { || { ::aLines[ ::nAt ] } }

return nil

//----------------------------------------------------------------------------//

METHOD DrawLine( nRow, nClrBack ) CLASS TText

   local cWord
   local nOffset := 0, nAt
   local cTextLine := ::aLines[ ::nAt ]
   local nCol := 0
   local nChrHeight
   local lString := .f.

   DEFAULT ::nChrHeight := ::nGetChrHeight(),;
           nClrBack := ::nClrPane,;
           nRow := ::nRowPos

   nChrHeight = ::nChrHeight()
   SetBkColor( ::GetDC(), nClrBack )

   if ::oFont != nil
      SelectObject( ::hDC, ::oFont:hFont )
   endif

   while ! Empty( cWord := cStrWord( cTextLine, @nOffset ) )
      do case
         case lString
              SetTextColor( ::hDC, CLR_HMAGENTA )
              if At( '"', cWord ) != 0
                 lString = .f.
              endif

         case SubStr( LTrim( cWord ), 1, 1 ) >= "0" .and. ;
              SubStr( LTrim( cWord ), 1, 1 ) <= "9"
              SetTextColor( ::hDC, CLR_HCYAN )

         case SubStr( LTrim( cWord ), 1, 1 ) == '"'
              SetTextColor( ::hDC, CLR_HMAGENTA )
              lString = .t.

         case ( nAt := At( PadR( LTrim( cWord ), 10 ), ::cKeyWords ) ) != 0
              SetTextColor( ::hDC, ::aKeyColors[ Int( nAt / 10 ) + 1 ] )

         case At( LTrim( cWord ), ::cOperators ) != 0
              SetTextColor( ::hDC, ::nOperators )

         otherwise
              SetTextColor( ::hDC, ::nClrText )
      endcase
      TextOut( ::hDC, nRow * nChrHeight, nCol, cWord )
      nCol += GetTextWidth( ::hDC, cWord )
   end
   TextOut( ::hDC, nRow * nChrHeight, nCol, Space( 200 ) )

   ::ReleaseDC()

return nil

//----------------------------------------------------------------------------//

METHOD Load( cFileName ) CLASS TText

   local hFile, cLine

   ::aLines    = {}
   ::cFileName = cFileName

   if File( cFileName )
      hFile = FOpen( cFileName )
      while lGetTextLine( hFile, @cLine )
         AAdd( ::aLines, cLine )
      end
      FClose( hFile )
   else
      MsgInfo( "Text Object: I don't find that file!" )
   endif

return nil

//----------------------------------------------------------------------------//
