// Testing Message standard Dialog Boxes

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Main()

   local cName := "Easily editing a string"

   MsgAbout( "Powerfull Msg functions", "FiveWin power" )

   MsgInfo( "Testing defaults" )

   MsgInfo( "General information Message", "Info Title" )

   MsgRun( "This message will be destroyed in 5 seconds",;
           "Now with caption update",;
            { | oDlg | UpdCaption( oDlg ) } )

   MsgWait( "Just wait a little" )

   if MsgGet( "Please type your name",;          // Title
              "Your Name:",;                     // Label
              @cName )                           // A variable by reference

      MsgStop( "Hello " + cName, "A Stop icon Message" )
      MsgStop( "Testing defaults" )

   else

      MsgAlert( "Hey, you did not typed your Name", "Alerting!" )

   endif


   If MsgYesNo( "Are you sure you want to go", "Please select" )

      nMsgBox( "A Normal message", "Ok, Bye!" )
      nMsgBox( "Testing defaults" )

   else

      Alert( "Typicall Clipper Alert function" )   // It does not support
                                                   // all Clipper features
                                                   // yet
   endif

   if MsgRetryCancel( "Lets try again ?" )
      MsgInfo( "You selected Retry" )
   else
      MsgInfo( "You selected Cancel" )
   endif

return nil

//----------------------------------------------------------------------------//

static function UpdCaption( oDlg )

   local nFor

   for nFor := 4 to 0 step -1
       Inkey( 1 )
       oDlg:cMsg := "This message will be destroyed in "+;
                     LTrim( Str( nFor ) ) + " second" + ;
                     If( nFor > 1, "s", "" )
       oDlg:Refresh()
       SysRefresh()
   next

return nil

//----------------------------------------------------------------------------//
