// This sample shows how to use a system windows help.

//----------------------------------------------------------------------------//
//  FiveWin 1.0 - Ejemplos
//  (c) A.Linares, F.Pulpn 1993
//
// Ejemplos de utilizacin del sistema de ayudas de Windows
// Construir con BUILD TestHelp
//----------------------------------------------------------------------------//

#include "FiveWin.ch"

static oWnd

//----------------------------------------------------------------------------//

function Main()

   SET HELPFILE TO "Calc.hlp"      // Este sera nuestro fichero de ayudas
                                   // por defecto

   DEFINE WINDOW oWnd FROM 1, 1 TO 20, 60 ;
      TITLE "Probando las Ayudas de Windows" ;
      MENU BuildMenu()

   SET MESSAGE OF oWnd ;
      TO OemToAnsi( "FiveWin 1.0 - (c) A. Linares, F. Pulpn 1993" )

   ACTIVATE WINDOW oWnd MAXIMIZED

return

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "&Sistema de Ayudas"
      MENU
         MENUITEM "&Llamar a cualquier Ayuda" ;
            MESSAGE "Accedemos a otras Ayudas y seguimos manteniendo " + ;
                    "nuestro fichero de ayudas por defecto" ;
            ACTION WinHelp( "ProgMan.hlp" )     // Un ayuda cualquiera.
                                                // Seguimos manteniendo
                                                // nuestra ayuda por defecto
         SEPARATOR

         MENUITEM OemToAnsi( "&Consultar nuestro ndice" ) ;
            ACTION HelpIndex() ;
            MESSAGE OemToAnsi( "Consultar el ndice del fichero" + ;
                               " asignado de ayudas" )

         MENUITEM OemToAnsi( "&Realizar una bsqueda" ) ;
            ACTION ( HelpIndex(), HelpSearch( "Hola" ) ) ;
            MESSAGE OemToAnsi( "Realizar una bsqueda en nuestro fichero de ayudas" )
                                         ; // La palabra a buscar es opcional

         MENUITEM OemToAnsi( "C&onsultar un determinado tema" ) ;
            ACTION ( HelpIndex(), HelpTopic( "Teclas para obtener ayuda" ) ) ;   // El tema se identifica por un nmero or by a string
            MESSAGE OemToAnsi( "Ir directamente a consultar un tema" )

         MENUITEM OemToAnsi( "E&stablecer un determinado tema" ) ;
            ACTION HelpSetTopic( "How to make $ from Software" ) ;  // You should identify it by a string or a number
            MESSAGE OemToAnsi( "Establecer un tema por defecto" )

         MENUITEM OemToAnsi( "S&olicitar tema por defecto" ) ;
            ACTION MsgInfo( If( ValType( GetHelpTopic() ) == "C", GetHelpTopic(), Str( GetHelpTopic() ) ) ) ;  // Requesting default topic
            MESSAGE OemToAnsi( "Informacin acerca del tema por defecto" )

         MENUITEM OemToAnsi( "C&ambiar la posicin de la Ayuda" ) ;
            ACTION ( HelpIndex(), HelpSetPos( 40, 120, 950, 800, .t. ) ) ;
            MESSAGE OemToAnsi( "Muestra la ayuda y cambia su posicin en pantalla" )
                          // Izquierda, Arriba, Ancho, Alto, Maximizada
                          // Ancho y Alto de 0 a 1024

         MENUITEM "Co&nocer el fichero por defecto" ;
            ACTION MsgInfo( GetHelpFile() ) ;
            MESSAGE "Nos permite conocer cual es el fichero de Ayuda " + ;
                    "que hemos asignado con SET HELPFILE TO..."

         SEPARATOR

         MENUITEM "&Terminar esta demo" ;
            ACTION  If( MsgYesNo( OemToAnsi( "Terminar..." ) ), oWnd:End(),);
            MESSAGE OemToAnsi( "Acabar la demostracin" )

      ENDMENU

      MENUITEM "&Construir Ayudas Windows" ;
         ACTION MsgInfo( "Necesitas algunas herramientas" ) ;
         MESSAGE "Necesitas disponer de WinWord de Microsoft y " + ;
                 "de un compilador de Ayudas Windows"
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//
