// FiveWin - Windows Communications Sample

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Main()

   local cDcb, nBytes
   local nComm := OpenComm( "COM1", 1024, 128 )
   local nError

   if ! BuildCommDcb( "COM1:2400,n,8,1", @cDcb )
      nError = GetCommError( nComm )
      MsgInfo( "BuildCommDcb Error: " + Str( nError ) )
   endif

   if ! SetCommState( cDcb )
      nError = GetCommError( nComm )
      MsgInfo( "SetCommState Error: " + Str( nError ) )
   endif

   if ( nBytes := WriteComm( nComm, "ATZ0" + Chr( 13 ) ) ) < 0
      nError = GetCommError( nComm )
      MsgInfo( "WriteComm Error: " + Str( nError ) )
   else
      // Windows requires to have a Window at least to perform comunications !!!
      // Let's use the MessageBox() Window as default
      MsgInfo( Str( nBytes ) + " bytes sent" )
   endif

   if ( nBytes := WriteComm( nComm, "ATDT 2834830" + Chr( 13 ) ) ) < 0
      nError = GetCommError( nComm )
      MsgInfo( "WriteComm Error: " + Str( nError ) )
   else
      // Windows requires to have a Window at least to perform comunications !!!
      // Let's use the MessageBox() Window as default
      MsgInfo( Str( nBytes ) + " bytes sent" )
   endif

   if FlushComm( nComm, 0 ) != 0
      nError = GetCommError( nComm )
      MsgInfo( "FlushComm Error: " + Str( nError ) )
   endif

   if ! CloseComm( nComm )
      nError = GetCommError( nComm )
      MsgInfo( "CloseComm Error: " + Str( nError ) )
   endif

return nil

//----------------------------------------------------------------------------//
