// Sample managing bitmaps with adjust, scroll and new zoom effects!
// Many thanks to Jesus Hiniesta

#include "FiveWin.ch"

STATIC ownd  //handle a la ventana principal

//----------------------------------------------------------------------------//

FUNCTION main()

local oBar
local oIni
local cUnidad
local oTmr

SET resources TO "..\ide\IDE.DLL"

set 3DLOOK ON

DEFINE WINDOW ownd FROM 1, 1 TO 22, 75 ;
   TITLE  "Test of BITMAP" MENU BuildMenu() ;
   MDI

DEFINE BUTTONBAR oBar OF oWnd

DEFINE BUTTON RESOURCE "BITMAP" OF oBar ;
   ACTION bmpopen()  ;
   MESSAGE oemtoansi("Open a Bitmap")

SET MESSAGE OF ownd ;
   TO oemtoansi( "Fivewin 1.7" )

DEFINE TIMER oTmr INTERVAL 17 OF oWnd ;
   ACTION oWnd:oMsgBar:Say( 4, 580, Time(), CLR_HGREEN, CLR_BLACK,, .t. )

ACTIVATE TIMER oTmr



ACTIVATE WINDOW ownd MAXIMIZED


set resources to
set 3DLOOK OFF

RETURN NIL


function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "&Open"
      MENU
         MENUITEM "&Open BITMAP" ACTION Bmpopen() ;
            MESSAGE OemToAnsi( "Open a BITMAP" )
      ENDMENU

      MENUITEM "&Exit" DISABLED
      MENU
         MENUITEM "&Exit" ACTION ownd:End() ;
            MESSAGE OemToAnsi( "Close Window" )
      ENDMENU
   ENDMENU

return oMenu


function BmpOpen( )

   local oWndBmp, oBar, oBmp, oIcon, oLupa
   local oSay,oFont
   local cBmpFile

   cBmpFile := cGetFile( "Windows Bitmap (*.bmp) | *.bmp",;
                              "Select a BMP" )


   if ! Empty( cBmpFile )

      DEFINE FONT oFont NAME "Arial" SIZE 5, 13


      DEFINE WINDOW oWndBmp FROM 2,2 TO 25,50;
         TITLE "BITMAP " + cBmpFile MDICHILD


      DEFINE BUTTONBAR oBar OF oWndBmp

      DEFINE BUTTON OF oBar RESOURCE "ZOOMOUT" ;
         ACTION ( AjustaZoom( oBmp ,"S",oSay) ) ;
         MESSAGE "ADJUST BITMAP ON WINDOW"

      DEFINE BUTTON OF oBar RESOURCE "DELWATCH" ;
         ACTION ( AjustaZoom( oBmp ,"A",oSay) ) ;
         MESSAGE "+ ZOOM 10%"

      DEFINE BUTTON OF oBar RESOURCE "FONT" ;
         ACTION ( AjustaZoom( oBmp ,"R",oSay) ) ;
         MESSAGE "- ZOOM 10%"

      DEFINE BUTTON OF oBar RESOURCE "BITMAP" ;
         ACTION ( oBmp:lStretch := .f. , oBmp:Reload(),;
                  oBmp:Zoom(1), AjustaZoom(oBmp,"z",oSay)) ;
         MESSAGE "LOAD BITMAP"


      DEFINE BUTTON OF oBar RESOURCE "Report" GROUP ;
         ACTION ( imprimirBmp( cBmpFile,oBmp ) ) ;
         MESSAGE "PRINTER BITMAP"

      DEFINE BUTTON OF oBar RESOURCE "exit" GROUP;
         ACTION oWndBmp:End() ;
         MESSAGE "CLOSE BITMAP"

      @ 9, 210 SAY oSay PROMPT Oemtoansi("BITMAP ADJUST") SIZE 200, 16 ;
         PIXEL OF oBar FONT oFont

      DEFINE CURSOR oLupa RESOURCE "Lupa"

      @ 0, 0 BITMAP oBmp FILENAME cBmpFile SCROLL ADJUST OF oWndBmp ;
         CURSOR oLupa ;
         on left click (AjustaZoom(oBmp,"A",oSay)) ;
         on right click (AjustaZoom(oBmp,"R",oSay))


      oWndBmp:SetControl( oBmp )

      ajustazoom(oBmp,"z",oBar)

      ACTIVATE WINDOW oWndBmp

      RELEASE oFont

   endif

return oWndBmp


function imprimirbmp(Bmp,oBmp)
local oPrn
local nZoom:=oBmp:Zoom()
local anchura:=oBmp:nWidth()*nZoom
local altura :=oBmp:nHeight()*nZoom
PRINT oPrn NAME "BITMAP"
   PAGE
      oPrn:SayBitmap(0,0,bmp,anchura,altura)
   ENDPAGE
ENDPRINT
return nil


Function AjustaZoom(oBmp,cAccion,oSay)
local nZoom:=oBmp:Zoom()

do case
   case cAccion == "S"
       oBmp:lStretch := !oBmp:lStretch
       oBmp:ScrollAdjust()
       oBmp:Refresh( .t. )
   case cAccion == "R"
       if nZoom*10>1
          oBmp:lStretch := .f.
          nZoom:=nZoom-(0.10)
          oBmp:Zoom(nZoom)
          oBmp:Refresh()
          oBmp:ScrollAdjust()
       endif
   case cAccion == "A"
       oBmp:lStretch := .f.
       nZoom:=nZoom+0.10
       oBmp:Zoom(nZoom)
       oBmp:Refresh()
       oBmp:ScrollAdjust()
endcase
if oBmp:lStretch
      oSay:SetText(Oemtoansi("BITMAP ADJUST"))
else
      oSay:SetText(Oemtoansi( "ZOOM BITMAP...: "+alltrim(str(nZoom*100,10,0))+"%"))
endif

return NIL

//----------------------------------------------------------------------------//

//----------------------------------------------------------------------------//


