// Reviewing two dimension arrays - using FiveWin TWBrowse

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Main()

   local oDlg, oBrw
   local aSample := { { "First row one",  "First row two" },;
                      { "Second row one", "Second row two" },;
                      { "Third row one",  "Third row two" },;
                      { "Fourth row one", "Fourth row two" } }
   local nItem := 1

   DEFINE DIALOG oDlg FROM 2, 2 TO 20, 60 TITLE "FiveWin TWBrowse Power!!!"

   @ 1, 2 LISTBOX oBrw ;
      FIELDS aSample[ nItem, 1 ], aSample[ nItem, 2 ] ;
      HEADERS "Reviewing two dimensions", "Array" ;
      FIELDSIZES 150, 150 ;
      OF oDlg ;
      SIZE 150, 100

   oBrw:bGoTop    = { || nItem := 1 }
   oBrw:bGoBottom = { || nItem := Eval( oBrw:bLogicLen ) }
   oBrw:bSkip     = { | nWant, nOld | nOld := nItem, nItem += nWant,;
                        nItem := Max( 1, Min( nItem, Eval( oBrw:bLogicLen ) ) ),;
                        nItem - nOld }
   oBrw:bLogicLen = { || Len( aSample ) }
   oBrw:cAlias    = "Array"                // Just put something

   @ 1, 25 BUTTON "&End" OF oDlg ACTION oDlg:End()

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//
