#include <WinTen.h>
#include <Windows.h>
#include <CommDlg.h>
#include <ClipApi.h>

#define PORTRAIT              1
#define LANDSCAPE             2
#define SETCOPYCOUNT         17
#define GETSETPAPERORIENT    30

static far PRINTDLG pd;
static far BOOL bInit = FALSE;

//----------------------------------------------------------------------------//

CLIPPER GetPrintDC() // ( hWndOwner ) --> hDC
{
   // PRINTDLG pd;

   if( ! bInit )
   {
      bInit = TRUE;
      _bset( ( BYTE * ) &pd, 0, sizeof( PRINTDLG ) );
   }

   pd.lStructSize = sizeof( PRINTDLG );
   pd.hwndOwner   = _parni( 1 );
   pd.Flags       = PD_RETURNDC | PD_USEDEVMODECOPIES;

   _retni( PrintDlg( &pd ) ? pd.hDC: 0 );
}

//----------------------------------------------------------------------------//

CLIPPER PRINTERSET() // up( hWndOwner ) --> nil
{
   // PRINTDLG pd;

   if( ! bInit )
   {
      bInit = TRUE;
      _bset( ( BYTE * ) &pd, 0, sizeof( PRINTDLG ) );
   }

   pd.lStructSize = sizeof( PRINTDLG );
   pd.hwndOwner   = IF( PCOUNT() == 0, GetActiveWindow(), _parni( 1 ) );
   pd.Flags       = PD_PRINTSETUP | PD_USEDEVMODECOPIES;

   PrintDlg( &pd );
}

//----------------------------------------------------------------------------//

CLIPPER GetPrinter() // DC()
{
   char szPrinter[ 100 ];
   LPSTR szDevice = 0, szOutput = 0;
   WORD w = 0;

   if( GetProfileString( "windows", "device", ",,,", szPrinter, 80 ) )
   {
      while( szPrinter[ w ] )
      {
         if( szPrinter[ w ] == ',' )
         {
            szPrinter[ w ] = 0;
            if( szDevice == 0 )
               szDevice = szPrinter + w + 1;
            else
               szOutput = szPrinter + w + 1;
         }
         w++;
      }
      _retni( CreateDC( szDevice, szPrinter, szOutput, 0 ) );
   }

   _retni( 0 );
}

//----------------------------------------------------------------------------//

CLIPPER StartDOC()
{
   DOCINFO info;

   info.cbSize      = sizeof( DOCINFO );
   info.lpszDocName = _parc( 2 );
   info.lpszOutput  = _parc( 3 );

   _retni( StartDoc( _parni( 1 ),       // hDC printer device
                     &info ) );
}

//----------------------------------------------------------------------------//

CLIPPER EndDOC()
{
   _retni( EndDoc( _parni( 1 ) ) );     // hDC printer device
}

//----------------------------------------------------------------------------//

CLIPPER StartPAGE()
{
   _retni( StartPage( _parni( 1 ) ) );  // hDC printer device
}

//----------------------------------------------------------------------------//

CLIPPER EndPAGE()
{
   _retni( EndPage( _parni( 1 ) ) );    // hDC printer device
}

//----------------------------------------------------------------------------//

CLIPPER PRNLANDSCA() // PE( hDC )  --> lSuccess
{
   LONG lMode = LANDSCAPE;

   _retl( Escape( ( HDC ) _parni( 1 ), GETSETPAPERORIENT, sizeof( lMode ),
          &lMode, 0 ) );
}

//----------------------------------------------------------------------------//

CLIPPER PRNPORTRAI() // T( hDC )  --> lSuccess
{
   LONG lMode = PORTRAIT;

   _retl( Escape( ( HDC ) _parni( 1 ), GETSETPAPERORIENT, sizeof( lMode ),
          &lMode, 0 ) );
}

//----------------------------------------------------------------------------//

CLIPPER PRNSETCOPI() // ES( hDC, nCopies )  --> lSuccess
{
   WORD wCopies = _parni( 2 );

   _retl( Escape( ( HDC ) _parni( 1 ), SETCOPYCOUNT, sizeof( wCopies ),
                  &wCopies, 0 ) == 1 );
}

//----------------------------------------------------------------------------//

CLIPPER ESCAPE() // ( hDC, nEscape, cInput, @cOutPut ) --> nReturn
{
   BYTE * pBuffer = IF( PCOUNT() == 4, _xgrab( _parclen( 3 ) ), 0 );

   _retni( Escape( _parni( 1 ), _parni( 2 ), _parclen( 3 ), _parc( 3 ),
                   pBuffer ) );

   if( pBuffer )
   {
      _storclen( pBuffer, _parclen( 3 ), 4 );
      _xfree( pBuffer );
   }
}

//----------------------------------------------------------------------------//
