// A nice Odometer developed by a FiveWin user

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Odo()

   local oDlg, oBmp1, oBmp2, oBmp3

   DEFINE DIALOG oDlg FROM 1, 1 TO 10, 44 TITLE "PROBANDO EL CONTADOR"

   // @  2, 5 SAY 'Contador : ' OF oDlg

   @  0, 0 BITMAP oBmp1 FILE "..\bitmaps\odo.bmp" OF oDlg
   @  0, 0 BITMAP oBmp2 FILE "..\bitmaps\odo.bmp" OF oDlg
   @  0, 0 BITMAP oBmp3 FILE "..\bitmaps\odo.bmp" OF oDlg

   oBmp1:nTop    := 28
   oBmp1:nLeft   := 80
   oBmp1:nBottom := 34
   oBmp1:nRight  := 84

   oBmp2:nTop    := 28
   oBmp2:nLeft   := 85
   oBmp2:nBottom := 34
   oBmp2:nRight  := 89

   oBmp3:nTop    := 28
   oBmp3:nLeft   := 90
   oBmp3:nBottom := 34
   oBmp3:nRight  := 94

   @ 4, 02 BUTTON "&Aumenta"   OF oDlg SIZE 40, 12 ;
      ACTION Cambia( oBmp1, oBmp2, oBmp3, .T. )

   @ 4, 10 BUTTON "&Disminuye" OF oDlg SIZE 40, 12 ;
      ACTION Cambia( oBmp1, oBmp2, oBmp3, .F. )

   @ 4, 18 BUTTON "&Solo" OF oDlg SIZE 40, 12 ;
      ACTION Solo( oBmp1, oBmp2, oBmp3 )

   ACTIVATE DIALOG oDlg CENTERED

return

//----------------------------------------------------------------------------//
function Solo( oB1, oB2, oB3 )

  local n

  for n = 1 to 2500

      Cambia( oB1, oB2, oB3, .T. )

      SysRefresh()

  next

  for n = 1 to 2500

      Cambia( oB1, oB2, oB3, .F. )

      SysRefresh()

  next

return

//----------------------------------------------------------------------------//
function Cambia( oBmp1, oBmp2, oBmp3, lSigno )
STATIC nCont  := 0
LOCAL nInc := iif( lSigno, 1, -1 )
LOCAL nCam := iif( lSigno, -100, -99 )
LOCAL nTopeI := iif( lSigno, -110, 0 )
LOCAL nTopeS := iif( lSigno, 0, -110 )

if ! lSigno .and. nCont == 0
   return
endif

if oBmp3:nX == nTopeI
   oBmp3:nX := nTopeS
endif
if oBmp2:nX == nTopeI 
   oBmp2:nX := nTopeS 
endif
if oBmp1:nX == nTopeI 
   oBmp1:nX := nTopeS 
endif

oBmp3:nX -= nInc
nCont += nInc
if oBmp3:nX <= nCam
   oBmp2:nX -= nInc
   if oBmp2:nX <= nCam
      oBmp1:nX -= nInc
   endif
endif


oBmp3:Refresh( .F. )
oBmp2:Refresh( .F. )
oBmp1:Refresh( .F. )

return
//---------------------------------------------------------------------------//
