// FiveWin ODBC management !!!

// ODBC = Open DataBase Connectivity

#include "FiveWin.ch"
#include "sql.ch"

STATIC oWnd
STATIC oDbc
STATIC cnameodbc
STATIC cNombre

//----------------------------------------------------------------------------//

function Main()

   LOCAL oBrush

   set date to italian

   oDbc:=NIL
   cNombre:="temp0000"

   DEFINE WINDOW oWnd FROM 1, 1 TO 20, 75 TITLE "Testing ODBC" ;
      MENU BuildMenu()

   @ 2, 2 BITMAP FILE "ODBC.bmp" OF oWnd

   @ 12, 2 BITMAP FILE "ODBC2.bmp" OF oWnd

   ACTIVATE WINDOW oWnd valid finishodbc()

return nil

//----------------------------------------------------------------------------//

function Initodbc()
LOCAL odlg
local naccion
local oDSN
local cDSN := space(20)
local oUsuario
local cUsuario := space(20)
local oPassword
local cPassword := space(20)

   naccion:=0

   DEFINE DIALOG oDlg FROM 2, 2 TO 14, 67 TITLE "Connect to ODBC"

   @ 1, 2 SAY "DSN..: " OF oDlg
   @ 1, 8 GET oDSN VAR cDSN OF oDlg COLOR "N/W+"

   @ 2, 2 SAY "Usuario..: " OF oDlg
   @ 2, 8 GET oUsuario VAR cUsuario OF oDlg COLOR "N/W+"

   @ 3, 2 SAY "Password..: " OF oDlg
   @ 3, 8 GET oPassword VAR cPassword OF oDlg COLOR "N/W+"


   @ 5, 1 BUTTON "&Manual" OF oDlg ;
      ACTION ( NACCION:=1,oDlg:End() )

   @ 5, 11 BUTTON "&Automatica" OF oDlg ;
      ACTION ( NACCION:=2,oDlg:End() )

   @ 5, 25 BUTTON "&Cancelar" OF oDlg ;
      ACTION ( NACCION:=3,oDlg:End() )

   ACTIVATE DIALOG oDlg

   //inicializa conexion logica con el ODBC
   DO CASE
      CASE nAccion == 2
         if oDbc!=NIL
            finishodbc()
         endif
         oDbc := TDbOdbc():New( alltrim(cDSN),alltrim(cUsuario) , alltrim(cPassword), ,.F. )
      CASE nAccion == 1
         if oDbc!=NIL
            finishodbc()
         endif
         oDbc := TDbOdbc():New( , , ,"DSN="+alltrim(cDSN) , .t. )
      OTHERWISE
         RETURN .f.
   endcase


   if oDbc:nRetorno!=0
      msgInfo("Error en conexin lgica " + str(oDbc:nRetorno) )
      oWnd:end()
      return .f.
    else
      cnameodbc:=alltrim(cDSN)
      msginfo("Connect to DRIVER " + oDbc:GetInfo(SQL_DRIVER_NAME) +;
              " VERSION " + oDbc:GetInfo(SQL_DRIVER_VER ))
   endif

return .t.

//----------------------------------------------------------------------------//

function finishodbc()

if oDbc != NIL
   oDbc:End()
   oDbc:=NIL
endif

return .t.

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "&Operations" ACTION TestOdbc()
      MENU
         MENUITEM "&Connect to ODBC" ;
            ACTION (Initodbc())

         MENUITEM "&Desconnect to ODBC" ;
            ACTION (finishodbc())
         SEPARATOR
         MENUITEM "&Order SQL for ODBC" ;
            ACTION Testodbc()
   ENDMENU


   MENUITEM oemtoansi( "&Exit" )
   MENU
      MENUITEM "&Exit" ;
         ACTION (ownd:End())
   ENDMENU
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function TestOdbc()

   local oDlg
   local oStmt
   local oName, cName
   local cConsulta:=space(300)
   local nAccion:=0
   local ncampos
   local nt:=0
   local nc:=1
   local ctexto:=space(0)

   if oDBC==NIL
      msgalert("No Connect to ODBC")
      return NIL
   endif

   //Estable una primera conexion fsica con el ODBC
   oStmt := OdbcStmt():New(oDbc)

   if oStmt:nRetorno!=0
      msgInfo("Error en conexin fsica "+str(oDbc:nRetorno))
      oStmt:End()
      return nil
   endif

   //Datos para una primera consulta
   DEFINE DIALOG oDlg FROM 1, 1 TO 14, 80 TITLE "Order SQL for ODBC -"+cNameodbc+"-"

   @ 1, 2 SAY "Texto de la consulta..: " OF oDlg
   @ 1, 12 GET oName VAR cConsulta OF oDlg ;
            MEMO SIZE 200,52 COLOR "W+/RB"

   @ 6 , 5 BUTTON "&Ejecutar" OF oDlg ;
      ACTION ( nAccion:=1,oDlg:End() )

   @ 6 , 19 BUTTON "&Cancelar" OF oDlg ;
      ACTION ( nAccion:=2,oDlg:End() )

   ACTIVATE DIALOG oDlg

   if naccion == 1 .and. len(alltrim(cConsulta))>10

      oStmt:Execute( cConsulta )
      if oStmt:nRetorno!=SQL_SUCCESS //consulta erronea
         oStmt:End()
         return nil
      endif

      //si no es una select no se ejecuta browser
      if substr(cConsulta,1,1)=="S" .or. substr(cConsulta,1,1)=="s"
      else
         oStmt:End()
         return nil
      endif

      oStmt:InitFields()

      dbcreate(cNombre,oStmt:aFields)
      nCampos:=oStmt:FCount()

      dbusearea(,,cNombre)

      do while (oStmt:Skip()==0)                    // Go to first element selected ???

         dbappend()

         for nt:=1 to ncampos
            ctexto:=oStmt:odbcFget(nt)
            nc++
            fieldput(nt,ctexto)
         next

      enddo

      dbgotop()

      Browse( "Resultado Consulta ODBC",;
              "Volcado sobre una DBF local",,,,,)


      dbclosearea()
      Ferase(cnombre+".dbf")

   endif

   oStmt:End()

return nil

//----------------------------------------------------------------------------//
function descompone(ctexto)
local nlen:=len(ctexto)
local csal:=space(0)
local nt:=1

for nt:=1 to nLen
   csal:=csal+alltrim(str(asc(substr(ctexto,nt,1))))+" "
next

return cSal




