// FiveWin IDE - Object Inspector MDIChild Window

#include "FiveWin.ch"

static aObjBmps

//----------------------------------------------------------------------------//

function ObjInspect( oObject, cTitle )

   local oWndObj, oIco, oBar, oBrw
   local aObjInfo
   local nItem := 1

   CursorWait()

   DEFAULT aObjBmps := GetObjBmps()

   if ValType( oObject ) == "O"
      aObjInfo = aOData( oObject )
      // Let's give the Data Names the 'hungarian notation' look
      AEval( aObjInfo, { | cData, n | aObjInfo[ n ] := cChr2Data( cData ) } )
   endif

   DEFAULT cTitle := If( ValType( oObject ) == "O",;
                         "Object Inspector",;
                         "Array Inspector" )

   DEFINE ICON oIco RESOURCE "Objects"

   DEFINE WINDOW oWndObj FROM 1, 1 TO 23, 33 ;
      TITLE If( ValType( oObject ) == "O", "Object Inspector: ",;
                "Array Inspector: " ) + cTitle ;
      MDICHILD OF GetWndMain() ;
      ICON oIco

   DEFINE BUTTONBAR oBar OF oWndObj

   DEFINE BUTTON OF oBar RESOURCE "Inspect" ;
      MESSAGE "Review this contained Object" ;
      ACTION DataInspect( oObject, nItem, aObjInfo, cTitle )

   DEFINE BUTTON GROUP OF oBar RESOURCE "ClassName" ;
      MESSAGE "Review ClassName Object" ;
      ACTION MsgInfo( "ClassName: " + oObject:ClassName() )

   DEFINE BUTTON OF oBar RESOURCE "Hierarchy" ;
      MESSAGE "Review this Class Hierarchy" ;
      ACTION  MsgInfo( cGetHierarchy( oObject ) )

   @ 0, 0 LISTBOX oBrw FIELDS "" ;
      HEADERS "  ", "Data", "Value" ;
      FIELDSIZES 16, 90, 300 ;
      OF oWndObj ;
      SIZE 400, 400 ;
      ON DBLCLICK DataInspect( oObject, nItem, aObjInfo, cTitle )

   oBrw:bLine = { || aGetData( oObject, nItem, aObjInfo, cTitle ) }

   // Browsing an Array using FiveWin a TWBrowse Object !

   oBrw:bGoTop    = { || nItem := 1 }
   oBrw:bGoBottom = { || nItem := Eval( oBrw:bLogicLen ) }

   oBrw:bSkip     = { | nWant, nOld | nOld := nItem, nItem += nWant,;
                        nItem := Max( 1, Min( nItem, Eval( oBrw:bLogicLen ) ) ),;
                        nItem - nOld }

   oBrw:bLogicLen = { || If( ValType( oObject ) == "O", Len( aObjInfo ),;
                             Len( oObject ) ) }
   oBrw:cAlias    = "Array"  // We need a non empty cAlias !

   oWndObj:SetControl( oBrw )

   ACTIVATE WINDOW oWndObj

return nil

//----------------------------------------------------------------------------//

static function cGetData( uData, cType )

   local cResult := ""

   do case
      case cType == "B"
           cResult = "{ || ... }"

      case cType == "A"
           cResult = "[ ... ]"

      case cType == "O"
           cResult = "Object"

      case cType == "U"
           cResult = "Undefined"

      otherwise
           cResult = cValToChar( uData )
   endcase

return cResult

//----------------------------------------------------------------------------//

static function DataInspect( oObject, nItem, aObjInfo, cTitle )

   local cType := ValType( oObject )
   local cData, uData

   do case
      case cType == "A"
           cData = "[ " + AllTrim( Str( nItem ) ) + " ]"
           if Len( oObject[ nItem ] ) > 0
              ObjInspect( oObject[ nItem ], cTitle + cData )
           else
              MsgInfo( "Array is empty!" )
           endif

      case cType == "O"
           cData = aObjInfo[ nItem ]
           uData = OSend( oObject, cData )
           if ValType( uData ) $ "AO"
              ObjInspect( OSend( oObject, cData ), cTitle + ":" + cData )
           else
              MsgInfo( "I don't find an Object or an Array there!" )
           endif
   endcase

return nil

//----------------------------------------------------------------------------//

static function aGetData( oObject, nItem, aObjInfo )

   local uData, cData, cType

   do case
      case ValType( oObject ) == "A"
           uData = oObject[ nItem ]
           cData = "[ " + AllTrim( Str( nItem ) ) + " ]"

      case ValType( oObject ) == "O"
           uData = OSend( oObject, aObjInfo[ nItem ] )
           cData = aObjInfo[ nItem ]
   endcase

   cType = ValType( uData )

return { aObjBmps[ At( cType, "ABCDLNMOU" ) ], cData, cGetData( uData, cType ) }

//----------------------------------------------------------------------------//

static function cGetHierarchy( oObject )

   local nClass   := oObject:ClassH
   local cClasses := "Class Hierarchy:" + CRLF
   local n := 1

   while n < nClass
      if oObject:ChildLevel( __ClassIns( n ) ) != 0
         cClasses += __ClassNam( n ) + CRLF
      endif
      n++
   end

   cClasses += oObject:ClassName()

return cClasses

//----------------------------------------------------------------------------//

function ThisInspect( oObject )

   local oMenu
   local aPos

   oObject:CoorsUpdate()

   aPos = { oObject:nBottom, oObject:nLeft }
   ClientToScreen( oObject:oWnd:hWnd, aPos )

   MENU oMenu POPUP
      MENUITEM "&Color..." ;
         MESSAGE "Select a new color" ACTION oObject:SelColor()

      MENUITEM "&Font..." ;
         MESSAGE "Select a new font" ACTION oObject:SelFont()

      MENUITEM "&Caption..." ;
         MESSAGE "Edit the current Object text"

      SEPARATOR

      MENUITEM "&Object Inspector..." ;
         MESSAGE "Review the Object data..." ACTION ObjInspect( oObject )

      MENUITEM "&Stack Inspector..." ;
         MESSAGE "Review the application Stack..." ACTION StackInspect()
   ENDMENU

   ACTIVATE POPUP oMenu AT aPos[ 1 ], aPos[ 2 ] OF oObject

return nil

//----------------------------------------------------------------------------//
