// Sample showing how to work with new help techniques from FiveWin.

#include "FiveWin.ch"
#include "NewHelp.ch"

#define SRCPAINT   15597702   // 0xEE0086
#define SRCAND      8913094

static oBmp1, oBmp2, oFont

//----------------------------------------------------------------------------//

function Main()

   local oDlg, oBtn, oCursor

   SET 3DLOOK ON

   DEFINE CURSOR oCursor RESOURCE "Help"

   DEFINE BITMAP oBmp1 RESOURCE "Genie1"
   DEFINE BITMAP oBmp2 RESOURCE "Genie2"

   DEFINE FONT oFont NAME "Arial" SIZE 0, -9

   DEFINE DIALOG oDlg RESOURCE "Test"

   REDEFINE BUTTON oBtn ID ID_HELP OF oDlg ;
      ACTION ( oBtn:Capture(),;
               oBtn:oCursor   := oCursor,;
               oBtn:bLClicked := { | nRow, nCol | ShowHelp( oBtn, nRow, nCol ),;
                                                  ReleaseCapture(),;
                                                  oBtn:oCursor   := nil,;
                                                  oBtn:bLClicked := nil, 0 } )

   ACTIVATE DIALOG oDlg CENTERED

   RELEASE OBJECTS oCursor, oBmp1, oBmp2, oFont

return nil

//----------------------------------------------------------------------------//

function ShowHelp( oBtn, nRow, nCol )

   local aPoint   := { nRow, nCol }
   local hCtl, nID
   local cMsg

   ClientToScreen( oBtn:hWnd, aPoint )

   hCtl = WindowFromPoint( aPoint[ 2 ], aPoint[ 1 ] )
   nID  = GetWindowWord( hCtl, -12 )

   REDEFINE cMsg AS CHARACTER RESOURCE nID

   MsgFancy( If( Empty( cMsg ), "Sorry, I am a very limited Genius...", cMsg ) )

return nil

//----------------------------------------------------------------------------//

function MsgFancy( cMsg )

   local oDlg, oBrush

   DEFINE BRUSH oBrush STYLE NULL             // Transparent painting !

   DEFINE DIALOG oDlg ;
      FROM 2, 2 TO 20, 60 ;
      BRUSH oBrush ;
      STYLE WS_POPUP

   ACTIVATE DIALOG oDlg CENTERED ;
      ON PAINT ( PalBmpDraw( oDlg:hDC, 0, 0, oBmp2:hBmpPal, 0, 0, SRCPAINT ),;
                 PalBmpDraw( oDlg:hDC, 0, 0, oBmp1:hBmpPal, 0, 0, SRCAND ),;
                 oDlg:Say( 3.7, 10, cMsg,,, oFont ) ) ;
      ON LEFT CLICK oDlg:End()

return nil

//----------------------------------------------------------------------------//
