#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

void WindowRaised( HDC, LPRECT );
void WindowBoxIn( HDC, LPRECT );

#define CLR_LIGHTGRAY 12632256          // RGB( 192, 192, 192 )

//----------------------------------------------------------------------------//

CLIPPER MsgPaint()
{
   HWND  hWnd    = _parni( 1 );
   LPSTR cMsg    = _parc( 2 );
   LPSTR cMsgDef = _parc( 3 );
   BOOL  bErase  = _parl( 4 );
   BOOL  bCenter = _parl( 5 );
   HDC   hDC     = GetDC( hWnd );
   RECT  rc;
   WORD  wLen;

   GetClientRect( hWnd, &rc );

   SetTextColor( hDC, 0 );
   SetBkColor( hDC, CLR_LIGHTGRAY );

   rc.top    += 4;
   rc.left   += 4;
   rc.bottom -= 4;
   rc.right  -= 8;

   if( ! ( wLen = _parclen( 2 ) ) )
   {
      wLen = _parclen( 3 );
      cMsg = cMsgDef;
   }

   if( bCenter )
   {
      ExtTextOut( hDC, 8, 4, ETO_OPAQUE | ETO_CLIPPED, &rc, "", 0, 0 );
      DrawText( hDC, cMsg, wLen, &rc, IF( bCenter, DT_CENTER, DT_LEFT ) );
   }
   else
      ExtTextOut( hDC, 8, 4, ETO_OPAQUE | ETO_CLIPPED, &rc, cMsg, wLen, 0 );

   if( bErase )
   {
      rc.top    -= 4;
      rc.left   -= 4;
      rc.bottom += 3;
      rc.right  += 7;
      WindowRaised( hDC, &rc );

      rc.top    += 3;
      rc.left   += 3;
      rc.right  -= 3;
      rc.bottom -= 3;
      WindowBoxIn( hDC, &rc );
   }
   ReleaseDC( hWnd, hDC );
}

//----------------------------------------------------------------------------//
